/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MMailText;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.core.model.MFamily;
import org.openup.core.model.MFamily_Member;
import org.openup.core.process.SendEmailToBPDunningAbstract;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class SendEmailToBPDunning
extends SendEmailToBPDunningAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<Object> mDunningRunEntries_id = new ArrayList();
        if (this.isSelection()) {
            mDunningRunEntries_id = this.getSelectionKeys();
        }
        if (mDunningRunEntries_id.size() > 0) {
            for (Integer n : mDunningRunEntries_id) {
                Trx.run(trxName -> this.sendEmailTo(new MDunningRunEntry(this.getCtx(), mDunningRunEntry_id, trxName)));
            }
            return "@Processed@ @UY_EmailLogBatch_ID@ ";
        }
        return "@C_DunningRunEntry_ID@ @not.found@";
    }

    private void sendEmailTo(MDunningRunEntry mDunningRunEntry) {
        ArrayList<MUser> emails = new ArrayList<MUser>();
        MBPartner mbPartner = (MBPartner)mDunningRunEntry.getC_BPartner();
        List<MFamily> families = MFamily.getByResponsibleOfPayment(this.getCtx(), this.get_TrxName(), mbPartner);
        for (MFamily family : families) {
            List members = family.getMembers().stream().filter(mFamily_member -> mFamily_member.isActive() && mFamily_member.isSendEMail() || mFamily_member.getC_BPartner_ID() == mbPartner.get_ID()).collect(Collectors.toList());
            for (MFamily_Member member : members) {
                try {
                    emails.add((MUser)member.getAD_User());
                }
                catch (Exception exception) {}
            }
        }
        if (emails.size() > 0) {
            this.sendEmailTo(mDunningRunEntry, emails);
            if (this.isSendEMail()) {
                mDunningRunEntry.set_ValueOfColumn("IsPrinted", (Object)true);
                mDunningRunEntry.saveEx();
            }
        }
    }

    private void sendEmailTo(MDunningRunEntry mDunningRunEntry, List<MUser> usersToSend) {
        MMailText mMailText = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        if (mMailText.get_ID() <= 0) {
            throw new AdempiereException("@R_MailText_ID@ @not.found@");
        }
        File pdf = null;
        MPrintFormat printFormat = MPrintFormat.get(this.getCtx(), this.getSelectionAsInt(mDunningRunEntry.get_ID(), "CDL_Dunning_PrintFormat_ID"), false);
        if (printFormat != null && printFormat.get_ID() > 0) {
            if (printFormat.getJasperProcess_ID() > 0) {
                ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(printFormat.getJasperProcess_ID()).withTitle(SendEmailToBPDunning.getProcessName()).withParameter("C_DunningRunEntry_ID", mDunningRunEntry.get_ID()).withoutPrintPreview().execute();
                pdf = processInfo.getPDFReport();
            } else {
                Language language = Env.getLanguage(this.getCtx());
                printFormat.setLanguage(language);
                printFormat.setTranslationLanguage(language);
                MQuery query = new MQuery(printFormat.getAD_Table().getTableName());
                query.addRestriction("C_DunningRunEntry_ID", "=", mDunningRunEntry.get_ID());
                PrintInfo printInfo = new PrintInfo(mDunningRunEntry.getC_BPartner().getName(), printFormat.getAD_Table().getAD_Table_ID(), mDunningRunEntry.get_ID());
                printInfo.setCopies(1);
                printInfo.setDocumentCopy(false);
                printInfo.setPrinterName(printFormat.getPrinterName());
                ReportEngine reportEngine = new ReportEngine(this.getCtx(), printFormat, query, printInfo, this.get_TrxName());
                pdf = reportEngine.getPDF();
            }
        }
        if (pdf == null) {
            try {
                this.addLog("@C_DunningRun_ID@ " + mDunningRunEntry.getC_DunningRun().getDescription() + " @C_BPartner_ID@ " + mDunningRunEntry.getC_BPartner().getName() + " : @attachment@ @not.found@");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            mMailText.setBPartner(mDunningRunEntry.getC_BPartner_ID());
            mMailText.setPO(mDunningRunEntry);
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
            notifier.clearMessage().withApplicationType("UDP").withText(mMailText.getMailText(true)).withDescription(mMailText.getMailHeader()).withEntity(MDunningRunEntry.Table_ID, mDunningRunEntry.getC_DunningRunEntry_ID()).withOrganizationId(mDunningRunEntry.getAD_Org_ID());
            notifier.addAttachment(pdf);
            for (MUser mUser : usersToSend) {
                notifier.addRecipient(mUser.get_ID());
            }
            notifier.addToQueue();
        }
    }
}

