/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MMailText;
import org.compiere.model.MOrg;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Trx;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.core.model.MUYEmailLog;
import org.openup.core.process.PrintDocumentAbstract;
import org.openup.core.process.SendDocumentAbstract;
import org.openup.core.utils.EmailSender;

public class SendDocument
extends SendDocumentAbstract {
    private EmailSender emailSender;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.addLog("___");
        this.emailSender = EmailSender.newInstance(this.getCtx());
        List mInvoices = null;
        if (this.isSelection()) {
            mInvoices = this.getSelectionValues().keySet().stream().map(invoiceId -> new MInvoice(this.getCtx(), (int)invoiceId, this.get_TrxName())).collect(Collectors.toList());
        } else {
            Object query = "AD_Org_ID=?";
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.getOrgId());
            this.addLog("AD_Org_ID=" + this.getOrgId());
            if (this.getTable_ID() == 318 && this.getRecord_ID() > 0) {
                query = (String)query + " AND C_Invoice_ID=?";
                params.add(this.getRecord_ID());
                this.addLog("C_Invoice_ID=" + this.getRecord_ID());
            }
            mInvoices = new Query(this.getCtx(), "C_Invoice", (String)query, this.get_TrxName()).setParameters(params).list();
        }
        this.addLog(mInvoices.size() + " documento/s encontrado/s");
        this.addLog("___");
        for (MInvoice mInvoice : mInvoices) {
            MBPGroup mbpGroup = (MBPGroup)mInvoice.getC_BPartner().getC_BP_Group();
            MMailText mMailText = new MMailText(this.getCtx(), mbpGroup.get_ValueAsInt("R_MailText_ID"), this.get_TrxName());
            if ("CO".equalsIgnoreCase(mInvoice.getDocStatus()) || "CL".equalsIgnoreCase(mInvoice.getDocStatus())) {
                if (mMailText.get_ID() <= 0) {
                    this.logErr(mInvoice, "@C_BP_Group_ID@ " + mbpGroup.getName() + " - @R_MailText_ID@ @not.found@");
                    continue;
                }
                Trx.run(trxName -> {
                    mInvoice.set_TrxName(trxName);
                    if (!mInvoice.isPrinted()) {
                        String sendInvoiceEmailTo = mbpGroup.get_ValueAsString("SendInvoiceEmailTo");
                        if (sendInvoiceEmailTo != null && sendInvoiceEmailTo.equalsIgnoreCase("BP")) {
                            MBPartner mbPartner = (MBPartner)mInvoice.getC_BPartner();
                            MBPartnerLocation mbPartnerLocation = mbPartner.getPrimaryC_BPartner_Location();
                            if (mbPartnerLocation == null || mbPartnerLocation.get_ID() <= 0 || mbPartnerLocation.getEMail() == null || mbPartnerLocation.getEMail().isEmpty()) {
                                this.logErr(mInvoice, mbPartner.getName() + " @C_BPartner_Location_ID@ @not.found@");
                                return;
                            }
                            this.sendEmailTo(mbPartnerLocation.getEMail(), mMailText, mInvoice);
                        } else if (sendInvoiceEmailTo != null && sendInvoiceEmailTo.equalsIgnoreCase("SR")) {
                            MUser salesRep = (MUser)mInvoice.getSalesRep();
                            if (salesRep != null && salesRep.getEMail() != null && !salesRep.getEMail().isEmpty()) {
                                this.sendEmailTo(salesRep.getEMail(), mMailText, mInvoice);
                            }
                        } else {
                            this.logErr(mInvoice, "@C_BP_Group_ID@.@SendInvoiceEmailTo@ @not.found@");
                            return;
                        }
                        if (this.isSendToOrgMail()) {
                            String mailAddress = null;
                            try {
                                MOrg mOrg = MOrg.get(this.getCtx(), mInvoice.getAD_Org_ID());
                                mailAddress = mOrg.getInfo().getEMail();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (mailAddress == null || mailAddress.isEmpty()) {
                                this.logErr(mInvoice, "@AD_Org_ID@ " + this.getOrgId() + " @EMail@ @not.found@");
                                return;
                            }
                            this.sendEmailTo(mailAddress, mMailText, mInvoice);
                        }
                        mInvoice.setIsPrinted(true);
                        mInvoice.saveEx();
                    }
                });
                if (this.getUserId() <= 0) continue;
                MUser mUser = new MUser(this.getCtx(), this.getUserId(), this.get_TrxName());
                String email = null;
                try {
                    email = mUser.getEMail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (email == null || email.isEmpty()) {
                    this.logErr(mInvoice, "Usuario seleccionado " + mUser.getValue() + "(" + this.getUserId() + ") no dispone de Email");
                    continue;
                }
                this.sendEmailTo(email, mMailText, mInvoice);
                continue;
            }
            this.logErr(mInvoice, "Documento no Completo ni Cerrado");
        }
        this.emailSender.save(true);
        if (this.isSendEMail()) {
            this.emailSender.send();
        }
        return "@Processed@ @UY_EmailLogBatch_ID@ " + this.emailSender.getValue();
    }

    private void sendEmailTo(String emailAddr, MMailText mMailText, MInvoice mInvoice) {
        mMailText.setBPartner(mInvoice.getC_BPartner_ID());
        mMailText.setPO(mInvoice);
        MUYEmailLog muyEmailLog = new MUYEmailLog(this.getCtx());
        muyEmailLog.setAD_Table_ID(I_C_Invoice.Table_ID);
        muyEmailLog.setRecord_ID(mInvoice.get_ID());
        muyEmailLog.setEMail_To(emailAddr);
        muyEmailLog.setMessage(mMailText.getMailText(true));
        muyEmailLog.setSubject(mMailText.getMailHeader());
        muyEmailLog.setIsHtml(mMailText.isHtml());
        muyEmailLog.setR_MailText_ID(mMailText.get_ID());
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(PrintDocumentAbstract.getProcessValue()).withTitle(SendDocument.getProcessName()).withParameter("C_Invoice_ID", mInvoice.get_ID()).withParameter("PrintProcess_ID", this.getPrintProcessId()).execute();
        File pdf = processInfo.getPDFReport();
        System.out.println("pdf = " + pdf);
        if (pdf == null) {
            muyEmailLog.setStatus("ER");
            muyEmailLog.setMessage("Documento requiere adjunto para ser enviado");
            this.emailSender.add(muyEmailLog, new File[0]);
        } else {
            this.emailSender.add(muyEmailLog, pdf);
        }
    }

    private void logOk(MInvoice mInvoice, String message) {
        this.addLog("OK - " + mInvoice.getDocumentNo() + "(" + mInvoice.get_ID() + ") - " + message);
    }

    private void logErr(MInvoice mInvoice, String message) {
        this.addLog("X - " + mInvoice.getDocumentNo() + "(" + mInvoice.get_ID() + ") - " + message);
    }
}

