/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class RInventoryValue
extends SvrProcess {
    private int p_M_PriceList_Version_ID;
    private Timestamp p_DateValue;
    private int p_M_Warehouse_ID;
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_AD_User_ID = 0;
    private static final String TABLA_MOLDE = "UY_Molde_InventoryValue";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DateValue")) {
                this.p_DateValue = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = para[i].getParameterAsInt();
                continue;
            }
            if (!name.equals("AD_Org_ID")) continue;
            this.p_AD_Org_ID = para[i].getParameterAsInt();
        }
        if (this.p_DateValue == null) {
            this.p_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.deleteInstanciasViejasReporte();
        MClient client = MClient.get(this.getCtx(), this.p_AD_Client_ID);
        MAcctSchema as = client.getAcctSchema();
        Object select = "";
        String insert = "";
        String where = " WHERE x.ad_client_id = " + this.p_AD_Client_ID + " AND x.ad_org_id = " + this.p_AD_Org_ID;
        insert = "INSERT INTO UY_Molde_InventoryValue (ad_client_id, ad_org_id, ad_user_id, m_warehouse_id, m_locator_id, m_product_id, m_pricelist_version_id, c_currency_id, c_currency_id_to, value, c_uom_id, m_product_category_id, qtyonhand, m_productprice_id, pricelist, pricelistamt)";
        select = "SELECT x.ad_client_id, x.ad_org_id, " + this.p_AD_User_ID + ", x.m_warehouse_id, x.m_locator_id, x.m_product_id, plv.m_pricelist_version_id, pl.c_currency_id, " + as.getC_Currency_ID() + ", x.value, x.c_uom_id, x.m_product_category_id, x.qtyonhand, x.m_productprice_id, pp.pricelist, (x.qtyonhand * pp.pricelist) AS pricelistamt FROM (SELECT s.ad_client_id, s.ad_org_id, l.m_warehouse_id, s.m_locator_id, s.m_product_id, p.value, p.c_uom_id, p.m_product_category_id, sum(s.qtyonhand) AS qtyonhand, actualproductprice(p.m_product_id, " + this.p_M_PriceList_Version_ID + ") as m_productprice_id FROM m_storage s JOIN m_locator l ON s.m_locator_id = l.m_locator_id JOIN m_product p ON s.m_product_id = p.m_product_id WHERE l.m_warehouse_id = " + this.p_M_Warehouse_ID + " GROUP BY s.ad_client_id, s.ad_org_id, s.m_product_id, p.value, p.name, p.description, p.c_uom_id, p.m_product_category_id, s.m_locator_id, l.m_warehouse_id, p.m_product_group_id, p.m_product_id) as x LEFT JOIN m_productprice pp ON x.m_productprice_id = pp.m_productprice_id LEFT JOIN m_pricelist_version plv ON pp.m_pricelist_version_id = plv.m_pricelist_version_id LEFT JOIN m_pricelist pl ON plv.m_pricelist_id = pl.m_pricelist_id " + where + " ORDER BY plv.m_pricelist_version_id, pl.c_currency_id, x.m_product_id";
        DB.executeUpdateEx(insert + (String)select, null);
        String myDate = this.p_DateValue.toString();
        StringBuffer sql = new StringBuffer("UPDATE UY_Molde_InventoryValue SET ").append("DateValue=TO_DATE('").append(myDate.substring(0, 10)).append(" 00:00:00','YYYY-MM-DD HH24:MI:SS')").append(" WHERE AD_User_ID=" + this.p_AD_User_ID);
        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        sql = new StringBuffer("UPDATE UY_Molde_InventoryValue iv SET QtyOnHand=(SELECT iv.QtyOnHand - NVL(SUM(t.MovementQty), 0) FROM M_Transaction t INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE t.M_Product_ID=iv.M_Product_ID AND t.MovementDate > iv.DateValue AND l.M_Warehouse_ID=iv.M_Warehouse_ID) WHERE iv.AD_User_ID=").append(this.p_AD_User_ID);
        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        sql = new StringBuffer("DELETE UY_Molde_InventoryValue WHERE (QtyOnHand=0 OR QtyOnHand IS NULL) AND AD_User_ID=").append(this.p_AD_User_ID);
        int noQty = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("NoQty Deleted=" + noQty);
        sql = new StringBuffer("UPDATE UY_Molde_InventoryValue iv SET Amount =  (SELECT currencyConvert(pp.PriceList,iv.C_Currency_ID,iv.C_Currency_ID_To,iv.DateValue,null,pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND pp.M_ProductPrice_ID = iv.M_ProductPrice_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID) WHERE iv.AD_User_ID = ").append(this.p_AD_User_ID);
        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        DB.executeUpdateEx("UPDATE UY_Molde_InventoryValue SET PriceListAmt = QtyOnHand * PriceList, ConvertedAmt = QtyOnHand * Amount WHERE AD_User_ID = " + this.p_AD_User_ID, this.get_TrxName());
        return "OK";
    }

    private void deleteInstanciasViejasReporte() {
        Object sql = "";
        try {
            sql = "DELETE FROM UY_Molde_InventoryValue WHERE ad_user_id = " + this.p_AD_User_ID;
            DB.executeUpdateEx((String)sql, null);
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }
}

