/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.text.SimpleDateFormat;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSequence;
import org.compiere.util.DB;
import org.openup.core.process.RIntercompanyAbstract;

public class RIntercompany
extends RIntercompanyAbstract {
    private static final String TABLA_MOLDE = "UY_Molde_Intercompany";
    private String dateLastRun;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getDateLastRun() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            this.dateLastRun = sdf.format(this.getDateLastRun());
        }
        String sqlToDelete = "DELETE FROM UY_Molde_Intercompany WHERE AD_User_ID = " + this.getUserId();
        DB.executeUpdateEx(sqlToDelete, this.get_TrxName());
        Object select = this.getProcessView();
        String insert = "INSERT INTO UY_Molde_Intercompany(UY_Molde_Intercompany_ID, AD_Client_ID, created, createdBy, updated, updatedBy, isActive, dateLastRun, AD_User_ID, C_Order_ID, AD_Org_ID, OrgName, user1_ID, account_code, value, name, name2, converted_amt, User3_ID, InvRef, NAICS, description, C_Currency_ID, DocTypeName, acct_currency, documentNoOrder, acct_amt, period_value, grandTotal, AccountValue, total_delivered, documentNo, ac29010D, ac29010C, ac9000D, ac29000C, ac29020D, ac29020C, BPValue, dateInvoiced, C_BP_Group_ID, DocTypeTargetName, C_BPartner_ID, C_DocType_ID, recognizedAmt ) ";
        if (this.getOrgId() > 0) {
            select = (String)select + "\n AND o.AD_Org_ID=" + this.getOrgId();
        }
        if (this.getUser1Id() > 0) {
            select = (String)select + "\n AND o.User1_ID=" + this.getUser1Id();
        }
        if (this.getBPartnerId() > 0) {
            select = (String)select + "\n AND o.Bill_BPartner_ID=" + this.getBPartnerId();
        }
        if (this.getUser3Id() > 0) {
            select = (String)select + "\n AND o.User3_ID=" + this.getUser3Id();
        }
        try {
            DB.executeUpdateEx(insert + (String)select, this.get_TrxName());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdempiereException(e);
        }
        return "";
    }

    private String getProcessView() {
        MSequence seq = MSequence.get(this.getCtx(), TABLA_MOLDE);
        String total_delivered_fn = "RV_Intercompany__Total_Delivered('" + this.dateLastRun + "', o.C_Order_ID)";
        return "SELECT nextID(" + seq.get_ID() + ", 'N')," + this.getAD_Client_ID() + ", now(), " + this.getUserId() + ", now(), " + this.getUserId() + ", 'Y', " + (String)(this.dateLastRun != null ? "'" + this.dateLastRun + "'" : "NULL") + " AS dateLastRun,\n" + this.getUserId() + " AS AD_User_ID,o.C_Order_ID,\no.AD_Org_ID,\no_org.name OrgName, \no.user1_ID, \nCASE\n  WHEN (o.isSoTrx='Y' AND (rrPlan.recognizedAmt IS NOT NULL OR rrPlan.recognizedAmt <> 0)) THEN '29020D'\n  WHEN (o.isSoTrx='N' AND (rrPlan.recognizedAmt IS NOT NULL OR rrPlan.recognizedAmt <> 0)) THEN '29020C'\n  WHEN (o.isSoTrx='Y' AND oi.C_Invoice_ID IS NULL) THEN '29010D' \n  WHEN (o.isSoTrx='N' AND oi.C_Invoice_ID IS NULL) THEN '29010C' \n  WHEN (o.isSoTrx='Y' AND oi.C_Invoice_ID IS NOT NULL) THEN '29000D' \n  WHEN (o.isSoTrx='N' AND oi.C_Invoice_ID IS NOT NULL) THEN '29000C' \nEND account_code, \no_user1.value, \no_bp.name, \no_bp.name2, \nROUND(CASE WHEN oi.C_Currency_ID <> 100 THEN currencyrate(oi.C_Currency_ID, 100, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * o.grandTotal, 2) converted_amt, \no.User3_ID, \n'' InvRef, \nCASE WHEN COALESCE(o_bp.AD_OrgBP_ID, 0) > 0 THEN o_user3.value ELSE o_bp.NAICS END, \noi.description, \no.C_Currency_ID, \no_dt_ref_trl.name AS DocTypeName, \n142 acct_currency, \no.documentNo AS documentNoOrder, \nROUND(CASE WHEN CASE WHEN oi.C_Currency_ID IS NOT NULL THEN oi.C_Currency_ID ELSE o.C_Currency_ID END <> 142 THEN currencyrate(CASE WHEN oi.C_Currency_ID IS NOT NULL THEN oi.C_Currency_ID ELSE o.C_Currency_ID END, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * CASE WHEN oi.C_Invoice_ID IS NOT NULL THEN o.grandTotal ELSE RV_Intercompany__Total_Delivered('" + this.dateLastRun + "', o.C_Order_ID) END, 2) acct_amt, \nTO_CHAR(TO_DATE('" + this.dateLastRun + "', 'YYYY-MM-DD'), 'YYYY-MM') period_value, \no.grandTotal,\n'' AccountValue, \n(\n  " + total_delivered_fn + "\n) as total_delivered, \noi.documentNo, \nCASE WHEN (o.isSoTrx='Y' AND oi.C_Invoice_ID IS NULL) THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * " + total_delivered_fn + ", 2) ELSE 0 END AS ac29010D , \nCASE WHEN (o.isSoTrx='N' AND oi.C_Invoice_ID IS NULL) THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * " + total_delivered_fn + ", 2) ELSE 0 END AS ac29010C , \nCASE WHEN (o.isSoTrx='Y' AND oi.C_Invoice_ID IS NOT NULL) THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * o.grandTotal, 2) ELSE 0 END AS ac9000D , \nCASE WHEN (o.isSoTrx='N' AND oi.C_Invoice_ID IS NOT NULL) THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * o.grandTotal, 2) ELSE 0 END AS ac29000C , \nCASE WHEN (o.isSoTrx='Y') THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * rrPlan.recognizedAmt, 2) ELSE 0 END AS ac29020D , \nCASE WHEN (o.isSoTrx='N') THEN ROUND(CASE WHEN o.C_Currency_ID <> 142 THEN currencyrate(o.C_Currency_ID, 142, to_date('" + this.dateLastRun + "', 'YYYY-MM-DD'), 115, o.AD_Client_ID, 0) ELSE 1 END * rrPlan.recognizedAmt, 2) ELSE 0 END AS ac29020C , \no_bp.value BPValue, \noi.dateInvoiced, \no_bp.C_BP_Group_ID, \no_dt.name, \no.Bill_BPartner_ID C_BPartner_ID, \no.C_DocTypeTarget_ID, \nrrPlan.recognizedAmt \nFROM C_Order o\nJOIN AD_Org o_org ON o.AD_Org_ID=o_org.AD_Org_ID\nLEFT JOIN C_ElementValue o_user1 ON o.User1_ID = o_user1.C_ElementValue_ID\nJOIN C_BPartner o_bp ON o.Bill_BPartner_ID = o_bp.C_BPartner_ID\nLEFT JOIN C_ElementValue o_user3 ON o.User3_ID = o_user3.C_ElementValue_ID\nJOIN C_DocType o_dt ON o.C_DocTypeTarget_ID = o_dt.C_DocType_ID\nJOIN AD_Ref_List o_dt_ref ON o_dt.DocBaseType = o_dt_ref.value AND AD_Reference_ID=183 \nJOIN AD_Ref_List_Trl o_dt_ref_trl ON o_dt_ref.AD_Ref_List_ID = o_dt_ref_trl.AD_Ref_List_ID AND o_dt_ref_trl.AD_Language='es_MX'\nLEFT JOIN C_invoice oi ON EXISTS (\n  SELECT 1\n  FROM C_InvoiceLine il\n  JOIN C_OrderLine ol ON il.C_OrderLine_ID=ol.C_OrderLine_ID\n  WHERE oi.C_Invoice_ID=il.C_Invoice_ID\n  AND ol.C_Order_ID=o.C_Order_ID\n  AND oi.DocStatus IN ('CO', 'CL')\n)\nLEFT JOIN (\n  SELECT rrpol.C_Order_ID, SUM(rrp.RecognizedAmt) recognizedAmt\n  FROM C_RevenueRecognition_Plan rrp\n  JOIN C_OrderLine rrpol ON rrp.C_OrderLine_ID=rrpol.C_OrderLine_ID\n  GROUP BY rrpol.C_Order_ID\n) rrPlan ON rrPlan.C_Order_ID=o.C_Order_ID\nWHERE o.DateOrdered <= '" + this.dateLastRun + "'\nAND o_bp.C_BP_Group_ID=" + this.getBPGroupId() + "\nAND o.docStatus IN ('CO', 'CL')\nAND (\n  " + total_delivered_fn + " > 0\n  OR oi.C_Invoice_ID IS NOT NULL\n  OR rrPlan.recognizedAmt IS NOT NULL\n)\nAND (oi.isPaid IS NULL OR oi.isPaid <> 'Y')\n";
    }
}

