/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.compiere.apps.Waiting;
import org.compiere.model.MBPartner;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class RAccountStatusReceipt {
    private ReportAccountStatus acctStatusFilters;
    private String idReporte = "";
    private static final String TABLA_MOLDE = "uy_molde_accountstatus";
    private Waiting waiting = null;
    private int idTableMolde;

    public RAccountStatusReceipt(ReportAccountStatus acctStatusFilters) {
        this.acctStatusFilters = acctStatusFilters;
    }

    public Waiting getWaiting() {
        return this.waiting;
    }

    public void setWaiting(Waiting value) {
        this.waiting = value;
    }

    public void execute() throws Exception {
        this.deleteInstanciasViejasReporte();
        this.getData();
        this.updateData();
        this.showHelp("Iniciando Vista Previa...");
    }

    private void deleteInstanciasViejasReporte() throws Exception {
        Object sql = "";
        sql = " DELETE FROM uy_molde_accountstatus WHERE ad_user_id =" + this.acctStatusFilters.adUserID;
        DB.executeUpdateEx((String)sql, null);
    }

    private void getData() throws Exception {
        String insert = "";
        String sql = "";
        Object whereFiltros = "";
        MBPartner partner = null;
        this.idTableMolde = DB.getSQLValue(null, "SELECT AD_Sequence_ID FROM AD_Sequence WHERE isTableID='Y' AND lower(name) LIKE lower('uy_molde_accountstatus')");
        this.idReporte = RAccountStatusReceipt.getReportID(Long.valueOf(this.acctStatusFilters.adUserID));
        if (this.acctStatusFilters.customerID > 0) {
            partner = new MBPartner(Env.getCtx(), this.acctStatusFilters.customerID, null);
        }
        whereFiltros = (String)whereFiltros + " AND st.c_currency_id = " + this.acctStatusFilters.cCurrencyID;
        insert = "INSERT INTO uy_molde_accountstatus (uy_molde_accountstatus_id, created, createdBy, updated, updatedBy, idreporte, fecreporte, ad_user_id, ad_client_id, ad_org_id, isinvoice, c_bpartner_id, bpvalue, bpname, isreceipt, record_id, documentno, c_currency_id, currencyname, c_doctype_id, docname, startdate, datetrx, duedate, amtdocument, saldoinicial, debe, haber, saldoacumulado, poreference, issotrx)";
        StringBuilder strb = new StringBuilder("");
        Timestamp dateFrom = TimeUtil.trunc(this.acctStatusFilters.dateFrom, "D");
        Timestamp dateTo = TimeUtil.trunc(this.acctStatusFilters.dateTo, "D");
        this.showHelp("Obteniendo datos...");
        Object whereOrg = "";
        if (this.acctStatusFilters.adOrgID > 0) {
            whereOrg = " AND st.ad_org_id =" + this.acctStatusFilters.adOrgID;
        }
        strb.append(" SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ", case when doc.docBaseType ='ARI' OR doc.docBaseType = 'API' then 'Y' else 'N' end as isinvoice, st.c_bpartner_id, bp.value as bpvalue, (bp.name || ' - ' ||coalesce(bp.name2,'')) as bpname, st.issotrx,  st.c_invoice_id, st.documentno, st.c_currency_id, cur.description as curname,  st.c_doctype_id, doc.printname, st.dateinvoiced as startdate, st.dateinvoiced as datedoc, st.dateinvoiced as duedate, st.grandtotal, 0, 0, 0, 0, coalesce(st.POReference, st.description) as poreference, st.issotrx  from c_invoice st  inner join c_doctype doc ON st.c_doctype_id = doc.c_doctype_id inner join c_currency cur on st.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on st.c_bpartner_id = bp.c_bpartner_id  WHERE st.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND st.dateinvoiced between '" + dateFrom + "' AND '" + dateTo + "'  AND doc.docbasetype NOT IN ('DRI','DPI','DRC','DPC') AND st.docstatus = 'CO' " + (String)whereFiltros);
        if (this.isParent(partner)) {
            strb.append(" AND st.c_bpartner_id IN (select c_bpartner_id from c_bpartner where bpartner_parent_id = " + this.acctStatusFilters.customerID + " OR c_bpartner_id = " + this.acctStatusFilters.customerID + ")");
        } else {
            strb.append(" AND st.c_bpartner_id = " + this.acctStatusFilters.customerID);
        }
        if (this.acctStatusFilters.IsSOTrx) {
            strb.append(" AND st.issotrx='Y' ");
        } else {
            strb.append(" AND st.issotrx='N' ");
        }
        strb.append(" UNION SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ", 'N' as isinvoice,st.c_bpartner_id, bp.value as bpvalue, (bp.name || ' - ' ||coalesce(bp.name2,'')) as bpname, st.isreceipt,  st.c_payment_id, st.documentno, st.c_currency_id, cur.description as curname,  st.c_doctype_id, doc.printname, st.datetrx as startdate, st.datetrx as datedoc, st.datetrx as duedate, st.payamt, 0,0,0,0, coalesce(st.description,'') as poreference, st.isreceipt  from c_payment st  inner join c_doctype doc ON st.c_doctype_id = doc.c_doctype_id inner join c_currency cur on st.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on st.c_bpartner_id = bp.c_bpartner_id  WHERE st.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND st.datetrx between '" + dateFrom + "' AND '" + dateTo + "'  AND doc.docbasetype NOT IN ('DRR','DRP') AND st.uy_payreceipt_id is null AND st.c_charge_id is null AND st.docstatus IN ('CO','CL') " + (String)whereFiltros);
        if (this.isParent(partner)) {
            strb.append(" AND st.c_bpartner_id IN (select c_bpartner_id from c_bpartner where bpartner_parent_id = " + this.acctStatusFilters.customerID + " OR c_bpartner_id = " + this.acctStatusFilters.customerID + ")");
        } else {
            strb.append(" AND st.c_bpartner_id = " + this.acctStatusFilters.customerID);
        }
        if (this.acctStatusFilters.IsSOTrx) {
            strb.append(" AND st.isreceipt='Y' ");
        } else {
            strb.append(" AND st.isreceipt='N' ");
        }
        strb.append(" UNION SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ", 'N' as isinvoice,st.c_bpartner_id, bp.value as bpvalue, (bp.name || ' - ' ||coalesce(bp.name2,'')) as bpname, st.issotrx,  st.uy_payreceipt_id, st.documentno, st.c_currency_id, cur.description as curname,  st.c_doctype_id, doc.printname, st.datedoc as startdate, st.datedoc as datedoc, st.datedoc as duedate, st.payamt, 0,0,0,0, coalesce(st.description,'') as poreference, st.issotrx  from uy_payreceipt st  inner join c_doctype doc ON st.c_doctype_id = doc.c_doctype_id inner join c_currency cur on st.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on st.c_bpartner_id = bp.c_bpartner_id  WHERE st.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND st.datedoc between '" + dateFrom + "' AND '" + dateTo + "'  AND st.ismulticurrency = 'N'  AND st.docstatus = 'CO' " + (String)whereFiltros);
        if (this.isParent(partner)) {
            strb.append(" AND st.c_bpartner_id IN (select c_bpartner_id from c_bpartner where bpartner_parent_id = " + this.acctStatusFilters.customerID + " OR c_bpartner_id = " + this.acctStatusFilters.customerID + ")");
        } else {
            strb.append(" AND st.c_bpartner_id = " + this.acctStatusFilters.customerID);
        }
        if (this.acctStatusFilters.IsSOTrx) {
            strb.append(" AND st.issotrx='Y' ");
        } else {
            strb.append(" AND st.issotrx='N' ");
        }
        strb.append(" UNION SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ", 'N' as isinvoice,st.c_bpartner_id, bp.value as bpvalue, (bp.name || ' - ' ||coalesce(bp.name2,'')) as bpname, st.issotrx,  st.uy_payreceipt_id, st.documentno, st.c_currency_id_to, cur.description as curname,  st.c_doctype_id, doc.printname, st.datedoc as startdate, st.datedoc as datedoc, st.datedoc as duedate,  currencyconvert_receipt(st.payamt, st.currencyrate, st.c_currency_id, st.c_currency_id_to,  st.ad_client_id, st.ad_org_id) as payamt,  0,0,0,0, coalesce(st.description,'') as poreference, st.issotrx  from uy_payreceipt st  inner join c_doctype doc ON st.c_doctype_id = doc.c_doctype_id inner join c_currency cur on st.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on st.c_bpartner_id = bp.c_bpartner_id  WHERE st.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND st.datedoc between '" + dateFrom + "' AND '" + dateTo + "'  AND st.docstatus = 'CO'  AND st.ismulticurrency = 'Y'  AND st.c_currency_id_to = " + this.acctStatusFilters.cCurrencyID);
        if (this.isParent(partner)) {
            strb.append(" AND st.c_bpartner_id IN (select c_bpartner_id from c_bpartner where bpartner_parent_id = " + this.acctStatusFilters.customerID + " OR c_bpartner_id = " + this.acctStatusFilters.customerID + ")");
        } else {
            strb.append(" AND st.c_bpartner_id = " + this.acctStatusFilters.customerID);
        }
        if (this.acctStatusFilters.IsSOTrx) {
            strb.append(" AND st.issotrx='Y' ");
        } else {
            strb.append(" AND st.issotrx='N' ");
        }
        BigDecimal multiplier = Env.ONE;
        if (!this.acctStatusFilters.IsSOTrx) {
            multiplier = multiplier.negate();
        }
        strb.append(" UNION SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ", 'N' as isinvoice,al.c_bpartner_id, bp.value as bpvalue, (bp.name || ' - ' ||coalesce(bp.name2,'')) as bpname, '" + this.acctStatusFilters.isSoTrx + "', st.c_allocationhdr_id, st.documentno, st.c_currency_id, cur.description as curname,  st.c_doctype_id, 'Asignaci\u00f3n con Cargo' as printname, st.datetrx as startdate, st.datetrx as datedoc, st.datetrx as duedate, al.amount * " + multiplier + ", 0,0,0,0, st.description as poreference, '" + this.acctStatusFilters.isSoTrx + "' from c_allocationhdr st  inner join c_allocationline al on st.c_allocationhdr_id = al.c_allocationhdr_id  inner join c_doctype doc ON st.c_doctype_id = doc.c_doctype_id inner join c_currency cur on st.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on al.c_bpartner_id = bp.c_bpartner_id  WHERE st.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND al.c_charge_id > 0 AND st.datetrx between '" + dateFrom + "' AND '" + dateTo + "'  AND st.docstatus in ('CO','CL') " + (String)whereFiltros + " AND NOT EXISTS (select uy_payreceipt_id from uy_payreceipt where c_allocationhdr_id = st.c_allocationhdr_id) AND ((select count(l.c_allocationline_id) from c_allocationline l inner join c_invoice i on l.c_invoice_id = i.c_invoice_id where l.c_allocationhdr_id = st.c_allocationhdr_id and i.issotrx = '" + this.acctStatusFilters.isSoTrx + "') > 0 OR (select count(l.c_allocationline_id) from c_allocationline l inner join c_payment p on l.c_payment_id = p.c_payment_id where l.c_allocationhdr_id = st.c_allocationhdr_id and p.isreceipt = '" + this.acctStatusFilters.isSoTrx + "') > 0)");
        if (this.isParent(partner)) {
            strb.append(" AND al.c_bpartner_id IN (select c_bpartner_id from c_bpartner where bpartner_parent_id = " + this.acctStatusFilters.customerID + " OR c_bpartner_id = " + this.acctStatusFilters.customerID + ")");
        } else {
            strb.append(" AND al.c_bpartner_id = " + this.acctStatusFilters.customerID);
        }
        strb.append(" ORDER BY datedoc");
        sql = strb.toString();
        DB.executeUpdateEx(insert + sql, null);
    }

    private void updateData() throws Exception {
        int rowCount;
        int totalRowCount;
        CPreparedStatement pstmt;
        ResultSet rs;
        block14: {
            String sql = "";
            rs = null;
            pstmt = null;
            this.showHelp("Calculo de saldos...");
            sql = " SELECT *  FROM uy_molde_accountstatus WHERE idreporte=? ORDER BY datetrx, uy_molde_accountstatus_id ASC";
            pstmt = DB.prepareStatement(sql, 1004, 1007, null);
            pstmt.setString(1, this.idReporte);
            rs = pstmt.executeQuery();
            rs.last();
            totalRowCount = rs.getRow();
            rowCount = 0;
            rs.beforeFirst();
            if (totalRowCount > 0) break block14;
            this.updateSoloConSaldoInicial();
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        try {
            Object action = "";
            BigDecimal saldoAcumulado = Env.ZERO;
            BigDecimal saldoInicial = Env.ZERO;
            BigDecimal totalDocumento = Env.ZERO;
            int cBPartnerID = 0;
            int cBPartnerIDAux = 0;
            int cDocTypeID = 0;
            int recordID = 0;
            int moldeID = 0;
            boolean isDebe = false;
            while (rs.next()) {
                this.showHelp("Procesando linea " + rowCount++ + " de " + totalRowCount);
                cDocTypeID = rs.getInt("c_doctype_id");
                recordID = rs.getInt("record_id");
                cBPartnerIDAux = rs.getInt("c_bpartner_id");
                moldeID = rs.getInt("uy_molde_accountstatus_id");
                if (cBPartnerIDAux != cBPartnerID) {
                    cBPartnerID = cBPartnerIDAux;
                    saldoAcumulado = saldoInicial = this.getSaldoInicial(cBPartnerID);
                }
                totalDocumento = rs.getBigDecimal("amtdocument");
                if (rs.getTimestamp("datetrx").compareTo(this.acctStatusFilters.dateFrom) < 0) {
                    totalDocumento = Env.ZERO;
                }
                if (this.acctStatusFilters.IsSOTrx) {
                    if (rs.getString("isinvoice").equalsIgnoreCase("Y")) {
                        saldoAcumulado = saldoAcumulado.add(totalDocumento);
                        isDebe = true;
                    } else {
                        saldoAcumulado = saldoAcumulado.subtract(totalDocumento);
                        isDebe = false;
                    }
                } else if (rs.getString("isinvoice").equalsIgnoreCase("Y")) {
                    saldoAcumulado = saldoAcumulado.subtract(totalDocumento);
                    isDebe = false;
                } else {
                    saldoAcumulado = saldoAcumulado.add(totalDocumento);
                    isDebe = true;
                }
                action = " UPDATE uy_molde_accountstatus SET saldoacumulado =" + saldoAcumulado + ", saldoinicial = " + saldoInicial + "," + (isDebe ? " debe = " : " haber = ") + totalDocumento + " WHERE idreporte ='" + this.idReporte + "' AND c_bpartner_id =" + cBPartnerID + " AND c_doctype_id =" + cDocTypeID + " AND record_id = " + recordID + " AND uy_molde_accountstatus_id = " + moldeID;
                DB.executeUpdateEx((String)action, null);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void updateSoloConSaldoInicial() throws Exception {
        Object sql = "";
        Object where = "";
        String insert = "";
        Object select = "";
        String name = "";
        int partnerID = 0;
        BigDecimal saldoInicial = Env.ZERO;
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            if (this.acctStatusFilters.customerID > 0) {
                where = (String)where + " and bp.c_bpartner_id = " + this.acctStatusFilters.customerID;
            }
            sql = "select c_bpartner_id,value,name from c_bpartner bp where bp.isactive='Y'" + (String)where + " order by bp.value";
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                partnerID = rs.getInt("c_bpartner_id");
                name = rs.getString("name").replace("'", "").trim();
                saldoInicial = this.getSaldoInicial(partnerID);
                if (saldoInicial.compareTo(Env.ZERO) == 0) continue;
                insert = "INSERT INTO uy_molde_accountstatus (uy_molde_accountstatus_id, created, createdBy, updated, updatedBy, idreporte, fecreporte, ad_user_id, ad_client_id, ad_org_id, isinvoice, c_bpartner_id, bpvalue, bpname, isreceipt, record_id, documentno, c_currency_id, currencyname, c_doctype_id, docname, startdate, datetrx, duedate, amtdocument, serie, saldoinicial, debe, haber, saldoacumulado, issotrx)";
                select = " SELECT nextID(" + this.idTableMolde + ", 'N'), now(), 100, now(), 100, '" + this.idReporte + "',current_date," + this.acctStatusFilters.adUserID + "," + this.acctStatusFilters.adClientID + "," + this.acctStatusFilters.adOrgID + ",'N'," + partnerID + ",'" + rs.getString("value") + "','" + name + "','N',null,null," + this.acctStatusFilters.cCurrencyID + ",null,null,null,'" + this.acctStatusFilters.dateFrom + "','" + this.acctStatusFilters.dateFrom + "',null,null,null," + saldoInicial + ",null,null," + saldoInicial + ",'" + this.acctStatusFilters.isSoTrx + "'";
                DB.executeUpdateEx(insert + (String)select, null);
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private BigDecimal getSaldoInicial(int cBPartnerID) throws Exception {
        return this.getSaldoInicialDebe(cBPartnerID).subtract(this.getSaldoInicialHaber(cBPartnerID)).subtract(this.getSaldoInicialAsignaciones(cBPartnerID));
    }

    private BigDecimal getSaldoInicialDebe(int cBPartnerID) throws Exception {
        BigDecimal value = new BigDecimal(0);
        value = this.acctStatusFilters.IsSOTrx ? this.getSaldoInicialDebeDeudInvoice(cBPartnerID) : this.getSaldoInicialDebeProvInvoice(cBPartnerID).add(this.getSaldoInicialDebeProvPayment(cBPartnerID));
        return value;
    }

    private BigDecimal getSaldoInicialHaber(int cBPartnerID) throws Exception {
        BigDecimal value = new BigDecimal(0);
        value = this.acctStatusFilters.IsSOTrx ? this.getSaldoInicialHaberDeudInvoice(cBPartnerID).add(this.getSaldoInicialHaberDeudPayment(cBPartnerID)) : this.getSaldoInicialHaberProvInvoice(cBPartnerID);
        return value;
    }

    private BigDecimal getSaldoInicialDebeDeudInvoice(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.grandtotal),0) as saldo  FROM C_Invoice a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.dateinvoiced <?  AND a.docstatus = 'CO'  AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='Y'  AND b.docBaseType ='ARI'";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getBigDecimal("saldo");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return value;
    }

    private BigDecimal getSaldoInicialHaberDeudInvoice(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.grandtotal),0) as saldo  FROM C_Invoice a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.dateinvoiced <?  AND a.docstatus = 'CO'  AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='Y' AND b.docBaseType IN ('ARC')";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getBigDecimal("saldo");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return value;
    }

    private BigDecimal getSaldoInicialHaberDeudPayment(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        ResultSet rs2 = null;
        CPreparedStatement pstmt2 = null;
        BigDecimal value = new BigDecimal(0);
        BigDecimal amtPay = new BigDecimal(0);
        BigDecimal amtReceipt = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.payamt),0) as saldo  FROM C_Payment a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.datetrx <?  AND a.docstatus in ('CO','CL') AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='Y' AND b.docbasetype='ARR' AND b.docbasetype NOT IN ('DRR','DRP') AND a.uy_payreceipt_id is null AND a.c_charge_id is null";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                amtPay = rs.getBigDecimal("saldo");
            }
            sql = "SELECT COALESCE(SUM(a.payamt),0) as saldo from uy_payreceipt a inner join c_doctype b ON a.c_doctype_id = b.c_doctype_id WHERE a.ad_client_id = " + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.datedoc <?  AND a.docstatus = 'CO' AND b.docbasetype = 'BRR' AND a.issotrx = 'Y' AND a.C_BPartner_ID = " + cBPartnerID + (String)whereMoneda;
            pstmt2 = DB.prepareStatement((String)sql, null);
            pstmt2.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs2 = pstmt2.executeQuery();
            if (rs2.next()) {
                amtReceipt = rs2.getBigDecimal("saldo");
            }
            value = amtPay.add(amtReceipt);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                DB.close(rs2, pstmt2);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        DB.close(rs2, pstmt2);
        return value;
    }

    private BigDecimal getSaldoInicialDebeProvInvoice(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.grandtotal),0) as saldo  FROM C_Invoice a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.dateinvoiced <?  AND a.docstatus = 'CO'  AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='N' AND b.docBaseType IN ('APC')";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getBigDecimal("saldo");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return value;
    }

    private BigDecimal getSaldoInicialDebeProvPayment(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        ResultSet rs2 = null;
        CPreparedStatement pstmt2 = null;
        BigDecimal value = new BigDecimal(0);
        BigDecimal amtPay = new BigDecimal(0);
        BigDecimal amtReceipt = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.payamt),0) as saldo  FROM C_Payment a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.datetrx <?  AND a.docstatus = 'CO'  AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='N' AND b.docbasetype='APP' AND b.docbasetype NOT IN ('DRR','DRP') AND a.uy_payreceipt_id IS NULL";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                amtPay = rs.getBigDecimal("saldo");
            }
            sql = "SELECT COALESCE(SUM(a.payamt),0) as saldo from uy_payreceipt a inner join c_doctype b ON a.c_doctype_id = b.c_doctype_id WHERE a.ad_client_id = " + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.datedoc <?  AND a.docstatus = 'CO' AND b.docbasetype = 'BPP' AND a.issotrx = 'N' AND a.C_BPartner_ID = " + cBPartnerID + (String)whereMoneda;
            pstmt2 = DB.prepareStatement((String)sql, null);
            pstmt2.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs2 = pstmt2.executeQuery();
            if (rs2.next()) {
                amtReceipt = rs2.getBigDecimal("saldo");
            }
            value = amtPay.add(amtReceipt);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                DB.close(rs2, pstmt2);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        DB.close(rs2, pstmt2);
        return value;
    }

    private BigDecimal getSaldoInicialHaberProvInvoice(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(a.grandtotal),0) as saldo  FROM C_Invoice a INNER JOIN C_DocType b ON a.c_doctype_id = b.c_doctype_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + (String)whereOrg + " AND a.dateinvoiced <?  AND a.docstatus = 'CO'  AND a.C_BPartner_ID =" + cBPartnerID + (String)whereMoneda + " AND b.issotrx='N' AND b.docBaseType = 'API'";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getBigDecimal("saldo");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return value;
    }

    private BigDecimal getSaldoInicialAsignaciones(int cBPartnerID) throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        BigDecimal value = new BigDecimal(0);
        try {
            Object whereMoneda = "";
            BigDecimal multiplier = Env.ONE;
            if (!this.acctStatusFilters.IsSOTrx) {
                multiplier = multiplier.negate();
            }
            if (this.acctStatusFilters.cCurrencyID > 0) {
                whereMoneda = " AND a.C_Currency_ID = " + this.acctStatusFilters.cCurrencyID;
            }
            Object whereOrg = "";
            if (this.acctStatusFilters.adOrgID > 0) {
                whereOrg = " AND a.ad_org_id =" + this.acctStatusFilters.adOrgID;
            }
            sql = "SELECT COALESCE(SUM(al.amount),0) as saldo  from c_allocationhdr a  inner join c_allocationline al on a.c_allocationhdr_id = al.c_allocationhdr_id  inner join c_doctype doc ON a.c_doctype_id = doc.c_doctype_id inner join c_currency cur on a.c_currency_id = cur.c_currency_id  inner join c_bpartner bp on al.c_bpartner_id = bp.c_bpartner_id  WHERE a.ad_client_id =" + this.acctStatusFilters.adClientID + " AND al.c_bpartner_id = " + cBPartnerID + (String)whereOrg + (String)whereMoneda + " AND al.c_charge_id > 0 AND a.datetrx < ?  AND a.docstatus in ('CO','CL')  AND NOT EXISTS (select uy_payreceipt_id from uy_payreceipt where c_allocationhdr_id = a.c_allocationhdr_id) AND ((select count(l.c_allocationline_id) from c_allocationline l inner join c_invoice i on l.c_invoice_id = i.c_invoice_id where l.c_allocationhdr_id = a.c_allocationhdr_id and i.issotrx = '" + this.acctStatusFilters.isSoTrx + "') > 0 OR (select count(l.c_allocationline_id) from c_allocationline l inner join c_payment p on l.c_payment_id = p.c_payment_id where l.c_allocationhdr_id = a.c_allocationhdr_id and p.isreceipt = '" + this.acctStatusFilters.isSoTrx + "') > 0)";
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setTimestamp(1, this.acctStatusFilters.dateFrom);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                value = rs.getBigDecimal("saldo");
            }
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return value;
    }

    private void showHelp(String text) {
        if (this.getWaiting() != null) {
            this.getWaiting().setText(text);
        }
    }

    private static String getReportID(Long userID) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        return userID + "_" + sdf.format(System.currentTimeMillis());
    }

    public boolean isParent(MBPartner mbPartner) {
        boolean parent = false;
        String sql = "select c_bpartner_id from c_bpartner where bpartner_parent_id = " + mbPartner.get_ID();
        int value = DB.getSQLValueEx(null, sql, new Object[0]);
        if (value > 0) {
            parent = true;
        }
        return parent;
    }

    public static class ReportOpenAmt {
        public static final String TIPO_MONEDA_SMN = "SMN";
        public static final String TIPO_MONEDA_SME = "SME";
        public static final String TIPO_MONEDA_TMN = "TMN";
        public static final String TIPO_MONEDA_TME = "TME";
        public static final String CTA_ABIERTA = "CA";
        public static final String CTA_DOCUMENTADA = "CD";
        public static final String CTA_CORRIENTE_CLIENTE = "CL";
        public static final String CTA_CORRIENTE_PROVEEDOR = "PR";
        public static final int GRUPO_CLIENTE = 1000001;
        public static final int GRUPO_PROVEEDOR = 1000002;
        public static final String PARTNER_CLIENTE = "CLIENTES";
        public static final String PARTNER_PROVEEDOR = "PROVEEDORES";
        public static final String REPORTCURRTYPE_UNA = "UNA";
        public static final String REPORTCURRTYPE_TODAS = "TODAS";
        public static final String REPORTCURRTYPE_TODASTRX = "TODASTRX";
        public Timestamp dateTo = null;
        public String tipoMoneda = "";
        public int cCurrencyID = 0;
        public String tipoReporte = "";
        public String tipoCtaCte = "";
        public int cBPGroupID = 0;
        public int customerID = 0;
        public int salesRepID = 0;
        public int collectorID = 0;
        public int canalVentaID = 0;
        public int departamentoID = 0;
        public int localidadID = 0;
        public int adUserID = 0;
        public int adClientID = 0;
        public int adOrgID = 0;
        public String partnerType = null;
        public boolean isDueDate = false;
        public String isSoTrx = "";
        public int cBPartnerID = 0;
        public String reportType = "";
        public String fchConsidero = "";
        public String bPartnerType = null;
    }

    public static class ReportAccountStatus {
        public static final int GRUPO_CLIENTE = 1000001;
        public static final int GRUPO_PROVEEDOR = 1000002;
        public static final String PARTNER_CLIENTE = "CLIENTES";
        public static final String PARTNER_PROVEEDOR = "PROVEEDORES";
        public static final String REPORTCURRTYPE_UNA = "UNA";
        public static final String REPORTCURRTYPE_TODAS = "TODAS";
        public static final String REPORTCURRTYPE_TODASTRX = "TODASTRX";
        public Timestamp dateFrom;
        public Timestamp dateTo;
        public int cCurrencyID = 0;
        public int cBPGroupID = 0;
        public int customerID = 0;
        public int adUserID = 0;
        public int adClientID = 0;
        public int adOrgID = 0;
        public String reportType = null;
        public String acctStatusType = null;
        public String currencyType = null;
        public String bPartnerType = null;
        public BigDecimal currencyRate = Env.ONE;
        public Timestamp today;
        public int cBPartnerID = 0;
        public String isSoTrx = "";
        public boolean IsSOTrx = true;
    }
}

