/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import java.io.File;
import java.util.Optional;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfo;
import org.eevolution.services.dsl.ProcessBuilder;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.core.process.PrintDocumentAbstract;

public class PrintDocument
extends PrintDocumentAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        Optional<MLUYCFEType> mluycfeType;
        MInvoice mInvoice = new MInvoice(this.getCtx(), this.getInvoiceId(), this.get_TrxName());
        int printProcessID = this.getPrintProcessId();
        if (printProcessID <= 0) {
            try {
                MSContract msContract = new MSContract(this.getCtx(), mInvoice.get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
                printProcessID = msContract.get_ValueAsInt("AD_Process_ID");
            }
            catch (Exception msContract) {
                // empty catch block
            }
        }
        if (printProcessID <= 0 && (mluycfeType = MLUYCFEType.get(this.getCtx(), this.get_TrxName(), mInvoice.getAD_Org_ID(), mInvoice.getC_DocTypeTarget_ID())).isPresent()) {
            printProcessID = mluycfeType.get().getAD_Process_ID();
        }
        if (printProcessID > 0) {
            ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(printProcessID).withTitle(PrintDocument.getProcessName()).withParameter("C_Invoice_ID", this.getInvoiceId()).execute();
            File pdf = processInfo.getPDFReport();
            System.out.println("pdf = " + pdf);
            this.getProcessInfo().setAD_Process_ID(printProcessID);
            this.getProcessInfo().setPDFReport(pdf);
            if (pdf == null) {
                return "PDF @not.found@";
            }
        } else {
            return "Representaci\u00f3n impresa @not.found@";
        }
        return "";
    }
}

