/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.process.PaymentReturnAbstract;

public class PaymentReturn
extends PaymentReturnAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        String result = "";
        if (this.getRecord_ID() != 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            result = this.generateReturn(payment, this.getDocTypeId(), this.getPayDate());
        }
        return result;
    }

    private String generateReturn(MPayment parentPayment, int documentType_ID, Timestamp payDate) {
        Optional<Object> paymentReturn = Optional.empty();
        Optional<Object> invoiceReturn = Optional.empty();
        Optional paymentAllocation = Optional.empty();
        ArrayList<Optional<Object>> payments = new ArrayList<Optional<Object>>();
        AtomicReference<String> result = new AtomicReference<String>();
        AtomicReference<String> msg = new AtomicReference<String>();
        result.set("");
        msg.set("");
        if (!parentPayment.getDocStatus().equals("CO") && !parentPayment.getDocStatus().equals("CL")) {
            return "@Invalid@ @DocStatus@ -> @C_Payment_ID@ " + parentPayment.getDocumentNo();
        }
        MDocType parentDocType = (MDocType)parentPayment.getC_DocType();
        MDocType returnDocType = MDocType.get(this.getCtx(), documentType_ID);
        if (parentDocType.getDocBaseType().equals(returnDocType.getDocBaseType())) {
            return "@PaymentDocTypeInvoiceInconsistent@";
        }
        Optional<MPayment> paymentReference = Optional.ofNullable(parentPayment.getPaymentReference());
        if (paymentReference.isPresent()) {
            return "@Invalid@ @C_Payment_ID@ -> @Ref_Payment_ID@  = " + paymentReference.get().getDocumentNo();
        }
        if (parentPayment.getC_Charge_ID() != 0) {
            paymentReturn = Optional.ofNullable(this.getPayment(parentPayment, documentType_ID, parentPayment.getDocumentNo() + " - RECHAZADO", payDate));
        } else {
            paymentReturn = Optional.ofNullable(this.getPayment(parentPayment, documentType_ID, parentPayment.getDocumentNo() + " - RECHAZADO", payDate));
            payments.add(paymentReturn);
            payments.add(Optional.ofNullable(parentPayment));
        }
        if (parentPayment.getDescription() != null && !parentPayment.getDescription().equalsIgnoreCase("")) {
            parentPayment.setDescription(parentPayment.getDescription() + " - RECHAZADO");
        } else {
            parentPayment.setDescription("RECHAZADO");
        }
        parentPayment.saveEx();
        invoiceReturn = Optional.ofNullable(this.generateInvoice((MPayment)paymentReturn.get()));
        paymentReturn.ifPresent(payment -> {
            msg.set("@Created@  " + payment.getC_DocType().getName() + " " + payment.getDocumentNo());
            this.addLog((String)msg.get());
            result.set((String)result.get() + (String)msg.get() + "\n");
        });
        invoiceReturn.ifPresent(invoice -> {
            msg.set("@Created@  " + invoice.getC_DocTypeTarget().getName() + " " + invoice.getDocumentNo());
            this.addLog((String)msg.get());
            result.set((String)result.get() + (String)msg.get() + "\n");
        });
        return (String)result.get();
    }

    private MPayment getPayment(MPayment parentPayment, int documentType_ID, String documentNo, Timestamp payDate) {
        MPayment paymentReturn = new MPayment(this.getCtx(), 0, this.get_TrxName());
        MPayment.copyValues(parentPayment, paymentReturn);
        paymentReturn.setC_DocType_ID(documentType_ID);
        paymentReturn.setDocumentNo(documentNo);
        paymentReturn.setDateTrx(payDate);
        paymentReturn.setDateAcct(payDate);
        paymentReturn.setTenderType(parentPayment.getTenderType());
        paymentReturn.setRelatedPayment_ID(parentPayment.getC_Payment_ID());
        int chargeID = this.getCharge(documentType_ID);
        if (chargeID > 0) {
            paymentReturn.setC_Charge_ID(chargeID);
        }
        paymentReturn.saveEx();
        return paymentReturn;
    }

    private MInvoice generateInvoice(MPayment pay) {
        String message = null;
        int docTypeID = 0;
        docTypeID = pay.getC_DocType().getDocBaseType().equals("APP") ? MDocType.getDocType("RRJ") : MDocType.getDocType("PRJ");
        MDocType doc = new MDocType(this.getCtx(), docTypeID, this.get_TrxName());
        MCurrency cur = (MCurrency)pay.getC_Currency();
        MInvoice hdr = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        hdr.setC_DocTypeTarget_ID(docTypeID);
        hdr.setC_DocType_ID(docTypeID);
        hdr.setDocumentNo(pay.getDocumentNo());
        hdr.setDateInvoiced(this.getPayDate());
        hdr.setDateAcct(this.getPayDate());
        hdr.setC_BPartner_ID(pay.getC_BPartner_ID());
        hdr.setC_Currency_ID(cur.get_ID());
        hdr.setTotalLines(pay.getPayAmt());
        hdr.setGrandTotal(pay.getPayAmt());
        hdr.setIsSOTrx(doc.isSOTrx());
        hdr.setC_PaymentTerm_ID(MPaymentTerm.getPaymentTermByDefault(this.getCtx(), this.get_TrxName()).get_ID());
        if (pay.getTenderType().equalsIgnoreCase("K")) {
            hdr.setPaymentRule("S");
        } else if (pay.getTenderType().equalsIgnoreCase("A")) {
            hdr.setPaymentRule("T");
        } else if (pay.getTenderType().equalsIgnoreCase("R")) {
            hdr.setPaymentRule("R");
        }
        MPriceList list = MPriceList.getDefault(this.getCtx(), doc.isSOTrx(), cur.getISO_Code());
        if (list == null) {
            throw new AdempiereException("No se obtuvo lista de precios predeterminada en " + cur.getISO_Code());
        }
        hdr.setM_PriceList_ID(list.get_ID());
        String sql = "select c_bpartner_location_id from c_bpartner_location where isbillto = 'Y' and c_bpartner_id = " + pay.getC_BPartner_ID();
        int locID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        if (locID <= 0) {
            throw new AdempiereException("No se obtuvo localizacion para el socio de negocio");
        }
        hdr.setC_BPartner_Location_ID(locID);
        hdr.setDocStatus("DR");
        hdr.setDocAction("CO");
        hdr.saveEx();
        MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
        line.setC_Invoice_ID(hdr.get_ID());
        line.setLine(0);
        line.setC_Charge_ID(pay.getC_Charge_ID());
        line.setQtyEntered(Env.ONE);
        line.setQtyInvoiced(Env.ONE);
        line.setPriceEntered(pay.getPayAmt());
        line.setPriceActual(pay.getPayAmt());
        line.setLineNetAmt(pay.getPayAmt());
        line.setLineTotalAmt(pay.getPayAmt());
        line.saveEx();
        MInvoicePaySchedule schedule = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
        schedule.setAD_Org_ID(pay.getAD_Org_ID());
        schedule.setC_Invoice_ID(hdr.get_ID());
        schedule.setDueAmt(pay.getPayAmt());
        schedule.setDueDate(this.getPayDate());
        schedule.setDiscountDate(this.getPayDate());
        schedule.setIsValid(true);
        schedule.saveEx();
        hdr.validatePaySchedule();
        hdr.saveEx();
        if (!hdr.processIt("CO")) {
            message = hdr.getProcessMsg();
            throw new AdempiereException(message);
        }
        return hdr;
    }

    private int getCharge(int docTypeID) {
        String sql = "select c.c_charge_id from c_charge c join c_chargetype_doctype d on c.c_chargetype_id = d.c_chargetype_id  where d.c_doctype_id = " + docTypeID;
        int value = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
        return value;
    }
}

