/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import com.eevolution.model.MServiceType;
import com.eevolution.model.X_S_ContractLine;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMemo;
import org.compiere.model.MProduct;
import org.compiere.model.MSubstitute;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.core.model.MSContractDiscount;
import org.openup.core.model.MSContractLine;
import org.openup.core.model.X_S_ContractDiscount;
import org.openup.core.process.PUpdateServiceContractAbstract;

public class PUpdateServiceContract
extends PUpdateServiceContractAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<Integer> recordIds = this.getSelectionKeys();
        recordIds.stream().forEach(key -> {
            String message = "";
            MSContract contract = new MSContract(this.getCtx(), (int)key, this.get_TrxName());
            if (contract.getDocStatus().equals("CO")) {
                if (!contract.processIt("CL")) {
                    message = contract.getProcessMsg();
                    throw new AdempiereException(message);
                }
                contract.saveEx();
            }
            MSContract newContract = new MSContract(this.getCtx(), 0, this.get_TrxName());
            newContract.setAD_Org_ID(contract.getAD_Org_ID());
            newContract.setC_DocType_ID(contract.getC_DocType_ID());
            newContract.setC_BPartner_ID(contract.getC_BPartner_ID());
            newContract.setC_BPartner_Location_ID(contract.getC_BPartner_Location_ID());
            newContract.setBill_BPartner_ID(contract.getBill_BPartner_ID());
            newContract.setBill_Location_ID(contract.getBill_Location_ID());
            newContract.set_ValueOfColumn("UY_Family_ID", contract.get_Value("UY_Family_ID"));
            newContract.setDateDoc(this.getDateDoc());
            newContract.setDateAcct(this.getDateAcct());
            newContract.setDateStart(this.getDateStart());
            newContract.setDateFinishSchedule(this.getDateFinishSchedule());
            newContract.setDuration(contract.getDuration());
            newContract.setDurationUnit(contract.getDurationUnit());
            newContract.setInvoiceRule(contract.getInvoiceRule());
            newContract.setM_PriceList_ID(contract.getM_PriceList_ID());
            newContract.setC_Currency_ID(contract.getC_Currency_ID());
            newContract.setSalesRep_ID(contract.getSalesRep_ID());
            newContract.setPaymentRule(contract.getPaymentRule());
            newContract.setC_PaymentTerm_ID(contract.getC_PaymentTerm_ID());
            newContract.setM_Warehouse_ID(contract.getM_Warehouse_ID());
            newContract.setIsCreditApproved(contract.isCreditApproved());
            newContract.setPosted(true);
            newContract.setIsInvoiced(false);
            newContract.setIsSOTrx(contract.isSOTrx());
            newContract.setTotalLines(Env.ZERO);
            newContract.setGrandTotal(Env.ZERO);
            newContract.setDocStatus("DR");
            newContract.setDocAction("CO");
            newContract.saveEx();
            List mSContractLines = new Query(this.getCtx(), "S_ContractLine", "S_Contract_ID=?", this.get_TrxName()).setParameters(contract.get_ID()).list();
            MProduct newProd = null;
            for (X_S_ContractLine mSContractLine : mSContractLines) {
                MSContractLine line = new MSContractLine(this.getCtx(), 0, this.get_TrxName());
                MProduct prod = (MProduct)mSContractLine.getM_Product();
                if (this.getServiceTypeId() > 0) {
                    newProd = (MProduct)new Query(this.getCtx(), "M_Product", "S_ServiceType_ID=?", this.get_TrxName()).setParameters(this.getServiceTypeId()).first();
                    if (newProd == null || newProd.get_ID() <= 0) throw new AdempiereException("ERROR: No se obtuvo producto para el tipo de servicio seleccionado");
                    line.setM_Product_ID(newProd.get_ID());
                } else {
                    MSubstitute substitute = (MSubstitute)new Query(this.getCtx(), "M_Substitute", "M_Product_ID=?", this.get_TrxName()).setParameters(prod.get_ID()).first();
                    if (substitute == null || substitute.get_ID() <= 0 || substitute.getM_Product_ID() <= 0) throw new AdempiereException("ERROR: No se obtuvo sustituto para el producto '" + prod.getName() + "'");
                    newProd = (MProduct)substitute.getSubstitute();
                    line.setM_Product_ID(newProd.get_ID());
                }
                MMemo memo = (MMemo)new Query(this.getCtx(), "AD_Memo", "M_Product_ID=?", this.get_TrxName()).setParameters(newProd.get_ID()).first();
                if (memo == null || memo.get_ID() <= 0 || memo.getC_Activity_ID() <= 0) {
                    throw new AdempiereException("ERROR: No se obtuvo Actividad para el producto '" + newProd.getName() + "'");
                }
                line.setC_Activity_ID(memo.getC_Activity_ID());
                newContract.setC_Activity_ID(memo.getC_Activity_ID());
                newContract.saveEx();
                if (newProd.get_ValueAsInt("S_ServiceType_ID") <= 0) throw new AdempiereException("ERROR: El producto '" + newProd.getName() + "' no tiene Tipo de Servicio definido");
                MServiceType serviceType = new MServiceType(this.getCtx(), newProd.get_ValueAsInt("S_ServiceType_ID"), this.get_TrxName());
                line.setS_ServiceType_ID(newProd.get_ValueAsInt("S_ServiceType_ID"));
                if (serviceType.get_ValueAsBoolean("IsRecurrent")) {
                    line.setIsRecurrent(true);
                    line.setFrequencyType(serviceType.get_ValueAsString("FrequencyType"));
                    line.setFrequency(serviceType.get_ValueAsInt("Frequency"));
                }
                line.setS_Contract_ID(newContract.get_ID());
                line.setC_BPartner_ID(mSContractLine.getC_BPartner_ID());
                line.setC_BPartner_Location_ID(mSContractLine.getC_BPartner_Location_ID());
                line.setC_Currency_ID(mSContractLine.getC_Currency_ID());
                line.setQtyEntered(mSContractLine.getQtyEntered());
                line.setQtyOrdered(mSContractLine.getQtyOrdered());
                line.setQtyDelivered(Env.ZERO);
                line.setC_UOM_ID(mSContractLine.getC_UOM_ID());
                line.setC_Tax_ID(mSContractLine.getC_Tax_ID());
                line.setDiscount(mSContractLine.getDiscount());
                line.setPriceActual(Env.ZERO);
                line.setPriceEntered(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                line.saveEx();
            }
            List mSContractDiscounts = new Query(this.getCtx(), "S_ContractDiscount", "S_Contract_ID=?", this.get_TrxName()).setParameters(contract.get_ID()).list();
            for (X_S_ContractDiscount mSContractDisc : mSContractDiscounts) {
                MSContractDiscount discountLine = new MSContractDiscount(this.getCtx(), 0, this.get_TrxName());
                discountLine.setS_Contract_ID(newContract.get_ID());
                discountLine.setM_DiscountSchema_ID(mSContractDisc.getM_DiscountSchema_ID());
                discountLine.setDiscount(mSContractDisc.getDiscount());
                if (newProd != null) {
                    discountLine.setM_Product_Category_ID(newProd.getM_Product_Category_ID());
                }
                discountLine.saveEx();
            }
            if (this.getDocAction() == null) return;
            if (!newContract.processIt(this.getDocAction())) {
                message = newContract.getProcessMsg();
                throw new AdempiereException(message);
            }
            newContract.saveEx();
        });
        return "OK";
    }
}

