/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.openup.core.process.PTestAllocatedInvoiceAbstract;

public class PTestAllocatedInvoice
extends PTestAllocatedInvoiceAbstract {
    private int clientID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty() || !name.equalsIgnoreCase("AD_Client_ID")) continue;
            this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.executeProcess();
        return "OK";
    }

    public void executeProcess() throws Exception {
        Object sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE DocStatus = 'CO' AND IsPaid = 'N' AND IsSOTrx = 'Y' AND PaymentRule IN ('B','D','T') AND AD_Client_ID = " + this.clientID;
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MInvoice invoice = new MInvoice(this.getCtx(), rs.getInt("C_Invoice_ID"), null);
                if (invoice == null || invoice.get_ID() <= 0 || !invoice.testAllocation()) continue;
                invoice.saveEx();
            }
        }
        catch (Exception ex) {
            try {
                throw new AdempiereException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }
}

