/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import com.eevolution.model.MSContract;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.Query;
import org.openup.core.process.PGenerateOrderFromProjectAbstract;
import org.openup.core.utils.model.MOrder;

public class PGenerateOrderFromProject
extends PGenerateOrderFromProjectAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int total = 0;
        int updated = 0;
        for (Integer key : this.getSelectionKeys()) {
            int c_project_id = this.getSelectionAsInt(key, "P_C_Project_ID");
            int c_order_id = this.getSelectionAsInt(key, "O_C_Order_ID");
            MProject mProject = new MProject(this.getCtx(), c_project_id, this.get_TrxName());
            if (c_order_id > 0) {
                org.compiere.model.MOrder mOrder = new org.compiere.model.MOrder(this.getCtx(), c_order_id, this.get_TrxName());
                this.createNegativeOrderForProject(mProject, mOrder);
                ++updated;
            }
            this.createOrderForProject(mProject);
            ++total;
        }
        return "Proyectos procesados " + total + " (Actualizados " + updated + ")";
    }

    private void createOrderForProject(MProject mProject) {
        MDocType mDocType = new MDocType(this.getCtx(), this.getDocTypeId(), this.get_TrxName());
        MSContract msContract = new MSContract(this.getCtx(), mProject.get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
        org.compiere.model.MOrder mOrder = new org.compiere.model.MOrder(mProject, true, mDocType.getDocSubTypeSO());
        mOrder.setC_DocTypeTarget_ID(this.getDocTypeId());
        mOrder.setC_Project_ID(mProject.get_ID());
        mOrder.set_ValueOfColumn("S_Contract_ID", (Object)msContract.get_ID());
        mOrder.setC_Currency_ID(mProject.getC_Currency_ID());
        mOrder.setM_PriceList_ID(mProject.getM_PriceList_ID());
        mOrder.setDateOrdered(this.getDateOrdered());
        mOrder.setDatePromised(this.getDateOrdered());
        mOrder.setBill_BPartner_ID(msContract.getBill_BPartner_ID());
        mOrder.setBill_Location_ID(msContract.getBill_Location_ID());
        mOrder.setPromotionCode(mProject.getPOReference());
        mOrder.saveEx();
        MProjectLine mProjectLine = (MProjectLine)new Query(this.getCtx(), "C_ProjectLine", "C_Project_ID=?", this.get_TrxName()).setParameters(mProject.get_ID()).first();
        if (mProjectLine == null) {
            throw new AdempiereException("Linea de Proyecto " + mProject.getValue() + " no definida");
        }
        MProduct mProduct = (MProduct)mProjectLine.getM_Product();
        if (mProduct == null || mProduct.get_ID() <= 0) {
            throw new AdempiereException("Producto no definido en Linea de Proyecto");
        }
        MOrderLine mOrderLine = new MOrderLine(mOrder);
        mOrderLine.setLine(10);
        mOrderLine.setM_Product_ID(mProduct.get_ID(), true);
        mOrderLine.setQty(mProjectLine.getPlannedQty());
        mOrderLine.setQtyEntered(mProjectLine.getPlannedQty());
        mOrderLine.setQtyOrdered(mProjectLine.getPlannedQty());
        mOrderLine.setC_UOM_ID(mProduct.getC_UOM_ID());
        mOrderLine.setC_Project_ID(mProject.get_ID());
        mOrderLine.setPriceActual(mProjectLine.getPlannedPrice());
        mOrderLine.setPriceEntered(mProjectLine.getPlannedPrice());
        mOrderLine.setLineNetAmt(mProjectLine.getPlannedAmt());
        mOrderLine.setTax();
        mOrderLine.saveEx();
        mOrder.setDocAction("CO");
        mOrder.processIt("CO");
        mOrder.saveEx();
    }

    private void createNegativeOrderForProject(MProject mProject, org.compiere.model.MOrder mOrder) {
        org.compiere.model.MOrder negativeMOrder = MOrder.createNegative(mOrder);
        if (MOrder.partiallyBilled(mOrder)) {
            throw new AdempiereException("Orden " + mOrder.getDocumentNo() + " facturada");
        }
        negativeMOrder.setDateOrdered(mOrder.getDateOrdered());
        negativeMOrder.setDatePromised(mOrder.getDatePromised());
        negativeMOrder.processIt("CO");
        negativeMOrder.saveEx();
        mProject.set_ValueOfColumn("CostAdjustment", (Object)false);
        mProject.saveEx();
        mOrder.setDocStatus("CL");
        mOrder.setDocAction("--");
        mOrder.setProcessed(true);
        mOrder.calculateTaxTotal();
        mOrder.saveEx();
        negativeMOrder.setDocStatus("CL");
        negativeMOrder.setDocAction("--");
        negativeMOrder.setProcessed(true);
        negativeMOrder.calculateTaxTotal();
        negativeMOrder.saveEx();
        negativeMOrder.processIt("PO");
    }
}

