/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.MLoanConfig;
import org.openup.core.model.MViaLoan;

public class PCreateSOForVia
extends SvrProcess {
    private int clientID = 0;
    private int orgID = 0;
    private int periodID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty()) continue;
            if (name.equalsIgnoreCase("AD_Client_ID")) {
                this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("AD_Org_ID")) {
                this.orgID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("C_Period_ID") || para[i].getParameter() == null) continue;
            this.periodID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        if (this.orgID == 0) {
            throw new AdempiereException("No se pudo obtener organizacion actual");
        }
        if (this.periodID == 0) {
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            String sql = "select c_period_id from c_period where '" + today + "' between startdate and enddate and ad_client_id = " + this.clientID;
            int perID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (perID > 0) {
                this.periodID = perID;
            } else {
                throw new AdempiereException("No se pudo obtener periodo para fecha actual");
            }
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.executeProcess();
        return "OK";
    }

    public void executeProcess() throws Exception {
        String sql = "";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        int docTypeID = 0;
        int productID = 0;
        int salesRepID = 0;
        try {
            MLoanConfig param = MLoanConfig.forClientOrg(this.getCtx(), this.get_TrxName(), this.clientID, this.orgID);
            if (param == null) {
                throw new AdempiereException("No se obtuvieron parametros de prestamos para la empresa actual");
            }
            if (param.getC_DocType_ID() <= 0) {
                throw new AdempiereException("No se obtuvo documento de cuota social en parametros de prestamos");
            }
            docTypeID = param.getC_DocType_ID();
            if (param.getM_Product_ID() <= 0) {
                throw new AdempiereException("No se obtuvo producto de cuota social en parametros de prestamos");
            }
            productID = param.getM_Product_ID();
            if (param.getSalesRep_ID() <= 0) {
                throw new AdempiereException("No se obtuvo agente comercial predeterminado en parametros de prestamos");
            }
            salesRepID = param.getSalesRep_ID();
            MPeriod period = new MPeriod(this.getCtx(), this.periodID, this.get_TrxName());
            sql = "select c_bpartner_id from c_bpartner where isactive = 'Y' and isprospect = 'Y'";
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int partnerID = rs.getInt("c_bpartner_id");
                for (MViaLoan via : MViaLoan.getViasForPartner(partnerID, this.getCtx())) {
                    String plateNo = via.getPlateNo().toUpperCase().trim();
                    String reference = via.getValue().toUpperCase().trim() + "-" + plateNo;
                    String sql2 = "select c_order_id from c_order where c_doctypetarget_id = " + docTypeID + " and c_bpartner_id = " + partnerID + " and dateordered between '" + period.getStartDate() + "' and '" + period.getEndDate() + "' and uy_vialoan_id = " + via.get_ID() + " and docstatus in ('CO','CL','IP') and isactive = 'Y' and ad_client_id = " + this.clientID + " and ad_org_id = " + this.orgID;
                    int result = DB.getSQLValueEx(this.get_TrxName(), sql2, new Object[0]);
                    if (result > 0) continue;
                    String sql3 = "select count(*) from c_invoice_candidate_v_opup where c_bpartner_id = " + partnerID + " and uy_vialoan_id = " + via.get_ID() + " and c_doctype_id = " + docTypeID + " and ad_client_id = " + this.clientID + " and ad_org_id = " + this.orgID;
                    int count = DB.getSQLValueEx(this.get_TrxName(), sql3, new Object[0]);
                    if (count > 3) {
                        via.setIsSelected(false);
                        via.saveEx();
                        this.processVoidSO(partnerID, via, docTypeID);
                        continue;
                    }
                    this.createSO(partnerID, via, docTypeID, productID, salesRepID, reference);
                }
            }
        }
        catch (Exception ex) {
            try {
                throw new AdempiereException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public void processVoidSO(int partnerID, MViaLoan via, int docTypeID) {
        Object sql = "";
        String message = null;
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            sql = "select c_order_id from c_invoice_candidate_v_opup where c_bpartner_id = " + partnerID + " and uy_vialoan_id = " + via.get_ID() + " and c_doctype_id = " + docTypeID + " order by documentno";
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MOrder order = new MOrder(this.getCtx(), rs.getInt("c_order_id"), this.get_TrxName());
                if (!order.processIt("VO")) {
                    message = order.getProcessMsg();
                    throw new AdempiereException(message);
                }
                order.setIsActive(false);
                order.saveEx();
            }
        }
        catch (Exception ex) {
            try {
                throw new AdempiereException(ex.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    public void createSO(int partnerID, MViaLoan via, int docTypeID, int productID, int salesRepID, String reference) {
        String message = null;
        Object whereClause = "";
        try {
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            MOrg org = new MOrg(this.getCtx(), this.orgID, this.get_TrxName());
            MOrgInfo info = org.getInfo();
            MBPartner partner = new MBPartner(this.getCtx(), partnerID, this.get_TrxName());
            MProduct product = new MProduct(this.getCtx(), productID, this.get_TrxName());
            MPriceList list = MPriceList.getDefault(this.getCtx(), true, "UYU");
            if (list == null) {
                whereClause = "IsSOPriceList = 'Y' AND IsDefault = 'Y' AND C_Currency_ID = 142 AND AD_Client_ID = " + this.clientID;
                list = (MPriceList)new Query(this.getCtx(), "M_PriceList", (String)whereClause, null).setOnlyActiveRecords(true).setOrderBy("M_PriceList_ID").first();
                if (list == null) {
                    throw new AdempiereException("No se obtuvo lista de precios de venta en Pesos por defecto");
                }
            }
            MOrder hdr = new MOrder(this.getCtx(), 0, this.get_TrxName());
            hdr.set_ValueOfColumn("AD_Client_ID", (Object)this.clientID);
            hdr.setAD_Org_ID(this.orgID);
            hdr.setIsSOTrx(true);
            hdr.set_ValueOfColumn("UY_ViaLoan_ID", (Object)via.get_ID());
            hdr.setPOReference(reference);
            hdr.setC_DocType_ID(docTypeID);
            hdr.setC_DocTypeTarget_ID(docTypeID);
            hdr.setDateOrdered(today);
            hdr.setDatePromised(today);
            hdr.setDateAcct(today);
            hdr.setC_BPartner_ID(partnerID);
            int locationID = partner.getPrimaryC_BPartner_Location_ID();
            if (locationID > 0) {
                hdr.setC_BPartner_Location_ID(locationID);
            }
            hdr.setM_PriceList_ID(list.get_ID());
            hdr.setC_Currency_ID(list.getC_Currency_ID());
            hdr.setPaymentRule("S");
            hdr.setSalesRep_ID(salesRepID);
            hdr.setDeliveryViaRule("P");
            hdr.setInvoiceRule("I");
            if (info.getM_Warehouse_ID() <= 0) {
                throw new AdempiereException("No se obtuvo almacen desde la organizacion");
            }
            hdr.setM_Warehouse_ID(info.getM_Warehouse_ID());
            whereClause = "IsDefault = 'Y' AND AD_Client_ID = " + this.clientID;
            MPaymentTerm term = (MPaymentTerm)new Query(this.getCtx(), "C_PaymentTerm", (String)whereClause, null).setOnlyActiveRecords(true).first();
            if (term == null || term.get_ID() <= 0) {
                throw new AdempiereException("No se obtuvo termino de pago por defecto");
            }
            hdr.setC_PaymentTerm_ID(term.get_ID());
            hdr.setDocStatus("DR");
            hdr.setDocAction("CO");
            hdr.saveEx();
            MOrderLine line = new MOrderLine(this.getCtx(), 0, this.get_TrxName());
            line.set_ValueOfColumn("AD_Client_ID", (Object)hdr.getAD_Client_ID());
            line.setAD_Org_ID(hdr.getAD_Org_ID());
            line.setOrder(hdr);
            line.setC_Order_ID(hdr.get_ID());
            line.setM_Product_ID(productID);
            line.setQtyEntered(Env.ONE);
            line.setQtyOrdered(Env.ONE);
            line.setC_UOM_ID(MUOM.getDefault_UOM_ID(this.getCtx()));
            line.setPrice();
            MTaxCategory taxCat = (MTaxCategory)product.getC_TaxCategory();
            MTax tax = taxCat.getDefaultTax();
            if (tax == null || tax.get_ID() <= 0) {
                throw new AdempiereException("No se obtuvo tasa de impuesto para la categoria '" + taxCat.getName() + "'");
            }
            line.setC_Tax_ID(tax.get_ID());
            line.saveEx();
            if (!hdr.processIt("CO")) {
                message = hdr.getProcessMsg();
                throw new AdempiereException(message);
            }
            hdr.saveEx();
        }
        catch (Exception ex) {
            throw new AdempiereException(ex.getMessage());
        }
    }
}

