/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.openup.core.model.MViaLoan;

public class PCapitalReturn
extends SvrProcess {
    private int clientID = 0;
    private int partnerID = 0;
    private int viaID = 0;
    private int chargeID = 0;
    private int accountID = 0;
    private String tenerType = "";
    private String checkNo = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name.isEmpty()) continue;
            if (name.equalsIgnoreCase("C_BPartner_ID")) {
                if (para[i].getParameter() == null) continue;
                this.partnerID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("UY_ViaLoan_ID")) {
                if (para[i].getParameter() == null) continue;
                this.viaID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("C_Charge_ID")) {
                if (para[i].getParameter() == null) continue;
                this.chargeID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (name.equalsIgnoreCase("TenderType")) {
                if (para[i].getParameter() == null) continue;
                this.tenerType = (String)para[i].getParameter();
                continue;
            }
            if (name.equalsIgnoreCase("CheckNo")) {
                if (para[i].getParameter() == null) continue;
                this.checkNo = (String)para[i].getParameter();
                continue;
            }
            if (name.equalsIgnoreCase("C_BankAccount_ID")) {
                if (para[i].getParameter() == null) continue;
                this.accountID = ((BigDecimal)para[i].getParameter()).intValueExact();
                continue;
            }
            if (!name.equalsIgnoreCase("AD_Client_ID") || para[i].getParameter() == null) continue;
            this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.executeProcess();
        return "OK";
    }

    public void executeProcess() throws Exception {
        BigDecimal capital = Env.ZERO;
        try {
            capital = MViaLoan.getCapital(this.viaID);
            if (capital.compareTo(Env.ZERO) > 0) {
                this.generatePayment(capital);
            }
        }
        catch (Exception ex) {
            throw new AdempiereException(ex.getMessage());
        }
    }

    private void generatePayment(BigDecimal capital) {
        try {
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            int docID = MDocType.getDocType("APP", " AND IsDocNoControlled = 'N'");
            MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
            pay.setDescription("Generado desde proceso de devoluci\u00f3n de capital");
            pay.setIsReceipt(false);
            pay.setC_DocType_ID(docID);
            pay.setDateTrx(today);
            pay.setDateAcct(today);
            pay.setC_BankAccount_ID(this.accountID);
            pay.setC_BPartner_ID(this.partnerID);
            pay.setC_Currency_ID(142);
            pay.setPayAmt(capital);
            pay.setC_Charge_ID(this.chargeID);
            pay.setTenderType(this.tenerType);
            if (this.checkNo != null) {
                pay.setCheckNo(this.checkNo);
            }
            pay.set_ValueOfColumn("UY_ViaLoan_ID", (Object)this.viaID);
            pay.setDocStatus("DR");
            pay.setDocAction("CO");
            pay.setC_ConversionType_ID(114);
            pay.saveEx();
            pay.processIt("CO");
        }
        catch (Exception ex) {
            throw new AdempiereException(ex.getMessage());
        }
    }
}

