/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.util.Hashtable;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang3.ObjectUtils;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MTable;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.openup.core.process.InvoiceGenFromTimeExpenseAbstract;

public class InvoiceGenFromTimeExpense
extends InvoiceGenFromTimeExpenseAbstract {
    private Hashtable<Integer, Hashtable<Integer, MInvoice>> teInvoices;
    private int quantityOfInvoices;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.teInvoices = new Hashtable();
        this.quantityOfInvoices = 0;
        Trx.run(trxName -> {
            if (this.isSelection()) {
                for (Integer key : this.getSelectionKeys()) {
                    this.addLog("Processing time expense line " + key);
                    int timeExpenseLine_ID = this.getSelectionAsInt(key, "ER_RV_S_TimeExpenseToInvoice_ID");
                    MTimeExpenseLine mTimeExpenseLine2 = new MTimeExpenseLine(this.getCtx(), timeExpenseLine_ID, trxName);
                    this.processTimeExpenseLine(mTimeExpenseLine2, trxName);
                }
            } else if ("UY_InvoiceImport".equalsIgnoreCase(MTable.getTableName(this.getCtx(), this.getTable_ID()))) {
                String sqlWhere = "IsInvoiced=? AND EXISTS (SELECT 1 FROM S_TimeExpense te WHERE te.S_TimeExpense_ID=S_TimeExpenseLine.S_TimeExpense_ID AND te.DocStatus=? AND te.UY_InvoiceImport_ID=?)";
                new Query(this.getCtx(), "S_TimeExpenseLine", sqlWhere, trxName).setParameters(false, "CO", this.getRecord_ID()).list().forEach(mTimeExpenseLine -> this.processTimeExpenseLine((MTimeExpenseLine)mTimeExpenseLine, trxName));
            } else {
                throw new AdempiereException("Table not implemented");
            }
        });
        this.teInvoices.forEach((cBPartner_ID, cbpInvoices) -> cbpInvoices.forEach((currency_ID, mInvoice) -> {
            try {
                Trx.run(trxInvoiceName -> {
                    mInvoice.set_TrxName(trxInvoiceName);
                    mInvoice.processIt(this.getDocAction());
                    mInvoice.saveEx();
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addLog("@C_Invoice_ID@ " + mInvoice.getDocumentNo() + " Error - " + e.getMessage());
            }
        }));
        return "@DocProcessed@: " + this.quantityOfInvoices;
    }

    private void processTimeExpenseLine(MTimeExpenseLine mTimeExpenseLine, String trxAuxName) {
        MTimeExpense mTimeExpense = (MTimeExpense)mTimeExpenseLine.getS_TimeExpense();
        MProduct mProduct = (MProduct)mTimeExpenseLine.getM_Product();
        MPriceList mPriceList = (MPriceList)mTimeExpense.getM_PriceList();
        BigDecimal priceListAmt = Env.ZERO;
        if (mPriceList == null || mPriceList.get_ID() <= 0) {
            throw new AdempiereException("Lista de precios del contrato no definida");
        }
        MPriceListVersion mPriceListVersion = mPriceList.getPriceListVersion(null);
        if (mPriceListVersion == null || mPriceListVersion.get_ID() <= 0) {
            throw new AdempiereException("Versi\u00f3n de lista de precios " + mPriceList.getName() + " no encontrada");
        }
        MProductPrice[] mProductPrice = mPriceListVersion.getProductPrice(" AND M_Product_ID=" + mProduct.getM_Product_ID());
        if (mProductPrice.length > 0) {
            priceListAmt = mProductPrice[0].getPriceList();
        }
        MInvoice mInvoice = this.getInvoice(mTimeExpense, mTimeExpenseLine, trxAuxName);
        MInvoiceLine mInvoiceLine = new MInvoiceLine(mInvoice);
        BigDecimal expenseAmt = mTimeExpenseLine.getExpenseAmt();
        BigDecimal qty = mTimeExpenseLine.getQty();
        mInvoiceLine.setQty(qty);
        mInvoiceLine.setQtyEntered(qty);
        mInvoiceLine.setPriceActual(expenseAmt);
        mInvoiceLine.setPriceEntered(expenseAmt);
        mInvoiceLine.setPriceList(priceListAmt);
        mInvoiceLine.setProduct(mProduct);
        mInvoiceLine.setC_UOM_ID(mProduct.getC_UOM_ID());
        mInvoiceLine.setDescription(mTimeExpenseLine.getDescription());
        mInvoiceLine.setC_Tax_ID(mTimeExpenseLine.getC_Tax_ID());
        mInvoiceLine.setC_Activity_ID(mTimeExpenseLine.getC_Activity_ID());
        mInvoiceLine.set_ValueOfColumn("S_ContractLine_ID", mTimeExpenseLine.get_Value("S_ContractLine_ID"));
        mInvoiceLine.set_ValueOfColumn("S_TimeExpenseLine_ID", (Object)mTimeExpenseLine.get_ID());
        mInvoiceLine.setDescription(mTimeExpenseLine.get_ValueAsString("Description"));
        if (mTimeExpense.get_ValueAsBoolean("IsSelfService")) {
            mInvoice.setIsSelfService(true);
            mInvoice.saveEx();
        }
        mInvoiceLine.saveEx();
        mTimeExpenseLine.setC_InvoiceLine_ID(mInvoiceLine.get_ID());
        mTimeExpenseLine.setIsInvoiced(true);
        mTimeExpenseLine.saveEx();
    }

    private MInvoice getInvoice(MTimeExpense mTimeExpense, MTimeExpenseLine mTimeExpenseLine, String trxName) {
        Object description;
        MInvoice mInvoice;
        int cBPartner_ID = mTimeExpense.get_ValueAsInt("Bill_BPartner_ID");
        int currency_ID = mTimeExpenseLine.getC_Currency_ID();
        int priceListId = mTimeExpense.getM_PriceList_ID();
        try {
            mInvoice = this.teInvoices.get(cBPartner_ID).get(priceListId);
        }
        catch (Exception e) {
            mInvoice = null;
        }
        if (mInvoice == null) {
            Hashtable<Object, Object> cbpInvoices;
            mInvoice = new MInvoice(this.getCtx(), 0, trxName);
            mInvoice.setDateInvoiced(this.getDateInvoiced());
            mInvoice.setDateAcct(this.getDateInvoiced());
            mInvoice.setClientOrg(mTimeExpenseLine.getAD_Client_ID(), mTimeExpenseLine.getAD_Org_ID());
            if (this.getDocTypeTargetId() > 0) {
                mInvoice.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
            } else {
                mInvoice.setC_DocTypeTarget_ID("ARI");
            }
            mInvoice.setC_BPartner_ID(cBPartner_ID);
            MBPartner businessPartner = new MBPartner(this.getCtx(), cBPartner_ID, trxName);
            mInvoice.setC_BPartner_Location_ID(businessPartner.getPrimaryC_BPartner_Location_ID());
            mInvoice.setSalesRep_ID(this.getAD_User_ID());
            mInvoice.setC_Currency_ID(currency_ID);
            mInvoice.setM_PriceList_ID(priceListId);
            if (this.teInvoices.containsKey(cBPartner_ID)) {
                cbpInvoices = this.teInvoices.get(cBPartner_ID);
            } else {
                cbpInvoices = new Hashtable();
                this.teInvoices.put(cBPartner_ID, cbpInvoices);
            }
            cbpInvoices.put(priceListId, mInvoice);
            ++this.quantityOfInvoices;
        }
        description = !((String)(description = ObjectUtils.firstNonNull(mInvoice.getDescription(), ""))).isEmpty() ? (String)description + "\n" : "";
        description = (String)description + ObjectUtils.firstNonNull(mTimeExpense.getDescription(), "");
        mInvoice.setDescription((String)description);
        if (mInvoice.is_Changed()) {
            mInvoice.saveEx();
        }
        return mInvoice;
    }
}

