/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProject;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class GeneratePOFromSOLines
extends SvrProcess {
    private int clientID = 0;
    private int orgID = 0;
    private int vendorID = 0;
    private int docTypeID = 0;
    private int partnerLocationID = 0;
    private int priceListID = 0;
    private int taxID = 0;
    private int paymentTermID = 0;
    private int salesRepID = 0;
    private int warehouseID = 0;
    private String priority = null;
    private String poReference = null;
    private String description = null;
    private String orderType = null;
    private String action = null;
    private Timestamp dateOrdered = null;
    private Timestamp datePromised = null;
    private int user1ID = 0;
    private boolean isFirstLine = true;
    private int vendorSplitID = 0;
    private boolean isSplit = false;
    private int productSplitID = 0;
    private int docTypeSplitID = 0;
    private int user3ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("AD_Client_ID") && para[i].getParameter() != null) {
                this.clientID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("AD_Org_ID") && para[i].getParameter() != null) {
                this.orgID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BPartner_ID") && para[i].getParameter() != null) {
                this.vendorID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BPartner_Location_ID") && para[i].getParameter() != null) {
                this.partnerLocationID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_DocType_ID") && para[i].getParameter() != null) {
                this.docTypeID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("M_PriceList_ID") && para[i].getParameter() != null) {
                this.priceListID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("DateOrdered") && para[i].getParameter() != null) {
                this.dateOrdered = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("DatePromised") && para[i].getParameter() != null) {
                this.datePromised = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("Priority") && para[i].getParameter() != null) {
                this.priority = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("C_PaymentTerm_ID") && para[i].getParameter() != null) {
                this.paymentTermID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("POReference") && para[i].getParameter() != null) {
                this.poReference = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("Description") && para[i].getParameter() != null) {
                this.description = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("OrderType") && para[i].getParameter() != null) {
                this.orderType = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("SalesRep_ID") && para[i].getParameter() != null) {
                this.salesRepID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("M_Warehouse_ID") && para[i].getParameter() != null) {
                this.warehouseID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("User1_ID") && para[i].getParameter() != null) {
                this.user1ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("DocAction") && para[i].getParameter() != null) {
                this.action = (String)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("C_Tax_ID") && para[i].getParameter() != null) {
                this.taxID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("C_BPartner_ID_P") && para[i].getParameter() != null) {
                this.vendorSplitID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("IsSplitDocuments") && para[i].getParameter() != null) {
                this.isSplit = para[i].getParameterAsBoolean();
            }
            if (name.equalsIgnoreCase("User3_ID") && para[i].getParameter() != null) {
                this.user3ID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("M_Product_ID") && para[i].getParameter() != null) {
                this.productSplitID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (!name.equalsIgnoreCase("C_DocTypeOrder_ID") || para[i].getParameter() == null) continue;
            this.docTypeSplitID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
        if (this.salesRepID == 0) {
            this.salesRepID = Env.getAD_User_ID(this.getCtx());
        }
    }

    @Override
    protected String doIt() throws Exception {
        List<Integer> recordIds = this.getSelectionKeys();
        MOrder purchaseOrder = this.createPO();
        recordIds.stream().forEach(key -> {
            MOrderLine line = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
            MOrder order = (MOrder)line.getC_Order();
            MDocType docType = (MDocType)order.getC_DocTypeTarget();
            int productID = this.getSelectionAsInt((int)key, "SOL_M_Product_ID");
            BigDecimal price = this.getSelectionAsBigDecimal((int)key, "SOL_CurrentCostPrice");
            String landing = this.getSelectionAsString((int)key, "SOL_DescriptionURL");
            if (price.compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("ERROR: Todas las l\u00edneas seleccionadas deben tener precio de compra mayor a cero");
            }
            BigDecimal qtyAvailable = this.getSelectionAsBigDecimal((int)key, "SOL_QtyAvailable");
            BigDecimal qty = this.getSelectionAsBigDecimal((int)key, "SOL_Qty");
            if (qtyAvailable == null) {
                qtyAvailable = Env.ZERO;
            }
            if (qty == null) {
                qty = Env.ZERO;
            }
            if (qty.compareTo(Env.ZERO) < 0) {
                throw new AdempiereException("ERROR: Cantidad ordenada no puede ser negativa");
            }
            if (qtyAvailable.compareTo(Env.ZERO) <= 0 && docType.get_ValueAsBoolean("IsQtyControlled")) {
                throw new AdempiereException("ERROR: Todas las l\u00edneas seleccionadas deben tener cantidad disponible para ordenar");
            }
            if (qty.compareTo(qtyAvailable) > 0 && docType.get_ValueAsBoolean("IsQtyControlled")) {
                throw new AdempiereException("ERROR: Cantidad ordenada no puede superar la cantidad disponible a ordenar");
            }
            MOrderLine poLine = new MOrderLine(purchaseOrder);
            if (productID > 0) {
                poLine.setM_Product_ID(productID);
            } else {
                poLine.setM_Product_ID(line.getM_Product_ID());
            }
            poLine.setC_Charge_ID(line.getC_Charge_ID());
            poLine.setM_AttributeSetInstance_ID(line.getM_AttributeSetInstance_ID());
            poLine.setC_UOM_ID(line.getC_UOM_ID());
            poLine.setQtyEntered(qty);
            poLine.setQtyOrdered(qty);
            poLine.setDescription(line.getDescription());
            poLine.setDateOrdered(line.getDateOrdered());
            poLine.setDatePromised(line.getDatePromised());
            poLine.set_ValueOfColumn("EndDate", line.get_Value("EndDate"));
            poLine.setC_Project_ID(line.getC_Project_ID());
            poLine.setPrice();
            poLine.setPriceEntered(price);
            poLine.setPriceActual(price);
            poLine.setPriceList(price);
            poLine.setPriceLimit(price);
            poLine.setC_Tax_ID(this.taxID);
            poLine.setUser1_ID(purchaseOrder.getUser1_ID());
            poLine.set_ValueOfColumn("DescriptionURL", (Object)landing);
            if (MSysConfig.getBooleanValue("UY_SETLINKORDER_SO_TO_PO", false, Env.getAD_Client_ID(Env.getCtx()))) {
                poLine.setLink_OrderLine_ID(line.get_ID());
            } else {
                line.setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                line.saveEx();
            }
            poLine.saveEx();
            if (this.isFirstLine && poLine.getC_Project_ID() > 0) {
                MProject project = (MProject)poLine.getC_Project();
                purchaseOrder.setC_Project_ID(poLine.getC_Project_ID());
                purchaseOrder.setC_Campaign_ID(project.getC_Campaign_ID());
                purchaseOrder.set_ValueOfColumn("S_Contract_ID", project.get_Value("S_Contract_ID"));
                purchaseOrder.saveEx();
                this.isFirstLine = false;
            }
        });
        if (purchaseOrder.getLines().length > 0) {
            String documentAction = this.getParameterAsString("DocAction");
            if (!Util.isEmpty(documentAction) && (documentAction.equals("CO") || documentAction.equals("PR"))) {
                purchaseOrder.processIt(documentAction);
                purchaseOrder.saveEx();
            }
        } else {
            purchaseOrder.deleteEx(true);
        }
        if (this.isSplit) {
            MOrder splitOrder = this.generateSplitOrder(recordIds);
            return "Orden de Compra: " + purchaseOrder.getDocumentNo() + " - Orden de Compra Split: " + splitOrder.getDocumentNo();
        }
        return "Orden de Compra: " + purchaseOrder.getDocumentNo();
    }

    private MOrder createPO() {
        MBPartner vendor = new MBPartner(this.getCtx(), this.vendorID, this.get_TrxName());
        MOrder purchaseOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
        purchaseOrder.setClientOrg(this.clientID, this.orgID);
        purchaseOrder.setIsSOTrx(false);
        purchaseOrder.setDateOrdered(this.dateOrdered);
        purchaseOrder.setDatePromised(this.datePromised);
        purchaseOrder.setC_BPartner_ID(this.vendorID);
        purchaseOrder.setC_BPartner_Location_ID(this.partnerLocationID);
        purchaseOrder.setC_DocTypeTarget_ID(this.docTypeID);
        purchaseOrder.setC_DocType_ID(this.docTypeID);
        purchaseOrder.setDescription(this.description);
        purchaseOrder.setPOReference(this.poReference);
        purchaseOrder.setOrderType(this.orderType);
        purchaseOrder.setPriorityRule(this.priority);
        purchaseOrder.setSalesRep_ID(this.salesRepID);
        purchaseOrder.setM_Warehouse_ID(this.warehouseID);
        purchaseOrder.setUser1_ID(this.user1ID);
        purchaseOrder.setM_PriceList_ID(this.priceListID);
        if (vendor.getPO_PaymentTerm_ID() > 0) {
            purchaseOrder.setC_PaymentTerm_ID(vendor.getPO_PaymentTerm_ID());
        } else {
            purchaseOrder.setC_PaymentTerm_ID(this.paymentTermID);
        }
        MPriceList priceList = new MPriceList(this.getCtx(), this.priceListID, this.get_TrxName());
        purchaseOrder.setC_Currency_ID(priceList.getC_Currency_ID());
        purchaseOrder.setDocStatus("DR");
        purchaseOrder.setDocAction(this.action);
        purchaseOrder.saveEx();
        return purchaseOrder;
    }

    private MOrder generateSplitOrder(List<Integer> recordIds) {
        this.isFirstLine = true;
        MOrder splitOrder = this.createSplitPO();
        recordIds.stream().forEach(key -> {
            MOrderLine line = new MOrderLine(this.getCtx(), (int)key, this.get_TrxName());
            BigDecimal percentage = this.getSelectionAsBigDecimal((int)key, "SOL_Percentage");
            if (percentage == null || percentage.compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("ERROR: Debe ingresar % Split en todas las lineas");
            }
            BigDecimal qty = this.getSelectionAsBigDecimal((int)key, "SOL_Qty");
            BigDecimal newPrice = line.getPriceEntered().multiply(percentage).divide(Env.ONEHUNDRED, 10, RoundingMode.HALF_UP);
            MOrderLine poLine = new MOrderLine(splitOrder);
            poLine.setM_Product_ID(this.productSplitID);
            poLine.setC_UOM_ID(line.getC_UOM_ID());
            poLine.setQtyEntered(qty);
            poLine.setQtyOrdered(qty);
            poLine.setDateOrdered(line.getDateOrdered());
            poLine.setDatePromised(line.getDatePromised());
            poLine.set_ValueOfColumn("EndDate", line.get_Value("EndDate"));
            poLine.setC_Project_ID(line.getC_Project_ID());
            poLine.setPrice();
            poLine.setPriceEntered(newPrice);
            poLine.setPriceActual(newPrice);
            poLine.setPriceList(newPrice);
            poLine.setPriceLimit(newPrice);
            poLine.setC_Tax_ID(this.taxID);
            poLine.setUser1_ID(splitOrder.getUser1_ID());
            if (MSysConfig.getBooleanValue("UY_SETLINKORDER_SO_TO_PO", false, Env.getAD_Client_ID(Env.getCtx()))) {
                poLine.setLink_OrderLine_ID(line.get_ID());
            } else {
                line.setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                line.saveEx();
            }
            poLine.saveEx();
            if (this.isFirstLine && poLine.getC_Project_ID() > 0) {
                MProject project = (MProject)poLine.getC_Project();
                splitOrder.setC_Project_ID(poLine.getC_Project_ID());
                splitOrder.setC_Campaign_ID(project.getC_Campaign_ID());
                splitOrder.set_ValueOfColumn("S_Contract_ID", project.get_Value("S_Contract_ID"));
                splitOrder.saveEx();
                this.isFirstLine = false;
            }
        });
        if (splitOrder.getLines().length > 0) {
            String documentAction = this.getParameterAsString("DocAction");
            if (!Util.isEmpty(documentAction) && (documentAction.equals("CO") || documentAction.equals("PR"))) {
                splitOrder.processIt(documentAction);
                splitOrder.saveEx();
            }
        } else {
            splitOrder.deleteEx(true);
        }
        if (splitOrder == null) {
            throw new AdempiereException("Error al geenrar OC Split");
        }
        return splitOrder;
    }

    private MOrder createSplitPO() {
        MBPartner vendor = new MBPartner(this.getCtx(), this.vendorSplitID, this.get_TrxName());
        MOrder purchaseOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
        purchaseOrder.setClientOrg(this.clientID, this.orgID);
        purchaseOrder.setIsSOTrx(false);
        purchaseOrder.setDateOrdered(this.dateOrdered);
        purchaseOrder.setDatePromised(this.datePromised);
        purchaseOrder.setC_BPartner_ID(this.vendorSplitID);
        purchaseOrder.setC_BPartner_Location_ID(this.partnerLocationID);
        purchaseOrder.setC_DocTypeTarget_ID(this.docTypeSplitID);
        purchaseOrder.setC_DocType_ID(this.docTypeSplitID);
        purchaseOrder.setDescription(this.description);
        purchaseOrder.setPOReference(this.poReference);
        purchaseOrder.setOrderType(this.orderType);
        purchaseOrder.setPriorityRule(this.priority);
        purchaseOrder.setSalesRep_ID(this.salesRepID);
        purchaseOrder.setM_Warehouse_ID(this.warehouseID);
        purchaseOrder.setUser1_ID(this.user1ID);
        purchaseOrder.setM_PriceList_ID(this.priceListID);
        purchaseOrder.setUser3_ID(this.user3ID);
        purchaseOrder.setInvoiceRule("D");
        if (vendor.getPO_PaymentTerm_ID() > 0) {
            purchaseOrder.setC_PaymentTerm_ID(vendor.getPO_PaymentTerm_ID());
        } else {
            purchaseOrder.setC_PaymentTerm_ID(this.paymentTermID);
        }
        MPriceList priceList = new MPriceList(this.getCtx(), this.priceListID, this.get_TrxName());
        purchaseOrder.setC_Currency_ID(priceList.getC_Currency_ID());
        purchaseOrder.setDocStatus("DR");
        purchaseOrder.setDocAction(this.action);
        purchaseOrder.saveEx();
        return purchaseOrder;
    }
}

