/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.openup.core.process.GenPaymentFromInvoiceAbstract;

public class GenPaymentFromInvoice
extends GenPaymentFromInvoiceAbstract {
    private MPayment payment = null;
    private BigDecimal remaining = Env.ZERO;
    private int currencyID = 0;
    private int chargeID = 0;
    private BigDecimal payAmt = Env.ZERO;
    private Timestamp dateDoc = null;
    private MInvoice invoice = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0 && this.getBankAccountId() == 0 && this.getPayDate() == null) {
            throw new AdempiereException("@C_Payment_ID@ @NotFound@");
        }
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.invoice.isPaid()) {
            throw new AdempiereException("Este documento ya est\u00e1 Pagado");
        }
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName().trim();
            if (name == null) continue;
            if (name.equalsIgnoreCase("DateDoc")) {
                this.dateDoc = (Timestamp)para[i].getParameter();
            }
            if (name.equalsIgnoreCase("C_Currency_ID_To") && para[i].getParameter() != null) {
                this.currencyID = ((BigDecimal)para[i].getParameter()).intValueExact();
            }
            if (name.equalsIgnoreCase("PayAmt") && para[i].getParameter() != null) {
                this.payAmt = (BigDecimal)para[i].getParameter();
            }
            if (!name.equalsIgnoreCase("C_Charge_ID") || para[i].getParameter() == null) continue;
            this.chargeID = ((BigDecimal)para[i].getParameter()).intValueExact();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.payAmt.compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("Importe del Pago/Cobro debe ser mayor a cero");
        }
        this.createPayment(this.invoice.getC_BPartner_ID(), this.currencyID);
        this.payment.load(this.get_TrxName());
        if (!this.payment.processIt("CO")) {
            throw new AdempiereException("@Error@ " + this.payment.getProcessMsg());
        }
        this.payment.saveEx();
        if (this.getTenderType() != null && !this.getTenderType().equalsIgnoreCase("")) {
            String paymentRule = "";
            if (this.getTenderType().equalsIgnoreCase("X")) {
                paymentRule = "B";
            } else if (this.getTenderType().equalsIgnoreCase("A")) {
                paymentRule = "T";
            } else if (this.getTenderType().equalsIgnoreCase("C")) {
                paymentRule = "K";
            } else if (this.getTenderType().equalsIgnoreCase("D")) {
                paymentRule = "D";
            } else if (this.getTenderType().equalsIgnoreCase("K")) {
                paymentRule = "S";
            } else if (this.getTenderType().equalsIgnoreCase("A")) {
                paymentRule = "T";
            }
            if (!paymentRule.equalsIgnoreCase("")) {
                this.invoice.setPaymentRule(paymentRule);
                this.invoice.saveEx();
            }
        }
        this.generateAllocation();
        return "@Created@ @C_Payment_ID@ " + this.payment.getDocumentInfo();
    }

    private void generateAllocation() {
        boolean IsAllocated = false;
        MAllocationLine aLine = null;
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), null);
        MAcctSchema schema = client.getAcctSchema();
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), true, this.getDateDoc(), this.payment.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), this.get_TrxName());
        alloc.setAD_Org_ID(this.invoice.getAD_Org_ID());
        alloc.setDescription("Generado automaticamente desde Documento por Cobrar Nro. " + this.invoice.getDocumentNo());
        alloc.saveEx();
        if (this.payment.getC_Currency_ID() == this.invoice.getC_Currency_ID()) {
            aLine = new MAllocationLine(alloc, this.invoice.getGrandTotal(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Invoice_ID(this.invoice.get_ID());
            aLine.setC_BPartner_ID(this.invoice.getC_BPartner_ID());
            aLine.setC_Payment_ID(this.payment.get_ID());
            aLine.saveEx();
        } else {
            BigDecimal invAmt = MConversionRate.convert(this.getCtx(), this.invoice.getGrandTotal(), this.invoice.getC_Currency_ID(), this.payment.getC_Currency_ID(), today, 114, this.invoice.getAD_Client_ID(), this.invoice.getAD_Org_ID());
            aLine = new MAllocationLine(alloc, this.payment.getPayAmt(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Payment_ID(this.payment.get_ID());
            aLine.setC_Invoice_ID(this.invoice.get_ID());
            aLine.setC_BPartner_ID(this.payment.getC_BPartner_ID());
            aLine.saveEx();
        }
        if (alloc != null && alloc.get_ID() > 0) {
            if (alloc.getLines(true).length > 0) {
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(alloc.getProcessMsg());
                }
                alloc.saveEx();
                IsAllocated = true;
            } else {
                alloc.deleteEx(true);
            }
        }
        if (IsAllocated) {
            this.testAllocation();
        }
    }

    private void testAllocation() {
        MPayment pay;
        Object sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
        BigDecimal open = DB.getSQLValueBD(this.get_TrxName(), (String)sql, this.invoice.get_ID());
        if (open != null && open.signum() == 0) {
            sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + this.invoice.get_ID();
            int n = DB.executeUpdate((String)sql, this.get_TrxName());
        }
        if ((pay = new MPayment(Env.getCtx(), this.payment.get_ID(), this.get_TrxName())).testAllocation()) {
            pay.saveEx();
        }
    }

    private void createPayment(int businessPartnerId, int currencyId) {
        this.payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        this.payment.setC_BPartner_ID(businessPartnerId);
        this.payment.setC_BankAccount_ID(this.getBankAccountId());
        this.payment.setDateTrx(this.getDateDoc());
        this.payment.setDateAcct(this.getDateDoc());
        if (this.getDocTypeTargetId() > 0) {
            this.payment.setC_DocType_ID(this.getDocTypeTargetId());
        }
        this.payment.setPayAmt(this.getPayAmt());
        this.remaining = this.getPayAmt();
        MUser user = MUser.get(this.getCtx(), this.getAD_User_ID());
        String userName = "";
        if (user != null) {
            userName = user.getName();
        }
        this.payment.setDescription(Msg.parseTranslation(Env.getCtx(), "@Created@ @from@") + " - " + userName + " - " + DisplayType.getDateFormat(15).format(this.getDateDoc()));
        this.payment.setTenderType(this.getTenderType());
        this.payment.setC_Currency_ID(currencyId);
        this.payment.setC_ConversionType_ID(201);
        if (!Util.isEmpty(this.getAccountNo())) {
            this.payment.setAccountNo(this.getAccountNo());
        }
        if (!Util.isEmpty(this.getRoutingNo())) {
            this.payment.setRoutingNo(this.getRoutingNo());
        }
        if (!Util.isEmpty(this.getCheckNo())) {
            this.payment.setCheckNo(this.getCheckNo());
        }
        if (!Util.isEmpty(this.getMicr())) {
            this.payment.setMicr(this.getMicr());
        }
        if (!Util.isEmpty(this.getCreditCardType())) {
            this.payment.setCreditCardType(this.getCreditCardType());
        }
        if (!Util.isEmpty(this.getTrxType())) {
            this.payment.setTrxType(this.getTrxType());
        }
        if (!Util.isEmpty(this.getCreditCardNumber())) {
            this.payment.setCreditCardNumber(this.getCreditCardNumber());
        }
        if (!Util.isEmpty(this.getCreditCardVV())) {
            this.payment.setCreditCardVV(this.getCreditCardVV());
        }
        if (this.getCreditCardExpMM() != 0) {
            this.payment.setCreditCardExpMM(this.getCreditCardExpMM());
        }
        if (this.getCreditCardExpYY() != 0) {
            this.payment.setCreditCardExpYY(this.getCreditCardExpYY());
        }
        if (!Util.isEmpty(this.getName())) {
            this.payment.setA_Name(this.getName());
        }
        if (!Util.isEmpty(this.getStreet())) {
            this.payment.setA_Street(this.getStreet());
        }
        if (!Util.isEmpty(this.getCity())) {
            this.payment.setA_City(this.getCity());
        }
        if (!Util.isEmpty(this.getZip())) {
            this.payment.setA_Zip(this.getZip());
        }
        if (!Util.isEmpty(this.getState())) {
            this.payment.setA_State(this.getState());
        }
        if (!Util.isEmpty(this.getCountry())) {
            this.payment.setA_Country(this.getCountry());
        }
        if (!Util.isEmpty(this.getIdentDL())) {
            this.payment.setA_Ident_DL(this.getIdentDL());
        }
        if (!Util.isEmpty(this.getIdentSSN())) {
            this.payment.setA_Ident_SSN(this.getIdentSSN());
        }
        if (!Util.isEmpty(this.getEMail())) {
            this.payment.setA_EMail(this.getEMail());
        }
        if (this.getTaxAmt() != null) {
            this.payment.setTaxAmt(this.getTaxAmt());
        }
        if (!Util.isEmpty(this.getPONum())) {
            this.payment.setPONum(this.getPONum());
        }
        if (!Util.isEmpty(this.getVoiceAuthCode())) {
            this.payment.setVoiceAuthCode(this.getVoiceAuthCode());
        }
        if (!Util.isEmpty(this.getTrxID())) {
            this.payment.setOrig_TrxID(this.getTrxID());
        }
        this.payment.saveEx();
    }
}

