/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.process;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.openup.core.model.MDetailAging;
import org.openup.core.utils.DateFormatUtils;

public class DetailCashFlow
extends SvrProcess {
    protected Timestamp p_DueDate = null;
    protected Timestamp p_FinalDueDate = null;
    protected int p_C_Currency_ID = -1;
    protected int p_C_BP_Group_ID = -1;
    protected int p_C_BPartner_ID = -1;
    protected boolean p_IsIncludeOrders = false;
    protected boolean p_IsIncludeCashFlows = false;
    protected boolean p_IsIncludeInvoices = true;
    protected boolean p_IsIncludeExpense = false;
    protected boolean p_IsIncludeBankBalance = true;
    protected boolean p_IsIncludeCreditline = true;
    protected boolean p_IsIncludeDefCheck = false;
    protected boolean p_IsSoTrx = false;
    protected boolean p_IsSalesPurchase = true;
    private MDetailAging m_aging = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            this.log.config("prepare - " + para);
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("DateFinish")) {
                this.p_DueDate = (Timestamp)para.getParameter();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = ((BigDecimal)para.getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = ((BigDecimal)para.getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para.getParameter()).intValue();
                continue;
            }
            if (name.equals("IsIncludeOrders")) {
                this.p_IsIncludeOrders = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("IsIncludeCashFlows")) {
                this.p_IsIncludeCashFlows = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("IsIncludeInvoices")) {
                this.p_IsIncludeInvoices = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("IsIncludeBankBalances")) {
                this.p_IsIncludeBankBalance = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("IsIncludeDefCheck")) {
                this.p_IsIncludeDefCheck = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equalsIgnoreCase("IsSalesPurchase")) {
                this.p_IsSalesPurchase = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equalsIgnoreCase("IsIncludeExpense")) {
                this.p_IsIncludeExpense = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equalsIgnoreCase("isApply")) {
                this.p_IsSoTrx = "Y".equals(para.getParameter());
                continue;
            }
            this.log.config("prepare - Unknown Parameter: " + name);
        }
        if (this.p_DueDate == null) {
            this.p_DueDate = new Timestamp(System.currentTimeMillis());
        }
        this.p_DueDate = TimeUtil.trunc(this.p_DueDate, "D");
        this.p_FinalDueDate = DateFormatUtils.addDays(this.p_DueDate, 14);
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("DueDate=" + this.p_DueDate + ", C_Currency_ID=" + this.p_C_Currency_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getSqlSelect("t", params));
        String whereClause = this.getSqlWhereClause("t", params);
        if (!Util.isEmpty(whereClause, true)) {
            sql.append(" WHERE ").append(whereClause);
        }
        sql.append(" ORDER BY ").append(this.getSqlSelectOrderBy("t", params));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.addLine(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.saveRow();
        return "";
    }

    protected String getSqlSelect(String tableAlias, List<Object> params) {
        StringBuffer sql = new StringBuffer();
        String isSoTrxWhere = " ";
        if (!this.p_IsSalesPurchase) {
            isSoTrxWhere = this.p_IsSoTrx ? " AND oi.IsSoTrx = 'Y' " : " AND oi.IsSoTrx = 'N' ";
        }
        if (this.p_IsIncludeInvoices) {
            if (sql.length() > 0) {
                sql.append(" UNION ");
            }
            sql.append("SELECT -1 AS C_BankAccount_ID, bp.C_BP_Group_ID, oi.C_BPartner_ID," + this.getSqlCashFlowSource("C_Invoice", params) + ", oi.C_Invoice_ID AS Record_ID," + this.getSqlCurrency("C_Invoice", "oi", params) + " AS C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced AS DateTrx, oi.NetDays, oi.DueDate, oi.DaysDue, " + this.getSqlCurrencyConvert("C_Invoice", "oi", "GrandTotal", params) + " AS GrandTotal," + this.getSqlCurrencyConvert("C_Invoice", "oi", "PaidAmt", params) + " AS PaidAmt," + this.getSqlCurrencyConvert("C_Invoice", "oi", "OpenAmt", params) + " AS OpenAmt, oi.C_InvoicePaySchedule_ID, oi.AD_Org_ID  FROM RV_OpenItem oi INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) JOIN C_Invoice ci on oi.C_Invoice_ID = ci.C_Invoice_ID  JOIN C_DocType cdt on ci.C_DocType_ID = cdt.C_DocType_ID  WHERE cdt.docbasetype not in ('DPI','DPC')  AND 1=1 " + isSoTrxWhere);
            this.addWhereClause(sql, params);
            if (this.p_DueDate != null) {
                sql.append(" AND oi.DueDate >= '" + this.p_DueDate + "' AND oi.DueDate <= '" + this.p_FinalDueDate + "'");
            }
        }
        if (this.p_IsIncludeOrders) {
            if (sql.length() > 0) {
                sql.append(" UNION ");
            }
            sql.append("SELECT -1 AS C_BankAccount_ID, bp.C_BP_Group_ID, oi.C_BPartner_ID," + this.getSqlCashFlowSource("C_Order", params) + ", oi.C_Order_ID AS Record_ID," + this.getSqlCurrency("C_Order", "oi", params) + " AS C_Currency_ID, oi.IsSOTrx, oi.DateOrdered AS DateTrx, paymentTermDueDays (oi.C_PaymentTerm_ID, oi.DateOrdered,paymenttermduedate(oi.c_paymentterm_id, oi.dateordered)) AS NetDays, paymentTermDueDate(oi.c_paymentterm_id, oi.dateordered) AS DueDate, paymentTermDueDays(oi.c_paymentterm_id, oi.dateordered, getdate()) AS DaysDue," + this.getSqlCurrencyConvert("C_Order", "oi", "GrandTotal", params) + " AS GrandTotal, 0 AS PaidAmt," + this.getSqlCurrencyConvert("C_Order", "oi", "GrandTotal", params) + " AS OpenAmt, 0 AS C_InvoicePaySchedule_ID, oi.AD_Org_ID  FROM C_Order oi  INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID)  WHERE oi.IsActive='Y' AND oi.IsInvoiced='N' AND DocStatus IN('CO','CL') " + isSoTrxWhere);
            this.addWhereClause(sql, params);
            if (this.p_DueDate != null) {
                sql.append(" AND paymentTermDueDate(oi.c_paymentterm_id, oi.dateordered) >= '" + this.p_DueDate + "' AND paymentTermDueDate(oi.c_paymentterm_id, oi.dateordered) <= '" + this.p_FinalDueDate + "'");
            }
        }
        if (this.p_IsIncludeCashFlows) {
            if (sql.length() > 0) {
                sql.append(" UNION ");
            }
            sql.append("SELECT -1 AS C_BankAccount_ID, bp.C_BP_Group_ID, oi.C_BPartner_ID," + this.getSqlCashFlowSource("C_CashFlow", params) + ", oi.C_CashFlow_ID AS Record_ID," + this.getSqlCurrency("C_CashFlow", "oi", params) + " AS C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced AS DateTrx, daysBetween(oi.DueDate,oi.DateInvoiced) AS NetDays, oi.DueDate, daysBetween(oi.DueDate,oi.DateInvoiced) AS DaysDue," + this.getSqlCurrencyConvert("C_CashFlow", "oi", "GrandTotal", params) + " AS GrandTotal, 0 AS PaidAmt," + this.getSqlCurrencyConvert("C_CashFlow", "oi", "GrandTotal", params) + " AS OpenAmt, 0 AS C_InvoicePaySchedule_ID, oi.AD_Org_ID  FROM C_CashFlow oi  INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID)  WHERE oi.IsActive='Y' AND oi.Processed = 'Y' " + isSoTrxWhere);
            this.addWhereClause(sql, params);
            if (this.p_DueDate != null) {
                sql.append(" AND oi.DueDate >= '" + this.p_DueDate + "' AND oi.DueDate <= '" + this.p_FinalDueDate + "'");
            }
        }
        if (this.p_IsIncludeDefCheck) {
            if (sql.length() > 0) {
                sql.append(" UNION ");
            }
            sql.append("SELECT -1 AS C_BankAccount_ID, bp.C_BP_Group_ID, oi.C_BPartner_ID," + this.getSqlCashFlowSource("C_Invoice", params) + ", oi.C_Invoice_ID AS Record_ID," + this.getSqlCurrency("C_Invoice", "oi", params) + " AS C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced AS DateTrx, oi.NetDays, duedate_deferreddoc(oi.c_invoice_id) as DueDate, oi.DaysDue, " + this.getSqlCurrencyConvert("C_Invoice", "oi", "GrandTotal", params) + " AS GrandTotal," + this.getSqlCurrencyConvert("C_Invoice", "oi", "PaidAmt", params) + " AS PaidAmt," + this.getSqlCurrencyConvert("C_Invoice", "oi", "OpenAmt", params) + " AS OpenAmt, oi.C_InvoicePaySchedule_ID, oi.AD_Org_ID FROM RV_OpenItem oi INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) JOIN C_Invoice ci on oi.C_Invoice_ID = ci.C_Invoice_ID  JOIN C_DocType cdt on ci.C_DocType_ID = cdt.C_DocType_ID  WHERE cdt.docbasetype in ('DPI','DPC')  AND 1=1" + isSoTrxWhere);
            this.addWhereClause(sql, params);
            if (this.p_DueDate != null) {
                sql.append(" AND oi.DueDate >= '" + this.p_DueDate + "' AND oi.DueDate <= '" + this.p_FinalDueDate + "'");
            }
        }
        if (this.p_IsIncludeExpense) {
            if (sql.length() > 0) {
                sql.append(" UNION ");
            }
            String isSoTrx = "Y";
            if (!this.p_IsSalesPurchase && !this.p_IsSoTrx) {
                isSoTrx = "N";
            }
            sql.append("SELECT -1 AS C_BankAccount_ID, bp.C_BP_Group_ID, oi.C_BPartner_ID, " + this.getSqlCashFlowSource("S_TimeExpense", params) + ",  oi.S_TimeExpense_ID AS Record_ID, pl.c_currency_id, '" + isSoTrx + "' as IsSOTrx, oi.DateReport AS DateTrx, 0 AS NetDays, oi.DateReport AS DueDate, 0 AS DaysDue, currencyconvert(oi.ApprovalAmt, pl.c_currency_id, " + this.p_C_Currency_ID + ", oi.DateReport, 0, oi.AD_Client_ID, oi.AD_Org_ID) AS GrandTotal, 0 AS PaidAmt, currencyconvert(oi.ApprovalAmt, pl.c_currency_id, " + this.p_C_Currency_ID + ", oi.DateReport, 0, oi.AD_Client_ID, oi.AD_Org_ID) AS OpenAmt, 0 AS C_InvoicePaySchedule_ID, oi.AD_Org_ID FROM S_TimeExpense oi JOIN m_pricelist pl ON oi.m_pricelist_id = pl.m_pricelist_id JOIN C_BPartner bp ON oi.C_BPartner_ID = bp.C_BPartner_ID");
            this.addWhereClause(sql, params);
            if (this.p_DueDate != null) {
                sql.append(" AND oi.DateReport >= '" + this.p_DueDate + "' AND oi.DateReport <= '" + this.p_FinalDueDate + "'");
            }
        }
        sql.insert(0, "SELECT * FROM (");
        sql.append(") ").append(tableAlias);
        return sql.toString();
    }

    protected String getSqlWhereClause(String tableAlias, List<Object> params) {
        return null;
    }

    protected String getSqlSelectOrderBy(String tableAlias, List<Object> params) {
        return tableAlias + ".C_BPartner_ID, " + tableAlias + ".C_Currency_ID, " + tableAlias + ".Record_ID";
    }

    protected void addLine(ResultSet rs) throws SQLException {
        BigDecimal OpenAmt;
        int C_BP_Group_ID = rs.getInt("C_BP_Group_ID");
        int C_BPartner_ID = rs.getInt("C_BPartner_ID");
        int C_BankAccount_ID = rs.getInt("C_BankAccount_ID");
        String CashFlowSource = rs.getString("CashFlowSource");
        int Record_ID = rs.getInt("Record_ID");
        int C_InvoicePaySchedule_ID = rs.getInt("C_InvoicePaySchedule_ID");
        int AD_Org_ID = rs.getInt("AD_Org_ID");
        int C_Currency_ID = rs.getInt("C_Currency_ID");
        boolean IsSOTrx = "Y".equals(rs.getString("IsSOTrx"));
        Timestamp DateTrx = rs.getTimestamp("DateTrx");
        Timestamp DueDate = rs.getTimestamp("DueDate");
        int DaysDue = rs.getInt("DaysDue");
        BigDecimal GrandTotal = rs.getBigDecimal("GrandTotal") != null ? rs.getBigDecimal("GrandTotal") : BigDecimal.ZERO;
        BigDecimal bigDecimal = OpenAmt = rs.getBigDecimal("OpenAmt") != null ? rs.getBigDecimal("OpenAmt") : BigDecimal.ZERO;
        if (this.m_aging == null || C_BPartner_ID != this.m_aging.getC_BPartner_ID() || C_Currency_ID != this.m_aging.getC_Currency_ID() || !CashFlowSource.equals(this.getCashFlowSource(this.m_aging)) || Record_ID != this.getRecord_ID(this.m_aging)) {
            this.saveRow();
            this.m_aging = this.createDetAgingRecord(DateTrx, C_BankAccount_ID, C_BPartner_ID, C_Currency_ID, CashFlowSource, Record_ID, C_InvoicePaySchedule_ID, C_BP_Group_ID, AD_Org_ID, DueDate, IsSOTrx);
        }
        if (IsSOTrx) {
            this.m_aging.add(DueDate, this.p_FinalDueDate, DaysDue, GrandTotal, OpenAmt);
        } else {
            this.m_aging.add(DueDate, this.p_FinalDueDate, DaysDue, GrandTotal.negate(), OpenAmt.negate());
        }
    }

    protected void saveRow() {
        if (this.m_aging != null) {
            this.m_aging.saveEx();
        }
    }

    private String getSqlCashFlowSource(String tableName, List<Object> params) {
        String sql = " ? AS CashFlowSource";
        params.add(tableName);
        return sql;
    }

    protected String getCashFlowSource(MDetailAging aging) {
        if (aging.getC_Invoice_ID() > 0) {
            return "C_Invoice";
        }
        if (aging.get_ValueAsInt("C_Order_ID") > 0) {
            return "C_Order";
        }
        if (aging.get_ValueAsInt("C_CashFlow_ID") > 0) {
            return "C_CashFlow";
        }
        if (aging.get_ValueAsInt("C_BankAccount_ID") > 0) {
            return "C_BankAccount";
        }
        if (aging.get_ValueAsInt("S_TimeExpense_ID") > 0) {
            return "S_TimeExpense";
        }
        throw new AdempiereException("Unknown CashFlowSource - " + aging);
    }

    protected int getRecord_ID(MDetailAging aging) {
        if (aging.getC_Invoice_ID() > 0) {
            return aging.getC_Invoice_ID();
        }
        if (aging.get_ValueAsInt("C_Order_ID") > 0) {
            return aging.get_ValueAsInt("C_Order_ID");
        }
        if (aging.get_ValueAsInt("C_CashFlow_ID") > 0) {
            return aging.get_ValueAsInt("C_CashFlow_ID");
        }
        if (aging.get_ValueAsInt("C_BankAccount_ID") > 0) {
            return aging.get_ValueAsInt("C_BankAccount_ID");
        }
        if (aging.get_ValueAsInt("S_TimeExpense_ID") > 0) {
            return aging.get_ValueAsInt("S_TimeExpense_ID");
        }
        throw new AdempiereException("Unknown CashFlowSource - " + aging);
    }

    private void setRecord_ID(MDetailAging aging, String CashFlowSource, int Record_ID) {
        if (Record_ID <= 0) {
            throw new IllegalArgumentException("Record_ID <= 0");
        }
        if (CashFlowSource.equals("C_Invoice")) {
            aging.set_ValueOfColumn("C_Order_ID", (Object)0);
            aging.set_ValueOfColumn("C_Invoice_ID", (Object)Record_ID);
            aging.set_ValueOfColumn("C_CashFlow_ID", (Object)0);
            aging.set_ValueOfColumn("C_BankAccount_ID", (Object)0);
            aging.set_ValueOfColumn("S_TimeExpense_ID", (Object)0);
        } else if (CashFlowSource.equals("C_Order")) {
            aging.set_ValueOfColumn("C_Order_ID", (Object)Record_ID);
            aging.set_ValueOfColumn("C_Invoice_ID", (Object)0);
            aging.set_ValueOfColumn("C_CashFlow_ID", (Object)0);
            aging.set_ValueOfColumn("C_BankAccount_ID", (Object)0);
            aging.set_ValueOfColumn("S_TimeExpense_ID", (Object)0);
        } else if (CashFlowSource.equals("C_CashFlow")) {
            aging.set_ValueOfColumn("C_Order_ID", (Object)0);
            aging.set_ValueOfColumn("C_Invoice_ID", (Object)0);
            aging.set_ValueOfColumn("C_CashFlow_ID", (Object)Record_ID);
            aging.set_ValueOfColumn("C_BankAccount_ID", (Object)0);
            aging.set_ValueOfColumn("S_TimeExpense_ID", (Object)0);
        } else if (CashFlowSource.equals("C_BankAccount")) {
            aging.set_ValueOfColumn("C_Order_ID", (Object)0);
            aging.set_ValueOfColumn("C_Invoice_ID", (Object)0);
            aging.set_ValueOfColumn("C_CashFlow_ID", (Object)0);
            aging.set_ValueOfColumn("C_BankAccount_ID", (Object)Record_ID);
            aging.set_ValueOfColumn("S_TimeExpense_ID", (Object)0);
        } else if (CashFlowSource.equals("S_TimeExpense")) {
            aging.set_ValueOfColumn("C_Order_ID", (Object)0);
            aging.set_ValueOfColumn("C_Invoice_ID", (Object)0);
            aging.set_ValueOfColumn("C_CashFlow_ID", (Object)0);
            aging.set_ValueOfColumn("C_BankAccount_ID", (Object)0);
            aging.set_ValueOfColumn("S_TimeExpense_ID", (Object)Record_ID);
        } else {
            throw new AdempiereException("Unknown CashFlowSource - " + aging);
        }
    }

    private String getSqlCurrency(String tableName, String alias, List<Object> params) {
        if (this.p_C_Currency_ID <= 0) {
            return alias + ".C_Currency_ID";
        }
        params.add(this.p_C_Currency_ID);
        return "?";
    }

    private String getSqlCurrencyConvert(String tableName, String tableAlias, String columnName, List<Object> params) {
        String dateColumnName;
        if (this.p_C_Currency_ID <= 0) {
            return tableAlias + "." + columnName;
        }
        if ("C_Invoice".equals(tableName)) {
            dateColumnName = "DateInvoiced";
        } else if ("C_Order".equals(tableName)) {
            dateColumnName = "DateOrdered";
        } else if ("C_CashFlow".equals(tableName)) {
            dateColumnName = "DateInvoiced";
        } else if ("C_BankAccount".equals(tableName)) {
            dateColumnName = "DateTrx";
        } else if ("S_TimeExpense".equals(tableName)) {
            dateColumnName = "DateReport";
        } else {
            throw new AdempiereException("Table not supported - " + tableName);
        }
        return "currencyconvert(" + tableAlias + "." + columnName + "," + tableAlias + ".C_Currency_ID," + this.p_C_Currency_ID + "," + tableAlias + "." + dateColumnName + "," + tableAlias + ".C_ConversionType_ID," + tableAlias + ".AD_Client_ID," + tableAlias + ".AD_Org_ID)";
    }

    private void addWhereClause(StringBuffer sql, List<Object> params) {
        sql.append(" AND oi.AD_Client_ID=?");
        params.add(this.getAD_Client_ID());
        if (this.p_C_BPartner_ID > 0) {
            sql.append(" AND oi.C_BPartner_ID=?");
            params.add(this.p_C_BPartner_ID);
        } else if (this.p_C_BP_Group_ID > 0) {
            sql.append(" AND bp.C_BP_Group_ID=?");
            params.add(this.p_C_BP_Group_ID);
        }
    }

    protected MDetailAging createDetAgingRecord(Timestamp StatementDate, int C_BankAccount_ID, int C_BPartner_ID, int C_Currency_ID, String cashFlowSource, int record_id, int C_InvoicePaySchedule_ID, int C_BP_Group_ID, int AD_Org_ID, Timestamp DueDate, boolean IsSOTrx) {
        MDetailAging aging = new MDetailAging(this.getCtx(), this.getAD_PInstance_ID(), StatementDate, C_BankAccount_ID, C_BPartner_ID, C_Currency_ID, 0, C_InvoicePaySchedule_ID, C_BP_Group_ID, AD_Org_ID, DueDate, IsSOTrx, this.get_TrxName());
        aging.setIsListInvoices(false);
        this.setRecord_ID(aging, cashFlowSource, record_id);
        return aging;
    }
}

