/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPayment;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRMA;
import org.compiere.model.MSequence;
import org.compiere.model.MSequenceCtl;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MUYPayReceipt;

public class OpUpModelValidator
implements ModelValidator {
    public static final String CTX_IsLiberoEnabled = "#IsInvoiceTercero";
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("UY_PayReceipt", this);
        engine.addModelChange("C_DunningRunEntry", this);
        engine.addModelChange("C_Order", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("UY_PayReceipt", this);
        engine.addDocValidate("S_TimeExpense", this);
        engine.addDocValidate("C_PaySelection", this);
        engine.addDocValidate("C_Payment", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_DocType", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        Env.setContext(Env.getCtx(), CTX_IsLiberoEnabled, true);
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MDocType docType;
        this.log.info(po.get_TableName() + " Timing: " + type);
        if (po instanceof MInvoice && (type == 1 || type == 2)) {
            MInvoice invoice = (MInvoice)po;
            if (invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") && (invoice.getDocumentNo() == null || invoice.getDocumentNo().trim().equalsIgnoreCase(""))) {
                return "Seleccione numero del documento";
            }
        } else if (po instanceof MUYPayReceipt && (type == 1 || type == 2)) {
            MUYPayReceipt receipt = (MUYPayReceipt)po;
            if (po.is_ValueChanged("DocumentNo")) {
                if (receipt.isSOTrx()) {
                    MUYPayReceipt model = MUYPayReceipt.getForTrx(receipt.getCtx(), receipt.getC_DocType_ID(), receipt.getAD_Org_ID(), receipt.getDocumentNo());
                    if (model != null && model.get_ID() > 0) {
                        throw new AdempiereException("Ya existe un recibo de cobro nro. '" + receipt.getDocumentNo() + "' para esta organizaci\u00f3n");
                    }
                } else {
                    MUYPayReceipt model = MUYPayReceipt.getForNoTrx(receipt.getCtx(), receipt.getC_DocType_ID(), receipt.getAD_Org_ID(), receipt.getC_BPartner_ID(), receipt.getDocumentNo());
                    if (model != null && model.get_ID() > 0) {
                        throw new AdempiereException("Ya existe un recibo de pago nro. '" + receipt.getDocumentNo() + "' para esta organizaci\u00f3n y socio de negocio");
                    }
                }
            }
        } else if (po instanceof MOrderLine) {
            boolean validateOrderedQty;
            MOrderLine model = (MOrderLine)po;
            if (5 == type && model.getC_Order().isSOTrx() && model.is_ValueChanged("QtyDelivered") && (validateOrderedQty = MSysConfig.getBooleanValue("UY_VALIDATE_ORDERED_QTY_SO", false, Env.getAD_Client_ID(Env.getCtx()))) && model.getQtyDelivered().compareTo(model.getQtyOrdered()) > 0) {
                throw new AdempiereException("ERROR: Cantidad Entregada es mayor a Cantidad Ordenada para la Orden " + model.getC_Order().getDocumentNo() + " y linea " + model.getLine());
            }
        } else if (po instanceof MDunningRunEntry) {
            MDunningRunEntry mDunningRunEntry = (MDunningRunEntry)po;
            if (type == 3 && mDunningRunEntry.get_ValueAsBoolean("IsPrinted")) {
                throw new AdempiereException("Entrada de Morosidad ya enviada por mail, no se puede borrar registro");
            }
        } else if (po instanceof MOrder) {
            MDocType docType2;
            MOrder order = (MOrder)po;
            if (order.isSOTrx() && (type == 1 || type == 2 && order.is_ValueChanged("C_DocTypeTarget_ID")) && (docType2 = (MDocType)order.getC_DocTypeTarget()).getDocBaseType().equalsIgnoreCase("SOO") && docType2.getDocSubTypeSO() != null && docType2.getDocSubTypeSO().equalsIgnoreCase("WI")) {
                order.setPaymentRule("P");
            }
        } else if (po instanceof MDocType && (type == 1 || type == 2) && (docType = (MDocType)po).getDocBaseType().equalsIgnoreCase("DPI") && docType.get_ValueAsInt("C_BankAccount_ID") > 0) {
            MBankAccount account = new MBankAccount(docType.getCtx(), docType.get_ValueAsInt("C_BankAccount_ID"), docType.get_TrxName());
            if (docType.getAD_Org_ID() != account.getAD_Org_ID()) {
                throw new AdempiereException("ERROR: La organizaci\u00f3n de la libreta/resma debe ser igual a la de la cuenta bancaria");
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        this.log.info(po.get_TableName() + " Timing: " + timing);
        String retorno = "";
        if (po instanceof MInvoice && timing == 9) {
            MUYPayReceipt pay;
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isSOTrx()) {
                MSequence seq;
                if (invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") && invoice.getReversal_ID() <= 0 && (seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence()) != null && seq.get_ID() > 0 && seq.get_ValueAsBoolean("IsDocNoControlled")) {
                    MSequenceCtl ctl = this.verifyCheckNumber(invoice);
                    if (null != ctl) {
                        ctl.setIsApply(true);
                        ctl.setDateTrx(invoice.getDateInvoiced());
                        ctl.setAD_Table_ID(invoice.get_Table_ID());
                        ctl.setRecord_ID(invoice.get_ID());
                        ctl.saveEx();
                        int docTypeID = MDocType.getDocType("DPC");
                        MInvoice nc = this.createCreditNoteDeferred(invoice, docTypeID, invoice.isSOTrx(), true, false);
                        if (!nc.processIt("CO")) {
                            retorno = nc.getProcessMsg();
                            nc.deleteEx(true);
                            return retorno;
                        }
                        nc.saveEx();
                    } else {
                        return "Verifique nro. de cheque seleccionado";
                    }
                }
                if (MSysConfig.getBooleanValue("UY_UPDATE_PO_PRICELIST_VERSION", false, invoice.getAD_Client_ID()) && invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("API")) {
                    this.checkPriceModificationInvoice(invoice);
                }
            } else if (invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DRI") && invoice.getGrandTotal().compareTo(Env.ZERO) > 0 && invoice.get_ValueAsInt("UY_PayReceipt_ID") > 0 && !(pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName())).get_ValueAsBoolean("IsRepresentation")) {
                int docTypeID = MDocType.getDocType("DRC");
                MInvoice nc = this.createCreditNoteDeferred(invoice, docTypeID, invoice.isSOTrx(), true, false);
                if (!nc.processIt("CO")) {
                    retorno = nc.getProcessMsg();
                    nc.deleteEx(true);
                    return retorno;
                }
                nc.saveEx();
            }
        } else if (po instanceof MInvoice && timing == 7) {
            MSequence seq;
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isSOTrx() && invoice.getReversal_ID() <= 0 && invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") && (seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence()) != null && seq.get_ID() > 0 && seq.get_ValueAsBoolean("IsDocNoControlled") && seq.get_ValueAsBoolean("IsSkipSeq") && null == this.verifyCheckNumber(invoice)) {
                return "Verifique nro. de cheque seleccionado";
            }
        } else if (po instanceof MInvoice && timing == 2) {
            MUYPayReceipt pay;
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isSOTrx()) {
                if (invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI")) {
                    if (invoice.getInvoiceCollectionType().equalsIgnoreCase("E")) {
                        throw new AdempiereException("Imposible anular documento: el cheque se encuentra en estado ENTREGADO");
                    }
                    retorno = this.verifyVoidDeferredDoc(invoice);
                    if (retorno != null) {
                        return retorno;
                    }
                    retorno = this.voidCreditNoteDeferred(invoice);
                    if (retorno != null) {
                        return retorno;
                    }
                    String sql = "select l.ad_sequencectl_id from c_doctype doc inner join ad_sequence sec on doc.docnosequence_id = sec.ad_sequence_id inner join ad_sequencectl l on sec.ad_sequence_id = l.ad_sequence_id where doc.c_doctype_id = " + invoice.getC_DocTypeTarget_ID() + " and l.documentno = '" + invoice.getDocumentNo() + "'";
                    int ctlLineID = DB.getSQLValueEx(invoice.get_TrxName(), sql, new Object[0]);
                    if (ctlLineID > 0) {
                        DB.executeUpdateEx("update ad_sequencectl set isapply = 'N' where ad_sequencectl_id = " + ctlLineID, invoice.get_TrxName());
                    }
                    return "";
                }
                if (!invoice.isSOTrx()) {
                    String mInvoiceLinesIds = Arrays.stream(invoice.getLines()).map(mInvoiceLine -> String.valueOf(mInvoiceLine.getC_InvoiceLine_ID())).collect(Collectors.joining(","));
                    List<MTimeExpenseLine> mTimeExpenseLines = new Query(invoice.getCtx(), "S_TimeExpenseLine", "C_InvoiceLine_ID IN (" + mInvoiceLinesIds + ")", invoice.get_TrxName()).list();
                    mTimeExpenseLines.forEach(mTimeExpenseLine -> {
                        mTimeExpenseLine.setC_InvoiceLine_ID(0);
                        mTimeExpenseLine.saveEx();
                    });
                }
            } else if (invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DRI") && invoice.get_ValueAsInt("UY_PayReceipt_ID") > 0 && (pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName())) != null && pay.get_ID() > 0 && !pay.get_ValueAsBoolean("IsRepresentation") && (retorno = this.voidCreditNoteTerDeferred(invoice)) != null) {
                return retorno;
            }
        } else if (po instanceof MOrder && timing == 9) {
            MOrder order = (MOrder)po;
            if (MSysConfig.getBooleanValue("UY_UPDATE_PO_PRICELIST_VERSION", false, order.getAD_Client_ID()) && !order.isSOTrx()) {
                this.checkPriceModificationOrder(order);
            }
        } else if (po instanceof MOrder && timing == 7) {
            MOrder order = (MOrder)po;
            if (order.getM_PriceList_ID() > 0 && order.getC_Currency_ID() > 0 && order.getM_PriceList().getC_Currency_ID() != order.getC_Currency_ID()) {
                throw new AdempiereException("ERROR: Moneda de lista de precios es distinta a moneda de la orden (Orden Nro. " + order.getDocumentNo() + ")");
            }
            this.verifyOrderLines(order);
        } else if (po instanceof MUYPayReceipt && timing == 10) {
            MUYPayReceipt model = (MUYPayReceipt)po;
            if (model.getDocStatus().equals("CO") && this.updateReceiptDocNo(model) > 0) {
                return "";
            }
        } else if (po instanceof MInvoice && (timing == 5 || timing == 6)) {
            MInvoice invoice = (MInvoice)po;
            if (!invoice.isSOTrx() && invoice.getC_DocTypeTarget().getDocBaseType().equalsIgnoreCase("DPI") && invoice.getInvoiceCollectionType().equalsIgnoreCase("E")) {
                throw new AdempiereException("Imposible reversar documento: el cheque se encuentra en estado ENTREGADO");
            }
        } else if (po instanceof MTimeExpense && timing == 10) {
            MTimeExpense model = (MTimeExpense)po;
            this.voidFromTimeExpense(po.get_ID(), true);
            this.voidFromTimeExpense(po.get_ID(), false);
        } else if (po instanceof MPaySelection && (timing == 4 || timing == 2)) {
            MPaySelection selection = (MPaySelection)po;
            if (timing == 4) {
                this.verifyPaySelectionPayment(selection, false);
            } else if (timing == 2) {
                this.verifyPaySelectionPayment(selection, true);
            }
        } else if (po instanceof MPayment && timing == 16) {
            if (po.get_TableName().equals("C_Payment")) {
                this.postAllocationsPayment((MPayment)po);
            }
        } else if (po instanceof MInvoice && timing == 16 && po.get_TableName().equals("C_Invoice")) {
            this.postAllocationsInvoice((MInvoice)po);
        }
        return null;
    }

    private void checkPriceModificationInvoice(MInvoice invoice) {
        MPriceList list = (MPriceList)invoice.getM_PriceList();
        MPriceListVersion version = list.getPriceListVersion(invoice.getDateInvoiced());
        if (version == null) {
            return;
        }
        MInvoiceLine[] lines = invoice.getLines(true);
        for (int i = 0; i < lines.length; ++i) {
            MProductPrice actualPrice;
            MInvoiceLine invLine = lines[i];
            if (invLine.getM_Product_ID() <= 0 || (actualPrice = MProductPrice.get(Env.getCtx(), version.get_ID(), invLine.getM_Product_ID(), invoice.get_TrxName())) == null || invLine.getPriceEntered().compareTo(actualPrice.getPriceList()) == 0) continue;
            actualPrice.setPriceList(invLine.getPriceEntered());
            actualPrice.setPriceLimit(invLine.getPriceEntered());
            actualPrice.setPriceStd(invLine.getPriceEntered());
            MUser user = new MUser(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()), invoice.get_TrxName());
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MDocType docType = (MDocType)invoice.getC_DocTypeTarget();
            String comments = "ACTUALIZADO: " + user.getName() + " - " + today + " - " + docType.getName() + " - " + invoice.getDocumentNo();
            actualPrice.set_ValueOfColumn("Help", (Object)comments);
            actualPrice.saveEx();
        }
    }

    private void checkPriceModificationOrder(MOrder order) {
        MPriceList list = (MPriceList)order.getM_PriceList();
        MPriceListVersion version = list.getPriceListVersion(order.getDateOrdered());
        if (version == null) {
            return;
        }
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MProductPrice actualPrice;
            MOrderLine orderLine = lines[i];
            if (orderLine.getM_Product_ID() <= 0 || (actualPrice = MProductPrice.get(Env.getCtx(), version.get_ID(), orderLine.getM_Product_ID(), order.get_TrxName())) == null || orderLine.getPriceEntered().compareTo(actualPrice.getPriceList()) == 0) continue;
            actualPrice.setPriceList(orderLine.getPriceEntered());
            actualPrice.setPriceLimit(orderLine.getPriceEntered());
            actualPrice.setPriceStd(orderLine.getPriceEntered());
            MUser user = new MUser(Env.getCtx(), Env.getAD_User_ID(Env.getCtx()), order.get_TrxName());
            Timestamp today = new Timestamp(System.currentTimeMillis());
            MDocType docType = (MDocType)order.getC_DocTypeTarget();
            String comments = "ACTUALIZADO: " + user.getName() + " - " + today + " - " + docType.getName() + " - " + order.getDocumentNo();
            actualPrice.set_ValueOfColumn("Help", (Object)comments);
            actualPrice.saveEx();
        }
    }

    private void verifyPaySelectionPayment(MPaySelection selection, boolean isVOID) {
        List<MAllocationHdr> allocationList;
        Object sql = "select ad_table_id from ad_table where lower(tablename) like 'c_payselectioncheckorg'";
        int tableID = DB.getSQLValueEx(selection.get_TrxName(), (String)sql, new Object[0]);
        String tableName = "c_payselectioncheck";
        if (tableID > 0) {
            tableName = "c_payselectioncheckorg";
        }
        sql = "select count (p.c_payment_id) from " + tableName + " l inner join c_payment p on l.c_payment_id = p.c_payment_id where l.c_payselection_id = " + selection.get_ID() + " and p.docstatus in ('CO','CL')";
        int count = DB.getSQLValueEx(selection.get_TrxName(), (String)sql, new Object[0]);
        if (count > 0) {
            throw new AdempiereException("ERROR: Existen pagos en estado completo, debe anular los pagos para poder reactivar o anular este documento.");
        }
        if (isVOID && !(allocationList = Arrays.asList(MAllocationHdr.getOfPaySelection(Env.getCtx(), selection.get_ID()))).isEmpty()) {
            throw new AdempiereException("ERROR: Existen asignaciones de pagos en estado completo, debe anular las asignaciones para poder reactivar o anular este documento.");
        }
    }

    private int updateReceiptDocNo(MUYPayReceipt model) {
        int qty = 0;
        String docNo = model.getDocumentNo() + "_" + model.get_ID();
        qty = DB.executeUpdateEx("update uy_payreceipt set documentno = '" + docNo + "' where uy_payreceipt_id = " + model.get_ID(), model.get_TrxName());
        return qty;
    }

    private String verifyVoidDeferredDoc(MInvoice invoice) {
        Object sql = "";
        Object retorno = "";
        sql = "select p.uy_payreceipt_id from uy_payreceipt p join c_doctype d on p.c_doctype_id = d.c_doctype_id join uy_payreceiptdef l on p.uy_payreceipt_id = l.uy_payreceipt_id where d.docbasetype = 'BPP' and p.docstatus <> 'VO' and l.c_invoice_id = " + invoice.get_ID();
        int receiptID = DB.getSQLValueEx(invoice.get_TrxName(), (String)sql, new Object[0]);
        if (receiptID > 0) {
            MUYPayReceipt pay = new MUYPayReceipt(invoice.getCtx(), receiptID, invoice.get_TrxName());
            retorno = "Imposible anular documento: el cheque ha sido utilizado en el recibo de pago Nro. " + pay.getDocumentNo() + ", en estado diferente a anulado";
            return retorno;
        }
        return null;
    }

    private String voidCreditNoteDeferred(MInvoice invoice) {
        Object sql = "";
        Object retorno = "";
        sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.ref_invoice_id = " + invoice.get_ID() + " and d.docbasetype = 'DPC' and i.docstatus = 'CO'";
        int ncID = DB.getSQLValueEx(invoice.get_TrxName(), (String)sql, new Object[0]);
        if (ncID > 0) {
            MInvoice invNC = new MInvoice(invoice.getCtx(), ncID, invoice.get_TrxName());
            sql = "select p.uy_payreceipt_id from uy_payreceipt p join c_doctype d on p.c_doctype_id = d.c_doctype_id join uy_payreceiptdoc l on p.uy_payreceipt_id = l.uy_payreceipt_id where d.docbasetype = 'BPP' and p.docstatus <> 'VO' and l.c_invoice_id = " + invNC.get_ID();
            int receiptID = DB.getSQLValueEx(invoice.get_TrxName(), (String)sql, new Object[0]);
            if (receiptID > 0) {
                MUYPayReceipt pay = new MUYPayReceipt(invoice.getCtx(), receiptID, invoice.get_TrxName());
                retorno = "Imposible anular documento: el pago diferido Nro. " + invNC.getDocumentNo() + " asociado a este cheque se encuentra en el recibo de pago Nro. " + pay.getDocumentNo() + ", en estado diferente a anulado";
                return retorno;
            }
            if (!invNC.processIt("VO")) {
                retorno = invNC.getProcessMsg();
                throw new AdempiereException((String)retorno);
            }
            invNC.saveEx();
        }
        return null;
    }

    private String voidCreditNoteTerDeferred(MInvoice invoice) {
        MInvoice nc;
        Object sql = "";
        String retorno = "";
        String message = "";
        MUYPayReceipt pay = null;
        if (invoice.get_ValueAsInt("UY_PayReceipt_ID") <= 0) {
            throw new AdempiereException("No se encontro recibo asociado al cobro diferido Nro. " + invoice.getDocumentNo());
        }
        pay = new MUYPayReceipt(invoice.getCtx(), invoice.get_ValueAsInt("UY_PayReceipt_ID"), invoice.get_TrxName());
        sql = "select i.c_invoice_id from c_invoice i join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.uy_payreceipt_id = " + pay.get_ID() + " and ref_invoice_id = " + invoice.get_ID() + " and d.docbasetype = 'DRC' and i.docstatus = 'CO'";
        int ncID = DB.getSQLValueEx(invoice.get_TrxName(), (String)sql, new Object[0]);
        if (ncID > 0 && (nc = new MInvoice(invoice.getCtx(), ncID, invoice.get_TrxName())) != null && nc.get_ID() > 0) {
            if (!nc.processIt("VO")) {
                message = nc.getProcessMsg();
                throw new AdempiereException(message);
            }
            nc.saveEx();
            if (!pay.getDocStatus().equalsIgnoreCase("CO")) {
                DB.executeUpdateEx("delete from uy_payreceiptdoc where c_invoice_id = " + nc.get_ID(), invoice.get_TrxName());
                sql = " DELETE FROM Fact_Acct WHERE AD_Table_ID = " + X_C_Invoice.Table_ID + " AND Record_ID = " + nc.get_ID();
                DB.executeUpdateEx((String)sql, invoice.get_TrxName());
                nc.deleteEx(true);
            }
        }
        return null;
    }

    private MSequenceCtl verifyCheckNumber(MInvoice invoice) {
        MSequence seq = (MSequence)invoice.getC_DocTypeTarget().getDocNoSequence();
        if (seq != null && seq.get_ID() > 0 && !invoice.getDocumentNo().isEmpty()) {
            List<MSequenceCtl> ctlList = seq.getControlLines(" AND IsApply = 'N' ");
            for (MSequenceCtl ctl : ctlList) {
                if (!invoice.getDocumentNo().equalsIgnoreCase(ctl.getDocumentNo())) continue;
                return ctl;
            }
        }
        return null;
    }

    private MInvoice createCreditNoteDeferred(MInvoice origin, int DocTypeTargetTo, boolean isSoTrx, boolean counter, boolean setOrder) {
        MInvoice newInv = MInvoice.copyFrom(origin, origin.getDateInvoiced(), origin.getDateAcct(), DocTypeTargetTo, isSoTrx, counter, false, origin.get_TrxName(), setOrder);
        if (newInv != null && newInv.get_ID() > 0) {
            newInv.setC_Project_ID(origin.getC_Project_ID());
            newInv.setC_BPartner_ID(origin.getC_BPartner_ID());
            newInv.setC_BPartner_Location_ID(origin.getC_BPartner_Location_ID());
            newInv.setDescription("Creada desde: " + origin.getC_DocType().getPrintName() + ", Nro:" + origin.getDocumentNo());
            if (origin.get_ValueAsInt("UY_PayReceipt_ID") > 0) {
                newInv.set_ValueOfColumn("UY_PayReceipt_ID", (Object)origin.get_ValueAsInt("UY_PayReceipt_ID"));
            }
        } else {
            throw new AdempiereException("No se puede crear factura al cliente del proyecto");
        }
        newInv.saveEx(origin.get_TrxName());
        return newInv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String createInvoiceToClientProject(MInvoice origin, int DocTypeTargetTo, boolean isSoTrx, boolean counter, boolean setOrder) {
        MInvoice newInv = MInvoice.copyFrom(origin, origin.getDateInvoiced(), origin.getDateAcct(), DocTypeTargetTo, isSoTrx, counter, false, origin.get_TrxName(), setOrder);
        if (newInv == null || newInv.get_ID() <= 0) throw new AdempiereException("No se puede crear factura al cliente del proyecto");
        if (origin.getC_Project_ID() <= 0) throw new AdempiereException("El documento: " + origin.getC_DocType().getPrintName() + ",necesita tener un proyecto asociado");
        newInv.setC_Project_ID(origin.getC_Project_ID());
        MBPartner cbp = (MBPartner)origin.getC_Project().getC_BPartner();
        if (cbp == null || cbp.get_ID() <= 0) throw new AdempiereException("El proyecto asociado al documento, no tiene cliente asociado");
        newInv.setC_BPartner_ID(cbp.get_ID());
        MBPartnerLocation locBp = cbp.getPrimaryC_BPartner_Location();
        if (locBp == null || locBp.get_ID() <= 0) {
            throw new AdempiereException("El cliente asociado al proyecto, no tiene localizacion definida");
        }
        newInv.setC_BPartner_Location_ID(locBp.get_ID());
        newInv.setDescription("Creada desde: " + origin.getC_DocType().getPrintName() + ", Nro:" + origin.getDocumentNo());
        newInv.saveEx(origin.get_TrxName());
        return null;
    }

    private String voidFromTimeExpense(int expenseID, boolean IsRMA) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Object sql = "";
        String message = "";
        String tableName = "M_RMA";
        String fieldID = "M_RMA_ID";
        MRMA rma = null;
        MInOut inout = null;
        if (!IsRMA) {
            tableName = "M_InOut";
            fieldID = "M_InOut_ID";
        }
        sql = "select " + fieldID + " from " + tableName + " where s_timeexpense_id = " + expenseID + " and docstatus = 'CO'";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (IsRMA) {
                    rma = new MRMA(Env.getCtx(), rs.getInt("M_RMA_ID"), null);
                    if (rma == null || !rma.getDocStatus().equalsIgnoreCase("CO")) continue;
                    if (!rma.processIt("VO")) {
                        message = rma.getProcessMsg();
                        throw new AdempiereException(message);
                    }
                    rma.saveEx();
                    continue;
                }
                inout = new MInOut(Env.getCtx(), rs.getInt("M_InOut_ID"), null);
                if (inout == null || !inout.getDocStatus().equalsIgnoreCase("CO")) continue;
                if (!inout.processIt("VO")) {
                    message = inout.getProcessMsg();
                    throw new AdempiereException(message);
                }
                inout.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return null;
    }

    private void postAllocationsPayment(MPayment payment) {
        MAllocationHdr[] allocations;
        if (!MClient.isClientAccountingImmediate()) {
            return;
        }
        if (payment.getReversal_ID() > 0) {
            return;
        }
        for (MAllocationHdr allocation : allocations = MAllocationHdr.getOfPayment(payment.getCtx(), payment.getC_Payment_ID(), payment.get_TrxName())) {
            String ignoreError;
            if (!allocation.getDocStatus().equals("CO") || allocation.isPosted() || (ignoreError = DocumentEngine.postImmediate(allocation.getCtx(), allocation.getAD_Client_ID(), allocation.get_Table_ID(), allocation.getC_AllocationHdr_ID(), true, payment.get_TrxName())) == null) continue;
            this.log.warning(ignoreError);
        }
    }

    private void postAllocationsInvoice(MInvoice invoice) {
        MAllocationHdr[] allocations;
        if (!MClient.isClientAccountingImmediate()) {
            return;
        }
        if (invoice.getReversal_ID() > 0) {
            return;
        }
        for (MAllocationHdr allocation : allocations = MAllocationHdr.getOfInvoice(invoice.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName())) {
            String ignoreError;
            if (!allocation.getDocStatus().equals("CO") || allocation.isPosted() || (ignoreError = DocumentEngine.postImmediate(allocation.getCtx(), allocation.getAD_Client_ID(), allocation.get_Table_ID(), allocation.getC_AllocationHdr_ID(), true, invoice.get_TrxName())) == null) continue;
            this.log.warning(ignoreError);
        }
    }

    private void verifyOrderLines(MOrder doc) {
        String sql = "select c_orderline_id from c_orderline where c_order_id = " + doc.get_ID() + " and m_product_id is null and c_charge_id is null";
        int lineID = DB.getSQLValueEx(doc.get_TrxName(), sql, new Object[0]);
        if (lineID > 0) {
            throw new AdempiereException("Todas las lineas deben tener un producto o cargo");
        }
    }
}

