/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MAllocInvoice;

public class ModelValidatorInvoice390
implements ModelValidator {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;
    private int m_AD_Org_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        } else {
            this.log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        this.m_AD_Org_ID = AD_Org_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        this.m_AD_User_ID = AD_User_ID;
        return null;
    }

    @Override
    public String modelChange(PO po, int timing) throws Exception {
        MInvoice invoice;
        if (po instanceof MInvoice && (invoice = (MInvoice)po).isSOTrx() && po instanceof MInvoice && timing == 5 && invoice.is_ValueChanged("IsPaid") && invoice.getC_DocType().getDocBaseType().equals("ARI") && !invoice.isPaid()) {
            DB.executeUpdateEx("UPDATE C_Invoice SET daysDue = 0 WHERE C_Invoice_ID = " + invoice.get_ID(), invoice.get_TrxName());
        }
        return null;
    }

    private int updateDocumentNo(MInvoice doc) {
        int qty = 0;
        String docNo = doc.getDocumentNo() + "_" + doc.get_ID();
        qty = DB.executeUpdateEx("update c_invoice set documentno = '" + docNo + "' where c_invoice_id = " + doc.get_ID(), doc.get_TrxName());
        return qty;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice doc;
        MDocType docType;
        if (po instanceof MInvoice && timing == 2) {
            MInvoice doc2 = (MInvoice)po;
            this.deleteMatchInv(doc2.getCtx(), doc2.get_TrxName(), doc2.get_ID(), true);
            if (!doc2.isSOTrx() && doc2.getDocStatus().equals("CO") && this.updateDocumentNo(doc2) > 0) {
                return "";
            }
        } else if (po instanceof MInvoice && timing == 7) {
            MInvoice doc3 = (MInvoice)po;
            MDocType docType2 = new MDocType(doc3.getCtx(), doc3.getC_DocTypeTarget_ID(), doc3.get_TrxName());
            this.verifyInvLines(doc3);
            boolean mandatoryReasonNC = MSysConfig.getBooleanValue("UY_SO_CREDIT_NOTE_REASON_MANDATORY", false, doc3.getAD_Client_ID());
            if (mandatoryReasonNC && docType2.getDocBaseType().equalsIgnoreCase("ARC") && doc3.get_ValueAsInt("M_RMAType_ID") == 0) {
                throw new AdempiereException("Debe seleccionar Motivo de Nota de Cr\u00e9dito");
            }
            if (docType2.getDocBaseType().equalsIgnoreCase("ARC") || docType2.getDocBaseType().equalsIgnoreCase("APC")) {
                BigDecimal amtAllocated = this.getAmtAllocatedNC(doc3);
                if (amtAllocated == null) {
                    amtAllocated = Env.ZERO;
                }
                if (amtAllocated.compareTo(Env.ZERO) > 0 && amtAllocated.compareTo(doc3.getGrandTotal()) > 0) {
                    throw new AdempiereException("ERROR: Monto total asignado de facturas no puede ser mayor al monto de la Nota de Cr\u00e9dito");
                }
            }
        } else if (po instanceof MInvoice && timing == 9) {
            int count;
            MInvoice doc4 = (MInvoice)po;
            MDocType docType3 = new MDocType(doc4.getCtx(), doc4.getC_DocTypeTarget_ID(), doc4.get_TrxName());
            if ((docType3.getDocBaseType().equalsIgnoreCase("ARC") || docType3.getDocBaseType().equalsIgnoreCase("APC")) && (count = DB.getSQLValueEx(doc4.get_TrxName(), "SELECT COUNT(*) FROM UY_AllocInvoice WHERE C_AllocInvoice_ID IS NOT NULL AND C_Invoice_ID = " + doc4.get_ID(), new Object[0])) > 0) {
                this.generateAllocation(doc4);
            }
            if (docType3.getDocBaseType().equalsIgnoreCase("ARC")) {
                String sql = "UPDATE S_TimeExpenseLine tl set IsInvoiced = 'N' FROM C_InvoiceLine il WHERE tl.S_TimeExpenseLine_ID = il.S_TimeExpenseLine_ID AND tl.IsInvoiced = 'Y' AND il.C_Invoice_ID = " + doc4.get_ID();
                DB.executeUpdateEx(sql, doc4.get_TrxName());
            }
        } else if (po instanceof MInOut && timing == 2) {
            MInOut doc5 = (MInOut)po;
            this.deleteMatchInv(doc5.getCtx(), doc5.get_TrxName(), doc5.get_ID(), false);
        } else if (po instanceof MInvoice && (timing == 10 || timing == 13 || timing == 14) && (docType = new MDocType((doc = (MInvoice)po).getCtx(), doc.getC_DocTypeTarget_ID(), doc.get_TrxName())).getDocBaseType().equalsIgnoreCase("ARI")) {
            String sql = "UPDATE S_TimeExpenseLine tl set IsInvoiced = 'N' FROM C_InvoiceLine il WHERE (tl.C_InvoiceLine_ID = il.C_InvoiceLine_ID OR tl.S_TimeExpenseLine_ID = il.S_TimeExpenseLine_ID) AND tl.IsInvoiced = 'Y' AND il.C_Invoice_ID = " + doc.get_ID();
            DB.executeUpdateEx(sql, doc.get_TrxName());
        }
        return null;
    }

    private BigDecimal getAmtAllocatedNC(MInvoice doc) {
        String sql = "SELECT coalesce(SUM(amtToAllocate),0) FROM UY_AllocInvoice WHERE C_AllocInvoice_ID IS NOT NULL AND C_Invoice_ID = " + doc.get_ID();
        BigDecimal amtAllocated = DB.getSQLValueBDEx(doc.get_TrxName(), sql, new Object[0]);
        if (amtAllocated == null) {
            amtAllocated = Env.ZERO;
        }
        return amtAllocated;
    }

    private void deleteMatchInv(Properties ctx, String trxName, int record_id, boolean IsInvoice) {
        Object sql = "";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = IsInvoice ? "select m.m_matchinv_id from m_matchinv m join c_invoiceline il on m.c_invoiceline_id = il.c_invoiceline_id where il.c_invoice_id = " + record_id : "select m.m_matchinv_id from m_matchinv m join m_inoutline il on m.m_inoutline_id = il.m_inoutline_id where il.m_inout_id = " + record_id;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int matchID = DB.getSQLValueEx(trxName, (String)sql, new Object[0]);
                if (matchID <= 0) continue;
                MMatchInv inv = new MMatchInv(ctx, matchID, trxName);
                inv.deleteEx(true);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void generateAllocation(MInvoice nc) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean IsAllocated = false;
        BigDecimal multiplier = Env.ONE;
        BigDecimal amountNC = nc.getGrandTotal();
        MAllocationLine aLine = null;
        boolean IsFromCreditNote = true;
        boolean IsFirstRow = true;
        try {
            BigDecimal amtAllocated;
            MDocType doc = (MDocType)nc.getC_DocTypeTarget();
            MAllocationHdr alloc = new MAllocationHdr(nc.getCtx(), true, nc.getDateInvoiced(), nc.getC_Currency_ID(), Env.getContext(Env.getCtx(), "#AD_User_Name"), nc.get_TrxName());
            alloc.setAD_Org_ID(nc.getAD_Org_ID());
            alloc.setDescription("Generado automaticamente desde " + doc.getPrintName() + " Nro. " + nc.getDocumentNo());
            alloc.saveEx();
            if (nc.getM_RMA_ID() > 0) {
                IsFromCreditNote = false;
            }
            String sql = "SELECT UY_AllocInvoice_ID FROM UY_AllocInvoice WHERE C_AllocInvoice_ID IS NOT NULL AND C_Invoice_ID = " + nc.get_ID();
            pstmt = DB.prepareStatement(sql, nc.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                multiplier = Env.ONE;
                MAllocInvoice line = new MAllocInvoice(nc.getCtx(), rs.getInt("UY_AllocInvoice_ID"), nc.get_TrxName());
                MInvoice inv = new MInvoice(nc.getCtx(), line.getC_AllocInvoice_ID(), nc.get_TrxName());
                if (inv.isPaid()) {
                    throw new AdempiereException("La factura nro. " + inv.getDocumentNo() + " est\u00e1 totalmente asignada");
                }
                BigDecimal amtInvAllocate = DB.getSQLValueBDEx(nc.get_TrxName(), "select invoiceopen(" + inv.get_ID() + ", null)", new Object[0]);
                if (nc.getC_Currency_ID() != inv.getC_Currency_ID()) {
                    amtInvAllocate = MConversionRate.convert(Env.getCtx(), amtInvAllocate, inv.getC_Currency_ID(), nc.getC_Currency_ID(), inv.getDateInvoiced(), inv.getC_ConversionType_ID(), inv.getAD_Client_ID(), inv.getAD_Org_ID());
                }
                if (amtInvAllocate == null) {
                    amtInvAllocate = Env.ZERO;
                }
                if (amtInvAllocate.compareTo(line.getAmtToAllocate()) < 0) {
                    throw new AdempiereException("Monto indicado para asignar del documento '" + inv.getDocumentNo() + "' difiere del monto abierto actual, por favor verifique");
                }
                if (!nc.isSOTrx()) {
                    multiplier = multiplier.negate();
                }
                aLine = new MAllocationLine(alloc, line.getAmtToAllocate().multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
                aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
                aLine.saveEx();
                if (IsFromCreditNote) {
                    for (MInvoiceLine invoiceLine : inv.getLines(true)) {
                        if (invoiceLine.getM_InOutLine_ID() <= 0) continue;
                        IsFromCreditNote = false;
                        break;
                    }
                }
                if (!IsFirstRow) continue;
                alloc.set_ValueOfColumn("User1_ID", (Object)inv.getUser1_ID());
                alloc.set_ValueOfColumn("C_BPartner_ID", (Object)inv.getC_BPartner_ID());
                alloc.set_ValueOfColumn("C_Project_ID", (Object)inv.getC_Project_ID());
                alloc.set_ValueOfColumn("S_Contract_ID", (Object)inv.get_ValueAsInt("S_Contract_ID"));
                IsFirstRow = false;
            }
            alloc.set_ValueOfColumn("IsFromCreditNote", (Object)IsFromCreditNote);
            alloc.saveEx();
            multiplier = Env.ONE;
            if (nc.isSOTrx()) {
                multiplier = multiplier.negate();
            }
            if ((amtAllocated = this.getAmtAllocatedNC(nc)) == null) {
                amtAllocated = Env.ZERO;
            }
            if (amtAllocated.compareTo(nc.getGrandTotal()) < 0) {
                amountNC = amtAllocated;
            }
            aLine = new MAllocationLine(alloc, amountNC.multiply(multiplier), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setDocInfo(nc.getC_BPartner_ID(), nc.getC_Order_ID(), nc.get_ID());
            aLine.setC_BPartner_ID(nc.getC_BPartner_ID());
            aLine.saveEx();
            if (alloc != null && alloc.get_ID() > 0) {
                if (!alloc.processIt("CO")) {
                    throw new AdempiereException(alloc.getProcessMsg());
                }
                alloc.saveEx();
                IsAllocated = true;
            }
            if (IsAllocated) {
                this.testAllocation(nc);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void testAllocation(MInvoice nc) {
        Object sql = "";
        BigDecimal open = Env.ZERO;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        sql = "SELECT coalesce(invoiceOpen(C_Invoice_ID, 0), 0) FROM C_Invoice WHERE C_Invoice_ID=?";
        open = DB.getSQLValueBD(nc.get_TrxName(), (String)sql, nc.get_ID());
        if (open != null && open.signum() == 0) {
            sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + nc.get_ID();
            int n = DB.executeUpdate((String)sql, nc.get_TrxName());
        }
        sql = "select * from uy_allocinvoice where c_invoice_id = " + nc.get_ID();
        try {
            pstmt = DB.prepareStatement((String)sql, nc.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer invoiceID = rs.getInt("C_AllocInvoice_ID");
                sql = "SELECT coalesce(invoiceOpen(C_Invoice_ID, 0), 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                open = DB.getSQLValueBD(nc.get_TrxName(), (String)sql, invoiceID);
                if (open == null || open.signum() != 0) continue;
                sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + invoiceID;
                int n = DB.executeUpdate((String)sql, nc.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void verifyInvLines(MInvoice doc) {
        String sql = "select c_invoiceline_id from c_invoiceline where c_invoice_id = " + doc.get_ID() + " and m_product_id is null and c_charge_id is null";
        int lineID = DB.getSQLValueEx(doc.get_TrxName(), sql, new Object[0]);
        if (lineID > 0) {
            throw new AdempiereException("Todas las lineas deben tener un producto o cargo");
        }
    }
}

