/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.openup.core.model.X_C_PaySelectionCheckOrg;

public class MPaySelectionCheckOrg
extends X_C_PaySelectionCheckOrg {
    public MPaySelectionCheckOrg(Properties ctx, int C_PaySelectionCheckOrg_ID, String trxName) {
        super(ctx, C_PaySelectionCheckOrg_ID, trxName);
    }

    public MPaySelectionCheckOrg(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void changePayment(AtomicInteger lastDocumentNo, String paymentRule, MPaySelection selection) {
        MPayment oldPayment = this.voidPayment();
        MPayment newPayment = this.generatePayment(lastDocumentNo, paymentRule, selection);
        Object description = oldPayment.getDescription();
        description = description != null && !((String)description).isEmpty() ? (String)description + " | " : "";
        description = (String)description + "Modificado por documento " + newPayment.getDocumentNo();
        oldPayment.setDescription((String)description);
        oldPayment.saveEx();
    }

    public MPayment generatePayment(AtomicInteger lastDocumentNo, String paymentRule, MPaySelection selection) {
        MPayment mPayment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if (this.getC_Payment_ID() != 0 && (mPayment.getDocStatus().equals("CO") || mPayment.getDocStatus().equals("CL"))) {
            if (paymentRule.equals("S")) {
                mPayment.setCheckNo(this.getDocumentNo());
                mPayment.saveEx();
            }
        } else {
            String mPaymentDescription;
            MDocType documentType = MDocType.get(this.getCtx(), this.getC_PaySelection().getC_DocType_ID());
            int docTypeId = documentType.getC_DocTypePayment_ID();
            mPayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            mPayment.setAD_Org_ID(this.getAD_Org_ID());
            if (paymentRule.equals("S")) {
                mPayment.setBankCheck(((MPaySelectionCheck)this.getC_PaySelectionCheck()).getParent().getC_BankAccount_ID(), false, this.getDocumentNo());
            } else if (paymentRule.equals("K")) {
                mPayment.setTenderType("C");
            } else if (paymentRule.equals("T") || this.getPaymentRule().equals("D")) {
                mPayment.setBankACH((MPaySelectionCheck)this.getC_PaySelectionCheck());
            } else {
                this.log.log(Level.SEVERE, "Unsupported Payment Rule=" + paymentRule);
                throw new AdempiereException("Unsupported Payment Rule=" + paymentRule);
            }
            if (paymentRule.equalsIgnoreCase("S")) {
                mPayment.setTenderType("K");
            }
            if (paymentRule.equalsIgnoreCase("T")) {
                mPayment.setTenderType("A");
            }
            mPayment.setTrxType("C");
            if (docTypeId > 0) {
                mPayment.setC_DocType_ID(docTypeId);
            }
            mPayment.setAmount(((MPaySelectionCheck)this.getC_PaySelectionCheck()).getParent().getC_Currency_ID(), this.getPayAmt());
            mPayment.setDiscountAmt(this.getDiscountAmt());
            mPayment.setDateTrx(((MPaySelectionCheck)this.getC_PaySelectionCheck()).getParent().getPayDate());
            mPayment.setDateAcct(mPayment.getDateTrx());
            mPayment.setC_BPartner_ID(this.getC_BPartner_ID());
            List<MPaySelectionLine> paySelectionLines = ((MPaySelectionCheck)this.getC_PaySelectionCheck()).getPaySelectionLinesAsList(false);
            this.log.fine("confirmPrint - " + this.toString() + " (#SelectionLines=" + (paySelectionLines != null ? paySelectionLines.size() : 0) + ")");
            if (documentType.isBankTransfer()) {
                mPayment.setC_Invoice_ID(-1);
                mPayment.setC_Order_ID(-1);
                mPayment.setTenderType("A");
                mPayment.saveEx();
                if (paySelectionLines != null) {
                    for (MPaySelectionLine line : paySelectionLines) {
                        if (line.getC_BankAccountTo_ID() == 0) {
                            throw new AdempiereException("@C_BankAccountTo_ID@ @NotFound@");
                        }
                        MPayment receiptAccount = new MPayment(this.getCtx(), 0, this.get_TrxName());
                        PO.copyValues(mPayment, receiptAccount);
                        receiptAccount.setC_BankAccount_ID(line.getC_BankAccountTo_ID());
                        receiptAccount.setIsReceipt(!mPayment.isReceipt());
                        receiptAccount.setC_DocType_ID(!mPayment.isReceipt());
                        receiptAccount.setRelatedPayment_ID(mPayment.getC_Payment_ID());
                        receiptAccount.setTenderType("A");
                        receiptAccount.saveEx();
                        receiptAccount.processIt("CO");
                        receiptAccount.saveEx();
                        mPayment.setRelatedPayment_ID(receiptAccount.getC_Payment_ID());
                    }
                }
            } else if (this.getC_PaySelectionCheck().getQty() == 1 && paySelectionLines != null && paySelectionLines.size() == 1) {
                MPaySelectionLine paySelectionLine = paySelectionLines.get(0);
                this.log.fine("Map to Invoice " + paySelectionLine);
                if (paySelectionLine.getC_Order_ID() != 0) {
                    mPayment.setC_Order_ID(paySelectionLine.getC_Order_ID());
                }
                if (paySelectionLine.getC_Charge_ID() != 0) {
                    mPayment.setC_Charge_ID(paySelectionLine.getC_Charge_ID());
                    if (paySelectionLine.getHR_Movement_ID() > 0) {
                        mPayment.setC_Project_ID(paySelectionLine.getHRMovement().getC_Project_ID());
                    }
                }
                if (paySelectionLine.getC_ConversionType_ID() != 0) {
                    mPayment.setC_ConversionType_ID(paySelectionLine.getC_ConversionType_ID());
                }
                if (paySelectionLine.getC_Invoice_ID() != 0) {
                    mPayment.setC_Invoice_ID(paySelectionLine.getC_Invoice_ID());
                }
                mPayment.setIsPrepayment(paySelectionLine.isPrepayment());
                mPayment.setDiscountAmt(paySelectionLine.getDiscountAmt());
                mPayment.setWriteOffAmt(paySelectionLine.getDifferenceAmt());
                BigDecimal overUnder = paySelectionLine.getOpenAmt().subtract(paySelectionLine.getPayAmt()).subtract(paySelectionLine.getDiscountAmt()).subtract(paySelectionLine.getDifferenceAmt());
                mPayment.setOverUnderAmt(overUnder);
            } else {
                mPayment.setDiscountAmt(Env.ZERO);
            }
            mPayment.setWriteOffAmt(Env.ZERO);
            mPayment.setDescription(this.getDescription());
            int docNo = 0;
            try {
                docNo = lastDocumentNo.get();
            }
            catch (Exception overUnder) {
                // empty catch block
            }
            if (docNo > 0) {
                mPayment.setCheckNo(String.valueOf(lastDocumentNo.get()));
                mPayment.setDocumentNo(String.valueOf(lastDocumentNo.get()));
                lastDocumentNo.incrementAndGet();
            }
            mPayment.setDescription((String)((mPaymentDescription = mPayment.getDescription()) != null && !mPaymentDescription.isEmpty() ? mPaymentDescription + " - " : "") + "Generado desde Seleccion de Pago Nro. '" + this.getC_PaySelection().getDocumentNo() + "'");
            mPayment.set_ValueOfColumn("C_PaySelection_ID", (Object)selection.get_ID());
            mPayment.saveEx();
            this.setC_Payment_ID(mPayment.getC_Payment_ID());
            mPayment.processIt("CO");
            mPayment.saveEx();
        }
        this.setIsPrinted(true);
        this.setProcessed(true);
        return mPayment;
    }

    private MPayment voidPayment() {
        try {
            MPayment mPayment = (MPayment)this.getC_Payment();
            if (mPayment != null && mPayment.get_ID() > 0 && !"VO".equals(mPayment.getDocStatus())) {
                if (!mPayment.processIt("VO")) {
                    throw new AdempiereException(mPayment.getProcessMsg());
                }
                mPayment.saveEx();
                this.setC_Payment_ID(0);
            }
            return mPayment;
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }
}

