/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MAttachment;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MYear;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.openup.core.model.MDGIF2181Issue;
import org.openup.core.model.MDGIF2181Line;
import org.openup.core.model.X_UY_DGI_F2181;
import org.openup.core.model.X_UY_DGI_F2181_Line;

public class MDGIF2181
extends X_UY_DGI_F2181 {
    private static final long serialVersionUID = 5478858604011707046L;
    private static String taxBasico;
    private static String taxMinimo;
    private static String taxExento;

    public MDGIF2181(Properties ctx, int UY_DGI_F2181_ID, String trxName) {
        super(ctx, UY_DGI_F2181_ID, trxName);
    }

    public MDGIF2181(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean getData() {
        boolean hayCompras = false;
        boolean hayVentas = false;
        MPeriod period = (MPeriod)this.getC_Period();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        Timestamp fechaHasta = Timestamp.valueOf(df.format(period.getEndDate()));
        this.deleteData();
        hayCompras = this.getDataCompras(period.getStartDate(), fechaHasta);
        hayVentas = this.getDataVentas(period.getStartDate(), fechaHasta);
        return hayCompras | hayVentas;
    }

    private boolean getDataCompras(Timestamp startDate, Timestamp endDate) {
        StringBuilder sql = new StringBuilder();
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        boolean hayInfo = false;
        HashMap<String, String> hashRut = new HashMap<String, String>();
        try {
            String impuestos = "'" + taxBasico + "'";
            impuestos = impuestos + this.getImpuestosManuales();
            sql.append(" select inv.c_invoice_id, inv.documentno, inv.dateinvoiced,  inv.c_doctype_id, inv.c_bpartner_id,  bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, inv.c_currency_id,  c_tax.c_tax_id, doc.docbasetype, invtax.taxamt as monto, inv.c_conversiontype_id  from c_invoice inv  inner join c_invoicetax invtax on inv.c_invoice_id = invtax.c_invoice_id  inner join c_tax on invtax.c_tax_id = c_tax.c_tax_id  inner join c_doctype doc ON inv.c_doctype_id = doc.c_doctype_id  inner join c_bpartner bp on inv.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where inv.dateinvoiced between ? and ?  and inv.docstatus = 'CO'  and inv.issotrx = 'N'  and tg.value = 'RUT'  and inv.ad_org_id = " + this.getAD_Org_ID() + " and doc.docbasetype in ('API','APC')  and c_tax.taxindicator IN (" + impuestos + ")");
            sql.append(" union ");
            sql.append(" select inv.c_invoice_id, inv.documentno, inv.dateinvoiced,  inv.c_doctype_id, inv.c_bpartner_id,  bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, inv.c_currency_id,  c_tax.c_tax_id, doc.docbasetype, invtax.taxamt as monto, inv.c_conversiontype_id  from c_invoice inv  inner join c_invoicetax invtax on inv.c_invoice_id = invtax.c_invoice_id  inner join c_tax on invtax.c_tax_id = c_tax.c_tax_id  inner join c_doctype doc ON inv.c_doctype_id = doc.c_doctype_id  inner join c_bpartner bp on inv.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where inv.dateinvoiced between ? and ?  and inv.docstatus = 'CO'  and inv.issotrx = 'N'  and tg.value = 'RUT'  and inv.ad_org_id = " + this.getAD_Org_ID() + " and doc.docbasetype in ('API','APC')  and c_tax.taxindicator='" + taxMinimo + "'");
            boolean includeExento = MSysConfig.getBooleanValue("UY_DGI_F2181_INCLUDE_EXENTO", true, this.getAD_Client_ID());
            if (includeExento) {
                sql.append(" union ");
                sql.append(" select inv.c_invoice_id, inv.documentno, inv.dateinvoiced,  inv.c_doctype_id, inv.c_bpartner_id,  bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, inv.c_currency_id,  c_tax.c_tax_id, doc.docbasetype, sum(invline.linenetamt) as monto, inv.c_conversiontype_id  from c_invoice inv  inner join c_invoiceline invline on inv.c_invoice_id = invline.c_invoice_id  inner join c_tax on invline.c_tax_id = c_tax.c_tax_id  inner join c_doctype doc ON inv.c_doctype_id = doc.c_doctype_id  inner join c_bpartner bp on inv.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where inv.dateinvoiced between ? and ?  and inv.docstatus = 'CO'  and inv.issotrx = 'N'  and tg.value = 'RUT'  and inv.ad_org_id = " + this.getAD_Org_ID() + " and doc.docbasetype in ('API','APC')  and c_tax.taxindicator='" + taxExento + "' group by inv.c_invoice_id, inv.documentno, inv.dateinvoiced, inv.c_doctype_id, inv.c_bpartner_id,  bp.name, bp.name2, bp.taxid, inv.c_currency_id, c_tax.c_tax_id, doc.docbasetype  having sum(invline.linenetamt) >= 1  order by c_tax_id, fantasia, dateinvoiced, c_doctype_id, c_invoice_id ");
            }
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(1, startDate);
            pstmt.setTimestamp(2, endDate);
            pstmt.setTimestamp(3, startDate);
            pstmt.setTimestamp(4, endDate);
            if (includeExento) {
                pstmt.setTimestamp(5, startDate);
                pstmt.setTimestamp(6, endDate);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                hayInfo = true;
                if (rs.getString("taxid") == null || rs.getString("taxid").equalsIgnoreCase("")) {
                    String partner = String.valueOf(rs.getInt("c_bpartner_id"));
                    if (hashRut.containsKey(partner)) continue;
                    MDGIF2181Issue issue = new MDGIF2181Issue(this.getCtx(), 0, null);
                    issue.setUY_DGI_F2181_ID(this.get_ID());
                    issue.setDescription("Socio de Negocio : " + rs.getString("fantasia") + " NO tiene RUT definido");
                    issue.saveEx();
                    hashRut.put(partner, partner);
                    continue;
                }
                if (!Util.validateRUT(rs.getString("taxid").trim())) {
                    String partner = String.valueOf(rs.getInt("c_bpartner_id"));
                    if (hashRut.containsKey(partner)) continue;
                    MDGIF2181Issue issue = new MDGIF2181Issue(this.getCtx(), 0, null);
                    issue.setUY_DGI_F2181_ID(this.get_ID());
                    issue.setDescription("Socio de Negocio : " + rs.getString("fantasia") + " tiene RUT INVALIDO (" + rs.getString("rut").trim() + ")");
                    issue.saveEx();
                    hashRut.put(partner, partner);
                    continue;
                }
                int currencyID = rs.getInt("c_currency_id");
                int convTypeID = rs.getInt("c_conversiontype_id");
                BigDecimal currencyRate = Env.ONE;
                BigDecimal monto = rs.getBigDecimal("monto");
                if (currencyID != 142) {
                    Timestamp fechaRate = TimeUtil.trunc(rs.getTimestamp("dateinvoiced"), "D");
                    currencyRate = MConversionRate.getRate(currencyID, 142, fechaRate, convTypeID, this.getAD_Client_ID(), 0);
                    if (currencyRate == null) {
                        throw new AdempiereException("No se pudo obtener Tasa de Cambio para Fecha : " + fechaRate);
                    }
                    monto = monto.multiply(currencyRate).setScale(2, RoundingMode.HALF_UP);
                }
                if (rs.getString("docbasetype").equalsIgnoreCase("APC")) {
                    monto = monto.negate();
                }
                MDGIF2181Line line = new MDGIF2181Line(this.getCtx(), 0, null);
                line.setUY_DGI_F2181_ID(this.get_ID());
                line.setC_Invoice_ID(rs.getInt("c_invoice_id"));
                line.setDateInvoiced(rs.getTimestamp("dateinvoiced"));
                line.setC_DocType_ID(rs.getInt("c_doctype_id"));
                line.setC_BPartner_ID(rs.getInt("c_bpartner_id"));
                line.setName(rs.getString("fantasia"));
                line.setName2(rs.getString("razonsocial"));
                line.setC_Currency_ID(currencyID);
                line.setCurrencyRate(currencyRate);
                line.setDUNS(rs.getString("taxid"));
                line.setC_Tax_ID(rs.getInt("c_tax_id"));
                line.setAmount(monto.setScale(0, RoundingMode.HALF_UP));
                line.setDocumentNo(rs.getString("documentno"));
                line.setDocBaseType(rs.getString("docbasetype"));
                MTax impuesto = (MTax)line.getC_Tax();
                String rubro = "";
                if (impuesto.getTaxIndicator().equalsIgnoreCase(taxBasico) || impuestos.contains(impuesto.getTaxIndicator())) {
                    rubro = "505";
                } else if (impuesto.getTaxIndicator().equalsIgnoreCase(taxMinimo)) {
                    rubro = "506";
                } else if (impuesto.getTaxIndicator().equalsIgnoreCase(taxExento)) {
                    rubro = "504";
                }
                line.setRubroDGI(rubro);
                line.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return hayInfo;
    }

    private String getImpuestosManuales() {
        Object retorno = "";
        String sql = "SELECT taxindicator from C_Tax WHERE IsMAnual = 'Y' AND ManualTaxType = 'RESTA'  AND lower(taxindicator) not in ('" + taxBasico + "','" + taxMinimo + "','" + taxExento + "') ";
        try {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                retorno = (String)retorno + ",'" + rs.getString(1) + "'";
            }
            return retorno;
        }
        catch (Exception e) {
            return " ";
        }
    }

    private boolean getDataVentas(Timestamp startDate, Timestamp endDate) {
        StringBuilder sql = new StringBuilder();
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        boolean hayInfo = false;
        HashMap<String, String> hashRut = new HashMap<String, String>();
        try {
            sql.append(" select inv.c_invoice_id, inv.documentno, inv.dateinvoiced, inv.c_doctypetarget_id, inv.c_bpartner_id, bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, inv.c_currency_id,  c_tax.c_tax_id, doc.docbasetype, invtax.taxamt as monto, inv.c_conversiontype_id  from c_invoice inv  inner join c_invoicetax invtax on inv.c_invoice_id = invtax.c_invoice_id  inner join c_tax on invtax.c_tax_id = c_tax.c_tax_id  inner join c_doctype doc ON inv.c_doctypetarget_id = doc.c_doctype_id  inner join c_bpartner bp on inv.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where inv.dateinvoiced between ? and ?  and inv.docstatus = 'CO'  and inv.issotrx = 'Y'  and tg.value = 'RUT'  and inv.ad_org_id = " + this.getAD_Org_ID() + " and doc.docbasetype in ('ARI','ARC')  and c_tax.taxindicator='" + taxBasico + "'");
            sql.append(" union ");
            sql.append(" select inv.c_invoice_id, inv.documentno, inv.dateinvoiced, inv.c_doctypetarget_id, inv.c_bpartner_id,  bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, inv.c_currency_id,  c_tax.c_tax_id, doc.docbasetype, invtax.taxamt as monto, inv.c_conversiontype_id  from c_invoice inv  inner join c_invoicetax invtax on inv.c_invoice_id = invtax.c_invoice_id  inner join c_tax on invtax.c_tax_id = c_tax.c_tax_id  inner join c_doctype doc ON inv.c_doctypetarget_id = doc.c_doctype_id  inner join c_bpartner bp on inv.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where inv.dateinvoiced between ? and ?  and inv.docstatus = 'CO'  and inv.issotrx = 'Y'  and tg.value = 'RUT'  and inv.ad_org_id = " + this.getAD_Org_ID() + " and doc.docbasetype in ('ARI','ARC')  and c_tax.taxindicator='" + taxMinimo + "'");
            sql.append(" union ");
            sql.append(" select pay.c_payment_id as c_invoice_id, pay.documentno, pay.datetrx as dateinvoiced,  pay.c_doctype_id as c_doctypetarget_id, pay.c_bpartner_id,  bp.name as fantasia, bp.name2 as razonsocial, bp.taxid, pay.c_currency_id,  (select c_tax_id from c_tax where ad_client_id=pay.ad_client_id and taxindicator='" + taxBasico + "') as c_tax_id,  doc.docbasetype, pay.discountamt as monto, pay.c_conversiontype_id  from c_payment pay  inner join c_doctype doc ON pay.c_doctype_id = doc.c_doctype_id  inner join c_bpartner bp on pay.c_bpartner_id = bp.c_bpartner_id  inner join c_taxgroup tg on bp.c_taxgroup_id = tg.c_taxgroup_id where pay.datetrx between ? and ?   and pay.docstatus = 'CO'  and pay.isreceipt = 'Y'  and tg.value = 'RUT'  and pay.ad_org_id = " + this.getAD_Org_ID() + " and pay.discountamt >= 10  order by c_tax_id, fantasia, dateinvoiced, c_invoice_id ");
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(1, startDate);
            pstmt.setTimestamp(2, endDate);
            pstmt.setTimestamp(3, startDate);
            pstmt.setTimestamp(4, endDate);
            pstmt.setTimestamp(5, startDate);
            pstmt.setTimestamp(6, endDate);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MDGIF2181Issue issue;
                hayInfo = true;
                if (rs.getString("taxid") == null || rs.getString("taxid").equalsIgnoreCase("")) {
                    String partner = String.valueOf(rs.getInt("c_bpartner_id"));
                    if (hashRut.containsKey(partner)) continue;
                    issue = new MDGIF2181Issue(this.getCtx(), 0, null);
                    issue.setUY_DGI_F2181_ID(this.get_ID());
                    issue.setDescription("Socio de Negocio : " + rs.getString("fantasia") + " NO tiene RUT definido");
                    issue.saveEx();
                    hashRut.put(partner, partner);
                    continue;
                }
                if (!Util.validateRUT(rs.getString("taxid").trim())) {
                    String partner = String.valueOf(rs.getInt("c_bpartner_id"));
                    if (hashRut.containsKey(partner)) continue;
                    issue = new MDGIF2181Issue(this.getCtx(), 0, null);
                    issue.setUY_DGI_F2181_ID(this.get_ID());
                    issue.setDescription("Socio de Negocio : " + rs.getString("fantasia") + " tiene RUT INVALIDO (" + rs.getString("rut").trim() + ")");
                    issue.saveEx();
                    hashRut.put(partner, partner);
                    continue;
                }
                int currencyID = rs.getInt("c_currency_id");
                BigDecimal currencyRate = Env.ONE;
                BigDecimal monto = rs.getBigDecimal("monto");
                if (currencyID != 142) {
                    Timestamp fechaRate = TimeUtil.trunc(rs.getTimestamp("dateinvoiced"), "D");
                    currencyRate = MConversionRate.getRate(currencyID, 142, fechaRate, 0, this.getAD_Client_ID(), 0);
                    if (currencyRate == null) {
                        throw new AdempiereException("No se pudo obtener Tasa de Cambio para Fecha : " + fechaRate);
                    }
                    monto = monto.multiply(currencyRate).setScale(2, RoundingMode.HALF_UP);
                }
                if (rs.getString("docbasetype").equalsIgnoreCase("ARC")) {
                    monto = monto.negate();
                }
                if (rs.getString("docbasetype").equalsIgnoreCase("ARR")) {
                    monto = monto.divide(new BigDecimal(1.22), 2, RoundingMode.HALF_UP);
                    monto = monto.multiply(new BigDecimal(0.22)).setScale(0, RoundingMode.HALF_UP);
                    monto = monto.negate();
                }
                MDGIF2181Line line = new MDGIF2181Line(this.getCtx(), 0, null);
                line.setUY_DGI_F2181_ID(this.get_ID());
                line.setC_Invoice_ID(rs.getInt("c_invoice_id"));
                line.setDateInvoiced(rs.getTimestamp("dateinvoiced"));
                line.setC_DocType_ID(rs.getInt("c_doctypetarget_id"));
                line.setC_BPartner_ID(rs.getInt("c_bpartner_id"));
                line.setName(rs.getString("fantasia"));
                line.setName2(rs.getString("razonsocial"));
                line.setC_Currency_ID(currencyID);
                line.setCurrencyRate(currencyRate);
                line.setDUNS(rs.getString("taxid"));
                line.setC_Tax_ID(rs.getInt("c_tax_id"));
                line.setAmount(monto.setScale(0, RoundingMode.HALF_UP));
                line.setDocumentNo(rs.getString("documentno"));
                line.setDocBaseType(rs.getString("docbasetype"));
                MTax impuesto = (MTax)line.getC_Tax();
                String rubro = "";
                if (impuesto.getTaxIndicator().equalsIgnoreCase(taxBasico)) {
                    rubro = "502";
                } else if (impuesto.getTaxIndicator().equalsIgnoreCase(taxMinimo)) {
                    rubro = "503";
                }
                line.setRubroDGI(rubro);
                line.saveEx();
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return hayInfo;
    }

    private void deleteData() {
        try {
            String action = " delete from uy_dgi_f2181_line  where uy_dgi_f2181_id =" + this.get_ID();
            DB.executeUpdateEx(action, this.get_TrxName());
            action = " delete from uy_dgi_f2181_issue  where uy_dgi_f2181_id =" + this.get_ID();
            DB.executeUpdateEx(action, this.get_TrxName());
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private List<MDGIF2181Line> getLines() {
        String whereClause = "UY_DGI_F2181_ID=" + this.get_ID();
        List<MDGIF2181Line> lines = new Query(this.getCtx(), "UY_DGI_F2181_Line", whereClause, this.get_TrxName()).list();
        return lines;
    }

    public void generateTXT() {
        BufferedWriter bw = null;
        String encoding = "8859_1";
        try {
            List<MDGIF2181Line> lines = this.getLines();
            if (lines.size() <= 0) {
                return;
            }
            MOrgInfo orgInfo = MOrgInfo.get(this.getCtx(), this.getAD_Org_ID(), null);
            String rutClient = orgInfo.getDUNS();
            if (rutClient == null || rutClient.equalsIgnoreCase("")) {
                throw new AdempiereException("Falta definir RUT de la Empresa");
            }
            rutClient = StringUtils.leftPad(rutClient, 12, "0");
            MPeriod period = (MPeriod)this.getC_Period();
            MYear year = (MYear)period.getC_Year();
            String month = StringUtils.leftPad(String.valueOf(period.getPeriodNo()), 2, "0");
            String literalPeriodo = String.valueOf(year.getYearAsInt()) + month;
            File file = this.createFile();
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            for (X_UY_DGI_F2181_Line x_UY_DGI_F2181_Line : lines) {
                Object cadena = "";
                cadena = (String)cadena + rutClient + ";02181;" + literalPeriodo + ";";
                String rutPartner = StringUtils.leftPad(x_UY_DGI_F2181_Line.getDUNS(), 12, "0");
                cadena = (String)cadena + rutPartner + ";";
                MPeriod periodInv = MPeriod.get(this.getCtx(), x_UY_DGI_F2181_Line.getDateInvoiced(), 0);
                MYear yearInv = (MYear)periodInv.getC_Year();
                String monthInv = StringUtils.leftPad(String.valueOf(periodInv.getPeriodNo()), 2, "0");
                String literalPeriodInv = String.valueOf(yearInv.getYearAsInt()) + monthInv;
                cadena = (String)cadena + literalPeriodInv + ";";
                cadena = (String)cadena + x_UY_DGI_F2181_Line.getRubroDGI() + ";";
                BigDecimal monto = x_UY_DGI_F2181_Line.getAmount();
                Object montoStr = "";
                if (monto.compareTo(Env.ZERO) >= 0) {
                    montoStr = String.valueOf(monto);
                    montoStr = StringUtils.leftPad((String)montoStr, 12, "0");
                } else {
                    montoStr = String.valueOf(monto.negate());
                    montoStr = "-" + StringUtils.leftPad((String)montoStr, 11, "0");
                }
                if ((cadena = (String)cadena + (String)montoStr + ";") == null) continue;
                this.saveInFile((String)cadena, bw);
            }
            bw.flush();
            bw.close();
            bw = null;
            MAttachment attachment = new MAttachment(this.getCtx(), Table_ID, this.get_ID(), this.get_TrxName());
            attachment.addEntry(file);
            attachment.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.flush();
                    bw.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private File createFile() {
        File file = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd_HHmmss");
            file = File.createTempFile("DGI_2181_", "_" + df.format(new Timestamp(System.currentTimeMillis())) + ".txt");
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return file;
    }

    private void saveInFile(String cadena, BufferedWriter bf) throws Exception {
        try {
            if (cadena != null && bf != null) {
                String ln = System.getProperty("line.separator");
                bf.append(cadena + ln);
            }
        }
        catch (Exception e) {
            this.log.info(e.getMessage());
            throw new Exception(e);
        }
    }

    static {
        taxExento = "1";
        taxMinimo = "2";
        taxBasico = "3";
    }
}

