/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.callout;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutOpUpProject
extends CalloutEngine {
    public String setPriceListVersion(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            mTab.setValue("M_PriceList_Version_ID", null);
            mTab.setValue("C_Currency_ID", null);
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        int priceListID = (Integer)value;
        MPriceList list = new MPriceList(ctx, priceListID, null);
        if (list != null && list.get_ID() > 0) {
            mTab.setValue("C_Currency_ID", (Object)list.getC_Currency_ID());
            Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
            MPriceListVersion version = list.getPriceListVersion(today);
            if (version != null && version.get_ID() > 0) {
                mTab.setValue("M_PriceList_Version_ID", (Object)version.get_ID());
            } else {
                mTab.setValue("M_PriceList_Version_ID", null);
            }
        }
        return "";
    }

    public String setVendorLocation(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MBPartnerLocation partnerLocation;
        if (value == null) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        int partnerID = (Integer)value;
        MBPartner partner = new MBPartner(ctx, partnerID, null);
        if (partner != null && partner.getC_BPartner_ID() > 0 && (partnerLocation = partner.getPrimaryC_BPartner_Location()) != null && partnerLocation.get_ID() > 0) {
            mTab.setValue("DropShip_Location_ID", (Object)partnerLocation.get_ID());
        }
        return "";
    }

    public String setEndDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        Timestamp date = (Timestamp)value;
        if (date != null) {
            mTab.setValue("EndDate", (Object)date);
        }
        return "";
    }

    public String setPriceAndQtyProjectPhase(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        BigDecimal priceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal plannedAmt = (BigDecimal)mTab.getValue("PlannedAmt");
        BigDecimal qty = (BigDecimal)mTab.getValue("QtyEntered");
        if (priceActual.compareTo(Env.ZERO) > 0) {
            if (mField.getColumnName().equalsIgnoreCase("PriceActual")) {
                if (qty.compareTo(Env.ZERO) > 0) {
                    mTab.setValue("PlannedAmt", (Object)priceActual.divide(qty, 2, RoundingMode.HALF_UP));
                }
            } else if (mField.getColumnName().equalsIgnoreCase("PlannedAmt")) {
                mTab.setValue("QtyEntered", (Object)priceActual.divide(plannedAmt, 2, RoundingMode.HALF_UP));
            } else if (mField.getColumnName().equalsIgnoreCase("QtyEntered")) {
                mTab.setValue("PlannedAmt", (Object)((BigDecimal)mTab.getValue("PriceActual")).divide(qty, 2, RoundingMode.HALF_UP));
            }
        }
        return "";
    }

    public String setUser1FromContract(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        if (this.isCalloutActive()) {
            return "";
        }
        int contractID = (Integer)value;
        MSContract contract = new MSContract(ctx, contractID, null);
        if (contract != null && contract.getUser1_ID() > 0) {
            mTab.setValue("User1_ID", (Object)contract.getUser1_ID());
        }
        return "";
    }

    public String quantity(Properties ctx, int windowNo, GridTab tab, GridField field, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int productId = 0;
        if (!(field.getColumnName().equals("PlannedQty") || field.getColumnName().equals("Qty") || field.getColumnName().equals("QtyEntered") || field.getColumnName().equals("C_UOM_ID") || field.getColumnName().equals("M_Product_ID"))) {
            return "";
        }
        int uOmToId = Env.getContextAsInt(ctx, windowNo, "C_UOM_ID");
        if (tab.getValue("M_Product_ID") != null) {
            productId = (Integer)tab.getValue("M_Product_ID");
            if (productId <= 0) {
                return "";
            }
        } else if (field.getColumnName().equals("QtyEntered")) {
            throw new AdempiereException("Debe seleccionar producto");
        }
        BigDecimal quantityEntered = (BigDecimal)tab.getValue("QtyEntered");
        BigDecimal plannedQuantity = (BigDecimal)tab.getValue("PlannedQty");
        if (plannedQuantity == null) {
            plannedQuantity = (BigDecimal)tab.getValue("Qty");
        }
        if (quantityEntered == null) {
            quantityEntered = Env.ZERO;
        }
        if (plannedQuantity == null) {
            plannedQuantity = Env.ZERO;
        }
        this.log.fine("QtyEntered = " + quantityEntered + ", PlannedQty=" + plannedQuantity + ", UOM=" + uOmToId);
        if (field.getColumnName().equals("QtyEntered") || field.getColumnName().equals("C_UOM_ID") || field.getColumnName().equals("M_Product_ID")) {
            BigDecimal quantityEnteredRounded = quantityEntered.setScale(MUOM.getPrecision(ctx, uOmToId), 4);
            if (quantityEntered.compareTo(quantityEnteredRounded) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + uOmToId + "; QtyEntered=" + quantityEntered + "->" + quantityEnteredRounded);
                quantityEntered = quantityEnteredRounded;
                tab.setValue("QtyEntered", (Object)quantityEntered);
            }
            if ((plannedQuantity = MUOMConversion.convertProductFrom(ctx, productId, uOmToId, quantityEntered)) == null) {
                plannedQuantity = quantityEntered;
            }
            boolean conversion = quantityEntered.compareTo(plannedQuantity) != 0;
            this.log.fine("UOM=" + uOmToId + ", QtyEntered=" + quantityEntered + " -> " + conversion + " PlannedQty=" + plannedQuantity);
            tab.setValue("PlannedQty", (Object)plannedQuantity);
            tab.setValue("Qty", (Object)plannedQuantity);
        } else if (field.getColumnName().equals("PlannedQty") || field.getColumnName().equals("Qty")) {
            int precision = MProduct.get(ctx, productId).getUOMPrecision();
            BigDecimal quantityRounded = plannedQuantity.setScale(precision, 4);
            if (plannedQuantity.compareTo(quantityRounded) != 0) {
                this.log.fine("Corrected PlannedQty Scale " + plannedQuantity + "->" + quantityRounded);
                plannedQuantity = quantityRounded;
                tab.setValue("PlannedQty", (Object)plannedQuantity);
            }
            if ((quantityEntered = MUOMConversion.convertProductTo(ctx, productId, uOmToId, plannedQuantity)) == null) {
                quantityEntered = plannedQuantity;
            }
            boolean conversion = plannedQuantity.compareTo(quantityEntered) != 0;
            this.log.fine("UOM=" + uOmToId + ", PlannedQty=" + plannedQuantity + " -> " + conversion + " QtyEntered=" + quantityEntered);
            tab.setValue("QtyEntered", (Object)quantityEntered);
        }
        if (plannedQuantity == null) {
            plannedQuantity = quantityEntered;
        }
        return "";
    }
}

