/*
 * Decompiled with CFR 0.152.
 */
package org.openup.core.callout;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridField;
import org.compiere.model.MInvoice;
import org.compiere.model.MPriceList;
import org.compiere.util.Env;
import org.eevolution.grid.BrowserCallOutEngine;
import org.eevolution.grid.BrowserRow;

public class CalloutOpUpBrowserCreateFrom
extends BrowserCallOutEngine {
    public String setPriceActualFromQty(Properties ctx, int WindowNo, BrowserRow row, GridField field, Object value, Object oldValue, int currentRow, int currentColumn) {
        BigDecimal priceEntered = (BigDecimal)row.getValue("CF_PriceEntered");
        BigDecimal quantity = (BigDecimal)row.getValue("CF_QtyEntered");
        BigDecimal priceActual = quantity.multiply(priceEntered);
        row.setValue("CF_PriceActual", priceActual);
        return "";
    }

    public String setFromPriceActual(Properties ctx, int WindowNo, BrowserRow row, GridField field, Object value, Object oldValue, int currentRow, int currentColumn) {
        MPriceList list = null;
        BigDecimal priceEntered = (BigDecimal)row.getValue("CF_PriceEntered");
        BigDecimal priceActual = (BigDecimal)row.getValue("CF_PriceActual");
        BigDecimal qty = (BigDecimal)row.getValue("CF_QtyEntered");
        boolean selected = (Boolean)row.getValue("CF_IsSelected");
        boolean isSOTrx = (Boolean)row.getValue("CF_IsSOTrx");
        int invoice_ID = Env.getContextAsInt(ctx, WindowNo, WindowNo, "C_Invoice_ID");
        MInvoice invoice = new MInvoice(ctx, invoice_ID, null);
        if (invoice.getM_PriceList_ID() <= 0) {
            throw new AdempiereException("Error al obtener lista de precios");
        }
        list = new MPriceList(ctx, invoice.getM_PriceList_ID(), null);
        if (!selected || isSOTrx) {
            if (priceEntered.compareTo(Env.ZERO) > 0) {
                qty = priceActual.divide(priceEntered, list.getPricePrecision(), RoundingMode.HALF_UP);
                row.setValue("CF_QtyEntered", qty);
            }
        } else if (selected && !isSOTrx && qty.compareTo(Env.ZERO) > 0) {
            BigDecimal price = priceActual.divide(qty, list.getPricePrecision(), RoundingMode.HALF_UP);
            row.setValue("CF_PriceEntered", price);
        }
        return "";
    }
}

