/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.util;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.openup.LUY.cfe.converter.CfeConverter;
import org.openup.LUY.cfe.dto.generic.cfe.CFEEmpresasType;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.MLUYCertificate;
import org.openup.LUY.model.MLUYSender;

public class CFEDTOManager {
    private PO po;
    private MLUYCertificate mluyCertificate;
    private LUYVendorInterface luyVendorInterface;
    private MDocType mDocType;
    private Properties ctx;
    private String trxName;

    public CFEDTOManager(PO po, MLUYCertificate mluyCertificate, LUYVendorInterface luyVendorInterface) {
        this.po = po;
        this.mluyCertificate = mluyCertificate;
        this.luyVendorInterface = luyVendorInterface;
        this.ctx = po.getCtx();
        this.trxName = po.get_TrxName();
    }

    public void createCFE() {
        MLUYSender mluySender = (MLUYSender)new Query(this.ctx, "LUY_Sender", "AD_Client_ID=? AND AD_Org_ID=?", this.trxName).setParameters(this.po.getAD_Client_ID(), this.po.getAD_Org_ID()).first();
        CFEEmpresasType genericDto = null;
        Properties params = null;
        if (this.po.get_Table_ID() == MInvoice.Table_ID) {
            CfeConverter invoiceConverter = new CfeConverter(mluySender, (MInvoice)this.po);
            invoiceConverter.loadCFE();
            genericDto = invoiceConverter.getObjCfe();
            params = invoiceConverter.getParams();
            this.mDocType = (MDocType)((MInvoice)this.po).getC_DocType();
        }
        if (genericDto != null && this.mDocType != null && this.mluyCertificate != null) {
            try {
                this.luyVendorInterface.sendGenericDto(genericDto, this.po, params);
            }
            catch (Exception e) {
                throw new AdempiereException("CFE Error: " + e.getMessage(), e);
            }
        }
    }
}

