/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.adempiere.core.domains.models.X_C_InvoiceLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.openup.LUY.model.MInvoiceDiscount;
import org.openup.LUY.process.PGenerateInvoiceLineCFEAbstract;
import org.openup.LUY.util.CFEUtils;
import org.openup.core.model.MInvoiceLineCFE;
import org.openup.core.utils.POGroupingProcessor;
import org.openup.core.utils.Utils;

public class PGenerateInvoiceLineCFE
extends PGenerateInvoiceLineCFEAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice mInvoice = new MInvoice(this.getCtx(), this.getInvoiceId(), this.get_TrxName());
        if (!CFEUtils.isCFEtoSend(mInvoice.getCtx(), mInvoice.get_TrxName(), mInvoice)) {
            return "El documento {{documentNo}} no es un CFE".replace("{{documentNo}}", mInvoice.getDocumentNo());
        }
        CFEUtils.CfeType cfeType = CFEUtils.getCFETypeFromDoc(this.getCtx(), (MDocType)mInvoice.getC_DocTypeTarget(), this.get_TrxName(), mInvoice.getAD_Client_ID(), mInvoice.getAD_Org_ID());
        if (cfeType == null) {
            throw new AdempiereException("CFE Error: No se encontr\u00f3 tipo de CFE electronico asociado al Tipo de Documento del Documento");
        }
        if (cfeType.is(CFEUtils.CfeType.eResguardo)) {
            return "Para tipo de CFE resguardo no se generan Lineas de CFE";
        }
        new Query(this.getCtx(), "C_InvoiceLineCFE", "C_Invoice_ID=?", this.get_TrxName()).setParameters(mInvoice.get_ID()).list().forEach(po -> po.deleteEx(false));
        CFEUtils.getDiscounts(mInvoice).forEach(mInvoiceDiscount -> mInvoiceDiscount.deleteEx(false));
        ArrayList mInvoiceLineCFES = new ArrayList();
        ArrayList discounts = new ArrayList();
        if (mInvoice.isProcessed()) {
            throw new AdempiereException("@Error@ @DocProcessed@");
        }
        AtomicBoolean isTaxIncluded = new AtomicBoolean(false);
        MPriceList priceList = (MPriceList)mInvoice.getM_PriceList();
        if (priceList != null && priceList.get_ValueAsBoolean("isTaxIncluded")) {
            isTaxIncluded.set(true);
        }
        String sqlHonoraryProductFilter = "EXISTS (SELECT 1 FROM C_Commission c WHERE c.M_Product_ID=M_Product.M_Product_ID AND IsActive='Y' AND DocBasisType='H')";
        List honoraryProduct = new Query(this.getCtx(), "M_Product", sqlHonoraryProductFilter, this.get_TrxName()).list();
        List<MInvoiceLine> allLines = Arrays.asList(mInvoice.getLines());
        ArrayList honoraryLines = new ArrayList();
        ArrayList commonLines = new ArrayList();
        allLines.forEach(mInvoiceLine -> {
            boolean isH = false;
            if (mInvoiceLine.getM_Product_ID() > 0) {
                int mProductId = mInvoiceLine.getM_Product_ID();
                for (MProduct hp : honoraryProduct) {
                    if (hp.getM_Product_ID() != mProductId) continue;
                    isH = true;
                }
            }
            if (isH) {
                honoraryLines.add(mInvoiceLine);
            } else {
                commonLines.add(mInvoiceLine);
            }
        });
        POGroupingProcessor<MInvoiceLine> gp = new POGroupingProcessor().addPO(commonLines).addCriteria("C_Tax_ID", X_C_InvoiceLine::getC_Tax_ID);
        String cfeBillingCriteria = mInvoice.get_ValueAsString("CFEBillingCriteria");
        if (cfeBillingCriteria == null || cfeBillingCriteria.isEmpty()) {
            throw new AdempiereException("@Error@ @CFEBillingCriteria@ @NotFound@");
        }
        if (cfeBillingCriteria.equalsIgnoreCase("L")) {
            gp.addCriteria("cfeBC", PO::get_ID);
        } else if (cfeBillingCriteria.equalsIgnoreCase("PP")) {
            gp.addCriteria("cfeBC", po -> po.get_ValueAsInt("C_ProjectPhase_ID"));
        } else if (cfeBillingCriteria.equalsIgnoreCase("P")) {
            gp.addCriteria("cfeBC", po -> po.get_ValueAsInt("C_Project_ID"));
        } else if (cfeBillingCriteria.equalsIgnoreCase("C")) {
            gp.addCriteria("cfeBC", po -> po.get_ValueAsInt("C_Contract_ID"));
        } else if (cfeBillingCriteria.equalsIgnoreCase("I")) {
            gp.addCriteria("cfeBC", X_C_InvoiceLine::getC_Invoice_ID);
        } else if (cfeBillingCriteria.equalsIgnoreCase("T")) {
            gp.addCriteria("cfeBC", X_C_InvoiceLine::getC_ProjectTask_ID);
        } else {
            throw new AdempiereException("@Error@ @CFEBillingCriteria@ @NotFound@");
        }
        gp.processGrupedObjects((params, poList) -> {
            MInvoiceLineCFE mInvoiceLineCFE = new MInvoiceLineCFE(this.getCtx(), 0, this.get_TrxName());
            BigDecimal lineTotalAmt = poList.stream().map(mInvoiceLine -> isTaxIncluded.get() ? mInvoiceLine.getLineTotalAmt() : mInvoiceLine.getLineNetAmt()).reduce(Env.ZERO, BigDecimal::add);
            mInvoiceLineCFE.setC_Invoice_ID(mInvoice.get_ID());
            mInvoiceLineCFE.setType(gp.getListValue(poList, po -> po.getM_Product().getValue() == null || po.getM_Product().getValue().isEmpty() ? "EAN" : "INT1"));
            mInvoiceLineCFE.setValue(gp.getListValue(poList, po -> {
                MProduct mProduct = (MProduct)po.getM_Product();
                String mProductValue = mProduct.getValue();
                return mProductValue != null ? mProductValue : mProduct.getUPC();
            }));
            mInvoiceLineCFE.setQty(Env.ONE);
            mInvoiceLineCFE.setPriceEntered(lineTotalAmt);
            mInvoiceLineCFE.setLineTotalAmt(lineTotalAmt);
            MProject mProject = new MProject(this.getCtx(), Optional.ofNullable(gp.getListValue(poList, MInvoiceLine::getC_Project_ID)).orElse(0), this.get_TrxName());
            MProjectPhase mProjectPhase = new MProjectPhase(this.getCtx(), Optional.ofNullable(gp.getListValue(poList, X_C_InvoiceLine::getC_ProjectPhase_ID)).orElse(0), this.get_TrxName());
            MProjectTask mProjectTask = new MProjectTask(this.getCtx(), Optional.ofNullable(gp.getListValue(poList, X_C_InvoiceLine::getC_ProjectTask_ID)).orElse(0), this.get_TrxName());
            mInvoiceLineCFE.setC_Project_ID(mProject.get_ID());
            mInvoiceLineCFE.setC_ProjectPhase_ID(mProjectPhase.get_ID());
            if (cfeBillingCriteria.equalsIgnoreCase("L")) {
                MInvoiceLine mInvoiceLine2 = (MInvoiceLine)poList.get(0);
                MProduct mProduct = mInvoiceLine2.getProduct();
                MCharge mCharge = mInvoiceLine2.getCharge();
                String lineDesc = null;
                if (mProduct != null && mProduct.get_ID() > 0) {
                    lineDesc = Utils.whenNull(mInvoiceLine2.getProduct().getName(), "") + " " + Utils.whenNull(mInvoiceLine2.getProduct().getDescription(), "");
                } else if (mCharge != null && mCharge.get_ID() > 0) {
                    lineDesc = Utils.whenNull(mInvoice.getC_Charge().getName(), "") + " " + Utils.whenNull(mInvoiceLine2.getCharge().getDescription(), "");
                } else {
                    throw new AdempiereException("@M_Product@ - @C_Charge@ @not.found@");
                }
                mInvoiceLineCFE.setDescription(lineDesc.trim());
            } else if (cfeBillingCriteria.equalsIgnoreCase("PP")) {
                mInvoiceLineCFE.setDescription(mProjectPhase.getDescription());
            } else if (cfeBillingCriteria.equalsIgnoreCase("P")) {
                mInvoiceLineCFE.setDescription(mProject.getDescription());
            } else if (cfeBillingCriteria.equalsIgnoreCase("C")) {
                try {
                    mInvoiceLineCFE.setDescription(new MSContract(this.getCtx(), mProject.get_ValueAsInt("S_Contract_ID"), this.get_TrxName()).get_ValueAsString("Name"));
                }
                catch (Exception mInvoiceLine2) {}
            } else if (cfeBillingCriteria.equalsIgnoreCase("I")) {
                mInvoiceLineCFE.setDescription("");
            } else if (cfeBillingCriteria.equalsIgnoreCase("T")) {
                mInvoiceLineCFE.setDescription(mProjectTask.getDescription());
            } else {
                throw new AdempiereException("@Error@ @CFEBillingCriteria@ @NotFound@");
            }
            MTax mTax = new MTax(this.getCtx(), (Integer)params.get("C_Tax_ID"), this.get_TrxName());
            mInvoiceLineCFE.setC_Tax_ID(mTax.get_ID());
            mInvoiceLineCFE.setTaxIndicator(mTax.getTaxIndicator());
            this.checkAndSave(mInvoiceLineCFE, mInvoiceLineCFES, discounts);
        });
        new POGroupingProcessor().addPO(honoraryLines).addCriteria("hProd", X_C_InvoiceLine::getM_Product_ID).addCriteria("C_Tax_ID", X_C_InvoiceLine::getC_Tax_ID).processGrupedObjects((params, poList) -> {
            MProduct mProduct = new MProduct(this.getCtx(), (Integer)params.get("hProd"), this.get_TrxName());
            MInvoiceLineCFE mInvoiceLineCFE = new MInvoiceLineCFE(this.getCtx(), 0, this.get_TrxName());
            mInvoiceLineCFES.add(mInvoiceLineCFE);
            BigDecimal lineTotalAmt = poList.stream().map(mInvoiceLine -> isTaxIncluded.get() ? mInvoiceLine.getLineTotalAmt() : mInvoiceLine.getLineNetAmt()).reduce(Env.ZERO, BigDecimal::add);
            mInvoiceLineCFE.setC_Invoice_ID(mInvoice.get_ID());
            if (mProduct.getValue() != null && !mProduct.getValue().isEmpty()) {
                mInvoiceLineCFE.setType("INT1");
                mInvoiceLineCFE.setValue(mProduct.getValue());
            } else {
                mInvoiceLineCFE.setType("EAN");
                mInvoiceLineCFE.setValue(mProduct.getUPC());
            }
            mInvoiceLineCFE.setQty(Env.ONE);
            mInvoiceLineCFE.setPriceEntered(lineTotalAmt);
            mInvoiceLineCFE.setLineTotalAmt(lineTotalAmt);
            mInvoiceLineCFE.setDescription(mProduct.getName());
            MTax mTax = new MTax(this.getCtx(), (Integer)params.get("C_Tax_ID"), this.get_TrxName());
            mInvoiceLineCFE.setC_Tax_ID(mTax.get_ID());
            mInvoiceLineCFE.setTaxIndicator(mTax.getTaxIndicator());
            this.checkAndSave(mInvoiceLineCFE, mInvoiceLineCFES, discounts);
        });
        return "OK";
    }

    private void checkAndSave(MInvoiceLineCFE mInvoiceLineCFE, List<MInvoiceLineCFE> lines, List<MInvoiceDiscount> discounts) {
        if (mInvoiceLineCFE.getLineTotalAmt() == null || mInvoiceLineCFE.getLineTotalAmt().compareTo(Env.ZERO) >= 0) {
            lines.add(mInvoiceLineCFE);
            mInvoiceLineCFE.setSeqNo(lines.size() * 10);
            mInvoiceLineCFE.saveEx();
        } else {
            MInvoiceDiscount mInvoiceDiscount = new MInvoiceDiscount(this.getCtx(), 0, mInvoiceLineCFE.get_TrxName());
            mInvoiceDiscount.setC_Invoice_ID(mInvoiceLineCFE.getC_Invoice_ID());
            discounts.add(mInvoiceDiscount);
            mInvoiceDiscount.setIsActive(true);
            mInvoiceDiscount.setSeqNo(discounts.size());
            mInvoiceDiscount.setMovementType("D");
            mInvoiceDiscount.setCalculationType("1");
            try {
                mInvoiceDiscount.setValueNumber(new BigDecimal(mInvoiceLineCFE.getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            mInvoiceDiscount.setDescription(mInvoiceLineCFE.getDescription());
            mInvoiceDiscount.setDiscount(mInvoiceLineCFE.getLineTotalAmt().abs());
            mInvoiceDiscount.setTaxIndicator(mInvoiceLineCFE.getTaxIndicator());
            mInvoiceDiscount.saveEx();
        }
    }
}

