/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import io.vavr.Tuple3;
import java.io.File;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.adempiere.core.domains.models.X_I_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.openup.LUY.cfe.dto.invoicy.CFEInvoiCyType;
import org.openup.LUY.cfe.dto.invoicy.EnvioCFE;
import org.openup.LUY.cfe.helper.dto.ConsultaCFERecibidos;
import org.openup.LUY.cfe.helper.dto.ConsultaCFERecibidosRetorno;
import org.openup.LUY.cfe.helper.dto.DescargaCFERecibidos;
import org.openup.LUY.cfe.helper.dto.DescargaCFERecibidosRetorno;
import org.openup.LUY.cfe.helper.dto.EncabezadoEnvioType;
import org.openup.LUY.engine.vendor.LUYInvoicyService;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.LUY.model.MLUYVendor;
import org.openup.LUY.model.MLUYVendorInvoicy;
import org.openup.LUY.process.GetCFEFromInvoiCyAbstract;
import org.openup.LUY.util.CFEUtils;
import org.openup.LUY.util.InvoiCyWebServiceHandler;

public class GetCFEFromInvoiCy
extends GetCFEFromInvoiCyAbstract {
    private HashMap<Tuple3, X_I_Invoice> currentInvoices;
    SimpleDateFormat simpleDateFormat;
    int linesOk;
    int linesErr;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MLUYVendor vendor = MLUYVendor.getByClassName(LUYInvoicyService.class.getCanonicalName());
        this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (vendor == null || vendor.get_ID() <= 0) {
            throw new AdempiereException("@LUY_Vendor_ID@ @NotFound@");
        }
        MLUYVendorInvoicy vendorInvoicy = (MLUYVendorInvoicy)new Query(this.getCtx(), "LUY_VendorInvoicy", "LUY_Vendor_ID=?", this.get_TrxName()).setParameters(vendor.get_ID()).first();
        if (vendorInvoicy == null || vendorInvoicy.get_ID() <= 0) {
            throw new AdempiereException("@LUY_VendorInvoicy_ID@ @NotFound@");
        }
        String endpoint = vendorInvoicy.getEndPoint();
        String endpointConsulta = endpoint + vendorInvoicy.getCol_2();
        String endpointDescarga = endpoint + vendorInvoicy.getCol_3();
        String empCodigo = vendorInvoicy.getValueNumber().setScale(0).toString();
        String empPK = vendorInvoicy.getInvoiCyPK();
        String empCK = vendorInvoicy.getInvoiCyCK();
        this.currentInvoices = new HashMap();
        ConsultaCFERecibidos.Filtros filtrosConsulta = new ConsultaCFERecibidos.Filtros();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (this.getDateTrx() != null) {
            this.addLog("@StartDate@ " + sdf.format(this.getDateTrx()));
            filtrosConsulta.setFechaIni(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.getDateTrx(), false));
        }
        if (this.getDateTrxTo() != null) {
            this.addLog("@EndDate@ " + sdf.format(this.getDateTrxTo()));
            filtrosConsulta.setFechaFin(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.getDateTrxTo(), false));
        }
        EncabezadoEnvioType encabezadoEnvioType = new EncabezadoEnvioType();
        encabezadoEnvioType.setEmpCodigo(empCodigo);
        encabezadoEnvioType.setEmpPK(empPK);
        ConsultaCFERecibidos consultaCFERecibidos = new ConsultaCFERecibidos();
        consultaCFERecibidos.setEncabezado(encabezadoEnvioType);
        consultaCFERecibidos.setFiltros(filtrosConsulta);
        ConsultaCFERecibidosRetorno consultaCFERecibidosRetorno = (ConsultaCFERecibidosRetorno)new InvoiCyWebServiceHandler("ConsultaCFERecibidos_ADPI_" + this.getProcessInfo().getAD_PInstance_ID() + "_", empPK, empCK, endpointConsulta, "Execute", "Gxaction/AWS_CONSULTARECIBIDOS.Execute", "Gx", "Xmlconsulta", consultaCFERecibidos, ConsultaCFERecibidos.class, filtrosConsulta, ConsultaCFERecibidos.Filtros.class, encabezadoEnvioType::setEmpCK, ConsultaCFERecibidosRetorno.class).call();
        Integer msgCod = consultaCFERecibidosRetorno.getEncabezado().getMsgCod();
        String msgDsc = consultaCFERecibidosRetorno.getEncabezado().getMsgDsc();
        if (msgDsc != null && !msgDsc.trim().isEmpty()) {
            this.addLog("@Message@");
            this.addLog(msgCod + "\t" + msgDsc);
        }
        List<ConsultaCFERecibidosRetorno.RespuestaConsultaCFERecibidos.CFE> respuestaConsultaCFERecibidos = consultaCFERecibidosRetorno.getRespuestaConsultaCFERecibidos().getCFE();
        this.addLog("@qty.received@ " + respuestaConsultaCFERecibidos.size());
        this.addLog("________________________________________");
        this.linesOk = 0;
        this.linesErr = 0;
        for (ConsultaCFERecibidosRetorno.RespuestaConsultaCFERecibidos.CFE respuestaConsultaCFERecibido : respuestaConsultaCFERecibidos) {
            DescargaCFERecibidos.Filtros filtrosDescarga = new DescargaCFERecibidos.Filtros();
            DescargaCFERecibidos.Filtros.CFE cfeDescarga = new DescargaCFERecibidos.Filtros.CFE();
            DescargaCFERecibidos.Filtros.CFE.CFEItem cfeItemDescarga = new DescargaCFERecibidos.Filtros.CFE.CFEItem();
            cfeDescarga.getCFEItem().add(cfeItemDescarga);
            filtrosDescarga.setCFE(cfeDescarga);
            cfeItemDescarga.setEmiRUT(respuestaConsultaCFERecibido.getEmiRUT());
            cfeItemDescarga.setCFETipo(respuestaConsultaCFERecibido.getCFETipo());
            cfeItemDescarga.setCFESerie(respuestaConsultaCFERecibido.getCFESerie());
            cfeItemDescarga.setCFENumero(respuestaConsultaCFERecibido.getCFENumero());
            String prefixFileName = "DescargaRecibidos_" + respuestaConsultaCFERecibido.getEmiRUT() + "_" + respuestaConsultaCFERecibido.getCFETipo() + "_" + respuestaConsultaCFERecibido.getCFESerie() + "_" + respuestaConsultaCFERecibido.getCFENumero() + "_ADPI_" + this.getProcessInfo().getAD_PInstance_ID() + "_";
            EncabezadoEnvioType encabezadoEnvioTypeDescarga = new EncabezadoEnvioType();
            encabezadoEnvioTypeDescarga.setEmpPK(empPK);
            encabezadoEnvioTypeDescarga.setEmpCodigo(empCodigo);
            DescargaCFERecibidos descargaCFERecibidos = new DescargaCFERecibidos();
            descargaCFERecibidos.setEncabezado(encabezadoEnvioTypeDescarga);
            descargaCFERecibidos.setFiltros(filtrosDescarga);
            DescargaCFERecibidosRetorno descargaCFERecibidosRetorno = (DescargaCFERecibidosRetorno)new InvoiCyWebServiceHandler(prefixFileName, empPK, empCK, endpointDescarga, "Execute", "Gxaction/AWS_DESCARGARECIBIDOS.Execute", "Gx", "Xmldescarga", descargaCFERecibidos, DescargaCFERecibidos.class, filtrosDescarga, DescargaCFERecibidos.Filtros.class, encabezadoEnvioTypeDescarga::setEmpCK, DescargaCFERecibidosRetorno.class).call();
            Object base64Xml = null;
            List<DescargaCFERecibidosRetorno.RespuestaDescargaCFERecibidos.CFE> respuestaDescargaCFERecibidos = descargaCFERecibidosRetorno.getRespuestaDescargaCFERecibidos().getCFE();
            for (DescargaCFERecibidosRetorno.RespuestaDescargaCFERecibidos.CFE respuestaDescargaCFERecibido : respuestaDescargaCFERecibidos) {
                String base64XmlDecoded = new String(Base64.getDecoder().decode(respuestaDescargaCFERecibido.getCFEXML().getBytes()));
                File responseFile = CFEUtils.getTempFileForCFE("_" + prefixFileName + "_BASE64DECODED_", ".xml");
                PrintWriter responseFilePW = new PrintWriter(responseFile);
                responseFilePW.print(base64XmlDecoded.replaceAll("^<EnvioCFE>", "<EnvioCFE xmlns=\"http://www.invoicy.com.uy/\">"));
                responseFilePW.close();
                JAXBContext jaxbContextResponseEnvioCFE = JAXBContext.newInstance(EnvioCFE.class);
                Unmarshaller jaxbUnmarshallerEnvioCFE = jaxbContextResponseEnvioCFE.createUnmarshaller();
                EnvioCFE responseEnvioCFE = (EnvioCFE)jaxbUnmarshallerEnvioCFE.unmarshal(responseFile);
                this.mapEnvioCFEToIInvoices(responseEnvioCFE);
            }
        }
        String msgRet = "@C_Invoice_ID@ " + this.currentInvoices.size() + " - @NoOfLines@ @Ok@ " + this.linesOk + " - Err " + this.linesErr;
        return msgRet;
    }

    private void mapEnvioCFEToIInvoices(EnvioCFE envioCFE) {
        List<CFEInvoiCyType> items = envioCFE.getCFE().getCFEItem();
        for (CFEInvoiCyType item : items) {
            for (CFEInvoiCyType.Detalle.Item line : item.getDetalle().getItem()) {
                try {
                    Trx.run(trxName -> {
                        CFEInvoiCyType.Emisor emisor = item.getEmisor();
                        CFEInvoiCyType.Receptor receptor = item.getReceptor();
                        String rutReceptor = receptor.getRcpDocRecep();
                        CFEInvoiCyType.IdDoc idDoc = item.getIdDoc();
                        String cfeDocumentNo = idDoc.getCFESerie() + idDoc.getCFENro();
                        CFEInvoiCyType.Totales totales = item.getTotales();
                        BigInteger cfeType = item.getIdDoc().getCFETipoCFE();
                        MDocType documentType = this.mapTypeToDoc(cfeType, Env.getAD_Org_ID(this.getCtx()), trxName);
                        String queryBP = "TaxID=?";
                        MBPartner businessPartner = (MBPartner)new Query(this.getCtx(), "C_BPartner", queryBP, trxName).setParameters(emisor.getEmiRut()).first();
                        String cfeMsg = emisor.getEmiRut() + " " + emisor.getEmiRznSoc() + " - " + idDoc.getCFETipoCFE() + " - " + idDoc.getCFESerie() + idDoc.getCFENro();
                        if (documentType == null || documentType.get_ID() <= 0) {
                            throw new AdempiereException("X - " + cfeMsg + " | @C_DocType_ID@ @NotFound@");
                        }
                        X_I_Invoice iinv = this.checkI_Invoice(cfeMsg, emisor.getEmiRut(), documentType.get_ID(), cfeDocumentNo, trxName);
                        MOrgInfo organizationInformation = (MOrgInfo)new Query(this.getCtx(), "AD_OrgInfo", "DUNS=?", trxName).setParameters(rutReceptor).first();
                        if (organizationInformation != null) {
                            iinv.setAD_Org_ID(organizationInformation.getAD_Org_ID());
                        }
                        iinv.setDocTypeName(String.valueOf(idDoc.getCFETipoCFE()));
                        iinv.setDocumentNo(cfeDocumentNo);
                        iinv.setC_DocType_ID(documentType.get_ID());
                        iinv.setIsSOTrx(false);
                        iinv.set_ValueOfColumn("POReference", (Object)idDoc.getCFEIdCompra());
                        if (businessPartner != null) {
                            iinv.setBPartnerValue(businessPartner.getValue());
                        }
                        iinv.set_ValueOfColumn("TaxID", (Object)emisor.getEmiRut());
                        iinv.setName(emisor.getEmiRznSoc());
                        iinv.setAddress1(emisor.getEmiDomFiscal());
                        iinv.setCity(emisor.getEmiCiudad());
                        iinv.setRegionName(emisor.getEmiDepartamento());
                        iinv.setPhone(emisor.getEmiTelefono());
                        iinv.setDescription(idDoc.getCFEAdenda());
                        iinv.setCountryCode(true);
                        MCountry country = MCountry.get(this.getCtx(), receptor.getRcpCodPaisRecep());
                        if (country != null) {
                            iinv.setC_Country_ID(country.get_ID());
                        }
                        try {
                            Timestamp documentDate = this.formatDate(idDoc.getCFEFchEmis().toString());
                            iinv.setDateInvoiced(documentDate);
                            iinv.setDateAcct(documentDate);
                        }
                        catch (Exception documentDate) {
                            // empty catch block
                        }
                        iinv.setPaymentTermValue(String.valueOf(idDoc.getCFEFmaPago()));
                        MCurrency currency = MCurrency.get(this.getCtx(), totales.getTotTpoMoneda().value());
                        if (currency != null) {
                            iinv.setC_Currency_ID(currency.get_ID());
                        }
                        try {
                            boolean isTaxIncluded = BigInteger.valueOf(1L).compareTo(idDoc.getCFEMntBruto()) == 0;
                            MPriceList priceList = MPriceList.get(this.getCtx(), false, currency.getISO_Code(), isTaxIncluded);
                            if (priceList != null && priceList.get_ID() > 0) {
                                iinv.setPriceListName(priceList.getName());
                                iinv.setM_PriceList_ID(priceList.get_ID());
                            }
                        }
                        catch (Exception isTaxIncluded) {
                            // empty catch block
                        }
                        String productCodes = null;
                        try {
                            productCodes = line.getCodItem().getCodItemItem().stream().map(CFEInvoiCyType.Detalle.Item.CodItem.CodItemItem::getIteCodiCod).collect(Collectors.joining(","));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        iinv.setProductValue(productCodes);
                        iinv.setLineDescription(line.getIteNomItem());
                        iinv.setQtyOrdered(line.getIteCantidad());
                        iinv.setPriceActual(line.getItePrecioUnitario());
                        iinv.setTaxIndicator(String.valueOf(line.getIteIndFact()));
                        iinv.saveEx();
                        this.addLog("OK | " + cfeMsg);
                        ++this.linesOk;
                    });
                }
                catch (AdempiereException e) {
                    this.addLog(e.getMessage());
                    ++this.linesErr;
                }
            }
        }
    }

    private X_I_Invoice checkI_Invoice(String cfeMsg, String bpValue, int documentTypeId, String documentNo, String trxName) {
        Tuple3 key = new Tuple3((Object)bpValue, (Object)documentTypeId, (Object)documentNo);
        X_I_Invoice ret = this.currentInvoices.get(key);
        if (ret == null) {
            String query = "TaxID=? AND C_DocType_ID=? AND DocumentNo=?";
            ret = (X_I_Invoice)new Query(this.getCtx(), "I_Invoice", query, trxName).setParameters(bpValue, documentTypeId, documentNo).first();
            if (ret != null) {
                throw new AdempiereException("X - " + cfeMsg + " | @AlreadyExists@");
            }
        }
        ret = new X_I_Invoice(this.getCtx(), 0, trxName);
        this.currentInvoices.put(key, ret);
        return ret;
    }

    private MDocType mapTypeToDoc(BigInteger cfeType, int orgId, String trxName) {
        Optional<MLUYCFEType> mluycfeType = MLUYCFEType.getDefault(this.getCtx(), trxName, orgId, false, cfeType.toString());
        if (mluycfeType.isPresent()) {
            return (MDocType)mluycfeType.get().getC_DocType();
        }
        return null;
    }

    private Timestamp formatDate(String strDate) throws ParseException {
        return new Timestamp(this.simpleDateFormat.parse(strDate).getTime());
    }

    public static void main(String[] args) throws Exception {
        new GetCFEFromInvoiCy().doIt();
    }
}

