/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.process;

import java.sql.Timestamp;
import java.util.List;
import org.compiere.model.MPayment;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.process.LUYCFE;

public class GenerateInvoiceCFDI
extends SvrProcess {
    protected Timestamp payDate;
    protected int payrollProcessId;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if ("HR_Process_ID".equals(para.getParameterName())) {
                this.payrollProcessId = para.getParameterAsInt();
                continue;
            }
            if (!"PayDate".equals(para.getParameter_ToAsBoolean())) continue;
            this.payDate = (Timestamp)para.getParameter();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (MPayment payment : this.getPayments(this.payrollProcessId)) {
            String employeeName = payment.getC_BPartner().getName();
            try {
                LUYCFE cdfdi = LUYCFE.get();
                cdfdi.setDocument(payment);
                MLUYDocument document = cdfdi.generate();
                String uuid = document.getCFDIUUID();
                this.addLog("@HR_Employee_ID@ : " + employeeName + " @LUY_Document_ID@ : " + uuid + " @CFDISealingDate@ " + document.getCFDISealingDate());
            }
            catch (Exception e) {
                this.addLog("@HR_Employee_ID@ : " + employeeName + " @Error@ :" + e.getMessage());
            }
        }
        return "@OK@";
    }

    private List<MPayment> getPayments(int payrollProcessId) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM HR_PaySelection ps INNER JOIN HR_PaySelectionCheck psc ON (ps.HR_PaySelection_ID=psc.HR_PaySelection_ID))").append("WHERE ps.HR_Process_ID = ? AND C_Payment.C_Paymnet_ID = psc.C_Paymnet_ID)");
        return new Query(this.getCtx(), "C_Payment", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(payrollProcessId).list();
    }
}

