/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.engine.vendor;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringEscapeUtils;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentNote;
import org.compiere.model.MInvoice;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.openup.LUY.cfe.dto.generic.cfe.CFEEmpresasType;
import org.openup.LUY.engine.LUYVendorInterface;
import org.openup.LUY.model.MLUYDocument;
import org.openup.LUY.model.MLUYVendor;
import org.openup.LUY.model.MLUYVendorService;
import org.openup.LUY.util.SHA1;
import org.openup.LUY.util.WebServiceConnector;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LUYEcodexService
implements LUYVendorInterface {
    MLUYVendor vendor = MLUYVendor.getByClassName(this.getClass().getCanonicalName());
    MLUYDocument documentCFDI;
    PO document;
    private static String cfdiAddenda = "<cfdi:Addenda/>";

    public LUYEcodexService() {
        if (this.vendor == null) {
            throw new AdempiereException("Implementaci\u00f3n para este proveedor de servicios no existe: " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public Source execute(MLUYDocument documentCFDI, String SOAPType) throws Exception {
        MLUYVendorService service = this.vendor.getService(SOAPType);
        WebServiceConnector wsc = new WebServiceConnector();
        String request = Env.parseVariable(service.getSOAPRequest(), documentCFDI, documentCFDI.get_TrxName(), false);
        System.out.println("Llamada del servicio :" + request);
        wsc.setRequest(request);
        wsc.setBinding(service.getSOAPBinding());
        wsc.setEndpointAddress(service.getSOAPEndpointAddress());
        wsc.setServiceName(service.getSOAPServiceName());
        wsc.setPortName(service.getSOAPPort());
        wsc.setTargetNS(service.getSOAPTargetNS());
        wsc.setSoapAction(service.getSOAPAction());
        wsc.executeConnector();
        Source response = wsc.getResponse();
        return response;
    }

    @Override
    public void sendGenericDto(CFEEmpresasType genericDto, PO document, Properties params) {
    }

    @Override
    public MLUYDocument getLUYDocument() {
        return null;
    }

    private String getResponseXML(Source response) throws TransformerFactoryConfigurationError, TransformerException, IOException, SOAPException {
        assert (response != null);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF8");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(response, result);
        return StringEscapeUtils.unescapeXml(writer.toString());
    }

    @Override
    public void setDocument(PO document) {
        this.document = document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getQR(MLUYDocument documentCFDI) {
        try {
            Source response = this.execute(documentCFDI, "QR");
            String responseXML = this.getResponseXML(response);
            String qrString = responseXML.substring(responseXML.indexOf("<Imagen>") + 8, responseXML.indexOf("</Imagen>"));
            if (qrString != null && qrString.length() <= 0) return;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AdempiereException(e.getMessage());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    @Override
    public void getToken(MLUYDocument documentCFDI) {
        try {
            Source response = this.execute(documentCFDI, "TK");
            String responseXML = this.getResponseXML(response);
            Optional<String> optionalTokenTag = Optional.of(this.getElement(responseXML, "Token"));
            if (optionalTokenTag.isPresent()) {
                String toHash = String.format("%s|%s", this.vendor.getPassword(), optionalTokenTag.get());
                byte[] as = toHash.getBytes("UTF-8");
                String toHash2 = new String(as, "UTF-8");
                SHA1 sha1 = new SHA1();
                String token = sha1.getHash(toHash2);
                documentCFDI.setCFDIToken(token);
                documentCFDI.saveEx();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AdempiereException(ex.getMessage());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    @Override
    public void getCFDI(MLUYDocument documentCFDI) {
        this.getToken(documentCFDI);
        String CFDI = "";
        try {
            Source response = this.execute(documentCFDI, "GS");
            String responseXML = this.getResponseXML(response);
            if (responseXML.contains("![CDATA[")) {
                CFDI = responseXML.substring(responseXML.indexOf("![CDATA[") + 8, responseXML.indexOf("]]>"));
            }
            CFDI = responseXML.contains("<DatosXML>") ? responseXML.substring(responseXML.indexOf("<DatosXML>") + 10, responseXML.indexOf("</DatosXML>")) : responseXML;
            this.fillCFDIInfo(documentCFDI, CFDI);
            documentCFDI.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e.toString());
        }
    }

    private void fillCFDIInfo(MLUYDocument documentCFDI, String CFDI) {
        try {
            String date = CFDI.substring(CFDI.indexOf("fecha=") + 7, CFDI.indexOf("fecha=") + 26);
            date = date.replace("T", " ");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd H:mm:ss");
            Date newDate = formatter.parse(date);
            Timestamp dateDocument = new Timestamp(newDate.getTime());
            if (this.document != null && this.document instanceof MInvoice) {
                this.document.set_ValueOfColumn("DateInvoiced", (Object)dateDocument);
                this.document.set_ValueOfColumn("DateAcct", (Object)dateDocument);
                this.document.saveEx();
            }
            documentCFDI.setCFDISealingDate(date);
            documentCFDI.setCFDIXML(CFDI);
            documentCFDI.setCFDISeal(this.getSeal(CFDI));
            documentCFDI.setCFDISATSeal(this.getSealSAT(CFDI));
            documentCFDI.setCFDIUUID(this.getUUID(CFDI));
            documentCFDI.setCFDISATCertificate(this.getNoCertificateSAT(CFDI));
            documentCFDI.saveEx();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }

    private String getSeal(String CFDI) {
        String tmpString = CFDI.substring(CFDI.indexOf("sello=") + 7);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private String getSealSAT(String CFDI) {
        String tmpSeal = CFDI.substring(CFDI.indexOf("selloSAT=") + 10);
        return tmpSeal.substring(0, tmpSeal.indexOf("\""));
    }

    private String getNoCertificateSAT(String CFDI) {
        String tmpString = CFDI.substring(CFDI.indexOf("noCertificadoSAT=") + 18);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private String getDate(String CFDI) {
        String fecha = CFDI.substring(CFDI.indexOf("fecha=") + 7);
        fecha = fecha.substring(0, fecha.indexOf("\""));
        fecha = fecha.replace("T", " ");
        return fecha;
    }

    private static String pasteAddenda(String xml) {
        xml = xml.replace("<cfdi:Addenda/>", cfdiAddenda);
        return xml;
    }

    private String getUUID(String CFDI) {
        String tmpString = CFDI.substring(CFDI.indexOf("UUID=") + 6);
        return tmpString.substring(0, tmpString.indexOf("\""));
    }

    private static String cutAddenda(String xml) {
        if (xml.contains("<cfdi:Addenda>")) {
            cfdiAddenda = xml.substring(xml.indexOf("<cfdi:Addenda>"), xml.indexOf("</cfdi:Addenda>") + 15);
            xml = xml.replace(cfdiAddenda, "<cfdi:Addenda/>");
        }
        return xml;
    }

    @Override
    public void getCancelCFDI(MLUYDocument documentCFDI) {
        try {
            this.getToken(documentCFDI);
            Source response = this.execute(documentCFDI, "CD");
            String responseXML = this.getResponseXML(response);
            MAttachment attachment = new MAttachment(documentCFDI.getCtx(), documentCFDI.get_Table_ID(), documentCFDI.getLUY_Document_ID(), documentCFDI.get_TrxName());
            attachment.setTitle("Acuse de Recibo CFDI");
            String fileName = "Acuse de Recibo CFDI" + documentCFDI.getCFDIUUID();
            String CFDName = "CFD" + fileName + ".xml";
            attachment.addEntry(CFDName, responseXML.getBytes("UTF-8"));
            attachment.addTextMsg(responseXML);
            attachment.saveEx();
            MAttachmentNote attachmentNote = new MAttachmentNote(documentCFDI.getCtx(), 0, documentCFDI.get_TrxName());
            attachmentNote.setAD_Attachment_ID(attachment.get_ID());
            attachmentNote.setAD_User_ID(100);
            attachmentNote.setTextMsg(responseXML);
            attachmentNote.setTitle(this.document.get_ValueAsString("DocumentNo"));
            attachmentNote.saveEx();
            documentCFDI.setIsCancelled(true);
            documentCFDI.saveEx();
            return;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AdempiereException(ex.getMessage());
        }
        catch (Exception e) {
            throw new AdempiereException(e.getMessage());
        }
    }

    private String getElement(String xml, String key) {
        Document document = this.getDocument(xml);
        return document.getElementsByTagName(key).item(0).getTextContent();
    }

    private Document getDocument(String xml) {
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = docfactory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

