/*
 * Decompiled with CFR 0.152.
 */
package org.openup.LUY.cfe.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_InvoiceLine;
import org.adempiere.core.domains.models.X_C_TaxGroup;
import org.adempiere.exceptions.AdempiereException;
import org.apache.commons.lang.StringUtils;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCharge;
import org.compiere.model.MCity;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRegion;
import org.compiere.model.MSequence;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.LUY.cfe.dto.generic.cfe.CAEDataType;
import org.openup.LUY.cfe.dto.generic.cfe.CFEDefType;
import org.openup.LUY.cfe.dto.generic.cfe.CFEEmpresasType;
import org.openup.LUY.cfe.dto.generic.cfe.DscRcgGlobal;
import org.openup.LUY.cfe.dto.generic.cfe.Emisor;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocFact;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocResg;
import org.openup.LUY.cfe.dto.generic.cfe.IdDocTck;
import org.openup.LUY.cfe.dto.generic.cfe.ItemDetFact;
import org.openup.LUY.cfe.dto.generic.cfe.ItemResg;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorFact;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorResg;
import org.openup.LUY.cfe.dto.generic.cfe.ReceptorTck;
import org.openup.LUY.cfe.dto.generic.cfe.Referencia;
import org.openup.LUY.cfe.dto.generic.cfe.RetPercResg;
import org.openup.LUY.cfe.dto.generic.cfe.TipMonType;
import org.openup.LUY.cfe.dto.generic.cfe.Totales;
import org.openup.LUY.cfe.dto.generic.cfe.TotalesResg;
import org.openup.LUY.model.MInvoiceDiscount;
import org.openup.LUY.model.MLUYSender;
import org.openup.LUY.util.CFEGenericData;
import org.openup.LUY.util.CFEUtils;
import org.openup.core.model.MAllocInvoice;
import org.openup.core.model.MInvoiceLineCFE;
import org.openup.core.utils.Utils;
import org.spin.model.MWHDefinition;

public class CfeConverter {
    public static final String PRINTER_NAME = "PRINTER_NAME";
    private MLUYSender mluySender;
    private MBPartner bpSender;
    private MOrg mOrg;
    private MOrgInfo mOrgInfo;
    private String trxName;
    private Properties ctx;
    private MInvoice mInvoice;
    private CFEEmpresasType objCfe;
    private Properties params;
    private String cfeStrFirmado;
    private BigDecimal montoC124;

    public MInvoice getmInvoice() {
        return this.mInvoice;
    }

    public CFEEmpresasType getObjCfe() {
        return this.objCfe;
    }

    public Properties getParams() {
        return this.params;
    }

    public CfeConverter(MLUYSender mluySender, MInvoice mInvoice) {
        this.ctx = mInvoice.getCtx();
        this.mInvoice = mInvoice;
        this.trxName = mInvoice.get_TrxName();
        if (this.ctx == null) {
            throw new AdempiereException("CFE Error: ctx null");
        }
        if (mInvoice == null) {
            throw new AdempiereException("CFE Error: mInvoice null");
        }
        if (this.trxName == null) {
            throw new AdempiereException("CFE Error: trxName null");
        }
        this.mluySender = mluySender;
        if (mluySender == null || mluySender.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: No se encontro parametrizacion del Emisor (Sender)");
        }
        this.bpSender = (MBPartner)mluySender.getC_BPartner();
        if (this.bpSender == null || this.bpSender.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: No se encontro parametrizacion del Socio de Negocio Emisor (SenderBP)");
        }
        this.mOrg = MOrg.get(this.ctx, mInvoice.getAD_Org_ID());
        this.mOrgInfo = this.mOrg.getInfo();
        if (this.mOrgInfo == null || this.mOrgInfo.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: No se encontr\u00f3 Informaci\u00f3n de la Organizaci\u00f3n para el documento a enviar");
        }
    }

    private ArrayList<MInvoiceLine> getInvoiceLines(String whereClause) {
        Object whereClauseFinal = "C_Invoice_ID=?";
        if (whereClause != null) {
            whereClauseFinal = (String)whereClauseFinal + whereClause;
        }
        List list = new Query(this.ctx, "C_InvoiceLine", (String)whereClauseFinal, this.trxName).setParameters(this.mInvoice.getC_Invoice_ID()).setOrderBy("Line").list();
        return new ArrayList<MInvoiceLine>(list);
    }

    public void loadCFE() {
        this.objCfe = new CFEEmpresasType();
        this.params = new Properties();
        CFEDefType objCfe = new CFEDefType();
        this.objCfe.setCFE(objCfe);
        if (this.mInvoice.getAD_Client_ID() != Env.getAD_Client_ID(this.ctx) || this.mInvoice.getAD_Org_ID() != Env.getAD_Org_ID(this.ctx)) {
            throw new AdempiereException("CFE Error: Los documentos emitidos deben tener la compa\u00f1ia y organizaci\u00f3n con la que se inici\u00f3 sesi\u00f3n en el sistema");
        }
        CFEUtils.CfeType cfeType = CFEUtils.getCFETypeFromDoc(this.ctx, (MDocType)this.mInvoice.getC_DocType(), this.trxName, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
        if (cfeType == null) {
            throw new AdempiereException("CFE Error: No se encontr\u00f3 tipo de CFE electronico asociado al Tipo de Documento del Documento");
        }
        if (cfeType.is(CFEUtils.CfeType.eResguardo)) {
            this.loadEncabezado_eResguardo(cfeType, objCfe);
            this.loadDetalleProductosOServicios_eResguardo(cfeType, objCfe);
        } else {
            this.loadEncabezado_eTicket_eFactura(cfeType, objCfe);
            if (this.mluySender.get_ValueAsString("CFELineFormat").equalsIgnoreCase("S")) {
                this.loadC_InvoiceLineCFE(cfeType, objCfe);
            } else {
                this.loadDetalleProductosOServicios_eTicket_eFactura(cfeType, objCfe);
            }
        }
        this.loadInformacionDeDescuentosORecargos_eTicket_eFactura(cfeType, objCfe);
        this.loadInfoReferencia(cfeType, objCfe);
        this.loadTimestamp(cfeType, objCfe);
        this.loadAdenda();
    }

    private void loadEncabezado_eTicket_eFactura(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        MCurrency mCurrency;
        MLocation bpmLocation;
        Totales totales;
        ReceptorFact receptorFact;
        ReceptorTck receptorTck;
        block71: {
            String sqlDueDate;
            Timestamp dueDate;
            if (!this.mInvoice.isSOTrx()) {
                throw new AdempiereException("CFE Error: e-Factura y e-Ticket debe ser IsSOTrx=Y");
            }
            String sql = "";
            Object rs = null;
            Object pstmt = null;
            CFEDefType.ETck eTicket = new CFEDefType.ETck();
            CFEDefType.EFact eFactura = new CFEDefType.EFact();
            CFEDefType.ETck.Encabezado eTicketEncabezado = new CFEDefType.ETck.Encabezado();
            CFEDefType.EFact.Encabezado eFactEncabezado = new CFEDefType.EFact.Encabezado();
            IdDocTck idDocTck = new IdDocTck();
            IdDocFact idDocFact = new IdDocFact();
            Emisor emisor = new Emisor();
            receptorTck = new ReceptorTck();
            receptorFact = new ReceptorFact();
            totales = new Totales();
            if (cfeType == CFEUtils.CfeType.eTicket || cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA) {
                objCfe.setETck(eTicket);
                eTicket.setEncabezado(eTicketEncabezado);
                eTicketEncabezado.setIdDoc(idDocTck);
                eTicketEncabezado.setEmisor(emisor);
                eTicketEncabezado.setReceptor(receptorTck);
                eTicketEncabezado.setTotales(totales);
            } else if (cfeType == CFEUtils.CfeType.eFactura || cfeType == CFEUtils.CfeType.eFactura_ND || cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_VxCA || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA || cfeType == CFEUtils.CfeType.eFactura_NC_VxCA) {
                objCfe.setEFact(eFactura);
                eFactura.setEncabezado(eFactEncabezado);
                eFactEncabezado.setIdDoc(idDocFact);
                eFactEncabezado.setEmisor(emisor);
                eFactEncabezado.setReceptor(receptorFact);
                eFactEncabezado.setTotales(totales);
            }
            objCfe.setVersion("1.0");
            MDocType doc = MDocType.get(this.ctx, this.mInvoice.getC_DocType_ID());
            BigInteger doctype = BigInteger.valueOf(Long.valueOf((String)CFEUtils.getCfeTypes().inverse().get((Object)cfeType)));
            idDocTck.setTipoCFE(doctype);
            idDocFact.setTipoCFE(doctype);
            MSequence sec = new MSequence(this.ctx, doc.getDefiniteSequence_ID(), this.trxName);
            if (sec.getPrefix() == null) {
                throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (3) - Falta Prefijo de la secuencia");
            }
            idDocTck.setSerie(sec.getPrefix());
            idDocFact.setSerie(sec.getPrefix());
            if (this.mInvoice.getDocumentNo() == null) {
                throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (4) - Numero de comprobante no asignado al documento");
            }
            String documentNo = this.mInvoice.getDocumentNo();
            documentNo = documentNo.replaceAll("[^0-9]", "");
            String docno = StringUtils.leftPad(String.valueOf(documentNo), 7, "0");
            BigInteger numero = new BigInteger(docno);
            idDocTck.setNro(numero);
            idDocFact.setNro(numero);
            if (this.mInvoice.getDateInvoiced() == null) {
                throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (5) - Fecha del comprobante no establecida");
            }
            idDocTck.setFchEmis(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.mInvoice.getDateInvoiced(), false));
            idDocFact.setFchEmis(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.mInvoice.getDateInvoiced(), false));
            MPriceList priceList = (MPriceList)this.mInvoice.getM_PriceList();
            if (priceList != null && priceList.get_ValueAsBoolean("isTaxIncluded")) {
                idDocTck.setMntBruto(new BigInteger("1"));
                idDocFact.setMntBruto(new BigInteger("1"));
            } else {
                idDocTck.setMntBruto(new BigInteger("0"));
                idDocFact.setMntBruto(new BigInteger("0"));
            }
            if (this.mInvoice.getPaymentRule().equalsIgnoreCase("P") || this.mInvoice.getPaymentRule().equalsIgnoreCase("D")) {
                idDocTck.setFmaPago(BigInteger.valueOf(2L));
                idDocFact.setFmaPago(BigInteger.valueOf(2L));
            } else {
                idDocTck.setFmaPago(BigInteger.valueOf(1L));
                idDocFact.setFmaPago(BigInteger.valueOf(1L));
            }
            if (this.mInvoice.getDateInvoiced() != null && this.mInvoice.getC_PaymentTerm_ID() > 0 && (dueDate = DB.getSQLValueTSEx(this.trxName, sqlDueDate = "select paymenttermduedate(" + this.mInvoice.getC_PaymentTerm_ID() + ", '" + this.mInvoice.getDateInvoiced() + "')", new Object[0])) != null) {
                idDocTck.setFchVenc(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(dueDate, false));
                idDocFact.setFchVenc(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(dueDate, false));
            }
            if (this.bpSender.getTaxID() == null) {
                throw new AdempiereException("CFE Error: Area Emisor (40) - RUT no establecido");
            }
            emisor.setRUCEmisor(this.bpSender.getTaxID());
            if (this.bpSender.getName() == null) {
                throw new AdempiereException("CFE Error: Area Emisor (41) - Razon Social no establecida");
            }
            emisor.setRznSoc(this.bpSender.getName());
            if (this.mOrgInfo.getPhone() != null) {
                emisor.getTelefono().add(this.mOrgInfo.getPhone());
            }
            emisor.setCorreoEmisor(this.mOrgInfo.getEMail());
            MLocation mLocationBp = (MLocation)this.mOrgInfo.getC_Location();
            emisor.setEmiSucursal(this.mOrg.getName());
            try {
                emisor.setCdgDGISucur(BigInteger.valueOf(this.bpSender.get_ValueAsInt("ReferenceNo")));
            }
            catch (Exception ex) {
                throw new AdempiereException("CFE Error: Area Emisor (47) - Identificador de DGI para local no establecido");
            }
            emisor.setDomFiscal(mLocationBp.getAddress1());
            MCity mCity = (MCity)mLocationBp.getC_City();
            if (mCity == null || mCity.getName() == null) {
                throw new AdempiereException("CFE Error: Area Emisor (49) - Ciudad para domicilio fiscal no establecida");
            }
            emisor.setCiudad(mCity.getName());
            MRegion mDepartamentos = (MRegion)mLocationBp.getC_Region();
            if (mDepartamentos == null || mDepartamentos.getName() == null) {
                throw new AdempiereException("CFE Error: Area Emisor (50) - Departamento para domicilio fiscal no establecido");
            }
            emisor.setDepartamento(mDepartamentos.getName());
            MBPartner partner = MBPartner.get(this.ctx, this.mInvoice.getC_BPartner_ID());
            MBPartnerLocation mbpLocation = new MBPartnerLocation(this.ctx, this.mInvoice.getC_BPartner_Location_ID(), this.trxName);
            bpmLocation = new MLocation(this.ctx, mbpLocation.getC_Location_ID(), this.trxName);
            X_C_TaxGroup xTaxGroup = (X_C_TaxGroup)new Query(this.ctx, "C_TaxGroup", "C_TaxGroup_ID=?", this.trxName).setParameters(partner.getC_TaxGroup_ID()).first();
            String bpDocType = null;
            if (xTaxGroup == null || xTaxGroup.get_ID() < 0) {
                throw new AdempiereException("CFE Error: El receptor no posee tipo de documento");
            }
            bpDocType = xTaxGroup.getValue();
            if ((cfeType.equals((Object)CFEUtils.CfeType.eFactura) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && (partner.getTaxID() == null || partner.getTaxID().equalsIgnoreCase("") || !bpDocType.equalsIgnoreCase("rut"))) {
                throw new AdempiereException("CFE Error: El receptor no tiene un RUT establecido y esta intentando emitir una E-Factura o sus notas de correcci\ufffdn");
            }
            int tipoDocRecep = 0;
            String docRecep = null;
            int tableIdDocTypeCod = MTable.getTable_ID("UY_CFE_IdentTributaria");
            if (tableIdDocTypeCod > 0) {
                try {
                    String sqlIdT = "SELECT CFEIdentTributaria FROM UY_CFE_IdentTributaria WHERE DocumentType = '" + bpDocType + "'";
                    BigDecimal cfeDocType = DB.getSQLValueBDEx(this.trxName, sqlIdT, new Object[0]);
                    tipoDocRecep = cfeDocType.intValue();
                }
                catch (Exception e) {
                    tipoDocRecep = 0;
                }
                if (tipoDocRecep != 2 && tipoDocRecep != 3 && tipoDocRecep != 4 && tipoDocRecep != 5 && tipoDocRecep != 6) {
                    tipoDocRecep = 0;
                }
            }
            if (tipoDocRecep == 0) {
                tipoDocRecep = bpDocType.equalsIgnoreCase("rut") ? 2 : (bpDocType.equalsIgnoreCase("CI") ? 3 : 4);
            }
            if (((docRecep = partner.getTaxID()) == null || docRecep.equalsIgnoreCase("")) && tipoDocRecep == 3) {
                try {
                    docRecep = partner.get_Value("cedula").toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tipoDocRecep != 3 && tipoDocRecep != 4 && (docRecep == null || docRecep.equalsIgnoreCase(""))) {
                throw new AdempiereException("CFE Error: El receptor de la factura n\ufffd: {{documentNo}} no tiene documento de identidad".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
            }
            mCurrency = (MCurrency)this.mInvoice.getC_Currency();
            if (mCurrency.getISO_Code() == null) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado (110) - Tipo de moneda de la transaccion no establecida");
            }
            boolean eTicketAmtExceededToIdentifyReceiver = false;
            if (tipoDocRecep == 3) {
                MCurrency mCurrUI = MCurrency.get(this.ctx, "UI");
                if (mCurrUI == null || mCurrUI.get_ID() == 0) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado - Moneda Unidad Indexada no definida");
                }
                Timestamp tstmpUI = Utils.getTimestampPrev3112(new Timestamp(System.currentTimeMillis()));
                if (tstmpUI == null) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado - No se puede obtener la fecha para la tasa de cambio de UI");
                }
                BigDecimal currRateUI = MConversionRate.getRate(mCurrUI.get_ID(), 142, tstmpUI, 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
                if (currRateUI == null || currRateUI.equals(Env.ZERO)) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado - Tasa de cambio no establecida para UI para la fecha {{fecha}}, requerido para definir monto l\ufffdmite para eTicket".replace("{{fecha}}", tstmpUI.toString()));
                }
                BigDecimal eTicketLimitAmtWithoutReceiver = new BigDecimal(MSysConfig.getDoubleValue("UY_CFE_TICKET_LIMIT_AMT_WITOUT_RECEIVER", 10000.0, this.mInvoice.getAD_Client_ID()));
                BigDecimal limitAmt142 = currRateUI.multiply(eTicketLimitAmtWithoutReceiver);
                BigDecimal currRateCurInv = MConversionRate.getRate(this.mInvoice.getC_Currency_ID(), 142, this.mInvoice.getDateInvoiced(), 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
                if (currRateCurInv == null || currRateCurInv.equals(Env.ZERO)) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado (111) - Tasa de cambio no establecida para la factura de la fecha {{fecha}} para la moneda {{moneda}}".replace("{{fecha}}", String.valueOf(this.mInvoice.getDateInvoiced())).replace("{{moneda}}", String.valueOf(this.mInvoice.getC_Currency_ID())));
                }
                if (this.mInvoice.getGrandTotal().multiply(currRateCurInv).compareTo(limitAmt142) > 0) {
                    if (docRecep == null || docRecep.equalsIgnoreCase("")) {
                        throw new AdempiereException("CFE Error: Area Totales Encabezado - Monto total supera limite en UI para eTicket sin especificar documento de receptor");
                    }
                    eTicketAmtExceededToIdentifyReceiver = true;
                }
            }
            String countryCode = null;
            try {
                countryCode = bpmLocation.getC_Country().getCountryCode();
            }
            catch (Exception tstmpUI) {
                // empty catch block
            }
            if (docRecep != null && !docRecep.isEmpty() && countryCode != null && !countryCode.isEmpty()) {
                receptorTck.setTipoDocRecep(tipoDocRecep);
                receptorFact.setTipoDocRecep(tipoDocRecep);
                receptorTck.setCodPaisRecep(countryCode);
                receptorFact.setCodPaisRecep(countryCode);
                if (tipoDocRecep == 2 || tipoDocRecep == 3) {
                    receptorTck.setDocRecep(docRecep);
                    receptorFact.setDocRecep(docRecep);
                } else if (tipoDocRecep == 4 || tipoDocRecep == 5 || tipoDocRecep == 6) {
                    receptorTck.setDocRecepExt(docRecep);
                    receptorFact.setDocRecep(docRecep);
                }
            } else {
                if (cfeType.is(CFEUtils.CfeType.eFactura, CFEUtils.CfeType.eFactura_NC, CFEUtils.CfeType.eFactura_ND, CFEUtils.CfeType.eFactura_VxCA, CFEUtils.CfeType.eFactura_NC_VxCA, CFEUtils.CfeType.eFactura_ND_VxCA)) {
                    throw new AdempiereException("CFE Error: El receptor de la factura {{documentNo}} requiere tener Tipo y N\u00famero de Documento, y Pa\u00eds definido en su Localizaci\u00f3n".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
                }
                if (cfeType.is(CFEUtils.CfeType.eTicket, CFEUtils.CfeType.eTicket_NC, CFEUtils.CfeType.eTicket_ND) && eTicketAmtExceededToIdentifyReceiver) {
                    throw new AdempiereException("CFE Error: El receptor del e-Ticket {{documentNo}} (que supera l\u00edmite de monto) requiere tener Tipo y N\u00famero de Documento, y Pa\u00eds definido en su Localizaci\u00f3n".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
                }
            }
            boolean hasBPValue = MSysConfig.getBooleanValue("UY_CFE_Send_BPartner_Value", false, Env.getAD_Client_ID(this.ctx), Env.getAD_Org_ID(this.ctx));
            String bpName = (String)(hasBPValue ? partner.getValue() + " - " : "") + partner.getName();
            receptorTck.setRznSocRecep(bpName);
            receptorFact.setRznSocRecep(bpName);
            String dirRecep = null;
            if (bpmLocation.getAddress1() != null) {
                dirRecep = bpmLocation.getAddress1().length() <= 70 ? bpmLocation.getAddress1() : bpmLocation.getAddress1().substring(0, 70);
            } else if (cfeType.equals((Object)CFEUtils.CfeType.eFactura) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) {
                throw new AdempiereException("CFE Error: Area Receptor (65) - Direccion de domicilio del receptor requerida");
            }
            receptorTck.setDirRecep(dirRecep);
            receptorFact.setDirRecep(dirRecep);
            try {
                if ((cfeType.equals((Object)CFEUtils.CfeType.eFactura) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC_VxCA) || cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) && (bpmLocation.getC_City() == null || bpmLocation.getC_City().getName() == null)) {
                    throw new AdempiereException("CFE Error: Area Receptor (65) - Ciudad de domicilio del receptor requerida");
                }
                receptorTck.setCiudadRecep(bpmLocation.getC_City().getName());
                receptorFact.setCiudadRecep(bpmLocation.getC_City().getName());
            }
            catch (Exception e) {
                if (!cfeType.equals((Object)CFEUtils.CfeType.eFactura) && !cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC) && !cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND) && !cfeType.equals((Object)CFEUtils.CfeType.eFactura_VxCA) && !cfeType.equals((Object)CFEUtils.CfeType.eFactura_NC_VxCA) && !cfeType.equals((Object)CFEUtils.CfeType.eFactura_ND_VxCA)) break block71;
                throw new AdempiereException("CFE Error: Area Receptor (65) - Ciudad de domicilio del receptor requerida");
            }
        }
        receptorTck.setDeptoRecep(bpmLocation.getC_Region().getName());
        receptorFact.setDeptoRecep(bpmLocation.getC_Region().getName());
        receptorTck.setPaisRecep(bpmLocation.getC_Country().getName());
        receptorFact.setPaisRecep(bpmLocation.getC_Country().getName());
        try {
            receptorTck.setCP(Integer.valueOf(bpmLocation.getPostal()));
            receptorFact.setCP(Integer.valueOf(bpmLocation.getPostal()));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            totales.setTpoMoneda(TipMonType.valueOf(mCurrency.getISO_Code()));
            if (mCurrency.getC_Currency_ID() != 142) {
                BigDecimal currRate = MConversionRate.getRate(mCurrency.getC_Currency_ID(), 142, this.mInvoice.getDateInvoiced(), 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
                if (currRate == null || currRate.equals(Env.ZERO)) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado (111) - Tasa de cambio no establecida para la factura de la fecha {{fecha}} para la moneda {{moneda}}".replace("{{fecha}}", this.mInvoice.getDateInvoiced().toString()).replace("{{moneda}}", mCurrency.getISO_Code()));
                }
                totales.setTpoCambio(currRate.setScale(3, 4));
            }
        }
        catch (AdempiereException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (110) - Tipo de moneda no aceptada por DGI");
        }
        totales.setMntNoGrv(Env.ZERO);
        totales.setMntExpoyAsim(Env.ZERO);
        totales.setMntImpuestoPerc(Env.ZERO);
        totales.setMntNetoIvaTasaMin(Env.ZERO);
        totales.setMntNetoIVATasaBasica(Env.ZERO);
        totales.setMntNetoIVAOtra(Env.ZERO);
        totales.setMntIVATasaMin(Env.ZERO);
        totales.setMntIVATasaBasica(Env.ZERO);
        totales.setMntIVAOtra(Env.ZERO);
        totales.setMontoNF(Env.ZERO);
        this.montoC124 = Env.ZERO;
        ArrayList<MInvoiceLine> invoiceLines = this.getInvoiceLines("");
        for (MInvoiceLine mInvL : invoiceLines) {
            MTax tax = MTax.get(this.ctx, mInvL.getC_Tax_ID());
            if (tax == null) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado - Impuesto para linea no establecido");
            }
            if (tax.getTaxIndicator() == null || tax.getTaxIndicator().equalsIgnoreCase("")) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado - Indicador de facturaci\u00f3n para el impuesto de la linea no establecido");
            }
            this.addTaxToTag(totales, tax, mInvL.getLineNetAmt(), mInvL.getTaxAmt());
        }
        MTax mTaxMinimo = (MTax)new Query(this.ctx, "C_Tax", "TaxIndicator=? AND AD_Client_ID=? AND IsActive=?", this.trxName).setParameters("2", this.mInvoice.getAD_Client_ID(), "Y").first();
        if (mTaxMinimo == null || mTaxMinimo.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: Impuesto (Nombre: {{impuestoNombre}}) no definido".replace("{{impuestoNombre}}", "minimo"));
        }
        MTax mTaxBasico = (MTax)new Query(this.ctx, "C_Tax", "TaxIndicator=? AND AD_Client_ID=? AND IsActive=?", this.trxName).setParameters("3", this.mInvoice.getAD_Client_ID(), "Y").first();
        if (mTaxBasico == null || mTaxBasico.get_ID() <= 0) {
            throw new AdempiereException("CFE Error: Impuesto (Nombre: {{impuestoNombre}}) no definido".replace("{{impuestoNombre}}", "basico"));
        }
        totales.setIVATasaMin(mTaxMinimo.getRate().setScale(3));
        totales.setIVATasaBasica(mTaxBasico.getRate().setScale(3));
        totales.setMntTotal(this.montoC124);
        totales.setMntPagar(this.mInvoice.getGrandTotal());
        if (cfeType == CFEUtils.CfeType.eTicket || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA) {
            if (invoiceLines.size() > 700) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado (126) - Para un eTicket y sus correspondientes NC y ND, no se pueden exceder la cantidad de 700 lineas");
            }
        } else if (invoiceLines.size() > 200) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (126) - Para los CFE que no son eTickets ni sus correspondientes NC y ND, no se pueden exeder la cantidad de 200 lineas");
        }
        totales.setCantLinDet(invoiceLines.size());
        try {
            this.params.put(PRINTER_NAME, this.mInvoice.getC_Order().getC_POS().getPrinterName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addTaxToTag(Totales totales, MTax tax, BigDecimal netoMontoLinea, BigDecimal ivaMontoLinea) {
        this.addTaxToTag(totales, tax.getTaxIndicator(), netoMontoLinea, ivaMontoLinea);
    }

    private void addTaxToTag(Totales totales, String taxIndicatorStr, BigDecimal netoMontoLinea, BigDecimal ivaMontoLinea) {
        BigDecimal taxIndicator = BigDecimal.valueOf(Double.valueOf(taxIndicatorStr.replace("%", "")));
        if (taxIndicator.compareTo(Env.ONE) == 0) {
            totales.setMntNoGrv(totales.getMntNoGrv().add(netoMontoLinea));
            this.montoC124 = this.montoC124.add(netoMontoLinea);
        } else if (taxIndicator.compareTo(BigDecimal.valueOf(2L)) == 0) {
            totales.setMntNetoIvaTasaMin(totales.getMntNetoIvaTasaMin().add(netoMontoLinea));
            totales.setMntIVATasaMin(totales.getMntIVATasaMin().add(ivaMontoLinea));
            this.montoC124 = this.montoC124.add(netoMontoLinea).add(ivaMontoLinea);
        } else if (taxIndicator.compareTo(BigDecimal.valueOf(3L)) == 0) {
            totales.setMntNetoIVATasaBasica(totales.getMntNetoIVATasaBasica().add(netoMontoLinea));
            totales.setMntIVATasaBasica(totales.getMntIVATasaBasica().add(ivaMontoLinea));
            this.montoC124 = this.montoC124.add(netoMontoLinea).add(ivaMontoLinea);
        } else if (taxIndicator.compareTo(BigDecimal.valueOf(10L)) == 0) {
            totales.setMntExpoyAsim(totales.getMntExpoyAsim().add(netoMontoLinea));
            this.montoC124 = this.montoC124.add(netoMontoLinea);
        } else if (taxIndicator.compareTo(BigDecimal.valueOf(6L)) == 0) {
            totales.setMontoNF(totales.getMontoNF().add(netoMontoLinea));
        } else {
            totales.setMntNetoIVAOtra(totales.getMntNetoIVAOtra().add(netoMontoLinea));
            totales.setMntIVAOtra(totales.getMntIVAOtra().add(ivaMontoLinea));
            this.montoC124 = this.montoC124.add(netoMontoLinea).add(ivaMontoLinea);
        }
    }

    private void loadC_InvoiceLineCFE(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        AtomicReference<List<ItemDetFact>> lineas = new AtomicReference<List<ItemDetFact>>();
        if (cfeType == CFEUtils.CfeType.eTicket || cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA) {
            objCfe.getETck().setDetalle(new CFEDefType.ETck.Detalle());
            lineas.set(objCfe.getETck().getDetalle().getItem());
        } else if (cfeType == CFEUtils.CfeType.eFactura || cfeType == CFEUtils.CfeType.eFactura_ND || cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_VxCA || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA || cfeType == CFEUtils.CfeType.eFactura_NC_VxCA) {
            objCfe.getEFact().setDetalle(new CFEDefType.EFact.Detalle());
            lineas.set(objCfe.getEFact().getDetalle().getItem());
        }
        AtomicInteger position = new AtomicInteger(1);
        new Query(this.ctx, "C_InvoiceLineCFE", "C_Invoice_ID=?", this.trxName).setParameters(this.mInvoice.get_ID()).list().forEach(po -> {
            MInvoiceLineCFE mInvoiceLineCFE = (MInvoiceLineCFE)po;
            ItemDetFact detalleItem = new ItemDetFact();
            ((List)lineas.get()).add(detalleItem);
            detalleItem.setNroLinDet(position.getAndIncrement());
            ItemDetFact.CodItem codItem = new ItemDetFact.CodItem();
            codItem.setTpoCod("INT1");
            codItem.setCod(mInvoiceLineCFE.getType());
            detalleItem.getCodItem().add(codItem);
            int taxIndicator = -1;
            try {
                taxIndicator = Integer.valueOf(mInvoiceLineCFE.getTaxIndicator());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (taxIndicator == -1) {
                throw new AdempiereException("CFE Error: Area Detalle de Productos o Servicios - Tasa en linea de invoice n\u00b0 {{documentNo}} no valida".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
            }
            detalleItem.setIndFact(BigInteger.valueOf(taxIndicator));
            detalleItem.setIndAgenteResp(null);
            detalleItem.setNomItem(mInvoiceLineCFE.getName());
            detalleItem.setDscItem(mInvoiceLineCFE.getDescription());
            detalleItem.setCantidad(mInvoiceLineCFE.getQty());
            detalleItem.setUniMed(mInvoiceLineCFE.getC_UOM().getUOMSymbol());
            detalleItem.setPrecioUnitario(mInvoiceLineCFE.getPriceEntered());
            detalleItem.setRecargoPct(Env.ZERO);
            detalleItem.setRecargoMnt(Env.ZERO);
            detalleItem.setMontoItem(mInvoiceLineCFE.getLineTotalAmt().abs());
        });
        if (((List)lineas.get()).size() == 0) {
            throw new AdempiereException("CFE Error: Ara detalles de Productos o Servicios - Hay lineas del documento que no tienen producto o cargo");
        }
    }

    private void loadDetalleProductosOServicios_eTicket_eFactura(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        ArrayList<MInvoiceLine> mInvoiceLines = this.getInvoiceLines("");
        List<ItemDetFact> lineas = null;
        String sql = "SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.mInvoice.get_ID() + " AND M_Product_ID IS NULL AND C_Charge_ID IS NULL";
        int lineID = DB.getSQLValueEx(this.mInvoice.get_TrxName(), sql, new Object[0]);
        if (lineID > 0) {
            throw new AdempiereException("CFE Error: Ara detalles de Productos o Servicios - Hay lineas del documento que no tienen producto o cargo");
        }
        boolean isTaxIncluded = false;
        MPriceList priceList = (MPriceList)this.mInvoice.getM_PriceList();
        if (priceList != null && priceList.get_ValueAsBoolean("isTaxIncluded")) {
            isTaxIncluded = true;
        }
        if (cfeType == CFEUtils.CfeType.eTicket || cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA) {
            objCfe.getETck().setDetalle(new CFEDefType.ETck.Detalle());
            lineas = objCfe.getETck().getDetalle().getItem();
        } else if (cfeType == CFEUtils.CfeType.eFactura || cfeType == CFEUtils.CfeType.eFactura_ND || cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_VxCA || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA || cfeType == CFEUtils.CfeType.eFactura_NC_VxCA) {
            objCfe.getEFact().setDetalle(new CFEDefType.EFact.Detalle());
            lineas = objCfe.getEFact().getDetalle().getItem();
        }
        int position = 1;
        for (MInvoiceLine mInvoiceLine : mInvoiceLines) {
            BigDecimal precioUnitario;
            MLUYSender mluySender;
            Object amt = null;
            ItemDetFact detalleItem = new ItemDetFact();
            lineas.add(detalleItem);
            detalleItem.setNroLinDet(position++);
            ItemDetFact.CodItem codItem = null;
            if (mInvoiceLine.getM_Product_ID() > 0) {
                MProduct mProduct = new MProduct(this.ctx, mInvoiceLine.getM_Product_ID(), this.trxName);
                if (mProduct.getValue() != null) {
                    codItem = new ItemDetFact.CodItem();
                    codItem.setTpoCod("INT1");
                    codItem.setCod(mProduct.getValue());
                    detalleItem.getCodItem().add(codItem);
                }
                if (mProduct.getUPC() != null) {
                    codItem = new ItemDetFact.CodItem();
                    codItem.setTpoCod("EAN");
                    codItem.setCod(mProduct.getUPC());
                    detalleItem.getCodItem().add(codItem);
                }
            } else if (mInvoiceLine.getC_Charge_ID() > 0) {
                MCharge charge = new MCharge(this.ctx, mInvoiceLine.getC_Charge_ID(), this.trxName);
                codItem = new ItemDetFact.CodItem();
                codItem.setTpoCod("INT1");
                codItem.setCod(Integer.toString(charge.get_ID()));
                detalleItem.getCodItem().add(codItem);
            }
            MTax tax = new MTax(this.ctx, mInvoiceLine.getC_Tax_ID(), this.trxName);
            int taxIndicator = -1;
            try {
                taxIndicator = Integer.valueOf(tax.getTaxIndicator());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (taxIndicator == -1) {
                throw new AdempiereException("CFE Error: Area Detalle de Productos o Servicios - Tasa en linea de invoice n\u00b0 {{documentNo}} no valida".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
            }
            detalleItem.setIndFact(BigInteger.valueOf(taxIndicator));
            detalleItem.setIndAgenteResp(null);
            if (mInvoiceLine.getM_Product_ID() > 0) {
                detalleItem.setNomItem(mInvoiceLine.getProduct().getName());
            } else if (mInvoiceLine.getC_Charge_ID() > 0) {
                detalleItem.setNomItem(mInvoiceLine.getC_Charge().getName());
            }
            detalleItem.setDscItem(mInvoiceLine.getDescription());
            detalleItem.setCantidad(mInvoiceLine.getQtyInvoiced());
            if (mInvoiceLine.getM_Product_ID() > 0) {
                detalleItem.setUniMed(mInvoiceLine.getProduct().getUOMSymbol());
            }
            if ((mluySender = MLUYSender.getSender(this.ctx, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID(), this.trxName)).get_ValueAsBoolean("UsePriceList")) {
                if (mInvoiceLine.getPriceEntered().compareTo(Env.ZERO) != 0 && mInvoiceLine.getPriceList().compareTo(Env.ZERO) == 0) {
                    throw new AdempiereException("CFE Error: M\u00f3dulo Descuentos Recargos habilidatos con Lista de Precios, no se permite Precio de Lista 0 con Precio distinto de 0");
                }
                precioUnitario = mInvoiceLine.getPriceList().setScale(6, RoundingMode.HALF_UP).abs();
                BigDecimal discountPercentage = Env.ZERO;
                BigDecimal discountAmount = Env.ZERO;
                try {
                    discountPercentage = (BigDecimal)mInvoiceLine.get_Value("Discount");
                    discountAmount = precioUnitario.multiply(discountPercentage).divide(Env.ONEHUNDRED);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (discountPercentage != null && discountPercentage.compareTo(Env.ZERO) > 0) {
                    detalleItem.setDescuentoPct(discountPercentage);
                    detalleItem.setDescuentoMonto(discountAmount);
                }
            } else {
                precioUnitario = mInvoiceLine.getPriceEntered().setScale(6, RoundingMode.HALF_UP).abs();
            }
            detalleItem.setPrecioUnitario(precioUnitario);
            detalleItem.setRecargoPct(Env.ZERO);
            detalleItem.setRecargoMnt(Env.ZERO);
            if (isTaxIncluded) {
                detalleItem.setMontoItem(mInvoiceLine.getLineTotalAmt().abs());
                continue;
            }
            detalleItem.setMontoItem(mInvoiceLine.getLineNetAmt().abs());
        }
    }

    private void loadInformacionDeDescuentosORecargos_eTicket_eFactura(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        DscRcgGlobal descRec = new DscRcgGlobal();
        if (cfeType == CFEUtils.CfeType.eTicket || cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA) {
            objCfe.getETck().setDscRcgGlobal(descRec);
        } else if (cfeType == CFEUtils.CfeType.eFactura || cfeType == CFEUtils.CfeType.eFactura_ND || cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_VxCA || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA || cfeType == CFEUtils.CfeType.eFactura_NC_VxCA) {
            objCfe.getEFact().setDscRcgGlobal(descRec);
        }
        BigDecimal descuentoGlobal = Env.ZERO;
        MBPartner mbPartner = (MBPartner)this.mInvoice.getC_BPartner();
        List<MInvoiceDiscount> discounts = CFEUtils.getDiscounts(this.mInvoice);
        for (MInvoiceDiscount discount : discounts) {
            DscRcgGlobal.DRGItem drgItem = new DscRcgGlobal.DRGItem();
            drgItem.setNroLinDR(discount.getSeqNo());
            drgItem.setTpoMovDR(discount.getMovementType());
            drgItem.setTpoDR(new BigInteger(discount.getCalculationType()));
            drgItem.setGlosaDR(discount.getDescription());
            drgItem.setValorDR(discount.getDiscount());
            drgItem.setIndFactDR(new BigInteger(discount.getTaxIndicator()));
            descRec.getDRGItem().add(drgItem);
        }
        if (mbPartner != null && mbPartner.get_ValueAsString("FlatDiscount") != null && mbPartner.get_ValueAsString("FlatDiscount") != "") {
            descuentoGlobal = mbPartner.getFlatDiscount();
        }
        if (!descuentoGlobal.equals(Env.ZERO)) {
            DscRcgGlobal.DRGItem drgItem;
            boolean hasIvaBasico = false;
            boolean hasIvaMinimo = false;
            boolean hasIvaExento = false;
            ArrayList<MInvoiceLine> mInvoiceLines = this.getInvoiceLines("");
            for (MInvoiceLine mInvL : mInvoiceLines) {
                MTax tax = new MTax(this.ctx, mInvL.getC_Tax_ID(), this.trxName);
                if (tax.getTaxIndicator() != null && tax.getTaxIndicator().equalsIgnoreCase("2")) {
                    hasIvaMinimo = true;
                    continue;
                }
                if (tax.getTaxIndicator() != null && tax.getTaxIndicator().equalsIgnoreCase("3")) {
                    hasIvaBasico = true;
                    continue;
                }
                if (tax.getTaxIndicator() == null || !tax.getTaxIndicator().equalsIgnoreCase("1")) continue;
                hasIvaExento = true;
            }
            int nroLinea = discounts.size() + 1;
            if (hasIvaBasico) {
                drgItem = new DscRcgGlobal.DRGItem();
                drgItem.setNroLinDR(nroLinea++);
                drgItem.setTpoMovDR("D");
                drgItem.setTpoDR(BigInteger.valueOf(2L));
                drgItem.setCodDR(new BigInteger("1"));
                drgItem.setGlosaDR("2");
                drgItem.setValorDR(descuentoGlobal);
                drgItem.setIndFactDR(BigInteger.valueOf(3L));
                descRec.getDRGItem().add(drgItem);
            }
            if (hasIvaMinimo) {
                drgItem = new DscRcgGlobal.DRGItem();
                drgItem.setNroLinDR(nroLinea++);
                drgItem.setTpoMovDR("D");
                drgItem.setTpoDR(BigInteger.valueOf(2L));
                drgItem.setCodDR(new BigInteger("1"));
                drgItem.setGlosaDR("2");
                drgItem.setValorDR(descuentoGlobal);
                drgItem.setIndFactDR(BigInteger.valueOf(2L));
                descRec.getDRGItem().add(drgItem);
            }
            if (hasIvaExento) {
                drgItem = new DscRcgGlobal.DRGItem();
                drgItem.setNroLinDR(nroLinea++);
                drgItem.setTpoMovDR("D");
                drgItem.setTpoDR(BigInteger.valueOf(2L));
                drgItem.setCodDR(new BigInteger("1"));
                drgItem.setGlosaDR("2");
                drgItem.setValorDR(descuentoGlobal);
                drgItem.setIndFactDR(BigInteger.valueOf(1L));
                descRec.getDRGItem().add(drgItem);
            }
        }
    }

    private void loadInfoReferencia(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        if (cfeType.is(CFEUtils.CfeType.eTicket_NC, CFEUtils.CfeType.eTicket_ND, CFEUtils.CfeType.eFactura_NC, CFEUtils.CfeType.eFactura_ND, CFEUtils.CfeType.eTicket_NC_VxCA, CFEUtils.CfeType.eTicket_ND_VxCA, CFEUtils.CfeType.eFactura_NC_VxCA, CFEUtils.CfeType.eFactura_ND_VxCA)) {
            System.out.println("cfeType = " + cfeType);
            Referencia referencias = new Referencia();
            if (cfeType.is(CFEUtils.CfeType.eTicket_ND, CFEUtils.CfeType.eTicket_NC, CFEUtils.CfeType.eTicket_ND_VxCA, CFEUtils.CfeType.eTicket_NC_VxCA)) {
                objCfe.getETck().setReferencia(referencias);
            } else if (cfeType.is(CFEUtils.CfeType.eFactura_ND, CFEUtils.CfeType.eFactura_NC, CFEUtils.CfeType.eFactura_ND_VxCA, CFEUtils.CfeType.eFactura_NC_VxCA)) {
                objCfe.getEFact().setReferencia(referencias);
            } else if (cfeType.is(CFEUtils.CfeType.eResguardo)) {
                objCfe.getEResg().setReferencia(referencias);
            }
            ArrayList<MAllocInvoice> mAllocInvoices = this.getInvoiceRefDocs();
            if (!cfeType.is(CFEUtils.CfeType.eResguardo) && mAllocInvoices.size() == 0) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia - En una NC/ND se debe indicar a que factura aplica o una observacion informando porque se crea");
            }
            if (mAllocInvoices.size() == 1 && mAllocInvoices.get(0).getDescription() != null && !mAllocInvoices.get(0).getDescription().trim().isEmpty()) {
                Referencia.Referencia1 referencia = new Referencia.Referencia1();
                referencias.getReferencia1().add(referencia);
                referencia.setNroLinRef(1);
                referencia.setIndGlobal(BigInteger.valueOf(1L));
                referencia.setRazonRef(mAllocInvoices.get(0).getDescription());
            } else {
                int refNo = 1;
                for (MAllocInvoice mAllocInvoice : mAllocInvoices) {
                    Referencia.Referencia1 referencia = new Referencia.Referencia1();
                    referencias.getReferencia1().add(referencia);
                    MInvoice refInv = (MInvoice)mAllocInvoice.getC_AllocInvoice();
                    if (refInv == null || refInv.get_ID() == 0) {
                        throw new AdempiereException("CFE Error: Area Informacion de Referencia - En la pesta\u00f1a de CFEs Referidos debe definir una linea con descripci\u00f3n o 1 a 40 lineas definiendo documentos referenciados");
                    }
                    CFEUtils.CfeType cfeTypeRef = CFEUtils.getCFETypeFromDoc(this.ctx, (MDocType)refInv.getC_DocType(), this.trxName, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
                    referencia.setNroLinRef(refNo++);
                    try {
                        referencia.setTpoDocRef(BigInteger.valueOf(Long.valueOf((String)CFEUtils.getCfeTypes().inverse().get((Object)cfeTypeRef))));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - Error al parsear codigo de CFE");
                    }
                    MDocType doc = MDocType.get(this.ctx, refInv.getC_DocType_ID());
                    MSequence sec = new MSequence(this.ctx, doc.getDefiniteSequence_ID(), this.trxName);
                    if (sec.getPrefix() == null) {
                        throw new AdempiereException("CFE Error: Area Informacion de Referencia (4) - Serie de documento no especificada");
                    }
                    referencia.setSerie(sec.getPrefix());
                    if (refInv.getDocumentNo() != null) {
                        String documentNo = refInv.getDocumentNo();
                        documentNo = documentNo.replaceAll("[^0-9]", "");
                        String docno = StringUtils.leftPad(String.valueOf(documentNo), 7, "0");
                        referencia.setNroCFERef(new BigInteger(docno));
                        continue;
                    }
                    throw new AdempiereException("CFE Error: Area Informacion de Referencia (5) - N\ufffdmero de documento no especificado");
                }
            }
        }
    }

    private ArrayList<MAllocInvoice> getInvoiceRefDocs() {
        ArrayList<MAllocInvoice> ret = new ArrayList<MAllocInvoice>();
        String sqlGetRefInv = "SELECT UY_AllocInvoice_ID FROM UY_AllocInvoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sqlGetRefInv, this.trxName);
            pstmt.setInt(1, this.mInvoice.get_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MAllocInvoice mAllocInvoice = new MAllocInvoice(this.ctx, rs.getInt("UY_AllocInvoice_ID"), this.trxName);
                ret.add(mAllocInvoice);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new AdempiereException("CFE Error: Area Informacion de Referencia - No se pudieron obtener referencias de la nota de correccion");
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        return ret;
    }

    private void loadReferencia(CFEUtils.CfeType cfeType, CFEDefType objCfe, ArrayList<MInvoice> refInvs) {
        Referencia referencias = new Referencia();
        Referencia.Referencia1 referencia = null;
        if (refInvs.size() > 40) {
            throw new AdempiereException("CFE Error: Area Informacion de Referencia - No se permiten referenciar mas de 40 documentos desde una nota de correccion");
        }
        if (cfeType == CFEUtils.CfeType.eTicket_ND || cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA || cfeType == CFEUtils.CfeType.eTicket_NC_VxCA) {
            objCfe.getETck().setReferencia(referencias);
        } else if (cfeType == CFEUtils.CfeType.eFactura_ND || cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA || cfeType == CFEUtils.CfeType.eFactura_NC_VxCA) {
            objCfe.getEFact().setReferencia(referencias);
        }
        int invCount = 1;
        for (MInvoice refInv : refInvs) {
            referencia = new Referencia.Referencia1();
            referencias.getReferencia1().add(referencia);
            referencia.setNroLinRef(invCount++);
            CFEUtils.CfeType cfeTypeRef = CFEUtils.getCFETypeFromDoc(this.ctx, (MDocType)refInv.getC_DocType(), this.trxName, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
            if ((cfeType == CFEUtils.CfeType.eTicket_NC || cfeType == CFEUtils.CfeType.eTicket_ND) && cfeTypeRef != CFEUtils.CfeType.eTicket) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - El doumento actual debe estar asociado a un eTicket");
            }
            if ((cfeType == CFEUtils.CfeType.eFactura_NC || cfeType == CFEUtils.CfeType.eFactura_ND) && cfeTypeRef != CFEUtils.CfeType.eFactura) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - El doumento actual debe estar asociado a una eFactura");
            }
            if ((cfeType == CFEUtils.CfeType.eTicket_NC_VxCA || cfeType == CFEUtils.CfeType.eTicket_ND_VxCA) && cfeTypeRef != CFEUtils.CfeType.eTicket_VxCA) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - El doumento actual debe estar asociado a un eTicket Venta por Cuenta Ajena");
            }
            if ((cfeType == CFEUtils.CfeType.eFactura_NC_VxCA || cfeType == CFEUtils.CfeType.eFactura_ND_VxCA) && cfeTypeRef != CFEUtils.CfeType.eFactura_VxCA) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - El doumento actual debe estar asociado a una eFactura Venta por Cuenta Ajena");
            }
            try {
                referencia.setTpoDocRef(BigInteger.valueOf(Long.valueOf((String)CFEUtils.getCfeTypes().inverse().get((Object)cfeTypeRef))));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (3) - Error al parsear codigo de CFE");
            }
            MDocType doc = MDocType.get(this.ctx, refInv.getC_DocType_ID());
            MSequence sec = new MSequence(this.ctx, doc.getDefiniteSequence_ID(), this.trxName);
            if (sec.getPrefix() == null) {
                throw new AdempiereException("CFE Error: Area Informacion de Referencia (4) - Serie de documento no especificada");
            }
            referencia.setSerie(sec.getPrefix());
            if (refInv.getDocumentNo() != null) {
                String documentNo = refInv.getDocumentNo();
                documentNo = documentNo.replaceAll("[^0-9]", "");
                String docno = StringUtils.leftPad(String.valueOf(documentNo), 7, "0");
                referencia.setNroCFERef(new BigInteger(docno));
                continue;
            }
            throw new AdempiereException("CFE Error: Area Informacion de Referencia (5) - N\ufffdmero de documento no especificado");
        }
    }

    private ReferenceType getReferenceType() {
        String sql = "SELECT COUNT(C_Invoice_ID) FROM UY_AllocDirectCreditNote WHERE C_Invoice_ID = " + this.mInvoice.get_ID();
        int cant = DB.getSQLValue(this.trxName, sql);
        if (cant != 0) {
            return ReferenceType.MultipleInv;
        }
        if (this.mInvoice.get_Value("UY_Invoice_ID") != null && this.mInvoice.get_ValueAsInt("UY_Invoice_ID") != 0) {
            return ReferenceType.SingleInv;
        }
        if (this.mInvoice.get_Value("NCDGIReferencedDescription") != null && !this.mInvoice.get_ValueAsString("NCDGIReferencedDescription").equalsIgnoreCase("")) {
            return ReferenceType.Description;
        }
        String defaultReferencedDescription = MSysConfig.getValue("UY_CFE_DEFAULT_NCREFDESC", "", this.mInvoice.getAD_Client_ID());
        if (defaultReferencedDescription != null && !defaultReferencedDescription.equalsIgnoreCase("")) {
            this.mInvoice.set_ValueOfColumn("NCDGIReferencedDescription", (Object)defaultReferencedDescription);
            return ReferenceType.Description;
        }
        throw new AdempiereException("CFE Error: Area Informacion de Referencia - En una NC/ND se debe indicar a que factura aplica o una observacion informando porque se crea");
    }

    private void loadCAE(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        CAEDataType caeDataType = new CAEDataType();
        switch (cfeType) {
            case eFactura: 
            case eFactura_NC: 
            case eFactura_ND: 
            case eFactura_VxCA: 
            case eFactura_NC_VxCA: 
            case eFactura_ND_VxCA: {
                objCfe.getEFact().setCAEData(caeDataType);
                break;
            }
            case eTicket: 
            case eTicket_NC: 
            case eTicket_ND: 
            case eTicket_VxCA: 
            case eTicket_NC_VxCA: 
            case eTicket_ND_VxCA: {
                objCfe.getETck().setCAEData(caeDataType);
            }
        }
        CFEUtils.loadCAE(this.trxName, this.ctx, this.mluySender, objCfe, (MDocType)this.mInvoice.getC_DocType(), cfeType, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
    }

    private void loadTimestamp(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        switch (cfeType) {
            case eFactura: 
            case eFactura_NC: 
            case eFactura_ND: 
            case eFactura_VxCA: 
            case eFactura_NC_VxCA: 
            case eFactura_ND_VxCA: {
                objCfe.getEFact().setTmstFirma(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.mInvoice.getDateInvoiced(), true));
                break;
            }
            case eTicket: 
            case eTicket_NC: 
            case eTicket_ND: 
            case eTicket_VxCA: 
            case eTicket_NC_VxCA: 
            case eTicket_ND_VxCA: {
                objCfe.getETck().setTmstFirma(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.mInvoice.getDateInvoiced(), true));
            }
        }
    }

    protected void loadAdenda() {
        if (this.objCfe != null) {
            Object adenda = "";
            MDocType doc = MDocType.get(this.ctx, this.mInvoice.getC_DocType_ID());
            if (doc.getDocumentNote() != null && !doc.getDocumentNote().isEmpty()) {
                adenda = doc.getDocumentNote() + "\n";
            }
            adenda = this.mInvoice.get_ColumnIndex("CFEAdenda") > 0 ? (String)adenda + Optional.ofNullable(this.mInvoice.get_ValueAsString("CFEAdenda")).orElse("") : (String)adenda + Optional.ofNullable(this.mInvoice.getDescription()).orElse("");
            this.objCfe.setAdenda(adenda);
        }
    }

    private BigDecimal validacionPagar(Totales totales) {
        BigDecimal validacionPagar = Env.ZERO;
        if (totales.getMontoNF() == null) {
            totales.setMontoNF(Env.ZERO);
        }
        if (totales.getMntTotRetenido() == null) {
            totales.setMntTotRetenido(Env.ZERO);
        }
        validacionPagar = validacionPagar.add(totales.getMntTotRetenido());
        validacionPagar = validacionPagar.add(totales.getMntTotal());
        return validacionPagar;
    }

    public String getCfeStrFirmado() {
        return this.cfeStrFirmado;
    }

    private void loadEncabezado_eResguardo(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        if (this.mInvoice.isSOTrx()) {
            throw new AdempiereException("CFE Error: e-Resguardo debe ser IsSOTrx=N");
        }
        objCfe.setEResg(new CFEDefType.EResg());
        CFEDefType.EResg.Encabezado encabezado = new CFEDefType.EResg.Encabezado();
        objCfe.getEResg().setEncabezado(encabezado);
        IdDocResg idDocResg = new IdDocResg();
        ReceptorResg receptorResg = new ReceptorResg();
        TotalesResg totales = new TotalesResg();
        encabezado.setIdDoc(idDocResg);
        encabezado.setReceptor(receptorResg);
        encabezado.setTotales(totales);
        objCfe.setVersion("1.0");
        idDocResg.setTipoCFE(BigInteger.valueOf(182L));
        MDocType doc = MDocType.get(this.ctx, this.mInvoice.getC_DocType_ID());
        MSequence sec = new MSequence(this.ctx, doc.getDefiniteSequence_ID(), this.trxName);
        if (sec.getPrefix() == null) {
            throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (3) - Falta Prefijo de la secuencia");
        }
        idDocResg.setSerie(sec.getPrefix());
        if (this.mInvoice.getDocumentNo() == null) {
            throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (4) - Numero de comprobante no asignado al documento");
        }
        String documentNo = this.mInvoice.getDocumentNo();
        documentNo = documentNo.replaceAll("[^0-9]", "");
        String docno = StringUtils.leftPad(String.valueOf(documentNo), 7, "0");
        BigInteger numero = new BigInteger(docno);
        idDocResg.setNro(numero);
        if (this.mInvoice.getDateInvoiced() == null) {
            throw new AdempiereException("CFE Error: Area Identificacion del Comprobante (5) - Fecha del comprobante no establecida");
        }
        idDocResg.setFchEmis(CFEUtils.Timestamp_to_XmlGregorianCalendar_OnlyDate(this.mInvoice.getDateInvoiced(), false));
        MOrgInfo orgInfo = MOrgInfo.get(this.ctx, this.mInvoice.getAD_Org_ID(), this.trxName);
        encabezado.setEmisor(CFEGenericData.loadEmisor(this.mOrg, orgInfo, this.bpSender, this.ctx, this.trxName));
        MBPartner partner = MBPartner.get(this.ctx, this.mInvoice.getC_BPartner_ID());
        MBPartnerLocation mbpLocation = new MBPartnerLocation(this.ctx, this.mInvoice.getC_BPartner_Location_ID(), this.trxName);
        MLocation bpmLocation = new MLocation(this.ctx, mbpLocation.getC_Location_ID(), this.trxName);
        MCurrency mCurrency = (MCurrency)this.mInvoice.getC_Currency();
        int tipoDocRecep = 0;
        String docRecep = null;
        X_C_TaxGroup xTaxGroup = (X_C_TaxGroup)new Query(this.ctx, "C_TaxGroup", "C_TaxGroup_ID=?", this.trxName).setParameters(partner.getC_TaxGroup_ID()).first();
        String bpDocType = null;
        if (xTaxGroup == null || xTaxGroup.get_ID() < 0) {
            throw new AdempiereException("CFE Error: El receptor no posee tipo de documento");
        }
        bpDocType = xTaxGroup.getValue();
        if (tipoDocRecep == 0) {
            tipoDocRecep = bpDocType.equalsIgnoreCase("rut") ? 2 : (bpDocType.equalsIgnoreCase("CI") ? 3 : 4);
        }
        if (((docRecep = partner.getTaxID()) == null || docRecep.equalsIgnoreCase("")) && tipoDocRecep == 3) {
            try {
                docRecep = partner.get_Value("cedula").toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tipoDocRecep != 3 && (docRecep == null || docRecep.equalsIgnoreCase(""))) {
            throw new AdempiereException("CFE Error: El receptor de la factura n\ufffd: {{documentNo}} no tiene documento de identidad".replace("{{documentNo}}", this.mInvoice.getDocumentNo()));
        }
        if (mCurrency.getISO_Code() == null) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (110) - Tipo de moneda de la transaccion no establecida");
        }
        boolean eTicketAmtExceededToIdentifyReceiver = false;
        if (tipoDocRecep == 3) {
            Timestamp tstmpUI;
            MCurrency mCurrUI = MCurrency.get(this.ctx, "UI");
            if (mCurrUI == null || mCurrUI.get_ID() == 0) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado - Moneda Unidad Indexada no definida");
            }
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                cal.add(1, -1);
                String prevYear = new SimpleDateFormat("yyyy").format(new Timestamp(cal.getTimeInMillis()));
                tstmpUI = new Timestamp(new SimpleDateFormat("ddMMyyyy").parse("3112" + prevYear).getTime());
            }
            catch (Exception e) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado - No se puede obtener la fecha para la tasa de cambio de UI");
            }
            BigDecimal currRateUI = MConversionRate.getRate(mCurrUI.get_ID(), 142, tstmpUI, 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
            if (currRateUI == null || currRateUI.equals(Env.ZERO)) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado - Tasa de cambio no establecida para UI para la fecha {{fecha}}, requerido para definir monto l\ufffdmite para eTicket".replace("{{fecha}}", tstmpUI.toString()));
            }
            BigDecimal eTicketLimitAmtWithoutReceiver = new BigDecimal(MSysConfig.getDoubleValue("UY_CFE_TICKET_LIMIT_AMT_WITOUT_RECEIVER", 10000.0, this.mInvoice.getAD_Client_ID()));
            BigDecimal limitAmt142 = currRateUI.multiply(eTicketLimitAmtWithoutReceiver);
            BigDecimal currRateCurInv = MConversionRate.getRate(this.mInvoice.getC_Currency_ID(), 142, this.mInvoice.getDateInvoiced(), 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
            if (currRateCurInv == null || currRateCurInv.equals(Env.ZERO)) {
                throw new AdempiereException("CFE Error: Area Totales Encabezado (111) - Tasa de cambio no establecida para la factura de la fecha {{fecha}} para la moneda {{moneda}}".replace("{{fecha}}", String.valueOf(this.mInvoice.getDateInvoiced())).replace("{{moneda}}", String.valueOf(this.mInvoice.getC_Currency_ID())));
            }
            if (this.mInvoice.getGrandTotal().multiply(currRateCurInv).compareTo(limitAmt142) > 0) {
                if (docRecep == null || docRecep.equalsIgnoreCase("")) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado - Monto total supera limite en UI para eTicket sin especificar documento de receptor");
                }
                eTicketAmtExceededToIdentifyReceiver = true;
            }
        }
        if (tipoDocRecep != 3 || eTicketAmtExceededToIdentifyReceiver) {
            receptorResg.setTipoDocRecep(tipoDocRecep);
            MCountry mCountry = null;
            try {
                mCountry = (MCountry)bpmLocation.getC_Country();
            }
            catch (Exception e) {
                throw new AdempiereException("CFE Error: Area Receptor (61) - Pais no definido para el Receptor");
            }
            if (mCountry == null) {
                throw new AdempiereException("CFE Error: Area Receptor (61) - Pais no definido para el Receptor");
            }
            receptorResg.setCodPaisRecep(mCountry.getCountryCode());
            if (tipoDocRecep == 2 || tipoDocRecep == 3) {
                receptorResg.setDocRecep(docRecep);
            } else if (tipoDocRecep == 4 || tipoDocRecep == 5 || tipoDocRecep == 6) {
                receptorResg.setDocRecepExt(docRecep);
            }
        }
        receptorResg.setRznSocRecep(partner.getName());
        String dirRecep = bpmLocation.getAddress1();
        if (dirRecep != null && dirRecep.length() > 70) {
            dirRecep = docRecep.substring(0, 70);
        }
        receptorResg.setDirRecep(dirRecep);
        try {
            receptorResg.setCiudadRecep(bpmLocation.getC_City().getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        receptorResg.setDeptoRecep(bpmLocation.getC_Region().getName());
        receptorResg.setPaisRecep(bpmLocation.getC_Country().getName());
        try {
            receptorResg.setCP(Integer.valueOf(bpmLocation.getPostal()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mCurrency.getISO_Code() == null) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (110) - Tipo de moneda de la transaccion no establecida");
        }
        try {
            totales.setTpoMoneda(TipMonType.valueOf(mCurrency.getISO_Code()));
            if (mCurrency.getC_Currency_ID() != 142) {
                BigDecimal currRate = MConversionRate.getRate(mCurrency.getC_Currency_ID(), 142, this.mInvoice.getDateInvoiced(), 0, this.mInvoice.getAD_Client_ID(), this.mInvoice.getAD_Org_ID());
                if (currRate.equals(Env.ZERO)) {
                    throw new AdempiereException("CFE Error: Area Totales Encabezado (111) - Tasa de cambio no establecida para la factura de la fecha {{fecha}} para la moneda {{moneda}}".replace("{{fecha}}", this.mInvoice.getDateInvoiced().toString()).replace("{{moneda}}", mCurrency.getISO_Code()));
                }
                totales.setTpoCambio(currRate.setScale(3, 4));
            }
        }
        catch (AdempiereException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (110) - Tipo de moneda no aceptada por DGI");
        }
        List<MInvoiceLine> lines = Arrays.asList(this.mInvoice.getLines());
        Map<Integer, List<MInvoiceLine>> linesByWHDefId = lines.stream().collect(Collectors.groupingBy(mInvoiceLine -> mInvoiceLine.get_ValueAsInt("WH_Definition_ID")));
        AtomicReference<BigDecimal> totalSum = new AtomicReference<BigDecimal>(Env.ZERO);
        List<TotalesResg.RetencPercep> listRetPerc = totales.getRetencPercep();
        if (linesByWHDefId.size() > 20) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (127) - Solo se permiten hasta 20 tipos de retenciones diferentes por CFE Resguardo");
        }
        linesByWHDefId.forEach((mwhDefinition_id, mInvoiceLines) -> {
            MWHDefinition mwhDefinition = new MWHDefinition(this.ctx, (int)mwhDefinition_id, this.trxName);
            String codigo = mwhDefinition.get_ValueAsString("value");
            BigDecimal montoSum = mInvoiceLines.stream().map(X_C_InvoiceLine::getLineTotalAmt).reduce(BigDecimal::add).orElse(Env.ZERO).setScale(2, RoundingMode.HALF_UP);
            TotalesResg.RetencPercep retPerc = new TotalesResg.RetencPercep();
            retPerc.setCodRet(codigo);
            retPerc.setValRetPerc(montoSum);
            totalSum.accumulateAndGet(montoSum, BigDecimal::add);
            listRetPerc.add(retPerc);
        });
        if (listRetPerc.size() == 0) {
            throw new AdempiereException("CFE Error: Area totales Encabezado (125) - Se necesita almenos una retencion / percepci\ufffdn para poder enviar el Resguardo");
        }
        totales.setMntTotRetenido(totalSum.get());
        totales.setCantLinDet(listRetPerc.size());
    }

    private void loadDetalleProductosOServicios_eResguardo(CFEUtils.CfeType cfeType, CFEDefType objCfe) {
        objCfe.getEResg().setDetalle(new CFEDefType.EResg.Detalle());
        List<ItemResg> itemResgs = objCfe.getEResg().getDetalle().getItem();
        List<MInvoiceLine> lines = Arrays.asList(this.mInvoice.getLines());
        if (lines.size() > 200) {
            throw new AdempiereException("CFE Error: Area Totales Encabezado (126) - Para los CFE que no son eTickets ni sus correspondientes NC y ND, no se pueden exeder la cantidad de 200 lineas");
        }
        AtomicInteger position = new AtomicInteger(1);
        lines.forEach(mInvoiceLine -> {
            MWHDefinition mwhDefinition = new MWHDefinition(this.ctx, mInvoiceLine.get_ValueAsInt("WH_Definition_ID"), this.trxName);
            if (mwhDefinition.get_ID() <= 0) {
                throw new AdempiereException("CFE Error: Ara detalles de Productos o Servicios - Linea de resguardo sin retenci\ufffdn establecida");
            }
            ItemResg itemResg = new ItemResg();
            itemResg.setNroLinDet(position.getAndIncrement());
            if (mInvoiceLine.getLineTotalAmt().compareTo(Env.ZERO) < 0) {
                itemResg.setIndFact(BigInteger.valueOf(9L));
            }
            List<RetPercResg> listRetPercs = itemResg.getRetencPercep();
            RetPercResg retPersc = new RetPercResg();
            listRetPercs.add(retPersc);
            retPersc.setCodRet(mwhDefinition.get_ValueAsString("Value"));
            retPersc.setTasa((BigDecimal)mwhDefinition.get_Value("Percentage"));
            retPersc.setMntSujetoaRet(Optional.ofNullable((BigDecimal)mInvoiceLine.get_Value("RRAmt")).orElse(Env.ZERO).setScale(2, RoundingMode.HALF_UP).abs());
            retPersc.setValRetPerc(mInvoiceLine.getLineTotalAmt().setScale(2, RoundingMode.HALF_UP).abs());
            itemResgs.add(itemResg);
        });
    }

    public static enum ReferenceType {
        Description,
        SingleInv,
        MultipleInv;

    }
}

