/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.wms.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_WM_InOutBound;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.wms.model.MWMInOutBoundLine;

public class MWMInOutBound
extends X_WM_InOutBound
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -7216075035497599383L;
    private List<MWMInOutBoundLine> inOutBoundLines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MWMInOutBound(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setIsPrinted(false);
            this.setSendEMail(false);
        }
    }

    public MWMInOutBound(Properties properties, int n) {
        this(properties, n, null);
    }

    public MWMInOutBound(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MInOutBound[").append(this.get_ID()).append("-").append("").append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return this.getDocumentNo() + "/";
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.isSOTrx() ? this.getPickDate() : this.getDateTrx(), mDocType.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        List<MWMInOutBoundLine> list = this.getLines(true, "Line");
        if (list.size() == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("D")) {
            for (MWMInOutBoundLine mWMInOutBoundLine : list) {
                MProduct mProduct = mWMInOutBoundLine.getProduct();
                if (mProduct == null || !mProduct.isExcludeAutoDelivery()) continue;
                this.m_processMsg = "@M_Product_ID@ " + mProduct.getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        for (MWMInOutBoundLine mWMInOutBoundLine : this.getLines(true, null)) {
            mWMInOutBoundLine.deleteEx(true);
        }
        return true;
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String string;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.setProcessed(true);
        if (!this.isSOTrx()) {
            this.generateReceipt();
        }
        this.setDocAction("CL");
        string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        return "CO";
    }

    @Override
    public void setProcessed(boolean bl) {
        super.setProcessed(bl);
        for (MWMInOutBoundLine mWMInOutBoundLine : this.getLines(true, "Line")) {
            mWMInOutBoundLine.setProcessed(bl);
            mWMInOutBoundLine.saveEx();
        }
    }

    private void reverseReceipt() {
        new Query(this.getCtx(), "M_InOut", "DocStatus = 'CO' AND EXISTS(SELECT 1 FROM M_InOutLine iol \t\tINNER JOIN WM_InOutBoundLine iobl ON(iobl.WM_InOutBoundLine_ID = iol.WM_InOutBoundLine_ID) \t\tWHERE iobl.WM_InOutBound_ID = ?)", this.get_TrxName()).setParameters(this.getWM_InOutBound_ID()).list().forEach(mInOut -> {
            if (!mInOut.processIt("RC")) {
                throw new AdempiereException("@Error@ " + mInOut.getProcessMsg());
            }
            mInOut.saveEx();
        });
    }

    private void generateReceipt() {
        Hashtable<Integer, MInOut> hashtable = new Hashtable<Integer, MInOut>();
        for (MWMInOutBoundLine mWMInOutBoundLine : this.getLines(true, null)) {
            if (mWMInOutBoundLine.getC_OrderLine_ID() <= 0) continue;
            MOrderLine mOrderLine = mWMInOutBoundLine.getOrderLine();
            BigDecimal bigDecimal = mWMInOutBoundLine.getMovementQty();
            MInOut mInOut = (MInOut)hashtable.get(mOrderLine.getC_Order_ID());
            if (mInOut == null) {
                mInOut = this.createReceipt(mOrderLine, mWMInOutBoundLine.getParent());
                hashtable.put(mOrderLine.getC_Order_ID(), mInOut);
            }
            MInOutLine mInOutLine = new MInOutLine(mWMInOutBoundLine.getCtx(), 0, mWMInOutBoundLine.get_TrxName());
            mInOutLine.setM_InOut_ID(mInOut.getM_InOut_ID());
            int n = mWMInOutBoundLine.getM_Locator_ID();
            if (n == 0) {
                n = this.getM_Locator_ID();
            }
            MProduct mProduct = MProduct.get(this.getCtx(), mWMInOutBoundLine.getM_Product_ID());
            mInOutLine.setM_Locator_ID(n);
            mInOutLine.setProduct(mProduct);
            mInOutLine.setQtyEntered(bigDecimal);
            mInOutLine.setMovementQty(bigDecimal);
            mInOutLine.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
            mInOutLine.setM_Shipper_ID(mWMInOutBoundLine.getM_Shipper_ID());
            mInOutLine.setM_FreightCategory_ID(mWMInOutBoundLine.getM_FreightCategory_ID());
            mInOutLine.setFreightAmt(mWMInOutBoundLine.getFreightAmt());
            mInOutLine.setWM_InOutBoundLine_ID(mWMInOutBoundLine.getWM_InOutBoundLine_ID());
            mInOutLine.saveEx();
        }
        hashtable.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MInOut mInOut = (MInOut)entry.getValue();
            mInOut.setDocAction(this.getDocAction());
            if (!mInOut.processIt(this.getDocAction())) {
                this.log.warning("@ProcessFailed@ :" + mInOut.getDocumentInfo());
            }
            mInOut.saveEx();
        });
    }

    private MInOut createReceipt(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound) {
        MOrder mOrder = mOrderLine.getParent();
        MDocType mDocType = MDocType.get(this.getCtx(), mOrder.getC_DocTypeTarget_ID());
        int n = 0;
        n = mDocType.getC_DocTypeShipment_ID() > 0 ? mDocType.getC_DocTypeShipment_ID() : MDocType.getDocType("MMR", mOrderLine.getAD_Org_ID());
        MInOut mInOut = new MInOut(mOrder, n, this.getDateTrx());
        mInOut.setIsSOTrx(false);
        mInOut.setM_Shipper_ID(mWMInOutBound.getM_Shipper_ID());
        mInOut.setM_FreightCategory_ID(mWMInOutBound.getM_FreightCategory_ID());
        mInOut.setFreightCostRule(mWMInOutBound.getFreightCostRule());
        mInOut.setFreightAmt(mWMInOutBound.getFreightAmt());
        mInOut.saveEx();
        return mInOut;
    }

    @Override
    public int customizeValidActions(String string, Object object, String string2, String string3, int n, String[] stringArray, String[] stringArray2, int n2) {
        if (n == Table_ID) {
            if (string.equals("DR") || string.equals("IP") || string.equals("IN")) {
                stringArray2[n2++] = "PR";
            } else if (string.equals("CO")) {
                stringArray2[n2++] = "VO";
                stringArray2[n2++] = "RE";
                stringArray2[n2++] = "CL";
            } else if (string.equals("CL")) {
                stringArray2[n2++] = "--";
            }
        }
        return n2;
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.getLines(true, null).forEach(mWMInOutBoundLine -> {
            if (mWMInOutBoundLine.getMovementQty().signum() != 0) {
                mWMInOutBoundLine.setDescription(Optional.ofNullable(mWMInOutBoundLine.getDescription()).orElse("") + " " + Msg.getMsg(this.getCtx(), "Voided") + " @MovementQty@ = (" + mWMInOutBoundLine.getMovementQty() + ")");
                mWMInOutBoundLine.setMovementQty(BigDecimal.ZERO);
                mWMInOutBoundLine.setProcessed(true);
                mWMInOutBoundLine.saveEx();
            }
        });
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        if (!this.isSOTrx()) {
            this.reverseReceipt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String string) {
        String string2 = this.getDescription();
        if (string2 == null) {
            this.setDescription(string);
        } else {
            this.setDescription(string2 + " | " + string);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.getLines(true, null).forEach(mWMInOutBoundLine -> {
            if (mWMInOutBoundLine.getMovementQty().compareTo(mWMInOutBoundLine.getPickedQty()) != 0) {
                mWMInOutBoundLine.setDescription(Optional.ofNullable(mWMInOutBoundLine.getDescription()).orElse("") + " " + Msg.getMsg(this.getCtx(), "@closed@ @MovementQty@ = (" + mWMInOutBoundLine.getMovementQty() + ")"));
                mWMInOutBoundLine.setMovementQty(mWMInOutBoundLine.getPickedQty());
                mWMInOutBoundLine.setProcessed(true);
                mWMInOutBoundLine.saveEx();
            }
        });
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public List<MWMInOutBoundLine> getLines(boolean bl, String string) {
        Object object = "";
        object = string != null && string.length() > 0 ? (String)object + string : (String)object + "Line";
        this.inOutBoundLines = this.getLines(null, (String)object);
        return this.inOutBoundLines;
    }

    public List<MWMInOutBoundLine> getLines(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("WM_InOutBound_ID=?");
        if (!Util.isEmpty(string, true)) {
            stringBuffer.append(string);
        }
        if (string2.length() == 0) {
            string2 = "Line";
        }
        return new Query(this.getCtx(), "WM_InOutBoundLine", stringBuffer.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy(string2).list();
    }
}

