/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public abstract class ScanBar {
    public static CLogger log = CLogger.getCLogger(ScanBar.class);
    private LinkedHashMap<MProduct, BigDecimal> scanLines = null;
    protected Boolean isLot = null;
    protected Boolean isSerNo = null;
    protected Boolean isSerNoMandotory = null;
    protected MProduct product = null;
    protected String lotNo = null;
    protected String serNo = null;
    protected int locatorId = 0;
    protected int locatorToId = 0;
    protected MTable table = null;
    protected MTable tableLine = null;
    protected int recordId = 0;
    protected PO parent = null;
    protected static int ID = 0;
    protected static int PRODUCT_ID = 1;
    protected static int QTY_ORDERED = 2;
    protected static int QTY_PICKED = 3;
    public LinkedHashMap<String, Vector> data = null;
    public LinkedHashMap<Integer, ArrayList<Object>> source = null;

    public LinkedHashMap<String, Vector> getData() {
        if (this.data == null) {
            this.loadData();
        }
        return this.data;
    }

    public MProduct getMProduct(String barCode) {
        MProduct product = this.getProductByUPC(barCode);
        if (product != null) {
            return product;
        }
        product = this.getProductByValueC(barCode);
        if (product != null) {
            return product;
        }
        int prefixPosition = barCode.toUpperCase().indexOf("P");
        if (prefixPosition > 0 && prefixPosition <= 3) {
            product = this.getProductByValueC(barCode.substring(prefixPosition + 1));
        }
        return product;
    }

    public MProduct getProductByUPC(String barCode) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("UPPER(").append("UPC").append(")=?");
        return (MProduct)new Query(Env.getCtx(), "M_Product", whereClause.toString(), null).setClient_ID().setParameters(barCode.toUpperCase()).first();
    }

    public MProduct getProductByValueC(String barCode) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("UPPER(").append("Value").append(")=?");
        return (MProduct)new Query(Env.getCtx(), "M_Product", whereClause.toString(), null).setClient_ID().setParameters(barCode.toUpperCase()).first();
    }

    public LinkedHashMap<MProduct, BigDecimal> getLines() {
        return this.scanLines;
    }

    public boolean findProduct(String searchKey) {
        if (this.scanLines != null) {
            return this.scanLines.containsKey(searchKey);
        }
        return false;
    }

    public BigDecimal getProductQty(String serachKey) {
        return this.scanLines.get(serachKey);
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>(5);
        columnNames.add(Msg.translate(Env.getCtx(), "Value"));
        columnNames.add(Msg.translate(Env.getCtx(), "Name"));
        columnNames.add(Msg.translate(Env.getCtx(), "Lot"));
        columnNames.add(Msg.translate(Env.getCtx(), "SerNo"));
        columnNames.add(Msg.translate(Env.getCtx(), "QtyEntered"));
        return columnNames;
    }

    public void setColumnClass(IMiniTable dataTable) {
        dataTable.setColumnClass(0, String.class, true);
        dataTable.setColumnClass(1, String.class, true);
        dataTable.setColumnClass(2, String.class, true);
        dataTable.setColumnClass(3, String.class, true);
        dataTable.setColumnClass(4, BigDecimal.class, true);
        dataTable.autoSize();
    }

    public boolean isLot() {
        if (this.isLot == null) {
            MAttributeSet attributeSet = null;
            if (this.product.getM_AttributeSet_ID() > 0) {
                attributeSet = (MAttributeSet)this.product.getM_AttributeSet();
                this.isLot = attributeSet.isLot();
                boolean isExcludeEntry = attributeSet.excludeEntry(this.getTableLine().getAD_Table_ID(), Env.isSOTrx(this.product.getCtx()));
                if (isExcludeEntry) {
                    this.isLot = false;
                }
            } else {
                this.isLot = false;
            }
        }
        return this.isLot;
    }

    public boolean isSerNo() {
        if (this.isSerNo == null) {
            MAttributeSet attributeSet = null;
            if (this.product.getM_AttributeSet_ID() > 0) {
                attributeSet = (MAttributeSet)this.product.getM_AttributeSet();
                this.isSerNo = attributeSet.isSerNo();
                this.isSerNoMandotory = attributeSet.isSerNoMandatory();
                boolean isExcludeEntry = attributeSet.excludeEntry(this.getTableLine().getAD_Table_ID(), Env.isSOTrx(this.product.getCtx()));
                if (isExcludeEntry) {
                    this.isSerNo = false;
                }
            } else {
                this.isSerNo = false;
            }
        }
        return this.isSerNo;
    }

    public boolean isSerNoMandatory() {
        if (this.isSerNoMandotory != null) {
            return this.isSerNoMandotory;
        }
        this.isSerNo();
        return this.isSerNoMandotory;
    }

    public void setProduct(MProduct product) {
        this.product = product;
        this.lotNo = null;
        this.serNo = null;
        this.isLot = null;
        this.isSerNo = null;
        this.isLot();
        this.isSerNo();
    }

    public String getLotNo() {
        return this.lotNo;
    }

    public String getSerNo() {
        return this.serNo;
    }

    protected void setLotNo(String lotNo) {
        this.lotNo = lotNo;
    }

    protected void setSerNo(String serNo) {
        this.serNo = serNo;
    }

    public MProduct getProduct() {
        return this.product;
    }

    protected void setData(LinkedHashMap<String, Vector> data) {
        this.data = data;
    }

    protected Vector<Vector<Object>> getDataModel() {
        Vector<Vector<Object>> dataModel = new Vector<Vector<Object>>();
        for (Vector line : this.getData().values()) {
            Vector targetLine = new Vector();
            targetLine.add(line.get(0));
            targetLine.add(line.get(1));
            targetLine.add(line.get(2));
            targetLine.add(line.get(3));
            targetLine.add(line.get(4));
            dataModel.add(targetLine);
        }
        return dataModel;
    }

    protected PO getParent() {
        if (this.parent == null) {
            this.parent = this.getTable().getPO(this.getRecord_ID(), null);
        }
        return this.parent;
    }

    protected LinkedHashMap<Integer, ArrayList<Object>> getSource() {
        if (this.source != null) {
            return this.source;
        }
        PO po = this.getParent();
        int C_Order_ID = po.get_ValueAsInt("C_Order_ID");
        if (C_Order_ID > 0) {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("C_Order_ID").append("=? AND ");
            whereClause.append("(").append("QtyOrdered").append("-");
            whereClause.append("QtyDelivered").append(")>0");
            List orderLines = new Query(Env.getCtx(), "C_OrderLine", whereClause.toString(), null).setClient_ID().setParameters(C_Order_ID).list();
            this.source = new LinkedHashMap();
            for (MOrderLine line : orderLines) {
                if (line.getQtyOrdered().subtract(line.getQtyDelivered()).signum() <= 0) continue;
                ArrayList<Number> parameters = new ArrayList<Number>();
                parameters.add(ID, line.getC_OrderLine_ID());
                parameters.add(PRODUCT_ID, line.getM_Product_ID());
                parameters.add(QTY_ORDERED, line.getQtyOrdered().subtract(line.getQtyDelivered()));
                parameters.add(QTY_PICKED, line.getQtyOrdered().subtract(line.getQtyDelivered()));
                this.source.put(line.get_ID(), parameters);
            }
        } else {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append(this.getTable().getKeyColumns()[0]).append("=? ");
            List lines = new Query(Env.getCtx(), this.getTable().getTableName(), whereClause.toString(), null).setClient_ID().setParameters(this.getRecord_ID()).list();
            this.source = new LinkedHashMap();
            for (PO line : lines) {
                if (line.get_ValueAsInt("M_Product_ID") <= 0) continue;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(ID, line.get_ID());
                parameters.add(PRODUCT_ID, line.get_ValueAsInt("M_Product_ID"));
                parameters.add(QTY_ORDERED, line.get_Value("PickedQty"));
                parameters.add(QTY_PICKED, line.get_Value("PickedQty"));
                this.source.put(line.get_ID(), parameters);
            }
        }
        return this.source;
    }

    protected ArrayList<Object> checkProduct(MProduct product, BigDecimal qty, boolean reset) {
        for (Map.Entry<Integer, ArrayList<Object>> entry : this.getSource().entrySet()) {
            ArrayList<Object> values = entry.getValue();
            int M_Product_ID = (Integer)values.get(PRODUCT_ID);
            BigDecimal qtyPicked = (BigDecimal)values.get(QTY_PICKED);
            if (product.get_ID() != M_Product_ID || qtyPicked.signum() <= 0) continue;
            Integer id = (Integer)values.get(ID);
            BigDecimal qtyOrdered = (BigDecimal)values.get(QTY_ORDERED);
            if (qtyPicked.compareTo(qty) < 0 || qtyPicked == null || qtyPicked.signum() < 0) continue;
            qtyPicked = reset ? qtyOrdered.subtract(qty) : qtyPicked.subtract(qty);
            if (qtyPicked.signum() < 0) {
                return null;
            }
            values.set(QTY_PICKED, qtyPicked);
            this.source.put(entry.getKey(), values);
            return values;
        }
        return null;
    }

    protected int getM_Locater_ID() {
        return this.locatorId;
    }

    protected int getM_LocaterTo_ID() {
        return this.locatorToId;
    }

    protected int getRecord_ID() {
        if (this.recordId <= 0) {
            this.recordId = this.getProcessInfo().getRecord_ID();
        }
        return this.recordId;
    }

    protected MTable getTable() {
        if (this.table == null) {
            this.table = MTable.get(Env.getCtx(), this.getProcessInfo().getTable_ID());
            this.tableLine = "WM_InOutBound".equals(this.table.getTableName()) ? MTable.get(Env.getCtx(), this.getTable().getTableName() + "LineMA") : MTable.get(Env.getCtx(), this.getTable().getTableName() + "Line");
        }
        return this.table;
    }

    protected MTable getTableLine() {
        return this.tableLine;
    }

    public void createLine() {
        int lineNo = DB.getSQLValueEx(null, "SELECT Line FROM " + this.tableLine.getTableName() + " WHERE " + this.table.getTableName() + "_ID=?", this.getRecord_ID());
        if (lineNo <= 0) {
            lineNo = 10;
        }
        for (Vector line : this.getData().values()) {
            String value = (String)line.get(0);
            String lotNo = (String)line.get(2);
            String serNo = (String)line.get(3);
            Boolean isASI = lotNo != null && lotNo.length() > 0 || serNo != null && serNo.length() > 0;
            BigDecimal qty = (BigDecimal)line.get(4);
            int id = (Integer)line.get(5);
            Integer referenceId = (Integer)line.get(6);
            PO poLine = null;
            MAttributeSetInstance asi = null;
            MProduct product = (MProduct)new Query(Env.getCtx(), "M_Product", "Value = ? ", null).setClient_ID().setParameters(value).firstOnly();
            Object desc = null;
            poLine = this.tableLine.getPO(id, null);
            if (product.getM_AttributeSet_ID() > 0 && isASI.booleanValue()) {
                asi = poLine != null && poLine.get_ValueAsInt("M_AttributeSetInstance_ID") > 0 ? new MAttributeSetInstance(Env.getCtx(), poLine.get_ValueAsInt("M_AttributeSetInstance_ID"), null) : this.getAttributeSetInstance(product, lotNo, serNo, this.getM_Locater_ID(), null);
            }
            poLine.set_ValueOfColumn(this.table.getKeyColumns()[0], (Object)this.getRecord_ID());
            poLine.set_ValueOfColumn("M_Product_ID", (Object)product.get_ID());
            poLine.set_ValueOfColumn("C_UOM_ID", (Object)product.getC_UOM_ID());
            poLine.set_ValueOfColumn("Line", (Object)lineNo);
            poLine.set_ValueOfColumn("IsActive", (Object)true);
            int locatorColumnId = poLine.get_ColumnIndex("M_Locator_ID");
            if (locatorColumnId > 0 && this.getM_Locater_ID() > 0) {
                poLine.set_ValueOfColumn("M_Locator_ID", (Object)this.getM_Locater_ID());
            }
            if (asi == null && isASI.booleanValue() && asi == null && isASI.booleanValue()) {
                asi = new MAttributeSetInstance(Env.getCtx(), 0, product.getM_AttributeSet_ID(), null);
                if (lotNo != null) {
                    asi.setLot(lotNo);
                    desc = lotNo;
                }
                if (serNo != null) {
                    asi.setSerNo(serNo);
                    desc = desc != null ? (String)desc + " - " + serNo : serNo;
                }
                asi.setDescription((String)desc);
                asi.saveEx();
            }
            if (poLine instanceof MInventoryLine) {
                MStorage storage = MStorage.get(Env.getCtx(), this.getM_Locater_ID(), product.getM_Product_ID(), asi == null ? 0 : asi.getM_AttributeSetInstance_ID(), null);
                poLine.set_CustomColumn("QtyCount", qty);
                poLine.set_CustomColumn("QtyBook", storage == null ? Env.ZERO : storage.getQtyOnHand());
            } else if (poLine instanceof MInOutLine) {
                MInOutLine ioLine = (MInOutLine)poLine;
                ioLine.setQty(qty);
                ioLine.setC_OrderLine_ID(referenceId);
            } else if (poLine instanceof MMovementLine) {
                MMovementLine movementLine = (MMovementLine)poLine;
                movementLine.setM_LocatorTo_ID(this.getM_LocaterTo_ID());
                movementLine.setMovementQty(qty);
            } else {
                poLine.set_ValueOfColumn("MovementQty", (Object)qty);
            }
            poLine.set_ValueOfColumn("M_AttributeSetInstance_ID", (Object)(asi == null ? 0 : asi.get_ID()));
            if (poLine.is_Changed()) {
                poLine.saveEx();
            }
            lineNo += 10;
        }
    }

    private PO getPOWithASI(MProduct product, String lotNo, String serNo, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(this.getRecord_ID());
        parameters.add(product.get_ID());
        whereClause.append("EXISTS (SELECT 1 FROM ").append("AD_Table");
        whereClause.append("INNER JOIN M_AttributeSetInstance asi ON (asi.M_AttributeSetInstance_ID=").append("AD_Table").append(".M_AttributeSetInstance_ID) ");
        whereClause.append("WHERE ").append("AD_Table").append(",").append(this.table.getKeyColumns()[0]).append("=? AND M_Product_ID=?");
        if (lotNo != null && lotNo.length() > 0) {
            whereClause.append(" AND ").append("Lot").append("=? ");
            parameters.add(lotNo);
        }
        if (serNo != null && serNo.length() > 0) {
            whereClause.append(" AND ").append("SerNo").append("=? ");
            parameters.add(serNo);
        }
        whereClause.append(")");
        return new Query(Env.getCtx(), "AD_Table", whereClause.toString(), null).setClient_ID().setParameters(parameters).firstOnly();
    }

    protected MAttributeSetInstance getAttributeSetInstance(MProduct product, String lotNo, String serNo, int M_Locator_ID, String trxName) {
        StringBuilder whereClause = new StringBuilder("EXISTS (SELECT 1 FROM M_Storage s WHERE s.M_Product_ID=? AND s.M_Locator_ID=? AND s.M_AttributeSetInstance_ID=M_AttributeSetInstance.M_AttributeSetInstance_ID ORDER BY s.QtyOnhand )");
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(product.get_ID());
        parameters.add(M_Locator_ID);
        if (lotNo != null && lotNo.length() > 0) {
            whereClause.append(" AND ").append("Lot").append("=?");
            parameters.add(lotNo);
        }
        if (serNo != null && serNo.length() > 0) {
            whereClause.append(" AND ").append("SerNo").append("=?");
            parameters.add(serNo);
        }
        return (MAttributeSetInstance)new Query(Env.getCtx(), "M_AttributeSetInstance", whereClause.toString(), trxName).setClient_ID().setParameters(parameters).first();
    }

    protected void loadData() {
        this.data = new LinkedHashMap();
        for (PO po : this.getDocumentLines()) {
            ArrayList<Object> values;
            MProduct product = null;
            MAttributeSetInstance asi = null;
            String lotNo = null;
            String serNo = null;
            Integer referenceId = null;
            BigDecimal qty = null;
            boolean reset = false;
            int M_Product_ID = po.get_ValueAsInt("M_Product_ID");
            int M_AttributeSetInstance_ID = po.get_ValueAsInt("M_AttributeSetInstance_ID");
            if (M_Product_ID <= 0) continue;
            product = MProduct.get(Env.getCtx(), M_Product_ID);
            if (M_AttributeSetInstance_ID > 0) {
                asi = new MAttributeSetInstance(Env.getCtx(), M_AttributeSetInstance_ID, null);
                lotNo = asi.getLot();
                serNo = asi.getSerNo();
            } else {
                M_AttributeSetInstance_ID = 0;
                reset = true;
                lotNo = null;
                serNo = null;
            }
            if (po instanceof MInOutLine) {
                MInOutLine ioLine = (MInOutLine)po;
                referenceId = ioLine.getC_OrderLine_ID();
                qty = ioLine.getMovementQty();
            }
            if (po instanceof MInventoryLine) {
                MInventoryLine invenotryLine = (MInventoryLine)po;
                qty = invenotryLine.getQtyCount();
            }
            if (this.getSource() != null && this.source.size() > 0 && (values = this.checkProduct(product, qty, reset)) == null) {
                throw new AdempiereException("@M_Product_ID@ ; " + product.getName() + " @InValid@");
            }
            Object key = product.getValue();
            if (lotNo != null && lotNo.length() > 0) {
                key = (String)key + lotNo;
            }
            if (serNo != null && serNo.length() > 0) {
                key = (String)key + serNo;
            }
            Vector<Object> line = new Vector<Object>(6);
            line.add(product.getValue());
            line.add(product.getName());
            line.add(lotNo);
            line.add(serNo);
            line.add(qty);
            line.add(po.get_ID());
            line.add(referenceId != null ? referenceId : 0);
            this.data.put((String)key, line);
        }
    }

    private List<PO> getDocumentLines() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(this.getTable().getKeyColumns()[0]).append("=? ");
        return new Query(Env.getCtx(), this.tableLine.getTableName(), whereClause.toString(), null).setClient_ID().setParameters(this.getRecord_ID()).list();
    }

    public abstract ProcessInfo getProcessInfo();
}

