/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.eevolution.process.GenerateSurrogateKeysAbstract;
import org.jfree.util.Log;

public class GenerateSurrogateKeys
extends GenerateSurrogateKeysAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        List<MTable> tableList = this.getTableList(this.get_TrxName());
        tableList.stream().filter(table2 -> table2 != null).forEach(table2 -> this.addColumn(table2.getAD_Table_ID()));
        if (this.isGenerateUUIDforallrecords()) {
            tableList.stream().filter(table2 -> table2 != null).forEach(table2 -> this.generateUUIDByTable(table2.getTableName()));
        }
        return "@Ok@";
    }

    private void addColumn(final int tableId) {
        try {
            Log.info((Object)"Procesing Add Column UUID in tables");
            final AtomicInteger elementId = new AtomicInteger();
            final AtomicInteger columnId = new AtomicInteger();
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    M_Element element = GenerateSurrogateKeys.getElement("UUID", trxName);
                    if (element == null) {
                        element = new M_Element(Env.getCtx(), 0, trxName);
                        element.setColumnName("UUID");
                        element.setPrintName("UUID");
                        element.setName("Immutable Universally Unique Identifier");
                        element.setDescription("Immutable Universally Unique Identifier");
                        element.setHelp("\"A surrogate key in a database is a unique identifier for either an entity in the modeled world or an object in the database. The surrogate key is not derived from application data, unlike a natural (or business) key which is derived from application data. \" , According to Wikipedia http://en.wikipedia.org/wiki/Surrogate_key");
                        element.setEntityType("D");
                        element.saveEx();
                        elementId.set(element.get_ID());
                    } else {
                        elementId.set(element.getAD_Element_ID());
                    }
                }
            });
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    MTable table2 = MTable.get(Env.getCtx(), tableId);
                    GenerateSurrogateKeys.this.log.info("Table Name: " + table2.getTableName() + " ...");
                    M_Element element = new M_Element(Env.getCtx(), elementId.get(), trxName);
                    MColumn column = table2.getColumn("UUID");
                    if (column == null) {
                        column = new MColumn(Env.getCtx(), 0, trxName);
                        column.setName(element.getName());
                        column.setAD_Table_ID(table2.getAD_Table_ID());
                        column.setAD_Element_ID(element.getAD_Element_ID());
                        column.setName(element.getName());
                        column.setColumnName(element.getColumnName());
                        column.setEntityType(element.getEntityType());
                        column.setIsActive(true);
                        column.setAD_Reference_ID(10);
                        column.setFieldLength(36);
                        column.setEntityType("D");
                        column.saveEx();
                        columnId.set(column.getAD_Column_ID());
                    } else {
                        column.setAD_Element_ID(element.getAD_Element_ID());
                        column.setFieldLength(36);
                        column.saveEx();
                        columnId.set(column.getAD_Column_ID());
                    }
                }
            });
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    MColumn column = new MColumn(Env.getCtx(), columnId.get(), trxName);
                    if (column != null && column.getAD_Column_ID() > 0) {
                        column.syncDatabase();
                    }
                }
            });
        }
        catch (Exception e) {
            this.addLog(e.getMessage());
        }
    }

    private void generateUUIDByTable(String tableName) {
        int updated = DB.executeUpdate("UPDATE " + tableName + " SET UUID = getUUID() WHERE UUID IS NULL", this.get_TrxName());
        this.addLog(tableName + " @Updated@: " + updated);
    }

    private List<MTable> getTableList(String trxName) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("IsView=?");
        parameters.add("N");
        if (this.getTableId() > 0) {
            whereClause.append(" AND ").append("AD_Table_ID").append(" = ? ");
            parameters.add(this.getTableId());
        }
        return new Query(Env.getCtx(), "AD_Table", whereClause.toString(), trxName).setOnlyActiveRecords(true).setParameters(parameters).setOrderBy("TableName").list();
    }

    public static M_Element getElement(String name, String trxName) {
        String whereClause = "ColumnName=?";
        return (M_Element)new Query(Env.getCtx(), "AD_Element", "ColumnName=?", trxName).setParameters(name).firstOnly();
    }
}

