/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.util.Hashtable;
import org.adempiere.core.domains.models.X_AD_Table;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.eevolution.process.ExportFormatGeneratorAbstract;

public class ExportFormatGenerator
extends ExportFormatGeneratorAbstract {
    private Hashtable<String, MEXPFormat> exportFormats = new Hashtable();
    private String version = "3.8.2";
    private String parentTable = null;
    private String formatValue = null;
    private int level = -1;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MTab[] tabs;
        MWindow window = new MWindow(this.getCtx(), this.getWindowId(), this.get_TrxName());
        for (MTab tab : tabs = window.getTabs(true, this.get_TrxName())) {
            X_AD_Table table2 = null;
            String format = null;
            if (this.isInsertRecord() && tab.isInsertRecord()) {
                table2 = new MTable(this.getCtx(), tab.getAD_Table_ID(), this.get_TrxName());
                format = this.createFormat((MTable)table2);
            } else if (!this.isInsertRecord()) {
                table2 = new MTable(this.getCtx(), tab.getAD_Table_ID(), this.get_TrxName());
                format = this.createFormat((MTable)table2);
            }
            if (tab.getTabLevel() <= this.level) continue;
            this.parentTable = table2.getTableName();
            this.formatValue = format;
        }
        return "ok";
    }

    private String createFormat(MTable table2) throws SQLException {
        this.log.info("Table Name:" + table2.getTableName());
        MColumn[] columns = table2.getColumns(true);
        String unique = null;
        boolean isFieldName = false;
        for (MColumn column : columns) {
            if (!column.isIdentifier() || column.getSeqNo() != 1) continue;
            unique = column.getColumnName();
            if (unique.equals("Name")) {
                isFieldName = true;
            }
            this.log.info("Unique Key" + unique);
            break;
        }
        if (unique == null) {
            unique = "Name";
        }
        MEXPFormat format = null;
        String formatValue = table2.getTableName();
        this.log.info("Export Format Value:" + formatValue);
        format = this.exportFormats.get(formatValue);
        if (format != null) {
            return format.getValue();
        }
        String where = " value = ? ";
        Query sql = new Query(this.getCtx(), "EXP_Format", where, this.get_TrxName()).setParameters(formatValue);
        if (sql.match()) {
            format = (MEXPFormat)sql.first();
            this.exportFormats.put(format.getValue(), format);
            return format.getValue();
        }
        format = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.getCtx(), formatValue, this.getAD_Client_ID(), this.version, this.get_TrxName());
        if (format == null) {
            format = new MEXPFormat(this.getCtx(), 0, this.get_TrxName());
        }
        format.setAD_Org_ID(0);
        format.setValue(formatValue);
        format.setName(table2.getName());
        format.setAD_Table_ID(table2.getAD_Table_ID());
        format.setDescription(table2.getDescription());
        format.setHelp(table2.getHelp());
        format.setVersion(this.version);
        format.saveEx();
        if (format != null) {
            this.exportFormats.put(format.getValue(), format);
        }
        int position = 10;
        for (MColumn column : columns) {
            if (this.isMandatory()) {
                if (column.isMandatory()) {
                    this.createFormatLine(format, table2, column, position, false);
                }
            } else {
                this.createFormatLine(format, table2, column, position, false);
            }
            ++position;
        }
        return format.getValue();
    }

    private int createFormatLine(MEXPFormat format, MTable table2, MColumn col, int position, boolean force) throws SQLException {
        int AD_Table_ID;
        MEXPFormatLine formatLine = null;
        String formatlinevalue = col.getColumnName();
        formatLine = MEXPFormatLine.getFormatLineByValue(this.getCtx(), formatlinevalue, format.getEXP_Format_ID(), this.get_TrxName());
        if (formatLine == null) {
            formatLine = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
        }
        formatLine.setAD_Org_ID(0);
        formatLine.setEXP_Format_ID(format.getEXP_Format_ID());
        formatLine.setValue(formatlinevalue);
        formatLine.setName(col.getName());
        formatLine.setDescription(col.getDescription());
        formatLine.setHelp(col.getHelp());
        formatLine.setPosition(position);
        formatLine.setIsMandatory(col.isMandatory());
        if (force || col.isIdentifier() && !col.isKey()) {
            formatLine.setIsPartUniqueIndex(true);
            formatLine.setIsActive(true);
        } else {
            formatLine.setIsActive(false);
        }
        MTable tabledir = null;
        if (col.getColumnName().equals(this.parentTable + "_ID") && DisplayType.isID(col.getAD_Reference_ID())) {
            MEXPFormat referenceFormat = null;
            referenceFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.getCtx(), this.parentTable + "_Key", this.getAD_Client_ID(), this.version, this.get_TrxName());
            if (referenceFormat == null) {
                referenceFormat = new MEXPFormat(this.getCtx(), 0, this.get_TrxName());
            }
            referenceFormat.setAD_Org_ID(0);
            referenceFormat.setValue(this.parentTable + "_Key");
            referenceFormat.setName(this.parentTable + "_Key");
            referenceFormat.setAD_Table_ID(MTable.getTable_ID(this.parentTable));
            referenceFormat.setDescription(table2.getDescription());
            referenceFormat.setHelp(table2.getHelp());
            referenceFormat.saveEx();
            int AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='DOCUMENTNO'", this.parentTable);
            if (AD_Column_ID > 0) {
                this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
                AD_Column_ID = 0;
                AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='C_DOCTYPE_ID'", this.parentTable);
                if (AD_Column_ID > 0) {
                    this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 20, true);
                }
                formatLine.setValue(this.parentTable + "_Key");
                formatLine.setName("Key DocumentNo_C_DocType");
                formatLine.setAD_Column_ID(col.getAD_Column_ID());
                formatLine.setType("R");
                formatLine.setEXP_EmbeddedFormat_ID(referenceFormat.getEXP_Format_ID());
                formatLine.saveEx();
                if (this.parentTable != null && col.isParent() && col.getColumnName().contains(this.parentTable)) {
                    int reference = this.exportFormats.get(this.formatValue).getEXP_Format_ID();
                    MEXPFormatLine embededformatLine = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
                    embededformatLine.setAD_Org_ID(0);
                    embededformatLine.setValue(format.getValue() + "_Embedded");
                    embededformatLine.setName("Embedded " + format.getName());
                    embededformatLine.setEXP_EmbeddedFormat_ID(formatLine.getEXP_Format_ID());
                    embededformatLine.setEXP_Format_ID(reference);
                    embededformatLine.setType("M");
                    embededformatLine.setAD_Column_ID(col.getAD_Column_ID());
                    embededformatLine.saveEx();
                }
                this.log.info("Export Format Line:" + formatLine.getName());
                return formatLine.getEXP_FormatLine_ID();
            }
            AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='NAME'", this.parentTable);
            if (AD_Column_ID > 0) {
                this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
            } else {
                AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='VALUE'", this.parentTable);
                if (AD_Column_ID > 0) {
                    this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
                } else {
                    throw new AdempiereException("Table without name or value column");
                }
            }
            formatLine.setValue(this.parentTable + "_Key");
            formatLine.setName("Key " + col.getColumnName());
            formatLine.setAD_Column_ID(col.getAD_Column_ID());
            formatLine.setType("R");
            formatLine.setEXP_EmbeddedFormat_ID(referenceFormat.getEXP_Format_ID());
            formatLine.saveEx();
            return formatLine.getEXP_FormatLine_ID();
        }
        if (DisplayType.isID(col.getAD_Reference_ID()) && col.getAD_Reference_Value_ID() > 0 && (AD_Table_ID = DB.getSQLValue(this.get_TrxName(), "SELECT rt.AD_Table_ID FROM AD_Reference r INNER JOIN AD_Ref_Table rt ON (r.AD_Reference_ID=rt.AD_Reference_ID)  WHERE r.AD_Reference_ID=?", col.getAD_Reference_Value_ID())) > 0) {
            tabledir = MTable.get(this.getCtx(), AD_Table_ID);
            formatLine.setValue(col.getColumnName() + "_Reference");
            formatLine.setName("Referenced " + tabledir.getTableName());
            formatLine.setAD_Column_ID(col.getAD_Column_ID());
            String format_value = this.createFormat(tabledir);
            int embedded = this.exportFormats.get(format_value).getEXP_Format_ID();
            formatLine.setType("R");
            formatLine.setEXP_EmbeddedFormat_ID(embedded);
            formatLine.saveEx();
            return formatLine.getEXP_FormatLine_ID();
        }
        if (DisplayType.isID(col.getAD_Reference_ID()) && !col.isKey() && 13 != col.getAD_Reference_ID() && 32 != col.getAD_Reference_ID()) {
            String tableName = col.getColumnName().substring(0, col.getColumnName().lastIndexOf("_ID"));
            this.log.info("Table Name:" + tableName);
            if (tableName == null) {
                this.log.info("Table Name: null");
                return 0;
            }
            tabledir = MTable.get(this.getCtx(), tableName);
            if (tabledir == null) {
                return 0;
            }
            formatLine.setValue(tabledir.getTableName() + "_Reference");
            formatLine.setName("Referenced " + tabledir.getTableName());
            if (tabledir != null) {
                String format_value = this.createFormat(tabledir);
                int embedded = this.exportFormats.get(format_value).getEXP_Format_ID();
                formatLine.setType("R");
                formatLine.setEXP_EmbeddedFormat_ID(embedded);
            } else {
                formatLine.setType("E");
            }
        }
        formatLine.setAD_Column_ID(col.getAD_Column_ID());
        formatLine.saveEx();
        this.log.info("Export Format Line:" + formatLine.getName());
        return formatLine.getEXP_FormatLine_ID();
    }
}

