/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTask;
import org.compiere.model.MRefList;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.process.ProjectGenerateManufacturingOrderAbstract;

public class ProjectGenerateManufacturingOrder
extends ProjectGenerateManufacturingOrderAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MProduct product;
        MProject project = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        if (project == null || project.getC_Project_ID() <= 0) {
            throw new AdempiereException("@C_Project@ @NotFound@");
        }
        AtomicReference<Optional<Timestamp>> atomicDateOrdered = new AtomicReference<Optional<Timestamp>>();
        AtomicReference<Optional<Timestamp>> atomicDatePromised = new AtomicReference<Optional<Timestamp>>();
        AtomicInteger atomicBOMId = new AtomicInteger(0);
        AtomicInteger atomicWorkflowId = new AtomicInteger(0);
        AtomicReference<MProjectPhase> atomicProjectPhase = new AtomicReference<MProjectPhase>();
        AtomicReference<MProjectTask> atomicProjectTask = new AtomicReference<MProjectTask>();
        AtomicReference<BigDecimal> atomicQuantity = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (this.getProjectLineId() > 0) {
            MProjectLine projectLine = new MProjectLine(this.getCtx(), this.getProjectLineId(), this.get_TrxName());
            if (projectLine.getPP_Order_ID() > 0) {
                MPPOrder order = (MPPOrder)projectLine.getPP_Order();
                throw new AdempiereException(order.getDocumentInfo() + " @AlreadyExists@ @To@ @C_ProjectLine_ID@");
            }
            product = MProduct.get(this.getCtx(), projectLine.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectLine.getPlannedQty());
            projectLine.getProjectPhase().ifPresent(projectPhaseLine -> {
                Optional<Timestamp> dateOrderedOptional = Optional.ofNullable(Optional.ofNullable(projectPhaseLine.getDateStartSchedule()).orElseGet(() -> project.getDateStartSchedule()));
                Optional<Timestamp> datePromisedOptional = Optional.ofNullable(Optional.ofNullable(projectPhaseLine.getDateFinishSchedule()).orElseGet(() -> project.getDateFinishSchedule()));
                atomicProjectPhase.set((MProjectPhase)projectPhaseLine);
                atomicDateOrdered.set(Optional.ofNullable(dateOrderedOptional.orElseGet(() -> Optional.ofNullable(projectPhaseLine.getStartDate()).orElseGet(() -> project.getDateStartSchedule()))));
                atomicDatePromised.set(Optional.ofNullable(datePromisedOptional.orElseGet(() -> Optional.ofNullable(projectPhaseLine.getDateDeadline()).orElseGet(() -> project.getDateFinishSchedule()))));
            });
            projectLine.getProjectTask().ifPresent(projectTaskLine -> {
                MProjectPhase projectPhase = (MProjectPhase)projectTaskLine.getC_ProjectPhase();
                atomicProjectTask.set((MProjectTask)projectTaskLine);
                atomicProjectPhase.set(projectPhase);
                Optional<Timestamp> dateOrderedOptional = Optional.ofNullable(Optional.ofNullable(projectTaskLine.getDateStartSchedule()).orElseGet(() -> Optional.ofNullable(projectPhase.getDateStartSchedule()).orElseGet(() -> project.getDateStartSchedule())));
                Optional<Timestamp> datePromisedOptional = Optional.ofNullable(Optional.ofNullable(projectTaskLine.getDateFinishSchedule()).orElseGet(() -> Optional.ofNullable(projectPhase.getDateFinishSchedule()).orElseGet(() -> project.getDateFinishSchedule())));
                dateOrderedOptional.ifPresent(dateOrdered -> atomicDateOrdered.set(Optional.ofNullable(dateOrdered)));
                datePromisedOptional.ifPresent(datePromised -> atomicDatePromised.set(Optional.ofNullable(datePromised)));
            });
        } else if (this.getProjectTaskId() > 0) {
            MProjectTask projectTask = new MProjectTask(this.getCtx(), this.getProjectTaskId(), this.get_TrxName());
            if (!"P".equals(projectTask.getProjInvoiceRule())) {
                String errorMessage = "@ProjInvoiceRule@ " + MRefList.getListName(this.getCtx(), 383, "P");
                throw new AdempiereException(errorMessage);
            }
            product = MProduct.get(this.getCtx(), projectTask.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectTask.getQty());
            MProjectPhase projectPhase = (MProjectPhase)projectTask.getC_ProjectPhase();
            Optional<Timestamp> dateOrderedPhase = Optional.ofNullable(projectPhase.getDateStartSchedule());
            Optional<Timestamp> datePromisedPhase = Optional.ofNullable(projectPhase.getDateFinishSchedule());
            atomicProjectPhase.set(projectPhase);
            atomicProjectTask.set(projectTask);
            Optional<Timestamp> dateOrderedTask = Optional.ofNullable(projectTask.getDateStartSchedule());
            Optional<Timestamp> datePromisedTask = Optional.ofNullable(projectTask.getDateFinishSchedule() != null ? projectTask.getDateFinishSchedule() : projectTask.getDateDeadline());
            atomicDateOrdered.set(Optional.ofNullable(dateOrderedTask.orElseGet(() -> dateOrderedPhase.orElseGet(() -> project.getDateStartSchedule()))));
            atomicDatePromised.set(Optional.ofNullable(datePromisedTask.orElseGet(() -> datePromisedPhase.orElseGet(() -> project.getDateFinishSchedule()))));
        } else if (this.getProjectPhaseId() > 0) {
            MProjectPhase projectPhase = new MProjectPhase(this.getCtx(), this.getProjectPhaseId(), this.get_TrxName());
            if (!"P".equals(projectPhase.getProjInvoiceRule())) {
                String errorMessage = "@ProjInvoiceRule@ " + MRefList.getListName(this.getCtx(), 383, "P");
                throw new AdempiereException(errorMessage);
            }
            product = MProduct.get(this.getCtx(), projectPhase.getM_Product_ID());
            this.validProduct(product);
            atomicBOMId.set(this.getProductBOMId() > 0 ? this.getProductBOMId() : MPPProductBOM.getDefault(product, this.get_TrxName()).getPP_Product_BOM_ID());
            atomicWorkflowId.set(this.getWorkflowId() > 0 ? this.getWorkflowId() : MWorkflow.getWorkflowSearchKey(product));
            atomicQuantity.set(projectPhase.getQty());
            Optional<Timestamp> dateOrderedPhase = Optional.ofNullable(projectPhase.getDateStartSchedule());
            Optional<Timestamp> datePromisedPhase = Optional.ofNullable(projectPhase.getDateFinishSchedule());
            atomicProjectPhase.set(projectPhase);
            atomicDateOrdered.set(Optional.ofNullable(dateOrderedPhase.orElseGet(() -> Optional.ofNullable(projectPhase.getStartDate()).orElseGet(() -> project.getDateStartSchedule()))));
            atomicDatePromised.set(Optional.ofNullable(datePromisedPhase.orElseGet(() -> Optional.ofNullable(projectPhase.getDateDeadline()).orElseGet(() -> project.getDateFinishSchedule()))));
        }
        Timestamp dateOrdered = (Timestamp)((Optional)atomicDateOrdered.get()).orElseThrow(() -> new AdempiereException("@DateStartSchedule@ @NotFound@"));
        Timestamp datePromised = (Timestamp)((Optional)atomicDatePromised.get()).orElseThrow(() -> new AdempiereException("@aDateFinishSchedule@ @NotFound@"));
        MPPOrder order = this.createOrder(project, Optional.ofNullable((MProjectPhase)atomicProjectPhase.get()), Optional.ofNullable((MProjectTask)atomicProjectTask.get()), atomicBOMId.get(), atomicWorkflowId.get(), dateOrdered, datePromised, atomicQuantity.get());
        this.addLog(Msg.parseTranslation(this.getCtx(), "@PP_Order_ID@ ") + order.getDocumentInfo());
        if (this.getProjectLineId() <= 0) {
            MProjectLine projectLine = new MProjectLine(project);
            if (order.getC_ProjectPhase_ID() > 0) {
                projectLine.setC_ProjectPhase_ID(order.getC_ProjectPhase_ID());
            }
            if (order.getC_ProjectTask_ID() > 0) {
                projectLine.setC_ProjectTask_ID(order.getC_ProjectTask_ID());
            }
            projectLine.setM_Product_ID(order.getM_Product_ID());
            projectLine.setPP_Product_BOM_ID(order.getPP_Product_BOM_ID());
            projectLine.setAD_Workflow_ID(order.getAD_Workflow_ID());
            projectLine.setPP_Order_ID(order.getPP_Order_ID());
            projectLine.setPlannedQty(order.getQtyOrdered());
            projectLine.saveEx();
            this.addLog(Msg.parseTranslation(this.getCtx(), "@C_ProjectLine_ID@ ") + projectLine.getM_Product().getName());
        }
        return "@Ok@";
    }

    private MPPOrder createOrder(MProject project, Optional<MProjectPhase> projectPhaseOptional, Optional<MProjectTask> projectTaskOptional, Integer bomId, Integer workflowId, Timestamp dateOrdered, Timestamp datePromised, BigDecimal orderdQuantity) {
        MPPOrder order = new MPPOrder(project, bomId, workflowId);
        order.setDateOrdered(dateOrdered);
        order.setDatePromised(datePromised);
        order.setDateStartSchedule(dateOrdered);
        order.setDateFinishSchedule(datePromised);
        order.setQtyOrdered(orderdQuantity);
        projectPhaseOptional.ifPresent(projectPhase -> {
            order.setC_ProjectPhase_ID(projectPhase.getC_ProjectPhase_ID());
            Optional.ofNullable(projectPhase.getPriorityRule()).ifPresent(priorityRule -> order.setPriorityRule((String)priorityRule));
        });
        projectTaskOptional.ifPresent(projectTask -> {
            order.setC_ProjectTask_ID(projectTask.getC_ProjectTask_ID());
            Optional.ofNullable(projectTask.getPriorityRule()).ifPresent(priorityRule -> order.setPriorityRule((String)priorityRule));
        });
        order.saveEx();
        return order;
    }

    private void validProduct(MProduct product) {
        if (product == null) {
            throw new AdempiereException("@M_Product_ID@ @NotFound@");
        }
        if (product != null && !product.isBOM()) {
            throw new AdempiereException("@M_Product_ID@ @IsBOM@ @NotFound@");
        }
    }
}

