/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_T_BOMLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;
import org.eevolution.manufacturing.process.PrintBOMAbstract;

public class PrintBOM
extends PrintBOMAbstract {
    private int LevelNo = 1;
    private int SeqNo = 0;
    private String levels = new String("....................");

    @Override
    protected String doIt() throws Exception {
        try {
            this.loadBOM();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "PrintBOM", e.toString());
            throw new Exception(e.getLocalizedMessage());
        }
        return "@OK@";
    }

    private void loadBOM() throws Exception {
        block14: {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                int count;
                block13: {
                    ResultSet rs2;
                    CPreparedStatement stmt2;
                    block11: {
                        count = 0;
                        if (this.getProductId() == 0) {
                            this.raiseError("Error: ", "Product ID not found");
                        }
                        X_T_BOMLine tboml = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
                        tboml.setPP_Product_BOM_ID(0);
                        tboml.setPP_Product_BOMLine_ID(0);
                        tboml.setM_Product_ID(this.getProductId());
                        tboml.setSel_Product_ID(this.getProductId());
                        tboml.setImplosion(this.isImplosion());
                        tboml.setLevelNo(0);
                        tboml.setLevels("0");
                        tboml.setSeqNo(0);
                        tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
                        tboml.save();
                        if (!this.isImplosion()) break block13;
                        stmt2 = null;
                        rs2 = null;
                        String sql = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                        try {
                            stmt2 = DB.prepareStatement(sql, this.get_TrxName());
                            stmt2.setInt(1, this.getProductId());
                            rs2 = stmt2.executeQuery();
                            while (rs2.next()) {
                                this.parentImplotion(rs2.getInt(1));
                                ++count;
                            }
                            if (count != 0) break block11;
                            this.raiseError("Error: ", "Product is not a component");
                        }
                        catch (SQLException e) {
                            try {
                                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                                throw new Exception("SQLException: " + e.getLocalizedMessage());
                            }
                            catch (Throwable throwable) {
                                DB.close(rs2, stmt2);
                                rs2 = null;
                                stmt2 = null;
                                throw throwable;
                            }
                        }
                    }
                    DB.close(rs2, stmt2);
                    rs2 = null;
                    stmt2 = null;
                    break block14;
                }
                stmt = null;
                rs = null;
                String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
                try {
                    stmt = DB.prepareStatement(sql, this.get_TrxName());
                    stmt.setInt(1, this.getProductId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.parentExplotion(rs.getInt(1));
                        ++count;
                    }
                    if (count != 0) break block12;
                    this.raiseError("Error: ", "Product is not a BOM");
                }
                catch (SQLException e) {
                    try {
                        this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                        throw new Exception("SQLException: " + e.getLocalizedMessage());
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        rs = null;
                        stmt = null;
                        throw throwable;
                    }
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
    }

    public void parentImplotion(int PP_Product_BOMLine_ID) throws Exception {
        int PP_Product_BOM_ID = 0;
        int M_Product_ID = 0;
        X_T_BOMLine tboml = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
        PP_Product_BOM_ID = DB.getSQLValue(this.get_TrxName(), "SELECT PP_Product_BOM_ID FROM PP_Product_BOMLine WHERE PP_Product_BOMLine_ID=?", PP_Product_BOMLine_ID);
        if (PP_Product_BOM_ID < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        M_Product_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_Product_ID FROM PP_Product_BOM WHERE PP_Product_BOM_ID=?", PP_Product_BOM_ID);
        if (M_Product_ID < 0) {
            throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.parentImplotion()"));
        }
        tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
        tboml.setPP_Product_BOMLine_ID(PP_Product_BOMLine_ID);
        tboml.setM_Product_ID(M_Product_ID);
        tboml.setLevelNo(this.LevelNo);
        tboml.setSel_Product_ID(this.getProductId());
        tboml.setImplosion(this.isImplosion());
        if (this.LevelNo >= 11) {
            tboml.setLevels(this.levels + ">" + this.LevelNo);
        } else if (this.LevelNo >= 1) {
            tboml.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
        }
        tboml.setSeqNo(this.SeqNo);
        tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
        tboml.save();
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT PP_Product_BOM_ID, M_Product_ID FROM PP_Product_BOM WHERE IsActive = 'Y' AND M_Product_ID = ? ";
        try {
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setInt(1, M_Product_ID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++this.SeqNo;
                this.component(rs.getInt(2));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    public void parentExplotion(int PP_Product_BOM_ID) throws Exception {
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT PP_Product_BOMLine_ID, M_Product_ID FROM PP_Product_BOMLine boml WHERE IsActive = 'Y' AND PP_Product_BOM_ID = ? ORDER BY Line ";
        try {
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setInt(1, PP_Product_BOM_ID);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ++this.SeqNo;
                X_T_BOMLine tboml = new X_T_BOMLine(this.getCtx(), 0, this.get_TrxName());
                tboml.setPP_Product_BOM_ID(PP_Product_BOM_ID);
                tboml.setPP_Product_BOMLine_ID(rs.getInt(1));
                tboml.setM_Product_ID(rs.getInt(2));
                tboml.setLevelNo(this.LevelNo);
                tboml.setLevels(this.levels.substring(0, this.LevelNo) + this.LevelNo);
                tboml.setSeqNo(this.SeqNo);
                tboml.setAD_PInstance_ID(this.getAD_PInstance_ID());
                tboml.setSel_Product_ID(this.getProductId());
                tboml.setImplosion(this.isImplosion());
                tboml.save();
                this.component(rs.getInt(2));
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    public void component(int M_Product_ID) throws Exception {
        if (this.isImplosion()) {
            ++this.LevelNo;
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive = 'Y' AND M_Product_ID = ? ";
            try {
                stmt = DB.prepareStatement(sql, this.get_TrxName());
                stmt.setInt(1, M_Product_ID);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    this.parentImplotion(rs.getInt(1));
                }
                rs.close();
                stmt.close();
                --this.LevelNo;
            }
            catch (SQLException e) {
                try {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                    throw new Exception("SQLException: " + e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            return;
        }
        String sql = "SELECT PP_Product_BOM_ID FROM PP_Product_BOM  WHERE IsActive = 'Y' AND Value = ? ";
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String Value2 = DB.getSQLValueString(this.get_TrxName(), "SELECT Value FROM M_PRODUCT WHERE M_PRODUCT_ID=?", M_Product_ID);
            if (Value2 == null) {
                throw new Exception(CLogger.retrieveErrorString("Error: PrintBOM.component()"));
            }
            stmt = DB.prepareStatement(sql, this.get_TrxName());
            stmt.setString(1, Value2);
            rs = stmt.executeQuery();
            boolean level = false;
            while (rs.next()) {
                if (!level) {
                    ++this.LevelNo;
                }
                level = true;
                this.parentExplotion(rs.getInt(1));
                --this.LevelNo;
            }
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, e.getLocalizedMessage() + sql, e);
                throw new Exception("SQLException: " + e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    private void raiseError(String string, String hint) throws Exception {
        Object msg = string;
        ValueNamePair pp = CLogger.retrieveError();
        if (pp != null) {
            msg = pp.getName() + " - ";
        }
        msg = (String)msg + hint;
        throw new Exception((String)msg);
    }
}

