/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.manufacturing.model.MPPMRP;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.process.MRPApprovalAbstract;

public class MRPApproval
extends MRPApprovalAbstract {
    protected String EXECUTION_MODE = "MOP";

    @Override
    protected void prepare() {
        super.prepare();
        int AD_Process_ID = this.getProcessInfo().getAD_Process_ID();
        if (AD_Process_ID == 53322) {
            this.EXECUTION_MODE = "MOP";
        }
        if (AD_Process_ID == 53323) {
            this.EXECUTION_MODE = "DOO";
        }
        if (AD_Process_ID == 53321) {
            this.EXECUTION_MODE = "POR";
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.getSelectionKeys().stream().filter(mrpId -> mrpId > 0).forEach(mrpId -> {
            MPPMRP mrp = new MPPMRP(this.getCtx(), (int)mrpId, this.get_TrxName());
            this.saveBrowseValues(mrp, "MRP");
            if (this.getPriorityRule() != null) {
                mrp.setPriority(this.getPriorityRule());
            }
            if (this.getOrderType() != null && !mrp.getOrderType().equals(this.getOrderType())) {
                this.createSupply(mrp, this.getOrderType());
            } else {
                if (this.EXECUTION_MODE.equals("MOP")) {
                    this.executeManufacturingOrderApproval(mrp);
                }
                if (this.EXECUTION_MODE.equals("DOO")) {
                    this.executeDistributionOrderApproval(mrp);
                }
                if (this.EXECUTION_MODE.equals("POR")) {
                    if (this.getBPartnerId() > 0) {
                        mrp.setC_BPartner_ID(this.getBPartnerId());
                    }
                    this.executeRequisitionApproval(mrp);
                }
            }
        });
        return null;
    }

    private void createSupply(MPPMRP mrp, String orderType) {
        PO order;
        PO document = null;
        if ("POR".equals(orderType)) {
            if (this.getBPartnerId() <= 0) {
                throw new AdempiereException("@BPartnerNotFound@");
            }
            document = this.createRequisition(mrp);
        }
        if ("MOP".equals(orderType) && this.getResourceId() > 0 && this.getProductBOMId() > 0 && this.getWorkflowId() > 0) {
            document = this.createManufacturingOrder(mrp);
        }
        if ("DOO".equals(orderType) && this.getWarehouseId() > 0 && this.getShipperId() > 0 && this.getLocatorId() > 0 && this.getLocatorToId() > 0 && this.getBPartnerId() > 0) {
            document = this.createDistributionOrder(mrp);
        }
        if ("POR".equals(mrp.getOrderType()) && document != null && document.get_ID() > 0) {
            MRequisition requisition = (MRequisition)mrp.getM_Requisition();
            requisition.deleteEx(true);
        }
        if ("MOP".equals(mrp.getOrderType()) && document != null && document.get_ID() > 0) {
            order = (MPPOrder)mrp.getPP_Order();
            order.deleteEx(true);
        }
        if ("DOO".equals(mrp.getOrderType()) && document != null && document.get_ID() > 0) {
            order = new MDDOrder(mrp.getCtx(), mrp.getDD_Order_ID(), mrp.get_TrxName());
            order.deleteEx(true);
        }
    }

    private MDDOrder createDistributionOrder(MPPMRP mrp) {
        MLocator locatorFrom = MLocator.get(mrp.getCtx(), this.getLocatorId());
        MLocator locatorTo = MLocator.get(mrp.getCtx(), this.getLocatorToId());
        int docTypeId = MPPMRP.getDocType(this.getCtx(), "DOO", locatorTo.getAD_Org_ID(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        MBPartner partner = MBPartner.get(mrp.getCtx(), this.getBPartnerId());
        MDDOrder order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
        order.setAD_Org_ID(mrp.getAD_Org_ID());
        order.addDescription("Generated by MRP");
        order.setC_BPartner_ID(this.getBPartnerId());
        order.setAD_User_ID(partner.getPrimaryAD_User_ID());
        order.setC_DocType_ID(docTypeId);
        order.setM_Warehouse_ID(this.getWarehouseId());
        if (this.getReferenceNo() != null) {
            order.setPOReference(this.getReferenceNo());
        }
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(mrp.getDateFinishSchedule());
        order.setDatePromised(mrp.getDatePromised());
        order.setM_Shipper_ID(this.getShipperId());
        if (this.getPriorityRule() != null) {
            order.setPriorityRule(this.getPriorityRule());
        }
        order.setIsInDispute(false);
        order.setIsInTransit(false);
        order.setSalesRep_ID(mrp.getPlanner_ID());
        order.saveEx();
        MDDOrderLine orderLine = new MDDOrderLine(this.getCtx(), 0, this.get_TrxName());
        orderLine.setDD_Order_ID(order.getDD_Order_ID());
        orderLine.setAD_Org_ID(locatorTo.getAD_Org_ID());
        orderLine.setM_Locator_ID(locatorFrom.getM_Locator_ID());
        orderLine.setM_LocatorTo_ID(locatorTo.getM_Locator_ID());
        orderLine.setM_Product_ID(mrp.getM_Product_ID());
        orderLine.setDateOrdered(order.getDateOrdered());
        orderLine.setDatePromised(mrp.getDatePromised());
        orderLine.setQtyEntered(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "MRP_Qty"));
        orderLine.setQtyOrdered(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "MRP_Qty"));
        orderLine.setConfirmedQty(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "DL_ConfirmedQty"));
        orderLine.setTargetQty(MPPMRP.getQtyReserved(this.getCtx(), locatorTo.getM_Warehouse_ID(), mrp.getM_Product_ID(), mrp.getDateStartSchedule(), this.get_TrxName()));
        orderLine.setIsInvoiced(false);
        orderLine.saveEx();
        order.processIt("PR");
        order.saveEx();
        return order;
    }

    private MRequisition createRequisition(MPPMRP mrp) {
        if ("MOP".equals(mrp.getOrderType())) {
            int docTypeId = MPPMRP.getDocType(this.getCtx(), "POR", mrp.getAD_Org_ID(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
            int priceListId = -1;
            String sql = "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?";
            priceListId = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", this.getBPartnerId());
            MRequisition requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
            requisition.setAD_Org_ID(mrp.getAD_Org_ID());
            requisition.setAD_User_ID(mrp.getPlanner_ID());
            requisition.setDateDoc(mrp.getDateStartSchedule());
            requisition.setDateRequired(mrp.getDatePromised());
            requisition.setM_Warehouse_ID(mrp.getM_Warehouse_ID());
            requisition.setC_DocType_ID(docTypeId);
            if (priceListId > 0) {
                requisition.setM_PriceList_ID(priceListId);
            }
            requisition.saveEx();
            MRequisitionLine requisitionLine = new MRequisitionLine(requisition);
            requisitionLine.setLine(10);
            requisitionLine.setAD_Org_ID(mrp.getAD_Org_ID());
            requisitionLine.setC_BPartner_ID(mrp.getC_BPartner_ID());
            requisitionLine.setM_Product_ID(mrp.getM_Product_ID());
            requisitionLine.setPrice();
            if (this.getReferenceNo() != null) {
                requisitionLine.setDescription(this.getReferenceNo());
            }
            requisitionLine.setPriceActual(Env.ZERO);
            requisitionLine.setQty(mrp.getQty());
            requisitionLine.saveEx();
            requisition.processIt("PR");
            requisition.saveEx();
            return requisition;
        }
        return null;
    }

    private MPPOrder createManufacturingOrder(MPPMRP mrp) {
        int docTypeId = MPPMRP.getDocType(this.getCtx(), "MOP", mrp.getAD_Org_ID(), mrp.getPlanner_ID(), this.get_TrxName());
        MPPOrder order = new MPPOrder(this.getCtx(), 0, this.get_TrxName());
        if (this.getReferenceNo() != null) {
            order.addDescription(this.getReferenceNo());
        }
        order.setAD_Org_ID(mrp.getAD_Org_ID());
        order.setLine(10);
        order.setC_DocTypeTarget_ID(docTypeId);
        order.setC_DocType_ID(docTypeId);
        if (this.getPriorityRule() != null) {
            order.setPriorityRule(this.getPriorityRule());
        }
        order.setS_Resource_ID(this.getResourceId());
        order.setM_Warehouse_ID(mrp.getM_Warehouse_ID());
        order.setM_Product_ID(mrp.getM_Product_ID());
        order.setM_AttributeSetInstance_ID(0);
        order.setPP_Product_BOM_ID(this.getProductBOMId());
        order.setAD_Workflow_ID(this.getWorkflowId());
        order.setPlanner_ID(mrp.getPlanner_ID());
        order.setDateOrdered(mrp.getDateOrdered());
        order.setDatePromised(mrp.getDatePromised());
        order.setDateStartSchedule(mrp.getDateStartSchedule());
        order.setDateFinishSchedule(mrp.getDateFinishSchedule());
        order.setQty(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "MRP_Qty"));
        order.setC_UOM_ID(mrp.getM_Product().getC_UOM_ID());
        order.setYield(Env.ZERO);
        order.setScheduleType("D");
        order.setPriorityRule("5");
        order.setDocAction("CO");
        order.saveEx();
        order.processIt("PR");
        order.saveEx();
        return order;
    }

    private void executeRequisitionApproval(MPPMRP mrp) {
        MRequisition requisition = (MRequisition)mrp.getM_Requisition();
        Timestamp dateRequired = this.getSelectionAsTimestamp(mrp.getPP_MRP_ID(), "R_DateRequired");
        if (dateRequired != null) {
            requisition.setDateRequired(dateRequired);
        }
        if (mrp.is_Changed()) {
            // empty if block
        }
        this.validateChanges(mrp, "Priority", requisition, "PriorityRule");
        requisition.saveEx();
        MRequisitionLine requisitionLine = (MRequisitionLine)mrp.getM_RequisitionLine();
        this.validateChanges(mrp, "C_BPartner_ID", requisitionLine, "C_BPartner_ID");
        this.validateChanges(mrp, "Qty", requisitionLine, "Qty");
        requisitionLine.saveEx();
        requisition.processIt("PR");
        requisition.saveEx();
    }

    private void executeDistributionOrderApproval(MPPMRP mrp) {
        MDDOrder order = new MDDOrder(mrp.getCtx(), mrp.getDD_Order_ID(), mrp.get_TrxName());
        if (mrp.is_Changed()) {
            this.validateChanges(mrp, "Priority", order, "PriorityRule");
            order.saveEx();
            MDDOrderLine orderLine = new MDDOrderLine(mrp.getCtx(), mrp.getDD_OrderLine_ID(), mrp.get_TrxName());
            orderLine.setQty(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "MRP_Qty"));
            Timestamp datePromised = this.getSelectionAsTimestamp(mrp.getPP_MRP_ID(), "DatePromised");
            if (datePromised != null) {
                orderLine.setDatePromised(datePromised);
            }
            orderLine.saveEx();
        }
        if (this.getShipperId() > 0) {
            order.setM_Shipper_ID(this.getShipperId());
        }
        order.processIt("PR");
        order.saveEx();
    }

    private void executeManufacturingOrderApproval(MPPMRP mrp) {
        boolean createMO = false;
        if (this.getProductBOMId() > 0) {
            createMO = true;
        }
        if (this.getWorkflowId() > 0) {
            createMO = true;
        }
        MPPOrder currentMfgOrder = (MPPOrder)mrp.getPP_Order();
        if (createMO) {
            MPPOrder newMfgOrder = new MPPOrder(mrp.getCtx(), 0, this.get_TrxName());
            PO.copyValues(currentMfgOrder, newMfgOrder);
            if (this.getProductBOMId() > 0) {
                newMfgOrder.setPP_Product_BOM_ID(this.getProductBOMId());
            }
            if (this.getWorkflowId() > 0) {
                newMfgOrder.setAD_Workflow_ID(this.getWorkflowId());
            }
            newMfgOrder.saveEx();
            currentMfgOrder.deleteEx(true);
            currentMfgOrder = newMfgOrder;
        }
        if (mrp.is_Changed()) {
            this.validateChanges(mrp, "Priority", currentMfgOrder, "PriorityRule");
            this.validateChanges(mrp, "DateStartSchedule", currentMfgOrder, "DateStartSchedule");
            this.validateChanges(mrp, "DatePromised", currentMfgOrder, "DatePromised");
            currentMfgOrder.setQty(this.getSelectionAsBigDecimal(mrp.getPP_MRP_ID(), "MRP_Qty"));
            currentMfgOrder.saveEx();
        }
        currentMfgOrder.processIt("PR");
        currentMfgOrder.saveEx();
    }

    private void saveBrowseValues(PO po, String alias) {
        LinkedHashMap<String, Object> values = this.getSelectionValues().get(po.get_ID());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String columnName = entry.getKey();
            if (!columnName.contains(alias.toUpperCase() + "_")) continue;
            columnName = columnName.substring(columnName.indexOf("_") + 1);
            po.set_ValueOfColumn(columnName, entry.getValue());
        }
    }

    private void validateChanges(MPPMRP mrp, String columnSource, PO po, String columnTarget) {
        if (mrp.is_ValueChanged(columnSource)) {
            po.set_ValueOfColumn(columnTarget, mrp.get_Value(columnSource));
        }
    }
}

