/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.eevolution.manufacturing.model.MPPProductPlanning;

public class CreateProductPlanning
extends SvrProcess {
    private int productCategoryId = 0;
    private int warehouseId = 0;
    private int resourceId = 0;
    private int plannerId = 0;
    private BigDecimal deliveryTimePromised = Env.ZERO;
    private int networkDistributionId = 0;
    private int workflowId = 0;
    private BigDecimal timeFence = Env.ZERO;
    private boolean createPlan = false;
    private boolean isMPS = false;
    private String orderPolicy = "";
    private BigDecimal orderPeriod = Env.ZERO;
    private BigDecimal transferTime = Env.ZERO;
    private BigDecimal safetyStock = Env.ZERO;
    private BigDecimal orderMin = Env.ZERO;
    private BigDecimal orderMax = Env.ZERO;
    private BigDecimal orderPack = Env.ZERO;
    private BigDecimal orderQty = Env.ZERO;
    private BigDecimal workingTime = Env.ZERO;
    private int yield = 0;
    private int orgId = 0;
    private int clientId = 0;
    private int countCreated = 0;
    private int countUpdated = 0;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if ("M_Product_Category_ID".equals(name)) {
                this.productCategoryId = para.getParameterAsInt();
                continue;
            }
            if ("M_Warehouse_ID".equals(name)) {
                this.warehouseId = para.getParameterAsInt();
                continue;
            }
            if ("S_Resource_ID".equals(name)) {
                this.resourceId = para.getParameterAsInt();
                continue;
            }
            if ("IsCreatePlan".equals(name)) {
                this.createPlan = para.getParameterAsBoolean();
                continue;
            }
            if ("IsMPS".equals(name)) {
                this.isMPS = para.getParameterAsBoolean();
                continue;
            }
            if ("DD_NetworkDistribution_ID".equals(name)) {
                this.networkDistributionId = para.getParameterAsInt();
                continue;
            }
            if ("AD_Workflow_ID".equals(name)) {
                this.workflowId = para.getParameterAsInt();
                continue;
            }
            if ("TimeFence".equals(name)) {
                this.timeFence = para.getParameterAsBigDecimal();
                continue;
            }
            if ("TransferTime".equals(name)) {
                this.transferTime = para.getParameterAsBigDecimal();
                continue;
            }
            if ("SafetyStock".equals(name)) {
                this.safetyStock = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Min".equals(name)) {
                this.orderMin = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Max".equals(name)) {
                this.orderMax = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Pack".equals(name)) {
                this.orderPack = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Qty".equals(name)) {
                this.orderQty = para.getParameterAsBigDecimal();
                continue;
            }
            if ("WorkingTime".equals(name)) {
                this.workingTime = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Yield".equals(name)) {
                this.yield = para.getParameterAsInt();
                continue;
            }
            if ("DeliveryTime_Promised".equals(name)) {
                this.deliveryTimePromised = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Period".equals(name)) {
                this.orderPeriod = para.getParameterAsBigDecimal();
                continue;
            }
            if ("Order_Policy".equals(name)) {
                this.orderPolicy = para.getParameterAsString();
                continue;
            }
            if ("Planner_ID".equals(name)) {
                this.plannerId = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.clientId = Env.getAD_Client_ID(this.getCtx());
        if (this.warehouseId > 0) {
            MWarehouse warehouse = MWarehouse.get(this.getCtx(), this.warehouseId);
            this.orgId = warehouse.getAD_Org_ID();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (int productId : this.getProductIds(this.clientId)) {
            this.createPlanning(productId);
        }
        return " @Created@ # " + this.countCreated + " @Updated@ # " + this.countUpdated;
    }

    private int[] getProductIds(int clientId) {
        return new Query(this.getCtx(), "M_Product", "AD_Client_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(clientId).getIDs();
    }

    private void createPlanning(int productId) {
        boolean isNew;
        MPPProductPlanning productPlanning = MPPProductPlanning.get(this.getCtx(), this.clientId, this.orgId, this.warehouseId, this.resourceId, productId, this.get_TrxName());
        boolean bl = isNew = productPlanning == null;
        if (productPlanning == null) {
            productPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
            productPlanning.setAD_Org_ID(this.orgId);
            productPlanning.setM_Warehouse_ID(this.warehouseId);
            productPlanning.setS_Resource_ID(this.resourceId);
            productPlanning.setM_Product_ID(productId);
        }
        productPlanning.setDD_NetworkDistribution_ID(this.networkDistributionId);
        productPlanning.setAD_Workflow_ID(this.workflowId);
        productPlanning.setIsCreatePlan(this.createPlan);
        productPlanning.setIsMPS(this.isMPS);
        productPlanning.setIsRequiredMRP(true);
        productPlanning.setIsRequiredDRP(true);
        productPlanning.setDeliveryTime_Promised(this.deliveryTimePromised);
        productPlanning.setOrder_Period(this.orderPeriod);
        productPlanning.setPlanner_ID(this.plannerId);
        productPlanning.setOrder_Policy(this.orderPolicy);
        productPlanning.setSafetyStock(this.safetyStock);
        productPlanning.setOrder_Qty(this.orderQty);
        productPlanning.setOrder_Min(this.orderMin);
        productPlanning.setOrder_Max(this.orderMax);
        productPlanning.setOrder_Pack(this.orderPack);
        productPlanning.setTimeFence(this.timeFence);
        productPlanning.setTransferTime(this.transferTime);
        productPlanning.setIsPhantom(false);
        productPlanning.setWorkingTime(this.workingTime);
        productPlanning.setYield(this.yield);
        productPlanning.saveEx();
        if (isNew) {
            ++this.countCreated;
        } else {
            ++this.countUpdated;
        }
    }
}

