/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MProduct;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

class ProductLowLevelCalculator {
    private Hashtable<Integer, Integer> tableproduct = new Hashtable();
    private Properties m_ctx = null;
    private String m_trxName = null;

    public ProductLowLevelCalculator(Properties ctx, String trxName) {
        this.m_ctx = ctx;
        this.m_trxName = trxName;
    }

    public int getLowLevel(int M_Product_ID) {
        int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
        this.tableproduct.clear();
        DefaultMutableTreeNode ibom = null;
        this.tableproduct.put(M_Product_ID, 0);
        ibom = this.iparent(AD_Client_ID, M_Product_ID, 0);
        return ibom.getDepth();
    }

    private DefaultMutableTreeNode iparent(int AD_Client_ID, int M_Product_ID, int PP_Product_BOM_ID) {
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(Integer.toString(M_Product_ID) + "|" + Integer.toString(PP_Product_BOM_ID));
        String sql = "SELECT PP_Product_BOMLine_ID FROM PP_Product_BOMLine WHERE IsActive=? AND AD_Client_ID=? AND M_Product_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.m_trxName);
            DB.setParameters((PreparedStatement)pstmt, new Object[]{true, AD_Client_ID, M_Product_ID});
            rs = pstmt.executeQuery();
            while (rs.next()) {
                DefaultMutableTreeNode bom;
                if (rs.getRow() > 1) {
                    this.tableproduct.clear();
                    this.tableproduct.put(M_Product_ID, PP_Product_BOM_ID);
                }
                if ((bom = this.icomponent(AD_Client_ID, rs.getInt(1), M_Product_ID, parent)) == null) continue;
                parent.add(bom);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return parent;
    }

    private DefaultMutableTreeNode icomponent(int AD_Client_ID, int PP_Product_BOMLine_ID, int M_Product_ID, DefaultMutableTreeNode bom) {
        String sql = "SELECT pbom.M_Product_ID , pbom.Value , pbom.PP_Product_BOM_ID FROM  PP_Product_BOMLine pboml INNER JOIN PP_Product_BOM pbom ON (pbom.PP_Product_BOM_ID = pboml.PP_Product_BOM_ID) WHERE pbom.IsActive=? AND pboml.IsActive=? AND pboml.AD_Client_ID=? AND pboml.PP_Product_BOMLine_ID=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement("SELECT pbom.M_Product_ID , pbom.Value , pbom.PP_Product_BOM_ID FROM  PP_Product_BOMLine pboml INNER JOIN PP_Product_BOM pbom ON (pbom.PP_Product_BOM_ID = pboml.PP_Product_BOM_ID) WHERE pbom.IsActive=? AND pboml.IsActive=? AND pboml.AD_Client_ID=? AND pboml.PP_Product_BOMLine_ID=? ", this.m_trxName);
            DB.setParameters((PreparedStatement)pstmt, new Object[]{true, true, AD_Client_ID, PP_Product_BOMLine_ID});
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (M_Product_ID != rs.getInt(1)) {
                    if (!this.tableproduct(rs.getInt(1), rs.getInt(3))) {
                        bom.add(this.iparent(AD_Client_ID, rs.getInt(1), rs.getInt(3)));
                        continue;
                    }
                    throw new AdempiereException("Cycle BOM & Formula:" + rs.getString(2) + "(" + rs.getString(3) + ")");
                }
                MProduct product = MProduct.get(this.m_ctx, M_Product_ID);
                throw new AdempiereException("Cycle BOM & Formula:" + rs.getString(2) + "(" + rs.getString(3) + ") - Component: " + product.getValue() + "(" + product.getM_Product_ID() + ")");
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, "SELECT pbom.M_Product_ID , pbom.Value , pbom.PP_Product_BOM_ID FROM  PP_Product_BOMLine pboml INNER JOIN PP_Product_BOM pbom ON (pbom.PP_Product_BOM_ID = pboml.PP_Product_BOM_ID) WHERE pbom.IsActive=? AND pboml.IsActive=? AND pboml.AD_Client_ID=? AND pboml.PP_Product_BOMLine_ID=? ");
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return null;
    }

    private boolean tableproduct(int M_Product_ID, int PP_Product_BOM_ID) {
        if (this.tableproduct.containsKey(M_Product_ID)) {
            return true;
        }
        this.tableproduct.put(M_Product_ID, PP_Product_BOM_ID);
        return false;
    }
}

