/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.engine.forecast;

import java.util.HashMap;
import org.eevolution.manufacturing.engine.forecast.DoubleExponentialSmoothing;
import org.eevolution.manufacturing.engine.forecast.ForecastEngine;
import org.eevolution.manufacturing.engine.forecast.ForecastRule;

public class ForecastFactory {
    private static final HashMap<Integer, ForecastEngine> s_engines = new HashMap();

    public static ForecastRule createForecastRule(String name) {
        DoubleExponentialSmoothing rule = null;
        if ("DoubleExponentialSmoothing".equals(name)) {
            rule = new DoubleExponentialSmoothing();
        }
        return rule;
    }

    public static ForecastEngine getForecastEngine(int AD_Client_ID) {
        ForecastEngine engine = s_engines.get(AD_Client_ID);
        if (engine == null && AD_Client_ID > 0) {
            engine = s_engines.get(0);
        }
        if (engine == null) {
            engine = new ForecastEngine();
            s_engines.put(AD_Client_ID, engine);
        }
        return engine;
    }

    public static void registerForecastEngine(int AD_Client_ID, ForecastEngine engine) {
        s_engines.put(AD_Client_ID, engine);
    }
}

