/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.manufacturing.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.core.domains.models.I_M_CostElement;
import org.adempiere.core.domains.models.I_PP_Order;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.acct.DocLine_CostCollector;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class Doc_PPCostCollector
extends Doc {
    protected DocLine_CostCollector docLineCostCollector = null;
    protected MPPCostCollector costCollector = null;
    protected I_PP_Order manufacturingOrder = null;
    protected RoutingService routingService = null;
    private List<MCostDetail> costDetails = null;

    public Doc_PPCostCollector(MAcctSchema[] acctSchemas, ResultSet rs, String trxName) {
        super(acctSchemas, MPPCostCollector.class, rs, "MCC", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.costCollector = (MPPCostCollector)this.getPO();
        this.manufacturingOrder = this.costCollector.getPP_Order();
        this.setDateDoc(this.costCollector.getMovementDate());
        this.setDateAcct(this.costCollector.getMovementDate());
        this.docLineCostCollector = new DocLine_CostCollector(this.costCollector, this);
        this.docLineCostCollector.setQty(this.costCollector.getMovementQty(), false);
        if (this.docLineCostCollector.getM_Product_ID() == 0) {
            this.log.warning(this.docLineCostCollector.toString() + " - No Product");
        }
        this.log.fine(this.docLineCostCollector.toString());
        this.routingService = RoutingServiceFactory.get().getRoutingService(this.costCollector.getAD_Client_ID());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        this.setC_Currency_ID(as.getC_Currency_ID());
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if ("100".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createMaterialReceipt(as));
        } else if ("110".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createComponentIssue(as));
        } else if ("130".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createVariance(as, 12));
        } else if ("120".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createVariance(as, 13));
        } else if ("120".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createVariance(as, 13));
        } else if ("140".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createVariance(as, 14));
        } else if ("150".equals(this.costCollector.getCostCollectorType())) {
            facts.add(this.createVariance(as, 15));
        } else if ("160".equals(this.costCollector.getCostCollectorType())) {
            facts.addAll(this.createActivityControl(as));
        }
        return facts;
    }

    protected void createLines(MCostElement element, MAcctSchema acctSchema, Fact fact, MProduct product, MAccount debit, MAccount credit, BigDecimal cost, BigDecimal qty) {
        if (cost == null || debit == null || credit == null) {
            return;
        }
        this.log.info("CostElement: " + element + "Product: " + product.getName() + " Debit: " + debit.getDescription() + " Credit: " + credit.getDescription() + " Cost: " + cost + " Qty: " + qty);
        FactLine debitLine = null;
        FactLine creditLine = null;
        if (cost.signum() != 0) {
            debitLine = fact.createLine((DocLine)this.docLineCostCollector, debit, acctSchema.getC_Currency_ID(), cost, null);
            debitLine.setQty(qty);
            String desc = this.manufacturingOrder.getDocumentNo() + " - " + this.costCollector.getS_Resource().getName() + "- " + element.getName();
            debitLine.addDescription(desc);
            debitLine.setC_Project_ID(this.costCollector.getC_Project_ID());
            debitLine.setC_Activity_ID(this.costCollector.getC_Activity_ID());
            debitLine.setC_Campaign_ID(this.costCollector.getC_Campaign_ID());
            debitLine.setM_Locator_ID(this.costCollector.getM_Locator_ID());
            creditLine = fact.createLine((DocLine)this.docLineCostCollector, credit, acctSchema.getC_Currency_ID(), null, cost);
            creditLine.setQty(qty);
            creditLine.addDescription(desc);
            creditLine.setC_Project_ID(this.costCollector.getC_Project_ID());
            creditLine.setC_Activity_ID(this.costCollector.getC_Activity_ID());
            creditLine.setC_Campaign_ID(this.costCollector.getC_Campaign_ID());
            creditLine.setM_Locator_ID(this.costCollector.getM_Locator_ID());
        }
    }

    protected Fact createMaterialReceipt(MAcctSchema acctSchema) {
        Fact fact = new Fact(this, acctSchema, "A");
        FactLine debitLine = null;
        FactLine creditLine = null;
        MAccount workInProcessAccount = this.docLineCostCollector.getAccount(11, acctSchema);
        MAccount burdenAccount = this.docLineCostCollector.getAccount(19, acctSchema);
        MAccount inventoryAccount = this.docLineCostCollector.getAccount(3, acctSchema);
        BigDecimal totalcosts = BigDecimal.ZERO;
        BigDecimal totalcostsScrapped = BigDecimal.ZERO;
        for (MCostDetail costDetail : this.docLineCostCollector.getCostDetail(acctSchema, true)) {
            BigDecimal cost;
            BigDecimal absoluteCost;
            MCostElement costElement = MCostElement.get(this.getCtx(), costDetail.getM_CostElement_ID());
            String description = this.manufacturingOrder.getDocumentNo() + " - " + costDetail.getM_CostType().getName() + " - " + costElement.getName();
            if ("B".equals(costElement.getCostElementType())) {
                absoluteCost = MCostDetail.getTotalCost(costDetail, acctSchema);
                if (absoluteCost.signum() == 0) continue;
                BigDecimal bigDecimal = cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost;
                if (cost.scale() > acctSchema.getStdPrecision()) {
                    cost = cost.setScale(acctSchema.getStdPrecision(), RoundingMode.HALF_UP);
                }
                if (cost.compareTo(Env.ZERO) == 0) continue;
                creditLine = fact.createLine((DocLine)this.docLineCostCollector, burdenAccount, acctSchema.getC_Currency_ID(), null, cost);
                creditLine.setQty(this.costCollector.getMovementQty());
                creditLine.setDescription(description);
                totalcosts = totalcosts.add(cost);
                continue;
            }
            if (this.costCollector.getMovementQty().signum() != 0) {
                absoluteCost = MCostDetail.getTotalCost(costDetail, acctSchema);
                if (absoluteCost.signum() == 0) continue;
                BigDecimal bigDecimal = cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost;
                if (cost.scale() > acctSchema.getStdPrecision()) {
                    cost = cost.setScale(acctSchema.getStdPrecision(), RoundingMode.HALF_UP);
                }
                if (cost.compareTo(Env.ZERO) == 0) continue;
                creditLine = fact.createLine(this.docLineCostCollector, workInProcessAccount, acctSchema.getC_Currency_ID(), cost.negate());
                creditLine.setQty(this.costCollector.getMovementQty());
                creditLine.setDescription(description);
                totalcosts = totalcosts.add(cost);
            }
            if (this.costCollector.getScrappedQty().signum() == 0) continue;
            absoluteCost = costDetail.getPrice().multiply(this.costCollector.getScrappedQty()).add(MCostDetail.getTotalCost(costDetail, acctSchema));
            if (absoluteCost.signum() == 0) continue;
            BigDecimal bigDecimal = cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost;
            if (cost.scale() > acctSchema.getStdPrecision()) {
                cost = cost.setScale(acctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            creditLine = fact.createLine((DocLine)this.docLineCostCollector, workInProcessAccount, acctSchema.getC_Currency_ID(), null, cost.negate());
            creditLine.setQty(this.costCollector.getMovementQty());
            description = this.manufacturingOrder.getDocumentNo() + " - " + costDetail.getM_CostType().getName() + " - " + costElement.getName() + " - " + Msg.parseTranslation(this.getCtx(), "@Scrap@");
            creditLine.setDescription(description);
            totalcostsScrapped = totalcostsScrapped.add(cost);
        }
        String description = this.manufacturingOrder.getDocumentNo();
        debitLine = fact.createLine(this.docLineCostCollector, inventoryAccount, acctSchema.getC_Currency_ID(), totalcosts);
        debitLine.setQty(this.costCollector.getMovementQty());
        debitLine.setDescription(description);
        if (totalcostsScrapped.compareTo(Env.ZERO) != 0) {
            debitLine = fact.createLine(this.docLineCostCollector, inventoryAccount, acctSchema.getC_Currency_ID(), totalcostsScrapped);
            debitLine.setQty(this.costCollector.getScrappedQty());
            description = Msg.parseTranslation(this.getCtx(), "@Scrap@");
            debitLine.setDescription(description);
        }
        return fact;
    }

    protected Fact createComponentIssue(MAcctSchema acctSchema) {
        Fact fact = new Fact(this, acctSchema, "A");
        BigDecimal totalCost = Env.ZERO;
        FactLine debitLine = null;
        FactLine creditLine = null;
        MAccount workInProcessAccount = this.docLineCostCollector.getAccount(11, acctSchema);
        MAccount inventoryAccount = this.docLineCostCollector.getAccount(3, acctSchema);
        if (this.costCollector.isFloorStock()) {
            inventoryAccount = this.docLineCostCollector.getAccount(16, acctSchema);
        }
        for (MCostDetail costDetail : this.docLineCostCollector.getCostDetail(acctSchema, false)) {
            BigDecimal cost;
            BigDecimal absoluteCost = MCostDetail.getTotalCost(costDetail, acctSchema);
            if (absoluteCost.signum() == 0 || (cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost).compareTo(Env.ZERO) == 0) continue;
            if (cost.scale() > acctSchema.getStdPrecision()) {
                cost = cost.setScale(acctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            debitLine = fact.createLine(this.docLineCostCollector, workInProcessAccount, acctSchema.getC_Currency_ID(), cost.negate());
            I_M_CostElement costElement = costDetail.getM_CostElement();
            String description = this.manufacturingOrder.getDocumentNo() + " - " + costDetail.getM_CostType().getName() + " - " + costElement.getName();
            debitLine.setDescription(description);
            totalCost = totalCost.add(cost);
        }
        String description = this.manufacturingOrder.getDocumentNo();
        creditLine = fact.createLine(this.docLineCostCollector, inventoryAccount, acctSchema.getC_Currency_ID(), totalCost);
        creditLine.setDescription(description);
        return fact;
    }

    protected List<Fact> createActivityControl(MAcctSchema acctSchema) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, acctSchema, "A");
        facts.add(fact);
        MProduct product = this.costCollector.getM_Product();
        MAccount workInProcessAccount = this.docLineCostCollector.getAccount(11, acctSchema);
        for (MCostDetail costDetail : this.getCostDetailsActivityControl()) {
            BigDecimal absoluteCost = MCostDetail.getTotalCost(costDetail, acctSchema);
            if (absoluteCost.signum() == 0) continue;
            BigDecimal cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost;
            MCostElement costElement = MCostElement.get(this.getCtx(), costDetail.getM_CostElement_ID());
            MAccount creditCostAccount = this.docLineCostCollector.getAccount(acctSchema, costElement);
            this.createLines(costElement, acctSchema, fact, product, workInProcessAccount, creditCostAccount, cost, this.costCollector.getMovementQty());
        }
        return facts;
    }

    protected Fact createVariance(MAcctSchema acctSchema, int varianceAcctType) {
        Fact fact = new Fact(this, acctSchema, "A");
        MProduct product = this.costCollector.getM_Product();
        MAccount varianceAccount = this.docLineCostCollector.getAccount(varianceAcctType, acctSchema);
        MAccount workInProcess = this.docLineCostCollector.getAccount(11, acctSchema);
        for (MCostDetail costDetail : this.docLineCostCollector.getCostDetail(acctSchema, false)) {
            BigDecimal cost;
            MCostElement costElement = MCostElement.get(this.getCtx(), costDetail.getM_CostElement_ID());
            BigDecimal absoluteCost = MCostDetail.getTotalCost(costDetail, acctSchema);
            if (absoluteCost.signum() == 0) continue;
            BigDecimal bigDecimal = cost = costDetail.getQty().signum() < 0 ? absoluteCost.negate() : absoluteCost;
            if (cost == null) {
                cost = BigDecimal.ZERO;
            }
            if (cost.scale() > acctSchema.getStdPrecision()) {
                cost = cost.setScale(acctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            BigDecimal qty = costDetail.getQty();
            this.createLines(costElement, acctSchema, fact, product, varianceAccount, workInProcess, cost, qty);
        }
        return fact;
    }

    private List<MCostDetail> getCostDetailsActivityControl() {
        if (this.costDetails == null) {
            String whereClause = "PP_Cost_Collector_ID=? AND EXISTS(SELECT 1 FROM M_CostElement ce WHERE ce.M_CostElement_ID = M_CostDetail.M_CostElement_ID AND ce.CostElementType IN('R','O'))";
            this.costDetails = new Query(this.getCtx(), "M_CostDetail", whereClause, this.getTrxName()).setParameters(this.costCollector.getPP_Cost_Collector_ID()).setOrderBy("M_CostDetail_ID").list();
        }
        return this.costDetails;
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }
}

