/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class PayrollViaEMail
extends SvrProcess {
    private int mailTextId = -1;
    private MMailText mailText = null;
    private int bPartnerId = -1;
    private MClient client = null;
    private MBPartner employee = null;
    private int m_counter = 0;
    private int m_errors = 0;
    private int payrollProcessId = -1;
    private int bPartnerGroupId = -1;
    private int reportProcessId = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) {
                this.log.fine("Null parameter: " + string);
                continue;
            }
            if (string.equals("HR_Process_ID")) {
                this.payrollProcessId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("R_MailText_ID")) {
                this.mailTextId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BP_Group_ID")) {
                this.bPartnerGroupId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BPartner_ID")) {
                this.bPartnerId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("AD_Process_ID")) {
                this.reportProcessId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.mailTextId);
        this.mailText = new MMailText(this.getCtx(), this.mailTextId, this.get_TrxName());
        if (this.mailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.mailTextId + " @NotFound@ ");
        }
        this.client = MClient.get(this.getCtx());
        if (this.client.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (this.client.getSMTPHost() == null || this.client.getSMTPHost().length() == 0) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long l = System.currentTimeMillis();
        if (this.bPartnerId > 0) {
            this.employee = new MBPartner(this.getCtx(), this.bPartnerId, this.get_TrxName());
            if (this.employee == null) {
                throw new Exception("@C_BPartner_ID@=" + this.bPartnerId + " @NotFound@");
            }
            this.sendIndividualMail(this.bPartnerId, null);
        } else {
            this.sendBPGroup();
        }
        this.log.fine("From " + this.employee);
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - l) + "ms";
    }

    private void sendBPGroup() {
        int[] nArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsActive").append("=? AND ").append("IsEmployee").append("=? AND ").append("EXISTS (SELECT 1 FROM HR_Movement m WHERE m.C_BPartner_ID=C_BPartner.C_BPartner_ID AND m.HR_Process_ID=?)");
        arrayList.add(true);
        arrayList.add(true);
        arrayList.add(this.payrollProcessId);
        if (this.bPartnerGroupId > 0) {
            stringBuffer.append(" AND ").append("C_BP_Group_ID").append("=? ");
            arrayList.add(this.bPartnerGroupId);
        }
        int[] nArray2 = nArray = new Query(this.getCtx(), "C_BPartner", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).getIDs();
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            boolean bl = this.sendIndividualMail(n2, null);
            if (bl) {
                ++this.m_counter;
                continue;
            }
            ++this.m_errors;
        }
    }

    private boolean sendIndividualMail(int n, String string) {
        try {
            MBPartner mBPartner = new MBPartner(this.getCtx(), n, null);
            Object object = this.mailText.getMailText(true);
            if (string != null) {
                object = (String)object + string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation mBPartnerLocation = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", stringBuffer.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(n, "Primary").first();
            if (mBPartnerLocation == null) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @NotFound@");
                return false;
            }
            DefaultNotifier defaultNotifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
            defaultNotifier.clearMessage().withUserId(this.getAD_User_ID()).addAttachment(this.CreatePDF(n)).withText((String)object).withDescription(this.mailText.getMailHeader());
            Optional<MUser> optional = Arrays.asList(MUser.getOfBPartner(this.getCtx(), n, null)).stream().filter(mUser -> mUser.getC_BPartner_Location_ID() == mBPartnerLocation.getC_BPartner_Location_ID()).findFirst();
            if (optional.isPresent()) {
                defaultNotifier.withApplicationType("UDP").addRecipient(optional.get().getAD_User_ID());
            } else {
                defaultNotifier.withApplicationType("EMA").addRecipient(mBPartnerLocation.getEMail());
            }
            defaultNotifier.addToQueue();
            return true;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    private File CreatePDF(int n) {
        File file = null;
        int n2 = this.reportProcessId;
        MPInstance mPInstance = new MPInstance(Env.getCtx(), n2, n);
        mPInstance.saveEx();
        ProcessInfo processInfo = new ProcessInfo("PH_SendEmail", n2);
        processInfo.setAD_PInstance_ID(mPInstance.getAD_PInstance_ID());
        MPInstancePara mPInstancePara = new MPInstancePara(mPInstance, 10);
        mPInstancePara.setParameter("HR_Process_ID", this.payrollProcessId);
        mPInstancePara.saveEx();
        processInfo.setRecord_ID(n);
        processInfo.setIsBatch(true);
        MProcess mProcess = new MProcess(this.getCtx(), n2, this.get_TrxName());
        mProcess.processIt(processInfo, Trx.get(this.get_TrxName(), true));
        file = processInfo.getPDFReport();
        return file;
    }
}

