/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_I_HR_Movement;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.process.ImportPayrollMovementsAbstract;

public class ImportPayrollMovements
extends ImportPayrollMovementsAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getPayrollImportMovementIds(true, true, null)).forEach(n -> {
                X_I_HR_Movement x_I_HR_Movement = new X_I_HR_Movement(this.getCtx(), n, null);
                x_I_HR_Movement.deleteEx(true);
            });
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicInteger atomicInteger2 = new AtomicInteger(0);
        Arrays.stream(this.getPayrollImportMovementIds(false, false, null)).forEach(n -> Trx.run(string -> {
            X_I_HR_Movement x_I_HR_Movement = new X_I_HR_Movement(this.getCtx(), n, string);
            this.fillIdValues(x_I_HR_Movement);
            if (this.importRecord(x_I_HR_Movement)) {
                atomicInteger.updateAndGet(n -> n + 1);
            } else {
                atomicInteger2.updateAndGet(n -> n + 1);
            }
        }));
        return "@HR_Movement_ID@ @Import@ @Records@ " + atomicInteger.get() + " @Errors@ " + atomicInteger2.get();
    }

    private void fillIdValues(X_I_HR_Movement x_I_HR_Movement) {
        Optional optional;
        StringBuilder stringBuilder = new StringBuilder();
        x_I_HR_Movement.setI_ErrorMsg("");
        if (x_I_HR_Movement.getHR_Process_ID() <= 0) {
            optional = Optional.ofNullable(x_I_HR_Movement.getProcessName()).flatMap(string -> {
                int n = this.getId("HR_Process", "Name=?", string);
                if (n > 0) {
                    return Optional.of(n);
                }
                return Optional.empty();
            });
            if (optional.isPresent()) {
                optional.ifPresent(x_I_HR_Movement::setHR_Process_ID);
            } else {
                stringBuilder.append("@HR_Process_ID@  @NotFound@ ");
            }
        }
        if (x_I_HR_Movement.getC_BPartner_ID() <= 0) {
            optional = Optional.ofNullable(x_I_HR_Movement.getBPartner_Value()).flatMap(string -> {
                int n = this.getId("C_BPartner", "Value=?", string);
                if (n > 0) {
                    MBPartner mBPartner = new MBPartner(this.getCtx(), n, x_I_HR_Movement.get_TrxName());
                    if (!mBPartner.isEmployee()) {
                        stringBuilder.append(", ").append("@IsEmployee@ @NotValid@ @C_BPartner_ID@ ").append(mBPartner.getName());
                        return Optional.empty();
                    }
                    return Optional.of(n);
                }
                return Optional.empty();
            });
            if (optional.isPresent()) {
                optional.ifPresent(x_I_HR_Movement::setC_BPartner_ID);
            } else {
                stringBuilder.append(", ").append("@C_BPartner_ID@ @NotFound@ ");
            }
        }
        if (x_I_HR_Movement.getHR_Concept_ID() <= 0) {
            optional = Optional.ofNullable(x_I_HR_Movement.getConceptValue()).flatMap(string -> {
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("Value").append("=? AND ").append("IsManual").append("=? AND ").append("IsActive").append("=? ");
                int n = this.getId("HR_Concept", stringBuilder2.toString(), string.trim(), true, true);
                if (n > 0) {
                    MHRConcept mHRConcept = new MHRConcept(this.getCtx(), n, x_I_HR_Movement.get_TrxName());
                    if ("E".equals(mHRConcept.getType())) {
                        stringBuilder.append(", ").append("@HR_Concept_ID@ ").append(mHRConcept.getName()).append(" @NotValid@ ");
                        return Optional.empty();
                    }
                    return Optional.of(n);
                }
                return Optional.empty();
            });
            if (optional.isPresent()) {
                optional.ifPresent(x_I_HR_Movement::setHR_Concept_ID);
            } else {
                stringBuilder.append("@HR_Concept_ID@ ").append(" @NotFound@ ");
            }
        }
        if (x_I_HR_Movement.getValidFrom() == null) {
            stringBuilder.append(", @ValidFrom@ @FillMandatory@ ");
        }
        if (x_I_HR_Movement.getValidTo() == null) {
            x_I_HR_Movement.setValidTo(x_I_HR_Movement.getValidFrom());
        }
        if (stringBuilder.length() > 0) {
            this.setImportError(x_I_HR_Movement, stringBuilder.toString()).saveEx(x_I_HR_Movement.get_TrxName());
        }
        x_I_HR_Movement.saveEx();
    }

    private boolean importRecord(X_I_HR_Movement x_I_HR_Movement) {
        if (x_I_HR_Movement.getI_ErrorMsg() != null && x_I_HR_Movement.getI_ErrorMsg().length() > 0) {
            x_I_HR_Movement.setProcessed(false);
            x_I_HR_Movement.setI_IsImported(false);
            x_I_HR_Movement.saveEx();
            return false;
        }
        MHRMovement mHRMovement = new MHRMovement(x_I_HR_Movement);
        mHRMovement.saveEx(x_I_HR_Movement.get_TrxName());
        x_I_HR_Movement.setHR_Movement_ID(mHRMovement.getHR_Movement_ID());
        x_I_HR_Movement.setI_IsImported(true);
        x_I_HR_Movement.setProcessed(true);
        x_I_HR_Movement.setI_ErrorMsg("");
        x_I_HR_Movement.saveEx(x_I_HR_Movement.get_TrxName());
        return true;
    }

    private int getId(String string, String string2, Object ... objectArray) {
        return new Query(this.getCtx(), string, string2, this.get_TrxName()).setClient_ID().setParameters(objectArray).firstId();
    }

    private X_I_HR_Movement setImportError(X_I_HR_Movement x_I_HR_Movement, String string) {
        x_I_HR_Movement.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), string));
        this.addLog(x_I_HR_Movement.getI_HR_Movement_ID(), x_I_HR_Movement.getValidFrom(), x_I_HR_Movement.getAmount(), x_I_HR_Movement.getI_ErrorMsg());
        return x_I_HR_Movement;
    }

    private int[] getPayrollImportMovementIds(boolean bl, boolean bl2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Movement", stringBuilder.toString(), string).setClient_ID().setOnlyActiveRecords(true).setParameters(bl, bl2).getIDs();
    }
}

