/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.Query;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRPayrollConcept;
import org.eevolution.hr.process.HRCreateConceptAbstract;

public class HRCreateConcept
extends HRCreateConceptAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        int n = 0;
        List<MHRConcept> list = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MHRConcept.Table_ID) {
            n = this.createPayrollConcept(list, this.getRecord_ID());
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            n = this.updatingConceptProperties(list, this.getRecord_ID());
        }
        return "@Created@/@Updated@ #" + n;
    }

    private int createPayrollConcept(List<MHRConcept> list, int n) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mHRConcept -> !this.existsPayrollConcept(mHRConcept.getHR_Concept_ID(), n)).forEach(mHRConcept -> {
            MHRPayrollConcept mHRPayrollConcept = new MHRPayrollConcept((MHRConcept)mHRConcept, n, this.get_TrxName());
            mHRPayrollConcept.setIsPrinted(mHRConcept.isPrinted());
            mHRPayrollConcept.setSeqNo(mHRConcept.getSeqNo());
            mHRPayrollConcept.setName(mHRConcept.getName());
            mHRPayrollConcept.saveEx();
            this.addLog("@SeqNo@" + mHRPayrollConcept.getSeqNo() + " @HR_PayrollConcept_ID@ : " + mHRPayrollConcept.getName());
            atomicInteger.updateAndGet(n -> n + 1);
        });
        return atomicInteger.get();
    }

    private int updatingConceptProperties(List<MHRConcept> list, int n) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        list.stream().filter(mHRConcept -> mHRConcept != null).forEach(mHRConcept -> {
            Optional.ofNullable(this.getSelectionAsString(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "Name")).ifPresent(string -> mHRConcept.setName((String)string));
            Optional.ofNullable(this.getSelectionAsString(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "Description")).ifPresent(string -> mHRConcept.setDescription((String)string));
            Optional.ofNullable(this.getSelectionAsInt(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "HR_Concept_Category_ID")).ifPresent(n -> mHRConcept.setHR_Concept_Category_ID((int)n));
            Optional.ofNullable(this.getSelectionAsInt(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "HR_Concept_Type_ID")).ifPresent(n -> mHRConcept.setHR_Concept_Type_ID((int)n));
            Optional.ofNullable(this.getSelectionAsInt(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "SeqNo")).ifPresent(n -> mHRConcept.setSeqNo((int)n));
            Optional.ofNullable(this.getSelectionAsString(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "Type")).ifPresent(string -> mHRConcept.setType((String)string));
            Optional.ofNullable(this.getSelectionAsString(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "ColumnType")).ifPresent(string -> mHRConcept.setColumnType((String)string));
            Optional.ofNullable(this.getSelectionAsString(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "AccountSign")).ifPresent(string -> mHRConcept.setAccountSign((String)string));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsActive")).ifPresent(bl -> mHRConcept.setIsActive((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsEmployee")).ifPresent(bl -> mHRConcept.setIsEmployee((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsManual")).ifPresent(bl -> mHRConcept.setIsManual((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPaid")).ifPresent(bl -> mHRConcept.setIsPaid((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPrepayment")).ifPresent(bl -> mHRConcept.setIsPrepayment((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsInvoiced")).ifPresent(bl -> mHRConcept.setIsInvoiced((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsSaveInHistoric")).ifPresent(bl -> mHRConcept.setIsSaveInHistoric((boolean)bl));
            Optional.ofNullable(this.getSelectionAsBoolean(mHRConcept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPrinted")).ifPresent(bl -> mHRConcept.setIsPrinted((boolean)bl));
            if (mHRConcept.is_Changed()) {
                atomicInteger.updateAndGet(n -> n + 1);
                mHRConcept.saveEx();
                this.addLog("@Updated@ @HR_Concept_ID@ : " + mHRConcept.getName());
            }
        });
        return atomicInteger.get();
    }

    private boolean existsPayrollConcept(int n, int n2) {
        return new Query(this.getCtx(), "HR_PayrollConcept", "HR_Payroll_ID=? AND HR_Concept_ID=?", this.get_TrxName()).setParameters(n2, n).match();
    }
}

