/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_WorkShift;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MHRWorkShift
extends X_HR_WorkShift {
    private static final long serialVersionUID = 955746318164528261L;
    private static CCache<Integer, MHRWorkShift> workShiftCache = new CCache("HR_WorkShift", 1000);
    private static CCache<String, MHRWorkShift> workShiftValueCache = new CCache("HR_WorkShift", 1000);

    public MHRWorkShift(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MHRWorkShift(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MHRWorkShift getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MHRWorkShift mHRWorkShift = workShiftCache.get(n);
        if (mHRWorkShift != null) {
            return mHRWorkShift;
        }
        mHRWorkShift = new MHRWorkShift(properties, n, string);
        if (mHRWorkShift.get_ID() == n) {
            workShiftCache.put(n, mHRWorkShift);
        } else {
            mHRWorkShift = null;
        }
        return mHRWorkShift;
    }

    public static MHRWorkShift getById(Properties properties, int n) {
        return MHRWorkShift.getById(properties, n, null);
    }

    public static MHRWorkShift getByValue(Properties properties, String string, String string2) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        int n = Env.getAD_Client_ID(properties);
        String string3 = n + "#" + string;
        MHRWorkShift mHRWorkShift = workShiftValueCache.get(string3);
        if (mHRWorkShift != null) {
            return mHRWorkShift;
        }
        mHRWorkShift = (MHRWorkShift)new Query(properties, "HR_WorkShift", "Value=? AND AD_Client_ID IN (?,?)", string2).setParameters(string, 0, n).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (mHRWorkShift != null) {
            workShiftValueCache.put(string3, mHRWorkShift);
            workShiftCache.put(mHRWorkShift.get_ID(), mHRWorkShift);
        }
        return mHRWorkShift;
    }

    public static List<MHRWorkShift> getFromGroup(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        return new Query(properties, "HR_WorkShift", "HR_ShiftGroup_ID=?", string).setParameters(n).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
    }

    public static MHRWorkShift getDefaultFromGroup(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        List<MHRWorkShift> list = MHRWorkShift.getFromGroup(properties, n, string);
        if (list != null && list.size() > 0) {
            return (MHRWorkShift)list.stream().findFirst().get();
        }
        return null;
    }

    public static MHRWorkShift getByValue(Properties properties, String string) {
        return MHRWorkShift.getByValue(properties, string, null);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        long l;
        if (this.isOnSunday() && this.isOnMonday() && this.isOnTuesday() && this.isOnWednesday() && this.isOnThursday() && this.isOnFriday() && this.isOnSaturday()) {
            throw new AdempiereException("@TNA.AtLeastBusinessDay@");
        }
        Timestamp timestamp = this.getShiftFromTime();
        Timestamp timestamp2 = this.getShiftToTime();
        Timestamp timestamp3 = this.getBreakStartTime();
        Timestamp timestamp4 = this.getBreakEndTime();
        BigDecimal bigDecimal = this.getBreakHoursNo();
        if (timestamp != null && timestamp2 != null && timestamp.after(timestamp2)) {
            timestamp2 = TimeUtil.getDayTime(TimeUtil.addDays(timestamp2, 1), timestamp2);
        }
        if (timestamp3 != null && timestamp4 != null) {
            if (timestamp.after(timestamp3)) {
                timestamp3 = TimeUtil.getDayTime(TimeUtil.addDays(timestamp3, 1), timestamp3);
            }
            if (timestamp3.after(timestamp4)) {
                timestamp4 = TimeUtil.getDayTime(TimeUtil.addDays(timestamp4, 1), timestamp4);
            }
            l = timestamp4.getTime() - timestamp3.getTime();
            bigDecimal = new BigDecimal((double)l / 3600000.0);
        }
        if (bigDecimal == null) {
            bigDecimal = Env.ZERO;
        }
        if (!TimeUtil.isValid(timestamp, timestamp2, timestamp3)) {
            throw new AdempiereException("@TNA.InvalidBreakStartTime@");
        }
        if (!TimeUtil.isValid(timestamp, timestamp2, timestamp4)) {
            throw new AdempiereException("@TNA.InvalidBreakEndTime@");
        }
        if (timestamp3 != null && timestamp4 != null && timestamp4.getTime() < timestamp3.getTime()) {
            throw new AdempiereException("@TNA.InvalidBreakTime@");
        }
        if (this.getMinAttendanceRequire() > 0 && this.getMinAttendanceRequire() % 2 != 0) {
            throw new AdempiereException("@TNA.AttendanceNotPair@");
        }
        l = timestamp2.getTime() - timestamp.getTime();
        BigDecimal bigDecimal2 = new BigDecimal((double)l / 3600000.0);
        this.setBreakHoursNo(bigDecimal);
        this.setNoOfHours(bigDecimal2.subtract(bigDecimal));
        this.setShiftFromTime(timestamp);
        this.setShiftToTime(timestamp2);
        this.setBreakStartTime(timestamp3);
        this.setBreakEndTime(timestamp4);
        return true;
    }

    @Override
    public String toString() {
        return "MHRWorkShift [getBreakEndTime()=" + this.getBreakEndTime() + ", getBreakHoursNo()=" + this.getBreakHoursNo() + ", getBreakStartTime()=" + this.getBreakStartTime() + ", isOverTimeApplicable()=" + this.isOverTimeApplicable() + ", getName()=" + this.getName() + ", getNoOfHours()=" + this.getNoOfHours() + ", isOnFriday()=" + this.isOnFriday() + ", isOnMonday()=" + this.isOnMonday() + ", isOnSaturday()=" + this.isOnSaturday() + ", isOnSunday()=" + this.isOnSunday() + ", isOnThursday()=" + this.isOnThursday() + ", isOnTuesday()=" + this.isOnTuesday() + ", isOnWednesday()=" + this.isOnWednesday() + ", getShiftFromTime()=" + this.getShiftFromTime() + ", getShiftToTime()=" + this.getShiftToTime() + "]";
    }
}

