/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import org.adempiere.core.domains.models.X_C_Period;
import org.adempiere.core.domains.models.X_HR_Payroll;
import org.adempiere.core.domains.models.X_HR_Process;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MBPartner;
import org.compiere.model.MCommission;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRAttribute;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRConceptCategory;
import org.eevolution.hr.model.MHRConceptType;
import org.eevolution.hr.model.MHRContract;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRPayrollConcept;
import org.eevolution.hr.model.MHRPeriod;
import org.eevolution.hr.services.HRProcessActionMsg;
import org.eevolution.manufacturing.model.MPPCostCollector;
import org.spin.hr.util.PayrollEngineHandler;
import org.spin.hr.util.TNAUtil;

public class MHRProcess
extends X_HR_Process
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = -8553627333715790110L;
    public int partnerId = 0;
    public int userId = 0;
    public int payrollConceptId = 0;
    public int payrollId = 0;
    public int departmentId = 0;
    public int jobId = 0;
    public String columnType = "";
    public Timestamp dateFrom;
    public Timestamp dateTo;
    private MHRPayroll payroll = null;
    public Hashtable<Integer, MHRMovement> movements = new Hashtable();
    public MHRPayrollConcept[] payrollConcepts;
    private MHREmployee employee;
    private MBPartner businessPartner;
    HashMap<String, Object> scriptCtx = new HashMap();
    private List<MHRConcept> activeConceptRule = new ArrayList<MHRConcept>();
    private Map<String, MHRMovement> lastConceptMap = new HashMap<String, MHRMovement>();
    private Map<String, BigDecimal> conceptAgregateMap = new HashMap<String, BigDecimal>();
    private Map<String, MHRAttribute> attributeInstanceMap = new HashMap<String, MHRAttribute>();
    private static CLogger logger = CLogger.getCLogger(MHRProcess.class);
    public static final String CONCEPT_PP_COST_COLLECTOR_LABOR = "PP_COST_COLLECTOR_LABOR";
    private Object description = null;
    private HRProcessActionMsg actionScope = null;
    private static StringBuffer s_scriptImport = new StringBuffer(" import org.eevolution.model.*;" + Env.NL + "import org.eevolution.hr.model.*;" + Env.NL + "import org.eevolution.hr.util.*;" + Env.NL + "import org.compiere.model.*;" + Env.NL + "import org.adempiere.model.*;" + Env.NL + "import org.compiere.util.*;" + Env.NL + "import org.spin.model.*;" + Env.NL + "import org.spin.hr.model.*;" + Env.NL + "import org.spin.tar.model.*;" + Env.NL + "import org.spin.util.*;" + Env.NL + "import org.spin.hr.util.*;" + Env.NL + "import java.util.*;" + Env.NL + "import java.math.*;" + Env.NL + "import java.sql.*;");
    private String processMsg = null;
    private boolean justPrepared = false;
    private boolean isReversal = false;

    public static void addScriptImportPackage(String string) {
        s_scriptImport.append(" import ").append(string).append(";");
    }

    public MHRProcess(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setC_DocType_ID(0);
            this.set_ValueNoCheck("DocumentNo", null);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setHR_Department_ID(0);
            this.setC_BPartner_ID(0);
        }
    }

    public MHRProcess(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public final void setProcessed(boolean bl) {
        super.setProcessed(bl);
        if (this.get_ID() <= 0) {
            return;
        }
        DB.executeUpdateEx("UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?", new Object[]{bl, this.get_ID()}, this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.getAD_Client_ID() == 0) {
            throw new AdempiereException("@AD_Client_ID@ = 0");
        }
        if (this.getAD_Org_ID() == 0) {
            int n = this.getAD_Org_ID();
            if (n == 0) {
                throw new AdempiereException("@AD_Org_ID@ = *");
            }
            this.setAD_Org_ID(n);
            logger.warning("Changed Org to Context=" + n);
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        return true;
    }

    @Override
    public boolean processIt(String string) {
        this.processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        logger.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        logger.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        logger.info("prepareIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        this.reActivateIt();
        MHRPeriod mHRPeriod = MHRPeriod.getById(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        MPeriod.testPeriodOpen(this.getCtx(), this.getHR_Period_ID() > 0 ? mHRPeriod.getDateAcct() : this.getDateAcct(), this.getC_DocTypeTarget_ID(), this.getAD_Org_ID(), this.get_TrxName());
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        try {
            this.createMovements();
        }
        catch (Exception exception) {
            this.deleteMovements();
            throw new AdempiereException(exception);
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        String string;
        if (!this.justPrepared && !"IP".equals(string = this.prepareIt())) {
            return string;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean approveIt() {
        return true;
    }

    @Override
    public boolean rejectIt() {
        logger.info("rejectIt - " + this.toString());
        return true;
    }

    public boolean postIt() {
        logger.info("postIt - " + this.toString());
        return false;
    }

    @Override
    public boolean voidIt() {
        logger.info("voidIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            List<MHRMovement> list = MHRMovement.findByProcess(this);
            for (MHRMovement mHRMovement : list) {
                BigDecimal bigDecimal = mHRMovement.getAmount();
                if (bigDecimal.signum() == 0) continue;
                mHRMovement.setAmount(Env.ZERO);
                mHRMovement.setDescription("Void (" + bigDecimal + ")");
                mHRMovement.saveEx();
            }
        } else {
            boolean bl = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID(), this.get_TrxName());
            }
            catch (PeriodClosedException periodClosedException) {
                bl = true;
            }
            if (bl) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.setProcessed(true);
        this.setDocStatus("VO");
        this.saveEx();
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        return this.processMsg == null;
    }

    @Override
    public boolean closeIt() {
        if (this.isProcessed()) {
            logger.info(this.toString());
            this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
            if (this.processMsg != null) {
                return false;
            }
            this.setProcessed(true);
            this.setDocAction("--");
            this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
            return this.processMsg == null;
        }
        return false;
    }

    @Override
    public MHRProcess reverseIt(boolean bl) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> optional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp timestamp2 = bl ? optional.orElseGet(() -> timestamp) : this.getDateAcct();
        MPeriod.testPeriodOpen(this.getCtx(), timestamp2, this.getC_DocType_ID(), this.getAD_Org_ID(), this.get_TrxName());
        MHRProcess mHRProcess = MHRProcess.copyFrom(this, this.getDateAcct(), this.getC_DocType_ID(), false, this.get_TrxName(), true);
        if (mHRProcess == null) {
            this.processMsg = "Could not create Payroll Process Reversal";
            return null;
        }
        mHRProcess.setReversal_ID(this.getHR_Process_ID());
        mHRProcess.setProcessing(false);
        mHRProcess.setDocStatus("RE");
        mHRProcess.setDocAction("--");
        mHRProcess.setProcessed(true);
        mHRProcess.setName("(" + mHRProcess.getDocumentNo() + " -> " + this.getDocumentNo() + ")");
        mHRProcess.saveEx();
        this.processMsg = mHRProcess.getDocumentNo();
        this.setProcessed(true);
        this.setReversal_ID(mHRProcess.getHR_Process_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setProcessed(true);
        this.setDocAction("--");
        this.setName("(" + this.getName() + " <- " + mHRProcess.getDocumentNo() + ")");
        this.saveEx();
        return mHRProcess;
    }

    @Override
    public boolean reverseCorrectIt() {
        logger.info("reverseCorrectIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMsg != null) {
            return false;
        }
        MHRProcess mHRProcess = this.reverseIt(false);
        if (mHRProcess == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        logger.info("reverseAccrualIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMsg != null) {
            return false;
        }
        MHRProcess mHRProcess = this.reverseIt(true);
        if (mHRProcess == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        logger.info("reActivateIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMsg != null) {
            return false;
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "HRP", this.getAD_Org_ID(), this.get_TrxName());
        int n = this.deleteMovements();
        logger.fine("HR_Process deleted #" + n);
        n = MFactAcct.deleteEx(Table_ID, this.getHR_Process_ID(), this.get_TrxName());
        logger.fine("Fact_Acct deleted #" + n);
        this.setProcessed(false);
        this.setDocAction("CO");
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.processMsg == null;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    @Override
    public String getProcessMsg() {
        return this.processMsg;
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            logger.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine reportEngine = ReportEngine.get(this.getCtx(), 0, 0);
        if (reportEngine == null) {
            return null;
        }
        return reportEngine.getPDF(file);
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    public MHRMovement[] getLines(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HR_Process_ID=?");
        arrayList.add(this.getHR_Process_ID());
        stringBuffer.append("AND (Qty <> 0 OR Amount <> 0)");
        stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND c.IsActive=? AND c.AccountSign<>?)");
        arrayList.add(true);
        arrayList.add("N");
        stringBuffer.append(" AND EXISTS(SELECT 1 FROM HR_Concept_Acct ca WHERE ca.HR_Concept_ID=HR_Movement.HR_Concept_ID AND ca.IsActive=? AND ca.IsBalancing<>?)");
        arrayList.add(true);
        arrayList.add(true);
        stringBuffer.append(" AND C_BPartner_ID IS NOT NULL");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("(SELECT bp.C_BP_Group_ID FROM C_BPartner bp WHERE bp.C_BPartner_ID=HR_Movement.C_BPartner_ID)");
        List<MHRMovement> list = new Query(this.getCtx(), "HR_Movement", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy(stringBuffer2.toString()).list();
        return list.toArray(new MHRMovement[list.size()]);
    }

    private void loadMovements(Hashtable<Integer, MHRMovement> hashtable, int n) {
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Process_ID=? AND C_BPartner_ID=?", this.get_TrxName()).setParameters(this.getHR_Process_ID(), n).list();
        for (MHRMovement mHRMovement : list) {
            if (hashtable.containsKey(mHRMovement.getHR_Concept_ID())) {
                MHRMovement mHRMovement2 = hashtable.get(mHRMovement.getHR_Concept_ID());
                MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRMovement2.getHR_Concept_ID(), this.get_TrxName());
                String string = mHRConcept.getColumnType();
                if (string.equals("A")) {
                    mHRMovement.addAmount(mHRMovement2.getAmount());
                } else if (string.equals("Q")) {
                    mHRMovement.addQty(mHRMovement2.getQty());
                }
            }
            hashtable.put(mHRMovement.getHR_Concept_ID(), mHRMovement);
        }
    }

    private Object executeScriptEngine(MHRConcept mHRConcept, MRule mRule, String string) {
        long l = System.currentTimeMillis();
        Object object = null;
        try {
            String string2 = "";
            if (mRule.getScript() != null) {
                string2 = mRule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
            }
            String string3 = s_scriptImport.toString() + Env.NL + string2;
            ScriptEngine scriptEngine = mRule.getScriptEngine();
            SimpleScriptContext simpleScriptContext = new SimpleScriptContext();
            this.scriptCtx.entrySet().stream().forEach(entry -> simpleScriptContext.setAttribute((String)entry.getKey(), entry.getValue(), 100));
            simpleScriptContext.setAttribute("description", "", 100);
            Double d = 0.0;
            if ("D".equals(string) || "T".equals(string)) {
                d = null;
            }
            simpleScriptContext.setAttribute("result", d, 100);
            object = scriptEngine.eval(string3, (ScriptContext)simpleScriptContext);
            if (object != null && "@Error@".equals(object.toString())) {
                throw new AdempiereException("@AD_Rule_ID@ @HR_Concept_ID@ " + mHRConcept.getValue() + mHRConcept.getName() + "\t @@Error@ " + object);
            }
            this.description = simpleScriptContext.getAttribute("description");
            long l2 = System.currentTimeMillis() - l;
            logger.info("ScriptResult -> Concept Name " + mHRConcept.getName() + " = " + object + " Time elapsed: " + TimeUtil.formatElapsed(l2));
        }
        catch (Exception exception) {
            throw new AdempiereException(exception.getLocalizedMessage());
        }
        return object;
    }

    private Object executeScript(MHRConcept mHRConcept, int n, String string) {
        long l = System.currentTimeMillis();
        MRule mRule = MRule.get(this.getCtx(), n);
        Object object = null;
        this.description = null;
        try {
            Object object2;
            if (mRule == null) {
                logger.log(Level.WARNING, " @AD_Rule_ID@ @NotFound@");
            }
            if (!mRule.getEventType().equals("H") || !mRule.getRuleType().equals("S")) {
                logger.log(Level.WARNING, " must be of type JSR 223 and event human resource");
            }
            boolean bl = false;
            if (mRule.isRuleClassGenerated()) {
                try {
                    object2 = PayrollEngineHandler.getInstance().getRuleEngine(mRule);
                    if (object2 != null) {
                        bl = true;
                        object = object2.run(this, this.scriptCtx);
                        this.description = object2.getDescription();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.log(Level.WARNING, classNotFoundException.getLocalizedMessage());
                }
                catch (Exception exception) {
                    throw new AdempiereException(exception);
                }
            }
            if (!bl) {
                if (mRule.getEngineName() != null) {
                    return this.executeScriptEngine(mHRConcept, mRule, string);
                }
                object2 = "";
                if (mRule.getScript() != null) {
                    object2 = mRule.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
                }
                String string2 = "double";
                String string3 = "0";
                if ("D".equals(string)) {
                    string2 = "Timestamp";
                    string3 = "null";
                } else if ("T".equals(string)) {
                    string2 = "String";
                    string3 = "null";
                }
                String string4 = s_scriptImport.toString() + Env.NL + string2 + " result = " + string3 + ";" + Env.NL + "String description = null;" + Env.NL + (String)object2;
                Scriptlet scriptlet = new Scriptlet("result", string4, this.scriptCtx);
                Exception exception = scriptlet.execute();
                if (exception != null) {
                    throw exception;
                }
                object = scriptlet.getResult(false);
                this.description = scriptlet.getDescription();
            }
            long l2 = System.currentTimeMillis() - l;
            logger.info("ScriptResult -> Concept Name " + mHRConcept.getName() + " = " + object + " Time elapsed: " + TimeUtil.formatElapsed(l2));
        }
        catch (Exception exception) {
            throw new AdempiereException("@HR_Employee_ID@ : " + this.businessPartner.getName() + " " + this.businessPartner.getName2() + " \n @HR_Concept_ID@ " + mHRConcept.getValue() + " -> " + mHRConcept.getName() + " \n @AD_Rule_ID@=" + mRule.getValue() + "\n  Script : " + mRule.getScript() + " \n Execution error : \n" + exception.getLocalizedMessage());
        }
        return object;
    }

    private void createCostCollectorMovements(int n, MHRPeriod mHRPeriod) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EXISTS (SELECT 1 FROM AD_User u WHERE u.AD_User_ID=PP_Cost_Collector.AD_User_ID AND u.C_BPartner_ID=?)");
        arrayList.add(n);
        stringBuffer.append(" AND MovementDate>=?");
        arrayList.add(mHRPeriod.getStartDate());
        stringBuffer.append(" AND MovementDate<=?");
        arrayList.add(mHRPeriod.getEndDate());
        stringBuffer.append(" AND DocStatus IN (?,?)");
        arrayList.add("CO");
        arrayList.add("CL");
        List list = new Query(this.getCtx(), "PP_Cost_Collector", stringBuffer.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(arrayList).setOrderBy("PP_Cost_Collector_ID DESC").list();
        for (MPPCostCollector mPPCostCollector : list) {
            this.createMovementForCostCollector(n, mPPCostCollector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MHRMovement createMovementForCostCollector(int n, MPPCostCollector mPPCostCollector) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), CONCEPT_PP_COST_COLLECTOR_LABOR, mPPCostCollector.get_TrxName());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        arrayList.add(this.dateFrom);
        arrayList.add(this.dateTo);
        if (this.payrollId > 0) {
            stringBuffer.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(this.payrollId);
        }
        if (this.departmentId > 0) {
            stringBuffer.append(" AND (HR_Department_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(this.departmentId);
        }
        if (this.jobId > 0) {
            stringBuffer.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            arrayList.add(this.jobId);
        }
        stringBuffer.append(" AND HR_Concept_ID = ? ");
        arrayList.add(mHRConcept.get_ID());
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        MHRAttribute mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (mHRAttribute == null) {
            throw new AdempiereException();
        }
        if ("E".equals(mHRConcept.getType())) {
            Object object;
            this.scriptCtx.put("_CostCollector", mPPCostCollector);
            try {
                object = this.executeScript(mHRConcept, mHRAttribute.getAD_Rule_ID(), mHRAttribute.getColumnType());
            }
            finally {
                this.scriptCtx.remove("_CostCollector");
            }
            MHREmployee mHREmployee = MHREmployee.getActiveEmployee(this.getCtx(), n, this.get_TrxName());
            MHRMovement mHRMovement = new MHRMovement(this, mHRConcept);
            mHRMovement.setHR_Attribute_ID(mHRAttribute.getHR_Attribute_ID());
            mHRMovement.setC_BPartner_ID(n);
            mHRMovement.setDescription(mHRAttribute.getDescription());
            mHRMovement.setReferenceNo(mHRAttribute.getReferenceNo());
            mHRMovement.setC_BP_Relation_ID(mHRAttribute.getC_BP_Relation_ID());
            mHRMovement.setAD_Rule_ID(mHRAttribute.getAD_Rule_ID());
            mHRMovement.setValidFrom(this.dateFrom);
            mHRMovement.setValidTo(this.dateTo);
            mHRMovement.setPP_Cost_Collector_ID(mPPCostCollector.getPP_Cost_Collector_ID());
            mHRMovement.setIsManual(true);
            mHRMovement.setColumnValue(object);
            mHRMovement.setProcessed(true);
            int n2 = DB.getSQLValue(this.get_TrxName(), "SELECT C_BP_Group_ID FROM C_BPartner WHERE C_BPartner_ID=?", this.partnerId);
            mHRMovement.setC_BP_Group_ID(n2);
            mHRMovement.setEmployee(mHREmployee);
            mHRMovement.saveEx();
            return mHRMovement;
        }
        throw new AdempiereException();
    }

    private void createMovements() throws Exception {
        MHRPeriod mHRPeriod;
        logger.info("CreateMovements #");
        long l = System.currentTimeMillis();
        this.scriptCtx.clear();
        this.lastConceptMap = new HashMap<String, MHRMovement>();
        this.conceptAgregateMap = new HashMap<String, BigDecimal>();
        this.attributeInstanceMap = new HashMap<String, MHRAttribute>();
        logger.info("info data - Process " + this.getHR_Process_ID() + ", Period :" + this.getHR_Period_ID() + ", Payroll : " + this.getHR_Payroll_ID() + ", @HR_Department_ID@ : " + this.getHR_Department_ID());
        if (this.getHR_Period_ID() > 0) {
            mHRPeriod = MHRPeriod.getById(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        } else {
            mHRPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            MBPartner[] mBPartnerArray = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID(), this.get_TrxName());
            if (mBPartnerArray != null) {
                mHRPeriod.setStartDate(mBPartnerArray.getStartDate());
                mHRPeriod.setEndDate(mBPartnerArray.getEndDate());
            } else {
                mHRPeriod.setStartDate(this.getDateAcct());
                mHRPeriod.setEndDate(this.getDateAcct());
            }
        }
        this.dateFrom = mHRPeriod.getStartDate();
        this.dateTo = mHRPeriod.getEndDate();
        this.payroll = MHRPayroll.getById(this.getCtx(), this.getHR_Payroll_ID(), this.get_TrxName());
        this.scriptCtx.put("process", this);
        this.scriptCtx.put("_Process", this.getHR_Process_ID());
        this.scriptCtx.put("_Period", this.getHR_Period_ID());
        this.scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.scriptCtx.put("_Department", this.getHR_Department_ID());
        this.scriptCtx.put("_From", this.dateFrom);
        this.scriptCtx.put("_To", this.dateTo);
        this.scriptCtx.put("_Period", mHRPeriod.getPeriodNo());
        this.scriptCtx.put("_PeriodNo", mHRPeriod.getPeriodNo());
        this.scriptCtx.put("_HR_Period_ID", this.getHR_Period_ID());
        this.scriptCtx.put("_HR_Payroll_Value", this.payroll.getValue());
        this.scriptCtx.put("SCOPE_PROCESS", 1);
        this.scriptCtx.put("SCOPE_EMPLOYEE", 2);
        this.scriptCtx.put("SCOPE_CONCEPT", 3);
        this.scriptCtx.put("PERSISTENCE_SAVE", 1);
        this.scriptCtx.put("PERSISTENCE_IGNORE", 2);
        this.scriptCtx.put("ACTION_BREAK", 1);
        if (this.getHR_Payroll_ID() > 0) {
            this.payrollId = this.getHR_Payroll_ID();
        }
        if (this.getHR_Department_ID() > 0) {
            this.departmentId = this.getHR_Department_ID();
        }
        if (this.getHR_Job_ID() > 0) {
            this.jobId = this.getHR_Job_ID();
        }
        this.payrollConcepts = MHRPayrollConcept.getPayrollConcepts(this);
        this.actionScope = new HRProcessActionMsg();
        for (MBPartner mBPartner : MHREmployee.getEmployees(this)) {
            this.calculateMovements(mBPartner, mHRPeriod);
            if (!this.actionScope.isProcessScope() || !this.actionScope.isBreakRunning()) continue;
            this.actionScope.clearAction();
            this.actionScope.clearScope();
            this.actionScope.clearPersistence();
            break;
        }
        if (this.getHR_Period_ID() > 0) {
            mHRPeriod.setProcessed(true);
            mHRPeriod.saveEx();
        }
        logger.info("Calculation for CreateMovements # Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - l));
    }

    public HRProcessActionMsg scope(int n) {
        return this.actionScope.scope(n);
    }

    private void calculateMovements(MBPartner mBPartner, MHRPeriod mHRPeriod) {
        Cloneable cloneable;
        logger.info("Employee # " + mBPartner.getValue() + " - " + mBPartner.getName() + " " + mBPartner.getName2());
        long l = System.currentTimeMillis();
        this.partnerId = mBPartner.get_ID();
        this.businessPartner = mBPartner;
        this.employee = MHREmployee.getActiveEmployee(this.getCtx(), this.partnerId, this.get_TrxName());
        if (this.employee == null) {
            return;
        }
        String string = null;
        if (this.employee.getHR_Payroll_ID() != 0) {
            cloneable = MHRPayroll.getById(this.getCtx(), this.employee.getHR_Payroll_ID(), this.get_TrxName());
            string = ((X_HR_Payroll)cloneable).getValue();
        }
        cloneable = this.dateFrom;
        Timestamp timestamp = this.dateTo;
        if (this.employee.getStartDate() != null && this.dateFrom != null && this.employee.getStartDate().getTime() > this.dateFrom.getTime()) {
            cloneable = this.employee.getStartDate();
        }
        if (this.employee.getEndDate() != null && this.dateTo != null && this.employee.getEndDate().getTime() < this.dateTo.getTime()) {
            timestamp = this.employee.getEndDate();
        }
        this.scriptCtx.remove("_DateStart");
        this.scriptCtx.remove("_DateEnd");
        this.scriptCtx.remove("_Days");
        this.scriptCtx.remove("_C_BPartner_ID");
        this.scriptCtx.remove("_HR_Employee_ID");
        this.scriptCtx.remove("_C_BPartner");
        this.scriptCtx.remove("_HR_Employee");
        this.scriptCtx.remove("_HR_Employee_ValidFrom");
        this.scriptCtx.remove("_HR_Employee_ValidTo");
        this.scriptCtx.remove("_HR_Employee_Payroll_Value");
        this.scriptCtx.remove("_HR_Employee_Contract");
        this.scriptCtx.put("_DateStart", this.employee.getStartDate());
        this.scriptCtx.put("_DateEnd", this.employee.getEndDate() == null ? (this.dateTo == null ? this.getDateAcct() : this.dateTo) : this.employee.getEndDate());
        this.scriptCtx.put("_Days", TimeUtil.getDaysBetween(mHRPeriod.getStartDate(), mHRPeriod.getEndDate(), new int[0]) + 1);
        this.scriptCtx.put("_C_BPartner_ID", mBPartner.getC_BPartner_ID());
        this.scriptCtx.put("_HR_Employee_ID", this.employee.getHR_Employee_ID());
        this.scriptCtx.put("_C_BPartner", mBPartner);
        this.scriptCtx.put("_HR_Employee", this.employee);
        this.scriptCtx.put("_HR_Employee_Payroll_Value", string);
        this.scriptCtx.put("_HR_Employee_ValidFrom", cloneable);
        this.scriptCtx.put("_HR_Employee_ValidTo", timestamp);
        if (this.employee.getHR_Payroll_ID() > 0) {
            MHRPayrollConcept[] mHRPayrollConceptArray = MHRPayroll.getById(this.getCtx(), this.employee.getHR_Payroll_ID(), this.get_TrxName());
            MHRContract mHRContract = MHRContract.getById(this.getCtx(), mHRPayrollConceptArray.getHR_Contract_ID(), this.get_TrxName());
            this.scriptCtx.put("_HR_Employee_Contract", mHRContract);
        }
        if (this.getHR_Period_ID() > 0) {
            this.createCostCollectorMovements(mBPartner.get_ID(), mHRPeriod);
        }
        this.movements.clear();
        this.loadMovements(this.movements, this.partnerId);
        for (MHRPayrollConcept mHRPayrollConcept : this.payrollConcepts) {
            if (this.actionScope.isConceptScope() && this.actionScope.isBreakRunning()) {
                this.actionScope.clearAction();
                this.actionScope.clearScope();
                this.actionScope.clearPersistence();
                continue;
            }
            this.payrollConceptId = mHRPayrollConcept.getHR_Concept_ID();
            MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), this.payrollConceptId, this.get_TrxName());
            boolean bl = mHRPayrollConcept.isPrinted() || mHRConcept.isPrinted();
            MHRMovement mHRMovement2 = this.movements.get(mHRConcept.get_ID());
            if (mHRMovement2 == null) {
                this.scriptCtx.remove("_HR_Concept_ID");
                this.scriptCtx.remove("_HR_Concept");
                this.scriptCtx.put("_HR_Concept_ID", mHRConcept.getHR_Concept_ID());
                this.scriptCtx.put("_HR_Concept", mHRConcept);
                this.scriptCtx.remove("_HR_PayrollConcept_ID");
                this.scriptCtx.put("_HR_PayrollConcept_ID", mHRPayrollConcept.getHR_PayrollConcept_ID());
                this.createMovementFromConcept(mHRConcept, bl);
                mHRMovement2 = this.movements.get(mHRConcept.get_ID());
                if (mHRMovement2 == null) {
                    throw new AdempiereException("Concept " + mHRConcept.getValue() + " not created");
                }
                mHRMovement2.setHR_Payroll_ID(mHRPayrollConcept.getHR_Payroll_ID());
                mHRMovement2.setHR_PayrollConcept_ID(mHRPayrollConcept.getHR_PayrollConcept_ID());
                mHRMovement2.setPeriodNo(mHRPeriod.getPeriodNo());
            }
            if (!this.actionScope.isEmployeeScope() && !this.actionScope.isProcessScope() || !this.actionScope.isBreakRunning()) continue;
            if (!this.actionScope.isEmployeeScope()) break;
            this.actionScope.clearScope();
            this.actionScope.clearAction();
            break;
        }
        if (this.actionScope.isIgnorePersistence()) {
            this.actionScope.clearPersistence();
            return;
        }
        logger.info("Calculation for Employee # " + mBPartner.getValue() + " - " + mBPartner.getName() + " " + mBPartner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - l));
        long l2 = System.currentTimeMillis();
        this.movements.values().stream().filter(mHRMovement -> mHRMovement.getHR_Concept_ID() != 0).forEach(mHRMovement -> {
            long l = System.currentTimeMillis();
            MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRMovement.getHR_Concept_ID(), this.get_TrxName());
            if (mHRConcept != null && mHRConcept.get_ID() > 0) {
                if (mHRConcept.isManual()) {
                    logger.fine("Skip saving " + mHRMovement);
                } else {
                    boolean bl;
                    boolean bl2 = bl = !(!mHRConcept.isSaveInHistoric() && !mHRMovement.isPrinted() && !mHRConcept.isPaid() && !mHRConcept.isPrinted() || mHRConcept.isNotSaveInHistoryIfNull() && mHRMovement.isEmpty());
                    if (bl) {
                        mHRMovement.saveEx();
                    }
                }
            }
            logger.info("Saving Concept " + mHRConcept.getValue() + " - " + mHRConcept.getName() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - l));
        });
        logger.info("Saving for Employee # " + mBPartner.getValue() + " - " + mBPartner.getName() + " " + mBPartner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - l2));
        logger.info("Employee # " + mBPartner.getValue() + " - " + mBPartner.getName() + " " + mBPartner.getName2() + " Time elapsed: " + TimeUtil.formatElapsed(System.currentTimeMillis() - l));
        this.actionScope.clearPersistence();
    }

    private int deleteMovements() {
        int n = DB.executeUpdateEx("DELETE FROM HR_Movement m WHERE HR_Process_ID=? AND IsManual<>?", new Object[]{this.getHR_Process_ID(), true}, this.get_TrxName());
        logger.info("Movements Deleted #" + n);
        return n;
    }

    private void createMovementFromConcept(MHRConcept mHRConcept, boolean bl) {
        logger.info("Calculating -> Concept " + mHRConcept.getValue() + " -> " + mHRConcept.getName());
        this.columnType = mHRConcept.getColumnType();
        MHRAttribute mHRAttribute = MHRAttribute.getByConceptAndEmployee(mHRConcept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (mHRAttribute == null || mHRConcept.isManual()) {
            this.createDummyMovement(mHRConcept);
            return;
        }
        logger.info("Concept : " + mHRConcept.getName());
        MHRMovement mHRMovement = this.createMovement(mHRConcept, mHRAttribute, bl);
        if ("E".equals(mHRConcept.getType())) {
            logger.info("Processing -> Rule to Concept " + mHRConcept.getValue());
            if (this.activeConceptRule.contains(mHRConcept)) {
                throw new AdempiereException("Recursion loop detected in concept " + mHRConcept.getValue());
            }
            this.activeConceptRule.add(mHRConcept);
            Object object = this.executeScript(mHRConcept, mHRAttribute.getAD_Rule_ID(), mHRAttribute.getColumnType());
            this.activeConceptRule.remove(mHRConcept);
            mHRMovement.setColumnValue(object);
            if (this.description != null) {
                mHRMovement.setDescription(this.description.toString());
            }
        }
        mHRMovement.setProcessed(true);
        this.movements.put(mHRConcept.getHR_Concept_ID(), mHRMovement);
    }

    private void createDummyMovement(MHRConcept mHRConcept) {
        logger.info("Skip concept " + mHRConcept + " - attribute not found");
        MHRMovement mHRMovement = new MHRMovement(this.getCtx(), 0, mHRConcept.get_TrxName());
        mHRMovement.setSeqNo(mHRConcept.getSeqNo());
        mHRMovement.setIsManual(true);
        this.movements.put(mHRConcept.getHR_Concept_ID(), mHRMovement);
    }

    public double getMonthlySalary(String string) {
        BigDecimal bigDecimal = this.employee.getMonthlySalary();
        if (bigDecimal != null && !bigDecimal.equals(Env.ZERO)) {
            return bigDecimal.doubleValue();
        }
        if (this.employee.getHR_Payroll_ID() != 0) {
            MHRPayroll mHRPayroll = MHRPayroll.getById(this.getCtx(), this.employee.getHR_Payroll_ID(), string);
            MHRContract mHRContract = MHRContract.getById(this.getCtx(), mHRPayroll.getHR_Contract_ID(), string);
            if (mHRContract != null && mHRContract.getMonthlySalary_ID() != 0) {
                MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRContract.getMonthlySalary_ID(), string);
                return this.getAttribute(mHRConcept.getValue());
            }
        }
        return 0.0;
    }

    public double getDailySalary() {
        BigDecimal bigDecimal = this.employee.getDailySalary();
        if (bigDecimal != null && !bigDecimal.equals(Env.ZERO)) {
            return bigDecimal.doubleValue();
        }
        if (this.employee.getHR_Payroll_ID() != 0) {
            MHRPayroll mHRPayroll = MHRPayroll.getById(this.getCtx(), this.employee.getHR_Payroll_ID(), this.get_TrxName());
            MHRContract mHRContract = MHRContract.getById(this.getCtx(), mHRPayroll.getHR_Contract_ID(), this.get_TrxName());
            if (mHRContract != null && mHRContract.getDailySalary_ID() != 0) {
                MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRContract.getDailySalary_ID(), this.get_TrxName());
                return this.getAttribute(mHRConcept.getValue());
            }
        }
        return 0.0;
    }

    private MHRMovement createMovement(MHRConcept mHRConcept, MHRAttribute mHRAttribute, boolean bl) {
        MHRPeriod mHRPeriod2 = MHRPeriod.getById(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        MHRMovement mHRMovement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
        mHRMovement.setAD_Org_ID(this.employee.getAD_Org_ID());
        mHRMovement.setSeqNo(mHRConcept.getSeqNo());
        mHRMovement.setHR_Attribute_ID(mHRAttribute.getHR_Attribute_ID());
        mHRMovement.setDescription(mHRAttribute.getDescription());
        mHRMovement.setReferenceNo(mHRAttribute.getReferenceNo());
        Optional.ofNullable(mHRPeriod2).ifPresent(mHRPeriod -> mHRMovement.setPeriodNo(mHRPeriod.getPeriodNo()));
        mHRMovement.setC_BPartner_ID(this.partnerId);
        mHRMovement.setC_BP_Relation_ID(mHRAttribute.getC_BP_Relation_ID());
        mHRMovement.setHR_Concept_ID(mHRConcept.getHR_Concept_ID());
        mHRMovement.setHR_Concept_Category_ID(mHRConcept.getHR_Concept_Category_ID());
        mHRMovement.setHR_Concept_Type_ID(mHRConcept.getHR_Concept_Type_ID());
        mHRMovement.setHR_Process_ID(this.getHR_Process_ID());
        mHRMovement.setAD_Rule_ID(mHRAttribute.getAD_Rule_ID());
        mHRMovement.setValidFrom(this.dateFrom);
        mHRMovement.setValidTo(this.dateTo);
        mHRMovement.setIsPrinted(bl);
        mHRMovement.setIsManual(mHRConcept.isManual());
        mHRMovement.setC_BP_Group_ID(this.businessPartner.getC_BP_Group_ID());
        mHRMovement.setEmployee(this.employee);
        if (!"E".equals(mHRConcept.getType())) {
            int n = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.p_ctx, "#C_Currency_ID"));
            if (mHRConcept.getStdPrecision() > 0) {
                n = mHRConcept.getStdPrecision();
            }
            BigDecimal bigDecimal = Env.ONE;
            BigDecimal bigDecimal2 = mHRAttribute.getAmount();
            if (mHRAttribute.isConvertedAmount() && mHRAttribute.getC_Currency_ID() != this.getC_Currency_ID() && (bigDecimal = MConversionRate.getRate(mHRAttribute.getC_Currency_ID(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID())) != null) {
                bigDecimal2 = bigDecimal.multiply(Optional.ofNullable(bigDecimal2).orElse(Env.ZERO)).setScale(n, RoundingMode.HALF_UP);
            }
            mHRMovement.setAmount(bigDecimal2);
            mHRMovement.setQty(mHRAttribute.getQty());
            mHRMovement.setTextMsg(mHRAttribute.getTextMsg());
            mHRMovement.setServiceDate(mHRAttribute.getServiceDate());
        }
        return mHRMovement;
    }

    public double getConcept(String string) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string.trim(), this.get_TrxName());
        if (mHRConcept == null) {
            return 0.0;
        }
        MHRMovement mHRMovement = this.movements.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.movements.get(mHRConcept.get_ID());
        }
        if (mHRMovement == null) {
            throw new AdempiereException("Concept " + mHRConcept.getValue() + " not created");
        }
        String string2 = mHRConcept.getColumnType();
        if ("A".equals(string2)) {
            return mHRMovement.getAmount().doubleValue();
        }
        if ("Q".equals(string2)) {
            return mHRMovement.getQty().doubleValue();
        }
        return 0.0;
    }

    public String getConceptString(String string) {
        String string2;
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string.trim(), this.get_TrxName());
        if (mHRConcept == null) {
            return null;
        }
        MHRMovement mHRMovement = this.movements.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.movements.get(mHRConcept.get_ID());
        }
        if ("T".equals(string2 = mHRConcept.getColumnType())) {
            return mHRMovement.getTextMsg();
        }
        return null;
    }

    public Timestamp getConceptDate(String string) {
        String string2;
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string.trim(), this.get_TrxName());
        if (mHRConcept == null) {
            return null;
        }
        MHRMovement mHRMovement = this.movements.get(mHRConcept.get_ID());
        if (mHRMovement == null) {
            this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            mHRMovement = this.movements.get(mHRConcept.get_ID());
        }
        if ("D".equals(string2 = mHRConcept.getColumnType())) {
            return mHRMovement.getServiceDate();
        }
        return null;
    }

    @Deprecated
    public void setConcept(String string, double d) {
        this.createMovement(string, d);
    }

    @Deprecated
    public void setConcept(String string, double d, boolean bl) {
        this.createMovement(string, d, bl);
    }

    public void createMovement(String string, double d) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConcept == null) {
            return;
        }
        MHRAttribute mHRAttribute = MHRAttribute.getByConceptAndEmployee(mHRConcept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (mHRAttribute == null || mHRConcept.isManual()) {
            this.createDummyMovement(mHRConcept);
            return;
        }
        MHRMovement mHRMovement = this.createMovement(mHRConcept, mHRAttribute, mHRConcept.isPrinted());
        mHRMovement.setColumnValue(BigDecimal.valueOf(d));
        mHRMovement.saveEx();
        this.movements.put(mHRConcept.getHR_Concept_ID(), mHRMovement);
    }

    public void createMovement(String string, double d, boolean bl) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConcept == null) {
            return;
        }
        MHRAttribute mHRAttribute = MHRAttribute.getByConceptAndEmployee(mHRConcept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        if (mHRAttribute == null || mHRConcept.isManual()) {
            this.createDummyMovement(mHRConcept);
            return;
        }
        MHRMovement mHRMovement = this.createMovement(mHRConcept, mHRAttribute, mHRConcept.isPrinted());
        if (mHRConcept.getColumnType().equals("A")) {
            mHRMovement.setAmount(BigDecimal.valueOf(d));
        } else if (mHRConcept.getColumnType().equals("Q")) {
            mHRMovement.setQty(BigDecimal.valueOf(d));
        } else {
            return;
        }
        mHRMovement.setIsManual(bl);
        mHRMovement.saveEx();
        this.movements.put(mHRMovement.getHR_Movement_ID(), mHRMovement);
    }

    public MHRMovement createMovement(MHRConcept mHRConcept, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string2, String string3) {
        if (mHRConcept == null || mHRConcept.getHR_Concept_ID() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        MHRMovement.findByProcessAndConceptIdAndPartnerId(this, mHRConcept.getHR_Concept_ID(), this.partnerId, string2, string3).stream().filter(mHRMovement -> mHRMovement != null).forEach(mHRMovement -> mHRMovement.deleteEx(true));
        MHRAttribute mHRAttribute = MHRAttribute.getByConceptAndEmployee(mHRConcept, this.employee, this.getHR_Payroll_ID(), this.dateFrom, this.dateTo);
        MHRMovement mHRMovement2 = this.createMovement(mHRConcept, mHRAttribute, mHRConcept.isPrinted());
        Optional.ofNullable(bigDecimal2).ifPresent(bigDecimal -> mHRMovement2.setAmount((BigDecimal)bigDecimal));
        Optional.ofNullable(bigDecimal3).ifPresent(bigDecimal -> mHRMovement2.setAmount((BigDecimal)bigDecimal));
        Optional.ofNullable(string2).ifPresent(string -> mHRMovement2.setReferenceNo((String)string));
        Optional.ofNullable(string3).ifPresent(string -> mHRMovement2.setDescription((String)string));
        mHRMovement2.saveEx();
        this.movements.put(mHRConcept.getHR_Concept_ID(), mHRMovement2);
        return mHRMovement2;
    }

    public MHRMovement createMovement(String string, BigDecimal bigDecimal, BigDecimal bigDecimal2, String string2, String string3) {
        if (string == null || string.length() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConcept == null || mHRConcept.getHR_Concept_ID() == 0) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@");
        }
        return this.createMovement(mHRConcept, bigDecimal, bigDecimal2, string2, string3);
    }

    public double getConceptType(String string) {
        MHRConceptType mHRConceptType = MHRConceptType.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConceptType == null) {
            return 0.0;
        }
        double d = 0.0;
        for (MHRPayrollConcept mHRPayrollConcept : this.payrollConcepts) {
            MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRPayrollConcept.getHR_Concept_ID(), this.get_TrxName());
            if (mHRConcept.getHR_Concept_Type_ID() != mHRConceptType.get_ID()) continue;
            MHRMovement mHRMovement = this.movements.get(mHRPayrollConcept.getHR_Concept_ID());
            if (mHRMovement == null) {
                this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            }
            if ((mHRMovement = this.movements.get(mHRConcept.get_ID())) == null) continue;
            String string2 = mHRConcept.getColumnType();
            if ("A".equals(string2)) {
                d += mHRMovement.getAmount().doubleValue();
                continue;
            }
            if (!"Q".equals(string2)) continue;
            d += mHRMovement.getQty().doubleValue();
        }
        return d;
    }

    public double getConceptGroup(String string) {
        return this.getConceptCategory(string);
    }

    public double getConceptCategory(String string) {
        MHRConceptCategory mHRConceptCategory = MHRConceptCategory.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConceptCategory == null) {
            return 0.0;
        }
        double d = 0.0;
        for (MHRPayrollConcept mHRPayrollConcept : this.payrollConcepts) {
            MHRConcept mHRConcept = MHRConcept.getById(this.getCtx(), mHRPayrollConcept.getHR_Concept_ID(), this.get_TrxName());
            if (mHRConcept.getHR_Concept_Category_ID() != mHRConceptCategory.get_ID()) continue;
            MHRMovement mHRMovement = this.movements.get(mHRPayrollConcept.getHR_Concept_ID());
            if (mHRMovement == null) {
                this.createMovementFromConcept(mHRConcept, mHRConcept.isPrinted());
            }
            if ((mHRMovement = this.movements.get(mHRConcept.get_ID())) == null) continue;
            String string2 = mHRConcept.getColumnType();
            if ("A".equals(string2)) {
                d += mHRMovement.getAmount().doubleValue();
                continue;
            }
            if (!"Q".equals(string2)) continue;
            d += mHRMovement.getQty().doubleValue();
        }
        return d;
    }

    public double getList(String string, double d, String string2) {
        return this.getList(string, this.dateFrom, d, string2, this.columnType);
    }

    public double getList(String string, Timestamp timestamp, double d, String string2) {
        return this.getList(string, timestamp, d, string2, null);
    }

    public double getList(String string, Timestamp timestamp, double d, String string2, String string3) {
        BigDecimal bigDecimal = Env.ZERO;
        Object object = string2;
        if ("A".equals(string3) || string3 == null) {
            object = ((String)object).toString().length() == 1 ? "Col_" + (String)object : "Amount" + (String)object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string4 = "SELECT " + (String)object + " FROM HR_List l INNER JOIN HR_ListVersion lv ON (lv.HR_List_ID=l.HR_List_ID) INNER JOIN HR_ListLine ll ON (ll.HR_ListVersion_ID=lv.HR_ListVersion_ID) WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND l.AD_Client_ID in (?,0) AND (? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND (? BETWEEN ll.MinValue AND\tll.MaxValue) ORDER BY l.AD_CLIENT_ID desc ";
            arrayList.add(string);
            arrayList.add(this.getAD_Client_ID());
            arrayList.add(timestamp);
            arrayList.add(BigDecimal.valueOf(d));
            bigDecimal = DB.getSQLValueBDEx(this.get_TrxName(), string4, arrayList);
        }
        if (bigDecimal == null) {
            throw new IllegalStateException("getList Out of Range");
        }
        return bigDecimal.doubleValue();
    }

    public MHRAttribute getAttributeInstance(String string) {
        return this.getAttributeInstance(string, 0, null);
    }

    public MHRAttribute getAttributeInstance(String string, int n, Timestamp timestamp) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        return this.getAttributeInstance(mHRConcept, n, timestamp);
    }

    public MHRAttribute getAttributeInstance(MHRConcept mHRConcept, int n, Timestamp timestamp) {
        String string;
        MHRAttribute mHRAttribute;
        if (mHRConcept == null) {
            return null;
        }
        if (timestamp == null) {
            timestamp = this.dateFrom;
        }
        if (n <= 0) {
            n = this.partnerId;
        }
        if ((mHRAttribute = this.attributeInstanceMap.get(string = mHRConcept.getValue() + "|" + n + "|" + timestamp.getTime())) != null) {
            return mHRAttribute;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidFrom<=?");
        arrayList.add(timestamp);
        stringBuffer.append(" AND AD_Client_ID = ?");
        arrayList.add(this.getAD_Client_ID());
        if (this.payrollId > 0) {
            stringBuffer.append(" AND (HR_Payroll_ID=? OR HR_Payroll_ID IS NULL)");
            arrayList.add(this.payrollId);
        }
        if (this.departmentId > 0) {
            stringBuffer.append(" AND (HR_Department_ID=? OR HR_Department_ID IS NULL)");
            arrayList.add(this.departmentId);
        }
        if (this.jobId > 0) {
            stringBuffer.append(" AND (HR_Job_ID=? OR HR_Job_ID IS NULL)");
            arrayList.add(this.jobId);
        }
        stringBuffer.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID = HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        arrayList.add(mHRConcept.getValue());
        if (!mHRConcept.getType().equals("I")) {
            stringBuffer.append(" AND C_BPartner_ID = ?");
            arrayList.add(n);
        }
        if ((mHRAttribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("ValidFrom DESC").setOnlyActiveRecords(true).first()) != null) {
            this.attributeInstanceMap.put(string, mHRAttribute);
        }
        return mHRAttribute;
    }

    public double getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public double getAttribute(String string, Timestamp timestamp) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        if (mHRConcept == null) {
            return 0.0;
        }
        MHRAttribute mHRAttribute = this.getAttributeInstance(mHRConcept, 0, timestamp);
        if (mHRAttribute == null) {
            return 0.0;
        }
        if (mHRConcept.getColumnType().equals("Q")) {
            return mHRAttribute.getQty().doubleValue();
        }
        if (mHRConcept.getColumnType().equals("A")) {
            BigDecimal bigDecimal = Env.ONE;
            BigDecimal bigDecimal2 = mHRAttribute.getAmount();
            if (mHRAttribute.isConvertedAmount() && mHRAttribute.getC_Currency_ID() != this.getC_Currency_ID()) {
                int n = MCurrency.getStdPrecision(this.getCtx(), Env.getContextAsInt(this.p_ctx, "#C_Currency_ID"));
                if (mHRConcept.getStdPrecision() > 0) {
                    n = mHRConcept.getStdPrecision();
                }
                if ((bigDecimal = MConversionRate.getRate(mHRAttribute.getC_Currency_ID(), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID())) != null) {
                    bigDecimal2 = bigDecimal.multiply(Optional.ofNullable(bigDecimal2).orElse(Env.ZERO)).setScale(n, RoundingMode.HALF_UP);
                }
            }
            if (bigDecimal2 == null) {
                return 0.0;
            }
            return bigDecimal2.doubleValue();
        }
        return 0.0;
    }

    public Timestamp getAttributeDate(String string) {
        return this.getAttributeDate(string, null);
    }

    public Timestamp getAttributeDate(String string, Timestamp timestamp) {
        MHRAttribute mHRAttribute = this.getAttributeInstance(string, 0, timestamp);
        if (mHRAttribute == null) {
            return null;
        }
        return mHRAttribute.getServiceDate();
    }

    public String getAttributeString(String string) {
        return this.getAttributeString(string, null);
    }

    public String getAttributeString(String string, Timestamp timestamp) {
        MHRAttribute mHRAttribute = this.getAttributeInstance(string, 0, timestamp);
        if (mHRAttribute == null) {
            return null;
        }
        return mHRAttribute.getTextMsg();
    }

    public int getDays(Timestamp timestamp, Timestamp timestamp2) {
        return TimeUtil.getDaysBetween(timestamp, timestamp2, new int[0]) + 1;
    }

    public int getDays(String string, String string2) {
        Timestamp timestamp = Timestamp.valueOf(string);
        Timestamp timestamp2 = Timestamp.valueOf(string2);
        return this.getDays(timestamp, timestamp2);
    }

    public int getMonths(Timestamp timestamp, Timestamp timestamp2) {
        Comparable<Date> comparable;
        boolean bl = false;
        Comparable<Date> comparable2 = timestamp2;
        Timestamp timestamp3 = timestamp;
        if (comparable2.before(timestamp3)) {
            bl = true;
            comparable = timestamp3;
            timestamp3 = comparable2;
            comparable2 = comparable;
        }
        comparable = new GregorianCalendar();
        ((Calendar)comparable).setTime(timestamp3);
        ((Calendar)comparable).set(11, 0);
        ((Calendar)comparable).set(12, 0);
        ((Calendar)comparable).set(13, 0);
        ((Calendar)comparable).set(14, 0);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)comparable2);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        if (((Calendar)comparable).get(1) == gregorianCalendar.get(1)) {
            if (bl) {
                return (gregorianCalendar.get(2) - ((Calendar)comparable).get(2)) * -1;
            }
            return gregorianCalendar.get(2) - ((Calendar)comparable).get(2);
        }
        int n = 0;
        while (gregorianCalendar.after(comparable)) {
            ((GregorianCalendar)comparable).add(2, 1);
            ++n;
        }
        if (bl) {
            return n * -1;
        }
        return n;
    }

    public double getConcept(String string, int n) {
        return this.getConcept(string, null, n, n, true);
    }

    public double getConcept(String string, int n, int n2) {
        return this.getConcept(string, null, n, n2, true);
    }

    public double getConcept(String string, String string2, int n, int n2) {
        return this.getConcept(string, string2, n, n2, true);
    }

    public double getConcept(String string, String string2, int n, int n2, boolean bl) {
        Object object;
        int n3;
        if (string2 == null) {
            n3 = this.getHR_Payroll_ID();
        } else {
            object = MHRPayroll.getByValue(this.getCtx(), string2, this.get_TrxName());
            if (object == null) {
                return 0.0;
            }
            n3 = ((PO)object).get_ID();
        }
        object = "SUM|" + this.partnerId + "|" + string + "|" + n3 + "|" + n + "|" + n2 + "|" + bl;
        BigDecimal bigDecimal = this.conceptAgregateMap.get(object);
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(MHRMovement.getConceptSum(this.getCtx(), string, n3, this.partnerId, this.getHR_Period_ID(), n, n2, bl, this.get_TrxName()));
            this.conceptAgregateMap.put((String)object, bigDecimal);
        }
        return bigDecimal.doubleValue();
    }

    public double getConceptAvg(String string, String string2, int n, int n2) {
        return this.getConceptAvg(string, string2, n, n2, true);
    }

    public double getConceptAvg(String string, String string2, int n, int n2, boolean bl) {
        Object object;
        int n3;
        if (string2 == null) {
            n3 = this.getHR_Payroll_ID();
        } else {
            object = MHRPayroll.getByValue(this.getCtx(), string2, this.get_TrxName());
            if (object == null) {
                return 0.0;
            }
            n3 = ((PO)object).get_ID();
        }
        object = "AVG|" + this.partnerId + "|" + string + "|" + n3 + "|" + n + "|" + n2 + "|" + bl;
        BigDecimal bigDecimal = this.conceptAgregateMap.get(object);
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(MHRMovement.getConceptAvg(this.getCtx(), string, n3, this.partnerId, this.getHR_Period_ID(), n, n2, bl, this.get_TrxName()));
            this.conceptAgregateMap.put((String)object, bigDecimal);
        }
        return bigDecimal.doubleValue();
    }

    public MHRMovement getLastMovement(String string, String string2, Timestamp timestamp, boolean bl) {
        String string3;
        MHRMovement mHRMovement;
        if (Util.isEmpty(string2)) {
            string2 = this.payroll.getValue();
        }
        if ((mHRMovement = this.lastConceptMap.get(string3 = this.partnerId + "|" + string + "|" + string2 + "|" + timestamp.getTime() + "|" + bl)) == null && (mHRMovement = MHRMovement.getLastMovement(this.getCtx(), string, string2, this.partnerId, timestamp, bl, this.get_TrxName())) != null) {
            this.lastConceptMap.put(string3, mHRMovement);
        }
        return mHRMovement;
    }

    public double getLastConcept(String string, String string2) {
        return this.getLastConcept(string, string2, this.dateFrom, false);
    }

    public double getLastConcept(String string, String string2, Timestamp timestamp) {
        return this.getLastConcept(string, string2, timestamp, false);
    }

    public double getLastConcept(String string, String string2, Timestamp timestamp, boolean bl) {
        MHRMovement mHRMovement = this.getLastMovement(string, string2, timestamp, bl);
        if (mHRMovement == null) {
            return 0.0;
        }
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        if ("Q".equals(mHRConcept.getColumnType())) {
            if (mHRMovement.getQty() != null) {
                return mHRMovement.getQty().doubleValue();
            }
        } else if ("A".equals(mHRConcept.getColumnType()) && mHRMovement.getAmount() != null) {
            return mHRMovement.getAmount().doubleValue();
        }
        return 0.0;
    }

    public Timestamp getLastConceptDate(String string, String string2) {
        return this.getLastConceptDate(string, string2, this.dateFrom, false);
    }

    public Timestamp getLastConceptDate(String string, String string2, Timestamp timestamp) {
        return this.getLastConceptDate(string, string2, timestamp, false);
    }

    public Timestamp getLastConceptDate(String string, String string2, Timestamp timestamp, boolean bl) {
        MHRMovement mHRMovement = this.getLastMovement(string, string2, timestamp, bl);
        if (mHRMovement == null) {
            return null;
        }
        return mHRMovement.getServiceDate();
    }

    public String getLastConceptString(String string, String string2) {
        return this.getLastConceptString(string, string2, this.dateFrom, false);
    }

    public String getLastConceptString(String string, String string2, Timestamp timestamp) {
        return this.getLastConceptString(string, string2, timestamp, false);
    }

    public String getLastConceptString(String string, String string2, Timestamp timestamp, boolean bl) {
        MHRMovement mHRMovement = this.getLastMovement(string, string2, timestamp, bl);
        if (mHRMovement == null) {
            return null;
        }
        if (!Util.isEmpty(mHRMovement.getTextMsg())) {
            return mHRMovement.getTextMsg();
        }
        return mHRMovement.getDescription();
    }

    public Timestamp getLastConceptValidFrom(String string, String string2) {
        return this.getLastConceptValidFrom(string, string2, this.dateFrom, false);
    }

    public Timestamp getLastConceptValidFrom(String string, String string2, Timestamp timestamp) {
        return this.getLastConceptValidFrom(string, string2, timestamp, false);
    }

    public Timestamp getLastConceptValidFrom(String string, String string2, Timestamp timestamp, boolean bl) {
        MHRMovement mHRMovement = this.getLastMovement(string, string2, timestamp, bl);
        if (mHRMovement == null) {
            return null;
        }
        return mHRMovement.getValidFrom();
    }

    public Timestamp getLastConceptValidTo(String string, String string2) {
        return this.getLastConceptValidTo(string, string2, this.dateFrom, false);
    }

    public Timestamp getLastConceptValidTo(String string, String string2, Timestamp timestamp) {
        return this.getLastConceptValidTo(string, string2, timestamp, false);
    }

    public Timestamp getLastConceptValidTo(String string, String string2, Timestamp timestamp, boolean bl) {
        MHRMovement mHRMovement = this.getLastMovement(string, string2, timestamp, bl);
        if (mHRMovement == null) {
            return null;
        }
        return mHRMovement.getValidTo();
    }

    public double getConcept(String string, Timestamp timestamp, Timestamp timestamp2) {
        return this.getConcept(string, null, timestamp, timestamp2, true);
    }

    public double getConcept(String string, String string2, Timestamp timestamp, Timestamp timestamp2) {
        return this.getConcept(string, string2, timestamp, timestamp2, true);
    }

    public double getConcept(String string, String string2, Timestamp timestamp, Timestamp timestamp2, boolean bl) {
        Object object;
        int n;
        if (string2 == null) {
            n = this.getHR_Payroll_ID();
        } else {
            object = MHRPayroll.getByValue(this.getCtx(), string2, this.get_TrxName());
            if (object == null) {
                return 0.0;
            }
            n = ((PO)object).get_ID();
        }
        object = "SUM|" + this.partnerId + "|" + string + "|" + n + "|" + timestamp.getTime() + "|" + timestamp2.getTime() + "|" + bl;
        BigDecimal bigDecimal = this.conceptAgregateMap.get(object);
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(MHRMovement.getConceptSum(this.getCtx(), string, n, this.partnerId, timestamp, timestamp2, bl, this.get_TrxName()));
            this.conceptAgregateMap.put((String)object, bigDecimal);
        }
        return bigDecimal.doubleValue();
    }

    public double getConceptAvg(String string, String string2, Timestamp timestamp, Timestamp timestamp2) {
        return this.getConceptAvg(string, string2, timestamp, timestamp2, true);
    }

    public double getConceptAvg(String string, String string2, Timestamp timestamp, Timestamp timestamp2, boolean bl) {
        Object object;
        int n;
        if (string2 == null) {
            n = this.getHR_Payroll_ID();
        } else {
            object = MHRPayroll.getByValue(this.getCtx(), string2, this.get_TrxName());
            if (object == null) {
                return 0.0;
            }
            n = ((PO)object).get_ID();
        }
        object = "AVG|" + this.partnerId + "|" + string + "|" + n + "|" + timestamp.getTime() + "|" + timestamp2.getTime() + "|" + bl;
        BigDecimal bigDecimal = this.conceptAgregateMap.get(object);
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal(MHRMovement.getConceptAvg(this.getCtx(), string, n, this.partnerId, timestamp, timestamp2, bl, this.get_TrxName()));
            this.conceptAgregateMap.put((String)object, bigDecimal);
        }
        return bigDecimal.doubleValue();
    }

    public double getAttribute(Properties properties, String string, Timestamp timestamp, Timestamp timestamp2) {
        logger.warning("not implemented yet -> getByConceptAndPartnerId (Properties, String, Timestamp, Timestamp)");
        return 0.0;
    }

    public double getAttribute(Properties properties, String string, int n, int n2, String string2, String string3) {
        logger.warning("not implemented yet -> getByConceptAndPartnerId (Properties, String, int, int, String, String)");
        return 0.0;
    }

    public int getAttributeInvoice(String string) {
        MHRAttribute mHRAttribute = this.getAttributeInstance(string);
        if (mHRAttribute == null) {
            return 0;
        }
        return mHRAttribute.get_ValueAsInt("C_Invoice_ID");
    }

    public int getAttributeDocType(String string) {
        MHRAttribute mHRAttribute = this.getAttributeInstance(string);
        if (mHRAttribute == null) {
            return 0;
        }
        return mHRAttribute.get_ValueAsInt("C_DocType_ID");
    }

    public BigDecimal getAttributeByPartnerId(String string, int n, Timestamp timestamp) {
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string, this.get_TrxName());
        MHRAttribute mHRAttribute = this.getAttributeInstance(string, n, timestamp);
        if (mHRAttribute == null) {
            return BigDecimal.ZERO;
        }
        if (mHRConcept.getColumnType().equals("Q")) {
            return mHRAttribute.getQty();
        }
        if (mHRConcept.getColumnType().equals("A")) {
            return mHRAttribute.getAmount();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAttributeByPartnerId(String string, int n) {
        return this.getAttributeByPartnerId(string, n, null);
    }

    @Deprecated
    public BigDecimal getAttributeBPartner(String string, int n) {
        return this.getAttributeByPartnerId(string, n);
    }

    public double getDays(int n) {
        logger.warning("instead of using getDays in the formula it's recommended to use _DaysPeriod+1");
        return Env.getContextAsInt(this.getCtx(), "_DaysPeriod") + 1;
    }

    public static MHRProcess copyFrom(MHRProcess mHRProcess, Timestamp timestamp, int n, boolean bl, String string, boolean bl2) {
        MHRProcess mHRProcess2 = new MHRProcess(mHRProcess.getCtx(), 0, string);
        PO.copyValues(mHRProcess, mHRProcess2, mHRProcess.getAD_Client_ID(), mHRProcess.getAD_Org_ID());
        mHRProcess2.setReversal(true);
        mHRProcess2.set_ValueNoCheck("DocumentNo", null);
        mHRProcess2.setDocStatus("DR");
        mHRProcess2.setDocAction("CO");
        mHRProcess2.setName(mHRProcess.getDocumentNo());
        mHRProcess2.setC_DocType_ID(n);
        mHRProcess2.setC_DocTypeTarget_ID(n);
        mHRProcess2.setDateAcct(timestamp);
        mHRProcess2.setHR_Job_ID(mHRProcess.getHR_Job_ID());
        mHRProcess2.setHR_Department_ID(mHRProcess.getHR_Department_ID());
        mHRProcess2.setHR_Payroll_ID(mHRProcess.getHR_Payroll_ID());
        mHRProcess2.setHR_Period_ID(mHRProcess.getHR_Period_ID());
        mHRProcess2.setC_BPartner_ID(mHRProcess.getC_BPartner_ID());
        mHRProcess2.setHR_Employee_ID(mHRProcess.getHR_Employee_ID());
        mHRProcess2.setPosted(false);
        mHRProcess2.setProcessed(false);
        mHRProcess2.setProcessing(false);
        mHRProcess2.saveEx();
        if (mHRProcess2.copyLinesFrom(mHRProcess) == 0) {
            throw new IllegalStateException("Could not create Payroll Lines");
        }
        return mHRProcess2;
    }

    public int copyLinesFrom(MHRProcess mHRProcess) {
        if (this.isProcessed() || this.isPosted() || mHRProcess == null) {
            return 0;
        }
        List<MHRMovement> list = MHRMovement.findByProcess(mHRProcess);
        for (MHRMovement mHRMovement : list) {
            MHRMovement mHRMovement2 = new MHRMovement(this.getCtx(), 0, mHRProcess.get_TrxName());
            PO.copyValues(mHRMovement, mHRMovement2, mHRMovement.getAD_Client_ID(), mHRMovement.getAD_Org_ID());
            mHRMovement2.setIsManual(mHRMovement.isManual());
            mHRMovement2.setHR_Concept_Category_ID(mHRMovement.getHR_Concept_Category_ID());
            mHRMovement2.setHR_Concept_Type_ID(mHRMovement.getHR_Concept_Type_ID());
            mHRMovement2.setHR_Process_ID(this.getHR_Process_ID());
            mHRMovement2.setC_BPartner_ID(mHRMovement.getC_BPartner_ID());
            mHRMovement2.setHR_Concept_ID(mHRMovement.getHR_Concept_ID());
            mHRMovement2.setDescription(mHRMovement.getDescription());
            mHRMovement2.setHR_Department_ID(mHRMovement.getHR_Department_ID());
            mHRMovement2.setHR_Job_ID(mHRMovement.getHR_Job_ID());
            mHRMovement2.setIsPrinted(mHRMovement.isPrinted());
            mHRMovement2.setQty(mHRMovement.getQty().negate());
            mHRMovement2.setServiceDate(mHRMovement.getServiceDate());
            mHRMovement2.setTextMsg(mHRMovement.getTextMsg());
            mHRMovement2.setValidFrom(mHRMovement.getValidFrom());
            mHRMovement2.setValidTo(mHRMovement.getValidTo());
            mHRMovement2.setAD_Rule_ID(mHRMovement.getAD_Rule_ID());
            mHRMovement2.setAmount(mHRMovement.getAmount().negate());
            mHRMovement2.setC_Activity_ID(mHRMovement.getC_Activity_ID());
            mHRMovement2.setC_Campaign_ID(mHRMovement.getC_Campaign_ID());
            mHRMovement2.setAD_OrgTrx_ID(mHRMovement.getAD_OrgTrx_ID());
            mHRMovement2.setC_ProjectPhase_ID(mHRMovement.getC_ProjectPhase_ID());
            mHRMovement2.setC_ProjectPhase_ID(mHRMovement.getC_ProjectPhase_ID());
            mHRMovement2.setC_Project_ID(mHRMovement.getC_Project_ID());
            mHRMovement2.setUser1_ID(mHRMovement.getUser1_ID());
            mHRMovement2.setUser2_ID(mHRMovement.getUser2_ID());
            mHRMovement2.setUser3_ID(mHRMovement.getUser3_ID());
            mHRMovement2.setUser4_ID(mHRMovement.getUser4_ID());
            mHRMovement2.setProcessed(false);
            mHRMovement2.setC_BP_Group_ID(mHRMovement.getC_BP_Group_ID());
            mHRMovement2.setHR_Employee_ID(mHRMovement.getHR_Employee_ID());
            mHRMovement2.setHR_EmployeeType_ID(mHRMovement.getHR_EmployeeType_ID());
            mHRMovement2.setHR_SkillType_ID(mHRMovement.getHR_SkillType_ID());
            mHRMovement2.setHR_Payroll_ID(mHRMovement.getHR_Payroll_ID());
            mHRMovement2.setHR_Contract_ID(MHRPayroll.getById(this.getCtx(), mHRMovement.getHR_Payroll_ID(), mHRMovement.get_TrxName()).getHR_Contract_ID());
            mHRMovement2.saveEx();
        }
        return list.size();
    }

    public MHREmployee setEmployee(String string, String string2) {
        PO pO;
        MHRPeriod mHRPeriod;
        MBPartner mBPartner = MBPartner.get(this.getCtx(), string);
        if (mBPartner == null) {
            throw new AdempiereException("@C_BPartner_ID@ @NotFound@ " + string);
        }
        this.partnerId = mBPartner.get_ID();
        MHRConcept mHRConcept = MHRConcept.getByValue(this.getCtx(), string2, this.get_TrxName());
        if (mHRConcept == null) {
            throw new AdempiereException("@HR_Concept_ID@ @NotFound@ " + string2);
        }
        this.payrollConceptId = mHRConcept.get_ID();
        this.columnType = mHRConcept.getColumnType();
        this.employee = MHREmployee.getActiveEmployee(this.getCtx(), this.partnerId, this.get_TrxName());
        if (this.getHR_Payroll_ID() > 0) {
            this.payrollId = this.getHR_Payroll_ID();
        }
        if (this.getHR_Department_ID() > 0) {
            this.departmentId = this.getHR_Department_ID();
        }
        if (this.getHR_Job_ID() > 0) {
            this.jobId = this.getHR_Job_ID();
        }
        if (this.getHR_Period_ID() > 0) {
            mHRPeriod = MHRPeriod.getById(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        } else {
            mHRPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            pO = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getAD_Org_ID());
            if (pO != null) {
                mHRPeriod.setStartDate(((X_C_Period)pO).getStartDate());
                mHRPeriod.setEndDate(((X_C_Period)pO).getEndDate());
            } else {
                mHRPeriod.setStartDate(this.getDateAcct());
                mHRPeriod.setEndDate(this.getDateAcct());
            }
        }
        this.dateFrom = mHRPeriod.getStartDate();
        this.dateTo = mHRPeriod.getEndDate();
        pO = MHRPayroll.getById(this.getCtx(), this.getHR_Payroll_ID(), this.get_TrxName());
        this.scriptCtx.clear();
        this.scriptCtx.put("process", this);
        this.scriptCtx.put("_Process", this.getHR_Process_ID());
        this.scriptCtx.put("_Period", mHRPeriod.getHR_Period_ID());
        this.scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        this.scriptCtx.put("_PayrollValue", Optional.ofNullable(((X_HR_Payroll)pO).getValue()).orElse(null));
        this.scriptCtx.put("_Department", this.getHR_Department_ID());
        logger.info("info data - Process " + this.getHR_Process_ID() + ", Period :" + this.getHR_Period_ID() + ", Payroll : " + this.getHR_Payroll_ID() + ", Department : " + this.getHR_Department_ID());
        this.scriptCtx.put("_From", this.dateFrom);
        this.scriptCtx.put("_To", this.dateTo);
        this.scriptCtx.put("_Period", mHRPeriod.getPeriodNo());
        this.scriptCtx.remove("_DateStart");
        this.scriptCtx.remove("_DateEnd");
        this.scriptCtx.remove("_Days");
        this.scriptCtx.remove("_C_BPartner_ID");
        this.scriptCtx.remove("_HR_Employee_ID");
        this.scriptCtx.put("_DateStart", this.employee.getStartDate());
        this.scriptCtx.put("_DateEnd", this.employee.getEndDate() == null ? TimeUtil.getDay(2999, 12, 31) : this.employee.getEndDate());
        this.scriptCtx.put("_Days", TimeUtil.getDaysBetween(mHRPeriod.getStartDate(), mHRPeriod.getEndDate(), new int[0]) + 1);
        this.scriptCtx.put("_C_BPartner_ID", this.employee.getC_BPartner_ID());
        this.scriptCtx.put("_HR_Employee_ID", this.employee.getHR_Employee_ID());
        this.scriptCtx.put("_Employee", this.employee);
        this.scriptCtx.remove("_HR_Concept_ID");
        this.scriptCtx.remove("_HR_Concept");
        this.scriptCtx.put("_HR_Concept_ID", mHRConcept.getHR_Concept_ID());
        this.scriptCtx.put("_HR_Concept", mHRConcept);
        this.scriptCtx.remove("_HR_PayrollConcept_ID");
        this.movements = new Hashtable();
        this.payrollConcepts = MHRPayrollConcept.getPayrollConcepts(this);
        this.loadMovements(this.movements, this.employee.getC_BPartner_ID());
        if (!mHRConcept.isManual()) {
            this.movements.remove(mHRConcept.get_ID());
        }
        return this.employee;
    }

    public double getCommissionAmt(int n, Timestamp timestamp, Timestamp timestamp2, String string) {
        BigDecimal bigDecimal = MCommission.getCommissionAmt((int)n, (Timestamp)timestamp, (Timestamp)timestamp2, (String)string, (String)this.get_TrxName());
        if (bigDecimal == null) {
            return 0.0;
        }
        return bigDecimal.doubleValue();
    }

    public double getCommissionAmt(Timestamp timestamp, Timestamp timestamp2, String string) {
        return this.getCommissionAmt(this.partnerId, timestamp, timestamp2, string);
    }

    public double getCommissionAmt(String string) {
        return this.getCommissionAmt(this.dateFrom, this.dateTo, string);
    }

    public double getCommissionAmt() {
        return this.getCommissionAmt(null);
    }

    public double getIncidenceSum(String string, String string2, Timestamp timestamp, Timestamp timestamp2) {
        return TNAUtil.getIncidenceSum(this.getCtx(), string, string2, this.partnerId, timestamp, timestamp2, this.get_TrxName());
    }

    public double getIncidenceSum(String string, Timestamp timestamp, Timestamp timestamp2) {
        return TNAUtil.getIncidenceSum(this.getCtx(), string, null, this.partnerId, timestamp, timestamp2, this.get_TrxName());
    }

    @Override
    public void setReversal(boolean bl) {
        this.isReversal = bl;
    }

    @Override
    public boolean isReversal() {
        return this.isReversal;
    }
}

