/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_HR_Concept;
import org.adempiere.core.domains.models.X_HR_Concept_Acct;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRule;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MHRConcept
extends X_HR_Concept {
    private static final long serialVersionUID = 7859469065116713767L;
    private static CCache<Integer, MHRConcept> cache = new CCache("HR_Concept", 100);
    private static CCache<String, MHRConcept> cacheValue = new CCache("HR_Concept_Value", 100);

    public MHRConcept(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setValue("");
            this.setName("");
            this.setDescription("");
            this.setIsEmployee(false);
            this.setIsPrinted(false);
            this.setHR_Payroll_ID(0);
            this.setHR_Job_ID(0);
            this.setHR_Department_ID(0);
        }
    }

    public MHRConcept(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Deprecated
    public static MHRConcept get(Properties properties, int n) {
        return MHRConcept.getById(properties, n, null);
    }

    public static MHRConcept getById(Properties properties, int n, String string) {
        if (n <= 0) {
            return null;
        }
        MHRConcept mHRConcept = cache.get(n);
        if (mHRConcept != null) {
            return mHRConcept;
        }
        mHRConcept = new MHRConcept(properties, n, string);
        if (mHRConcept.get_ID() == n) {
            cache.put(n, mHRConcept);
        } else {
            mHRConcept = null;
        }
        return mHRConcept;
    }

    @Deprecated
    public static MHRConcept forValue(Properties properties, String string) {
        return MHRConcept.getByValue(properties, string, null);
    }

    public static MHRConcept getByValue(Properties properties, String string, String string2) {
        if (Util.isEmpty(string, true)) {
            return null;
        }
        int n = Env.getAD_Client_ID(properties);
        String string3 = n + "#" + string;
        MHRConcept mHRConcept = cacheValue.get(string3);
        if (mHRConcept != null) {
            return mHRConcept;
        }
        mHRConcept = (MHRConcept)new Query(properties, "HR_Concept", "Value=? AND AD_Client_ID IN (?,?)", string2).setParameters(string, 0, n).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (mHRConcept != null) {
            cacheValue.put(string3, mHRConcept);
            cache.put(mHRConcept.get_ID(), mHRConcept);
        }
        return mHRConcept;
    }

    @Deprecated
    public static MHRConcept[] getConcepts(int n, int n2, String string) {
        return MHRConcept.getConcepts(n, n2, string, null).toArray(new MHRConcept[0]);
    }

    public static List<MHRConcept> getConcepts(int n, int n2, String string, String string2) {
        Properties properties = Env.getCtx();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID in (?,?)");
        arrayList.add(0);
        arrayList.add(Env.getAD_Client_ID(Env.getCtx()));
        stringBuffer.append(" AND (HR_Payroll_ID =? OR HR_Payroll_ID IS NULL)");
        arrayList.add(n);
        if (n2 != 0) {
            stringBuffer.append(" AND HR_Concept.HR_Department_ID=?");
            arrayList.add(n2);
        }
        if (!Util.isEmpty(string)) {
            stringBuffer.append(string);
        }
        return new Query(properties, "HR_Concept", stringBuffer.toString(), string2).setParameters(arrayList).setOnlyActiveRecords(true).setOrderBy("COALESCE(SeqNo,999999999999) DESC, Value").list();
    }

    public int getConceptAccountCR() {
        String string = " HR_Expense_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int n = DB.getSQLValue("ConceptCR", string);
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public int getConceptAccountDR() {
        String string = " HR_Revenue_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int n = DB.getSQLValue("ConceptDR", string);
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public X_HR_Concept_Acct getConceptAcct(int n) {
        return (X_HR_Concept_Acct)new Query(this.getCtx(), "HR_Concept_Acct", "HR_Concept_ID = ? AND C_AcctSchema_ID = ?", this.get_TrxName()).setParameters(this.getHR_Concept_ID(), n).first();
    }

    public X_HR_Concept_Acct getConceptAcct(Optional<Integer> optional, Optional<Integer> optional2, Optional<Integer> optional3) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        stringBuilder.append("HR_Concept_ID").append("=?");
        arrayList.add(this.getHR_Concept_ID());
        optional.ifPresent(n -> {
            stringBuilder.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            arrayList.add(n);
        });
        optional2.ifPresent(n -> {
            stringBuilder.append("AND (").append("HR_Payroll_ID").append("=? OR  ").append("HR_Payroll_ID").append(" IS NULL)");
            arrayList.add(n);
        });
        optional3.ifPresent(n -> {
            stringBuilder.append(" AND (").append("C_BP_Group_ID").append("=? OR  ").append("C_BP_Group_ID").append(" IS NULL)");
            arrayList.add(n);
        });
        return (X_HR_Concept_Acct)new Query(this.getCtx(), "HR_Concept_Acct", stringBuilder.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("C_AcctSchema_ID DESC , HR_Payroll_ID DESC , C_BP_Group_ID DESC ").first();
    }

    @Override
    public String toString() {
        return this.getValue() + " - " + this.getName();
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.is_Changed() && this.is_ValueChanged("Value")) {
            String string = (String)this.get_ValueOld("Value");
            String string2 = this.getValue();
            String string3 = this.validateRules(string);
            if (string3.length() > 0) {
                throw new AdempiereException("@RecordFound@ @HR_Concept_ID@: " + this.getName() + " [@OldValue@: " + string + " @NewValue@: " + string2 + " ]" + string3);
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        String string = this.validateRules(this.getValue());
        if (string.length() > 0) {
            throw new AdempiereException("@HR_Concept_ID@ @CannotDeleteUsed@ " + string);
        }
        return true;
    }

    private String validateRules(String string) {
        AtomicReference<String> atomicReference = new AtomicReference<String>("");
        List<MRule> list = this.getRulesDependences(string);
        list.forEach(mRule -> {
            String string = Msg.parseTranslation(this.getCtx(), " @AD_Rule_ID@: ") + mRule.getValue() + Msg.parseTranslation(this.getCtx(), " -> ") + mRule.getName() + " , ";
            atomicReference.getAndUpdate(string2 -> string2 + string);
        });
        return atomicReference.get();
    }

    private List<MRule> getRulesDependences(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EventType").append("=? AND ").append("Script").append(" LIKE '%\"" + string + "\"%'");
        return new Query(this.getCtx(), "AD_Rule", stringBuilder.toString(), this.get_TrxName()).setParameters("H").list();
    }
}

