/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.acct;

import java.math.BigDecimal;
import org.adempiere.core.domains.models.X_HR_Concept_Acct;
import org.compiere.acct.DocLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.acct.Doc_HRProcess;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;

public class DocLine_Payroll
extends DocLine {
    private int processId = 0;
    private int conceptId = 0;
    private int bPartnerId = 0;
    private int orgId = 0;
    private int orgTrxId = 0;
    private int activityId = 0;
    private int projectId = 0;
    private int projectPhaseId = 0;
    private int projectTaskId = 0;
    private int campaignId = 0;
    private int user1Id = 0;
    private int user2Id = 0;
    private int user3Id = 0;
    private int user4Id = 0;
    private String accountSign = "";
    private BigDecimal amount = Env.ZERO;
    private int departmentId = 0;
    private int bPGroupId = 0;
    private int payrollId = 0;

    public DocLine_Payroll(MHRMovement mHRMovement, Doc_HRProcess doc_HRProcess) {
        super(mHRMovement, doc_HRProcess);
        int n = mHRMovement.getC_BPartner_ID();
        MHRConcept mHRConcept = MHRConcept.getById(Env.getCtx(), mHRMovement.getHR_Concept_ID(), this.getTrxName());
        this.conceptId = mHRConcept.getHR_Concept_ID();
        this.processId = mHRMovement.getHR_Process_ID();
        this.accountSign = mHRConcept.getAccountSign();
        this.amount = mHRMovement.getAmount();
        this.bPartnerId = n;
        this.departmentId = mHRMovement.getHR_Department_ID();
        this.payrollId = mHRMovement.getHR_Payroll_ID();
        this.bPGroupId = mHRMovement.getC_BP_Group_ID();
        if (this.bPGroupId == 0) {
            this.bPGroupId = DB.getSQLValue(doc_HRProcess.getTrxName(), "SELECT C_BP_Group_ID FROM C_BPartner WHERE C_BPartner_ID=?", n);
        }
        this.orgId = mHRMovement.getAD_Org_ID();
        this.orgTrxId = mHRMovement.getAD_OrgTrx_ID();
        this.activityId = mHRMovement.getC_Activity_ID();
        this.projectId = mHRMovement.getC_Project_ID();
        this.projectPhaseId = mHRMovement.getC_ProjectPhase_ID();
        this.projectTaskId = mHRMovement.getC_ProjectTask_ID();
        this.user1Id = mHRMovement.getUser1_ID();
        this.user2Id = mHRMovement.getUser2_ID();
        this.user3Id = mHRMovement.getUser3_ID();
        this.user4Id = mHRMovement.getUser4_ID();
        this.setAmount(mHRMovement.getAmount());
    }

    public int getHR_Process_ID() {
        return this.processId;
    }

    public int getHR_Concept_ID() {
        return this.conceptId;
    }

    public String getAccountSign() {
        return this.accountSign;
    }

    @Override
    public int getC_BPartner_ID() {
        return this.bPartnerId;
    }

    @Override
    public int getC_Activity_ID() {
        return this.activityId;
    }

    @Override
    public int getC_Project_ID() {
        return this.projectId;
    }

    @Override
    public int getC_ProjectPhase_ID() {
        return this.projectPhaseId;
    }

    @Override
    public int getC_ProjectTask_ID() {
        return this.projectTaskId;
    }

    @Override
    public int getC_Campaign_ID() {
        return this.campaignId;
    }

    @Override
    public int getUser1_ID() {
        return this.user1Id;
    }

    @Override
    public int getUser2_ID() {
        return this.user2Id;
    }

    @Override
    public int getUser3_ID() {
        return this.user3Id;
    }

    @Override
    public int getUser4_ID() {
        return this.user4Id;
    }

    @Override
    public int getAD_Org_ID() {
        return this.orgId;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        return this.orgTrxId;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public int getHR_Department_ID() {
        return this.departmentId;
    }

    public int getC_BP_Group_ID() {
        return this.bPGroupId;
    }

    public int getHR_Payroll_ID() {
        return this.payrollId;
    }

    public Integer getAccountSchemaId() {
        return this.getC_AcctSchema_ID() > 0 ? Integer.valueOf(this.getC_AcctSchema_ID()) : null;
    }

    public Integer getPartnerGroupId() {
        return this.getC_BP_Group_ID() > 0 ? Integer.valueOf(this.getC_BP_Group_ID()) : null;
    }

    public Integer getPayrollId() {
        return this.getHR_Payroll_ID() > 0 ? Integer.valueOf(this.getHR_Payroll_ID()) : null;
    }

    public X_HR_Concept_Acct getConceptAcct(int n) {
        MHRConcept mHRConcept = MHRConcept.getById(Env.getCtx(), this.getHR_Concept_ID(), this.getTrxName());
        if (mHRConcept != null) {
            return mHRConcept.getConceptAcct(n);
        }
        return null;
    }
}

