/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.grid;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MViewColumn;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IDColumnEditor;
import org.compiere.minigrid.IDColumnRenderer;
import org.compiere.minigrid.ROCellEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CTable;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.form.VBrowser;
import org.eevolution.grid.BrowserRow;
import org.eevolution.grid.IBrowserTable;
import org.eevolution.grid.VBrowserCellEditor;

public class VBrowserTable
extends CTable
implements IBrowserTable {
    private static final long serialVersionUID = 2853772547464132497L;
    private static CLogger log = CLogger.getCLogger(VBrowserTable.class);
    private BrowserRow browserRows = null;
    private VBrowser browser;
    private ArrayList<Integer> m_readWriteColumn = new ArrayList();
    private ArrayList<Integer> m_minWidth = new ArrayList();
    private int m_colorColumnIndex = -1;
    private Object m_colorDataCompare = Env.ZERO;
    private boolean m_multiSelection = false;
    private boolean showTotals = false;
    private boolean autoResize = true;
    private Properties ctx = Env.getCtx();
    private List<MBrowseField> browserFields = null;

    public VBrowserTable(VBrowser browser) {
        this.browserRows = new BrowserRow(this);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setCellEditor(new ROCellEditor());
        this.browser = browser;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public TableColumn getColumn(int col) {
        return this.getColumnModel().getColumn(col);
    }

    @Override
    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    @Override
    public void autoSize() {
        if (!this.autoResize) {
            return;
        }
        long start = System.currentTimeMillis();
        int SLACK = 8;
        int MAXSIZE = 300;
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int col = 0; col < size; ++col) {
            TableCellRenderer renderer;
            TableColumn tc = this.getColumnModel().getColumn(col);
            int width = 0;
            if (this.m_minWidth.size() > col) {
                width = this.m_minWidth.get(col);
            }
            if ((renderer = tc.getHeaderRenderer()) == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = Math.max(width, comp.getPreferredSize().width + 8);
            int maxRow = Math.min(30, this.getRowCount());
            for (int row = 0; row < maxRow; ++row) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                if (comp == null) continue;
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
        }
        log.finer("Cols=" + size + " - " + (System.currentTimeMillis() - start) + "ms");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean isSelected = false;
        Object value = this.getValueAt(row, 0);
        if (value instanceof Boolean) {
            isSelected = (Boolean)value;
        } else if (value instanceof IDColumn) {
            isSelected = ((IDColumn)value).isSelected();
        }
        return column == 0 || isSelected && this.m_readWriteColumn.contains(column);
    }

    @Override
    public void setColumnReadOnly(int column, boolean readOnly) {
        if (this.m_readWriteColumn.contains(column)) {
            if (readOnly) {
                int size = this.m_readWriteColumn.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.m_readWriteColumn.get(i2) != column) continue;
                    this.m_readWriteColumn.remove(i2);
                    break;
                }
            }
        } else if (!readOnly) {
            this.m_readWriteColumn.add(column);
        }
    }

    @Override
    public String prepareTable(List<MBrowseField> fields, boolean multiSelection) {
        StringBuffer sql = new StringBuffer("");
        this.m_multiSelection = multiSelection;
        this.browserFields = fields;
        int col = 0;
        for (MBrowseField field : fields) {
            MViewColumn columnView = field.getAD_View_Column();
            if (col > 0 && columnView.getColumnSQL().length() > 0) {
                sql.append(", ");
            }
            if (field.isKey()) {
                this.setKey(col);
                field.setName("#");
            }
            sql.append(columnView.getColumnSQL()).append(" ").append("AS").append(" ").append(columnView.getColumnName());
            this.browserRows.addBrowserField(field, col);
            if (field.isDisplayed()) {
                this.addColumn(field.get_Translation("Name"));
            }
            ++col;
        }
        col = 0;
        for (MBrowseField field : fields) {
            if (!field.isDisplayed()) continue;
            this.setColumnClass(col, MBrowseField.createGridFieldVO(field, this.browser.getWindowNo()), field.getAD_Reference_ID(), field.isReadOnly(), field.get_Translation("Name"));
            ++col;
        }
        return sql.toString();
    }

    @Override
    public void addColumn(String header) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addColumn(Util.cleanAmp(header));
    }

    @Override
    public void setColumnClass(int index, GridField gridField, int displayType, boolean readOnly, String header) {
        TableColumn tc = this.getColumnModel().getColumn(index);
        if (tc == null) {
            return;
        }
        this.setColumnReadOnly(index, readOnly);
        if (header != null && header.length() > 0) {
            tc.setHeaderValue(Util.cleanAmp(header));
        }
        if (index == this.p_keyColumnIndex) {
            tc.setCellRenderer(new IDColumnRenderer(this.m_multiSelection));
            if (this.m_multiSelection) {
                tc.setCellEditor(new IDColumnEditor());
                this.setColumnReadOnly(index, false);
            } else {
                tc.setCellEditor(new ROCellEditor());
            }
            this.m_minWidth.add(10);
            tc.setMaxWidth(20);
            tc.setPreferredWidth(20);
            tc.setResizable(false);
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else {
            tc.setCellRenderer(new VCellRenderer(gridField));
            tc.setCellEditor(new VBrowserCellEditor(gridField));
            this.m_minWidth.add(30);
            tc.setHeaderRenderer(new VHeaderRenderer(displayType));
        }
    }

    @Override
    public void setRowCount(int no) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setRowCount(no);
    }

    @Override
    public Integer getSelectedRowKey() {
        if (this.browserRows.getColumnCount() == 0) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (data instanceof IDColumn) {
                data = ((IDColumn)data).getRecord_ID();
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
        }
        return null;
    }

    public Collection<Integer> getSelectedKeys() {
        if (this.browserRows.getColumnCount() == 0) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        if (this.p_keyColumnIndex < 0) {
            throw new UnsupportedOperationException("Key Column is not defined");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            IDColumn record;
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (!(data instanceof IDColumn) || !(record = (IDColumn)data).isSelected()) continue;
            list.add(record.getRecord_ID());
        }
        return list;
    }

    @Override
    public boolean isMultiSelection() {
        return this.m_multiSelection;
    }

    @Override
    public void setMultiSelection(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
    }

    public void setColorColumn(int modelIndex) {
        this.m_colorColumnIndex = modelIndex;
    }

    @Override
    public void setColorCompare(Object dataCompare) {
        this.m_colorDataCompare = dataCompare;
    }

    @Override
    public int getColorCode(int row) {
        if (this.m_colorColumnIndex == -1) {
            return 0;
        }
        Object data = this.getModel().getValueAt(row, this.m_colorColumnIndex);
        int cmp = 0;
        if (data == null) {
            return 0;
        }
        try {
            if (data instanceof Timestamp) {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof Timestamp)) {
                    this.m_colorDataCompare = new Timestamp(System.currentTimeMillis());
                }
                cmp = ((Timestamp)this.m_colorDataCompare).compareTo((Timestamp)data);
            } else {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof BigDecimal)) {
                    this.m_colorDataCompare = Env.ZERO;
                }
                if (!(data instanceof BigDecimal)) {
                    data = new BigDecimal(data.toString());
                }
                cmp = ((BigDecimal)this.m_colorDataCompare).compareTo((BigDecimal)data);
            }
        }
        catch (Exception e) {
            return 0;
        }
        if (cmp > 0) {
            return -1;
        }
        if (cmp < 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isShowTotals() {
        return this.showTotals;
    }

    @Override
    public void setShowTotals(boolean show) {
        this.showTotals = show;
    }

    public void addTotals() {
        int row;
        if (this.getRowCount() == 0 || this.browserRows.getNoViewColumns() == 0) {
            return;
        }
        Object[] total = new Object[this.browserRows.getNoViewColumns().intValue()];
        for (row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.browserRows.getNoViewColumns(); ++col) {
                Object data = this.getModel().getValueAt(row, col);
                int ReferenceType2 = this.browserRows.getBrowserField(this.browserRows.getTableIndex(col)).getAD_Reference_ID();
                if (!DisplayType.isNumeric(ReferenceType2)) continue;
                BigDecimal subtotal = Env.ZERO;
                if (total[col] != null) {
                    if (total[col] instanceof BigDecimal) {
                        subtotal = (BigDecimal)total[col];
                    }
                    if (total[col] instanceof Integer) {
                        subtotal = new BigDecimal((Integer)total[col]);
                    }
                }
                BigDecimal amt = Env.ZERO;
                if (data == null) {
                    amt = Env.ZERO;
                }
                if (data instanceof BigDecimal) {
                    amt = (BigDecimal)data;
                }
                if (data instanceof Integer) {
                    amt = new BigDecimal((Integer)data);
                }
                if (subtotal == null) {
                    subtotal = Env.ZERO;
                }
                total[col] = subtotal.add(amt);
            }
        }
        row = this.getRowCount() + 1;
        boolean markerSet = false;
        this.setRowCount(row);
        for (int col = 0; col < this.browserRows.getNoViewColumns(); ++col) {
            MBrowseField field = this.browserRows.getBrowserField(this.browserRows.getTableIndex(col));
            GridField gridField = MBrowseField.createGridFieldVO(field, this.browser.getWindowNo());
            if (DisplayType.isNumeric(field.getAD_Reference_ID())) {
                gridField.setValue(total[col], true);
                this.setValueAt(row - 1, col, gridField);
                continue;
            }
            if (DisplayType.isText(field.getAD_Reference_ID()) && !markerSet) {
                gridField.setValue(" \u03a3 ", true);
                this.setValueAt(row - 1, col, gridField);
                markerSet = true;
                continue;
            }
            gridField.setValue(null, true);
            this.setValueAt(row - 1, col, gridField);
        }
    }

    @Override
    public BrowserRow getData() {
        return this.browserRows;
    }

    @Override
    public void setValueAt(int row, int column, GridField gridField) {
        if (gridField == null) {
            throw new UnsupportedOperationException("No GridField");
        }
        this.browserRows.setValue(row, this.browserRows.getTableIndex(column), gridField);
        if (gridField.isDisplayed()) {
            super.setValueAt(gridField.getValue(), row, column);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        GridField gridField = this.browserRows.getValue(row, this.browserRows.getTableIndex(column));
        gridField.setValue(value, true);
        this.setValueAt(row, column, gridField);
    }

    private void setValueAnyColumn(int row, int column, GridField gridField) {
        if (gridField == null) {
            throw new UnsupportedOperationException("No GridField");
        }
        this.browserRows.setValue(row, column, gridField);
        if (gridField.isDisplayed()) {
            super.setValueAt(gridField.getValue(), row, this.browserRows.getDisplayIndex(column));
        }
    }

    private void setKey(int col) {
        this.p_keyColumnIndex = col;
        this.browser.keyColumnIndex = col;
    }

    @Override
    protected void sort(int modelColumnIndex) {
        Boolean isCanSort = true;
        for (MBrowseField browseField : this.getFields()) {
            if (browseField.isReadOnly()) continue;
            isCanSort = false;
            break;
        }
        if (isCanSort.booleanValue()) {
            super.sort(modelColumnIndex);
        }
    }

    public List<MBrowseField> getFields() {
        return this.browserFields;
    }

    @Override
    public int loadTable(ResultSet rs) {
        long start = System.currentTimeMillis();
        int row = 0;
        int no = 0;
        this.setRowCount(row);
        try {
            log.fine("Start load - " + (System.currentTimeMillis() - start) + "ms");
            while (rs.next()) {
                ++no;
                this.setRowCount(row + 1);
                int colOffset = 1;
                int column = 0;
                for (MBrowseField field : this.getFields()) {
                    Object value = null;
                    if (field.isKey() && DisplayType.isID(field.getAD_Reference_ID()) && !field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) {
                        value = new IDColumn(rs.getInt(column + colOffset));
                    } else if (field.isKey() && (DisplayType.isNumeric(field.getAD_Reference_ID()) && field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"") || !DisplayType.isID(field.getAD_Reference_ID()) && 11 != field.getAD_Reference_ID())) {
                        value = new IDColumn(no);
                    } else if (DisplayType.isID(field.getAD_Reference_ID()) || field.getAD_Reference_ID() == 11) {
                        Integer id = rs.getInt(column + colOffset);
                        value = id != 0 ? id : null;
                    } else if (DisplayType.isNumeric(field.getAD_Reference_ID())) {
                        value = rs.getBigDecimal(column + colOffset);
                    } else if (DisplayType.isDate(field.getAD_Reference_ID())) {
                        value = rs.getTimestamp(column + colOffset);
                    } else if (20 == field.getAD_Reference_ID()) {
                        value = rs.getString(column + colOffset);
                        if (value != null) {
                            value = value.equals("Y");
                        }
                    } else {
                        value = rs.getObject(column + colOffset);
                    }
                    GridField gridField = MBrowseField.createGridFieldVO(field, this.browser.getWindowNo());
                    gridField.setValue(value, true);
                    this.setValueAnyColumn(row, column, gridField);
                    ++column;
                }
                ++row;
            }
            log.fine("End load - " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "", e);
        }
        log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        if (this.isShowTotals()) {
            this.addTotals();
        }
        this.autoSize();
        return no;
    }

    @Override
    public String processCallOut(GridField field, Object value, Object oldValue, int currentRow, int currentColumn) {
        return this.browserRows.processCallOut(this.ctx, this.browser.getWindowNo(), field, value, oldValue, currentRow, currentColumn);
    }

    @Override
    public GridField getGridFieldAt(int row, int column) {
        return this.browserRows.getValue(row, this.browserRows.getTableIndex(column));
    }
}

