/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.freight.model.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.I_M_Shipper;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_DD_Order;
import org.adempiere.core.domains.models.X_WM_InOutBound;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPackage;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.model.MDDOrderLine;
import org.eevolution.freight.engine.FreightEngine;
import org.eevolution.freight.engine.FreightEngineFactory;
import org.eevolution.freight.engine.FreightInfo;
import org.eevolution.wms.model.MWMInOutBound;
import org.eevolution.wms.model.MWMInOutBoundLine;

public class Freight
implements ModelValidator {
    FreightEngine freightEngine;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        Integer n = mClient != null ? Integer.valueOf(mClient.getAD_Client_ID()) : Integer.valueOf(this.getAD_Client_ID());
        this.freightEngine = FreightEngineFactory.getFreightEngine(n);
        modelValidationEngine.addModelChange("C_OrderLine", this);
        modelValidationEngine.addModelChange("WM_InOutBoundLine", this);
        modelValidationEngine.addModelChange("DD_OrderLine", this);
        modelValidationEngine.addModelChange("M_Package", this);
        modelValidationEngine.addModelChange("M_PackageLine", this);
        modelValidationEngine.addDocValidate("C_Order", this);
        modelValidationEngine.addDocValidate("DD_Order", this);
        modelValidationEngine.addDocValidate("WM_InOutBound", this);
    }

    @Override
    public int getAD_Client_ID() {
        return Env.getAD_Client_ID(Env.getCtx());
    }

    @Override
    public String login(int n, int n2, int n3) {
        return null;
    }

    @Override
    public String docValidate(PO pO, int n) {
        if (9 == n) {
            AtomicReference<BigDecimal> atomicReference;
            PO pO2;
            if (pO instanceof MOrder) {
                pO2 = (MOrder)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                Arrays.stream(((MOrder)pO2).getLines()).forEach(mOrderLine -> atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mOrderLine.getFreightAmt())));
                ((X_C_Order)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
            if (pO instanceof MDDOrder) {
                pO2 = (MDDOrder)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                ((MDDOrder)pO2).getLines().forEach(mDDOrderLine -> atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mDDOrderLine.getFreightAmt())));
                ((X_DD_Order)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
            if (pO instanceof MWMInOutBound) {
                pO2 = (MWMInOutBound)pO;
                atomicReference = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                ((MWMInOutBound)pO2).getLines(false, null).forEach(mWMInOutBoundLine -> {
                    if ("S".equals(mWMInOutBoundLine.getParent().getDeliveryViaRule())) {
                        atomicReference.getAndUpdate(bigDecimal -> bigDecimal.add(mWMInOutBoundLine.getFreightAmt()));
                    }
                });
                ((X_WM_InOutBound)pO2).setFreightAmt(atomicReference.get());
                pO2.saveEx();
            }
        }
        return null;
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        if (2 == n || 1 == n) {
            MPackage mPackage;
            if (pO instanceof MOrderLine) {
                MOrderLine mOrderLine = (MOrderLine)pO;
                if ("S".equals(mOrderLine.getParent().getDeliveryViaRule())) {
                    FreightInfo freightInfo = this.getFreight(mOrderLine, null, null);
                    mOrderLine.setFreightAmt(freightInfo.getFreightAmount().multiply(mOrderLine.getQtyOrdered()));
                    if (!"I".equals(mOrderLine.getParent().getFreightCostRule()) && freightInfo.getFreightAmount().signum() != 0) {
                        BigDecimal bigDecimal = mOrderLine.getPriceActual().add(freightInfo.getFreightAmount());
                        mOrderLine.setPriceEntered(bigDecimal);
                        mOrderLine.setPriceActual(bigDecimal);
                        mOrderLine.setLineNetAmt();
                    }
                }
            } else if (pO instanceof MDDOrderLine) {
                MDDOrderLine mDDOrderLine = (MDDOrderLine)pO;
                if ("S".equals(mDDOrderLine.getParent().getDeliveryViaRule())) {
                    FreightInfo freightInfo = this.getFreight(mDDOrderLine, null, null);
                    mDDOrderLine.setFreightRate(freightInfo.getFreightRate());
                    if (freightInfo.getFreightId() != 0) {
                        mDDOrderLine.setM_Freight_ID(freightInfo.getFreightId());
                    }
                    mDDOrderLine.setFreightAmt(freightInfo.getFreightAmount().multiply(mDDOrderLine.getQtyOrdered()));
                }
            } else if (pO instanceof MWMInOutBoundLine) {
                MWMInOutBoundLine mWMInOutBoundLine = (MWMInOutBoundLine)pO;
                if ("S".equals(mWMInOutBoundLine.getParent().getDeliveryViaRule())) {
                    FreightInfo freightInfo = this.getFreight(mWMInOutBoundLine);
                    mWMInOutBoundLine.setFreightRate(freightInfo.getFreightRate());
                    if (freightInfo.getFreightId() != 0) {
                        mWMInOutBoundLine.setM_Freight_ID(freightInfo.getFreightId());
                    }
                    mWMInOutBoundLine.setFreightAmt(freightInfo.getFreightAmount().multiply(mWMInOutBoundLine.getMovementQty()));
                }
            } else if (pO instanceof MPackage && "S".equals((mPackage = (MPackage)pO).getDeliveryViaRule())) {
                FreightInfo freightInfo = this.getFreightInfo(mPackage);
                mPackage.setFreightAmt(freightInfo.getFreightAmount());
                mPackage.setFreightRate(freightInfo.getFreightRate());
                if (freightInfo.getFreightId() != 0) {
                    mPackage.setM_Freight_ID(freightInfo.getFreightId());
                }
            }
        }
        return null;
    }

    private FreightInfo getFreight(MOrderLine mOrderLine, MWMInOutBound mWMInOutBound2, MWMInOutBoundLine mWMInOutBoundLine) {
        MOrder mOrder = mOrderLine.getParent();
        FreightInfo freightInfo = new FreightInfo();
        MWarehouse mWarehouse = (MWarehouse)mOrder.getM_Warehouse();
        Optional<I_M_Shipper> optional = Optional.ofNullable(Optional.ofNullable(mWMInOutBound2).map(mWMInOutBound -> "L".equals(mWMInOutBound.getFreightCostRule()) ? mWMInOutBoundLine.getM_Shipper() : mWMInOutBound.getM_Shipper()).orElseGet(() -> "L".equals(mOrder.getFreightCostRule()) ? mOrderLine.getM_Shipper() : mOrder.getM_Shipper()));
        if (optional.isPresent()) {
            int n;
            int n2 = mWMInOutBound2 == null ? ("L".equals(mOrder.getFreightCostRule()) ? mOrderLine.getM_FreightCategory_ID() : mOrder.getM_FreightCategory_ID()) : (n = mWMInOutBound2.getM_FreightCategory_ID());
            if (this.isCalculatedFreight(mOrder.getFreightCostRule()) && n > 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                BigDecimal bigDecimal = Env.ZERO;
                BigDecimal bigDecimal2 = Env.ZERO;
                if (mOrderLine.getM_Product_ID() != 0) {
                    MProduct mProduct = MProduct.get(mOrderLine.getCtx(), mOrderLine.getM_Product_ID());
                    bigDecimal = mProduct.getWeight();
                    bigDecimal2 = mProduct.getVolume();
                    hashMap.put("M_Product_ID", mProduct.getM_Product_ID());
                }
                this.freightEngine = FreightEngineFactory.getFreightEngine(mOrderLine.getAD_Client_ID());
                return this.freightEngine.getFreightRuleFactory(optional.get(), mOrder.getFreightCostRule()).calculate(mOrder.getCtx(), optional.get().getM_Shipper_ID(), mWarehouse.getC_Location_ID(), mOrder.getC_BPartner_Location().getC_Location_ID(), n, mOrder.getC_Currency_ID(), mOrder.getDateOrdered(), bigDecimal, bigDecimal2, mOrder.get_TrxName(), hashMap);
            }
        }
        return freightInfo;
    }

    private FreightInfo getFreight(MDDOrderLine mDDOrderLine, MWMInOutBound mWMInOutBound2, MWMInOutBoundLine mWMInOutBoundLine) {
        MDDOrder mDDOrder = mDDOrderLine.getParent();
        FreightInfo freightInfo = new FreightInfo();
        Optional<I_M_Shipper> optional = Optional.ofNullable(Optional.ofNullable(mWMInOutBound2).map(mWMInOutBound -> "L".equals(mWMInOutBound.getFreightCostRule()) ? mWMInOutBoundLine.getM_Shipper() : mWMInOutBound.getM_Shipper()).orElseGet(() -> "L".equals(mDDOrder.getFreightCostRule()) ? mDDOrderLine.getM_Shipper() : mDDOrder.getM_Shipper()));
        if (optional.isPresent()) {
            int n;
            int n2 = mWMInOutBound2 == null ? ("L".equals(mDDOrder.getFreightCostRule()) ? mDDOrderLine.getM_FreightCategory_ID() : mDDOrder.getM_FreightCategory_ID()) : (n = mWMInOutBound2.getM_FreightCategory_ID());
            if (this.isCalculatedFreight(mDDOrder.getFreightCostRule()) && n > 0) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                BigDecimal bigDecimal = Env.ZERO;
                BigDecimal bigDecimal2 = Env.ZERO;
                if (mDDOrderLine.getM_Product_ID() != 0) {
                    MProduct mProduct = MProduct.get(mDDOrderLine.getCtx(), mDDOrderLine.getM_Product_ID());
                    bigDecimal = mProduct.getWeight();
                    bigDecimal2 = mProduct.getVolume();
                    hashMap.put("M_Product_ID", mProduct.getM_Product_ID());
                }
                freightInfo = this.freightEngine.getFreightRuleFactory(optional.get(), mDDOrder.getFreightCostRule()).calculate(mDDOrder.getCtx(), optional.get().getM_Shipper_ID(), mDDOrderLine.getM_Locator().getM_Warehouse().getC_Location_ID(), mDDOrder.getC_BPartner_Location().getC_Location_ID(), n, mDDOrder.getC_Currency_ID(), mDDOrder.getDateOrdered(), bigDecimal, bigDecimal2, mDDOrder.get_TrxName(), hashMap);
            }
        }
        return freightInfo;
    }

    private FreightInfo getFreightInfo(MPackage mPackage) {
        I_M_Shipper i_M_Shipper = mPackage.getM_Shipper();
        int n = 0;
        int n2 = 0;
        MWarehouse mWarehouse = MWarehouse.get(mPackage.getCtx(), mPackage.getM_Warehouse_ID());
        n = mWarehouse.getC_Location_ID();
        n2 = mPackage.getC_BPartner_Location().getC_Location_ID();
        FreightInfo freightInfo = new FreightInfo();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Width", mPackage.getWidth());
        hashMap.put("Height", mPackage.getHeight());
        hashMap.put("Depth", mPackage.getDepth());
        if (i_M_Shipper != null) {
            int n3;
            int n4 = n3 = "L".equals(mPackage.getFreightCostRule()) ? mPackage.getM_FreightCategory_ID() : mPackage.getM_FreightCategory_ID();
            if (this.isCalculatedFreight(mPackage.getFreightCostRule()) && n3 > 0) {
                return this.freightEngine.getFreightRuleFactory(i_M_Shipper, mPackage.getFreightCostRule()).calculate(mPackage.getCtx(), mPackage.getC_Currency_ID(), n, n2, i_M_Shipper.getM_Shipper_ID(), n3, mPackage.getDateDoc(), mPackage.getWeight(), mPackage.getVolume(), mPackage.get_TrxName(), hashMap);
            }
        }
        return freightInfo;
    }

    private boolean isCalculatedFreight(String string) {
        return "L".equals(string) || "C".equals(string) || "I".equals(string);
    }

    private FreightInfo getFreight(MWMInOutBoundLine mWMInOutBoundLine) {
        if (mWMInOutBoundLine.getC_OrderLine_ID() > 0) {
            return this.getFreight((MOrderLine)mWMInOutBoundLine.getC_OrderLine(), mWMInOutBoundLine.getParent(), mWMInOutBoundLine);
        }
        if (mWMInOutBoundLine.getDD_OrderLine_ID() > 0) {
            MDDOrderLine mDDOrderLine = new MDDOrderLine(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getDD_OrderLine_ID(), mWMInOutBoundLine.get_TrxName());
            return this.getFreight(mDDOrderLine, mWMInOutBoundLine.getParent(), mWMInOutBoundLine);
        }
        return new FreightInfo();
    }
}

