/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.freight.engine;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.TreeSet;
import org.adempiere.core.domains.models.I_M_Shipper;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CLogger;
import org.eevolution.freight.engine.FreightRule;
import org.eevolution.freight.engine.FreightRuleInterface;

public class FreightEngine {
    static final String packageName = "org.eevolution.freight.engine";
    private static FreightEngine instanceFreightEngine;
    private static TreeSet<String> freightRuleNoImplement;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private HashMap<String, FreightRuleInterface> freightRules = new HashMap();

    public FreightEngine() {
        this.registerRules(true);
    }

    public static FreightEngine get() {
        if (instanceFreightEngine == null) {
            instanceFreightEngine = new FreightEngine();
        }
        return instanceFreightEngine;
    }

    protected void registerRules(boolean bl) {
        if (bl) {
            this.freightRules.clear();
        }
        this.getFreightRuleFactory(null, "C");
        this.getFreightRuleFactory(null, "I");
        this.getFreightRuleFactory(null, "L");
    }

    public String getPackageName() {
        return packageName;
    }

    protected <T extends FreightRuleInterface> Class<T> getClass(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public FreightRuleInterface getFreightRuleFactory(I_M_Shipper i_M_Shipper, String string) {
        Object object = "";
        Boolean bl = i_M_Shipper != null && i_M_Shipper.getCalculationClass() == null || i_M_Shipper == null;
        if (bl.booleanValue()) {
            object = this.getPackageName() + "." + FreightRule.class.getSimpleName();
        } else if (i_M_Shipper.getCalculationClass() != null) {
            object = i_M_Shipper.getCalculationClass();
        }
        if (this.freightRules.containsKey(object)) {
            return this.freightRules.get(object);
        }
        try {
            Class clazz = this.getClass((String)object);
            Constructor constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception exception) {
                this.log.fine("Freight Not Found");
            }
            if (constructor != null) {
                FreightRuleInterface freightRuleInterface = (FreightRuleInterface)constructor.newInstance(new Object[0]);
                this.freightRules.put((String)object, freightRuleInterface);
                return freightRuleInterface;
            }
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            FreightRuleInterface freightRuleInterface = (FreightRuleInterface)constructor.newInstance(new Object[0]);
            this.freightRules.put((String)object, freightRuleInterface);
            return freightRuleInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            freightRuleNoImplement.add((String)object);
            throw new AdempiereException("@CalculationClass@ @NotFound@ " + classNotFoundException);
        }
        catch (Throwable throwable) {
            throw new AdempiereException(throwable);
        }
    }

    static {
        freightRuleNoImplement = new TreeSet();
    }
}

