/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.compiere.model.MProduct;
import org.eevolution.form.bom.BOMTreeCellRenderer;
import org.eevolution.manufacturing.model.MPPOrder;
import org.eevolution.manufacturing.model.wrapper.BOMLineWrapper;
import org.eevolution.manufacturing.model.wrapper.BOMWrapper;
import org.eevolution.manufacturing.msg.HTMLMessenger;

public class BOMMessenger
extends HTMLMessenger {
    protected JTree bomTree;
    protected BOMTreeCellRenderer bomTreeCellRenderer;
    protected HashMap<DefaultMutableTreeNode, String> cache;

    public BOMMessenger(JTree bomTree) {
        this.bomTree = bomTree;
        this.cache = new HashMap();
    }

    public String getToolTipText(MouseEvent evt) {
        String tooltip = null;
        if (this.bomTree.getRowForLocation(evt.getX(), evt.getY()) == -1) {
            return tooltip;
        }
        return this.getToolTipText(this.bomTree.getPathForLocation(evt.getX(), evt.getY()));
    }

    public String getToolTipText(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        String tooltip = this.cache.get(node);
        if (tooltip != null) {
            return tooltip;
        }
        if (node.getUserObject() instanceof MProduct) {
            tooltip = this.getProductInfo((MProduct)node.getUserObject());
        }
        if (node.getUserObject() instanceof MPPOrder) {
            tooltip = this.getMfcOrderInfo((MPPOrder)node.getUserObject());
        } else if (node.getUserObject() instanceof BOMWrapper) {
            tooltip = this.getBOMInfo((BOMWrapper)node.getUserObject());
        } else if (node.getUserObject() instanceof BOMLineWrapper) {
            tooltip = this.getBOMLineInfo((BOMLineWrapper)node.getUserObject());
        }
        this.cache.put(node, tooltip);
        return tooltip;
    }

    public static String getToolTipText(JTree tree, MouseEvent evt) {
        BOMMessenger msg = new BOMMessenger(tree);
        return msg.getToolTipText(evt);
    }
}

